/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AdminToOrgRangeHandler;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.BizDataCheckInfo;
import com.kingdee.eas.basedata.org.BizDataChecker;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOUPartCtrl;
import com.kingdee.eas.basedata.org.IOrgDelegateFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTypeRelation;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IOtherDealOrgChange;
import com.kingdee.eas.basedata.org.IOtherDealOrgUpGrade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartAdmin;
import com.kingdee.eas.basedata.org.OUPartCtrlFactory;
import com.kingdee.eas.basedata.org.OUPartFIInfo;
import com.kingdee.eas.basedata.org.OUPartHRInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgDelegateFacadeFactory;
import com.kingdee.eas.basedata.org.OrgLogTypeEnum;
import com.kingdee.eas.basedata.org.OrgSpecialTablesRebuildFacadeFactory;
import com.kingdee.eas.basedata.org.OrgSpecialTalbesEnum;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitDefaultRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitDefaultRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.eas.basedata.org.OtherDealRelateToOrg;
import com.kingdee.eas.basedata.org.app.AbstractFullOrgUnitControllerBean;
import com.kingdee.eas.basedata.org.app.AdminParentChangeAroundListener;
import com.kingdee.eas.basedata.org.app.AutoSealUpNoBizOrgUnitHelper;
import com.kingdee.eas.basedata.org.app.OUPartReference;
import com.kingdee.eas.basedata.org.app.OrgBizConfigUtil;
import com.kingdee.eas.basedata.org.app.OrgSpecialTablesSqlManager;
import com.kingdee.eas.basedata.org.app.SyncOrgUnitStructHelper;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.basedata.org.app.ext.ExtHelper;
import com.kingdee.eas.basedata.org.app.ext.IOrgExt;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppCtrlHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgDBHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.app.log.OrgLogServerUtils;
import com.kingdee.eas.basedata.org.helper.IDelUserOrgRangeRef;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.basedata.org.service.CUBDControlUtils;
import com.kingdee.eas.basedata.org.util.OrgToolUtils;
import com.kingdee.eas.basedata.org.util.OrgTypeUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class FullOrgUnitControllerBean
extends AbstractFullOrgUnitControllerBean {
    private static Logger logger = Logger.getLogger((String)FullOrgUnitControllerBean.class.getName());
    private static IDelUserOrgRangeRef delUserOrgRangeRef;
    private BOSUuid admin2FITypeRelationID = BOSUuid.read((String)"00000000-0000-0000-0000-0000000000010FE9F8B5");
    private final int AFTERORGADDNEW = 1;
    private final int AFTERORGDELETE = 2;
    private final int ORGUPDATEAFTER = 3;
    private final int ORGUPDATEBEFORE = 4;
    private static final String BOSTYPE = "CCE7AED4";
    private final int ORGUPGRADEAFTER = 1;
    private static final String ADMIN_TO_HR_ID = "00000000-0000-0000-0000-0000000000100FE9F8B5";
    private static final String ADMIN_TO_FI_ID = "00000000-0000-0000-0000-0000000000010FE9F8B5";

    public int getDisplayNameLength() {
        return 500;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgAppHelper oneHelper;
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)model;
        OrgToolUtils.trimNameAndNumberSpaceOfObjectInfo((DataBaseInfo)unitInfo);
        this.checkNumberAndName(ctx, unitInfo);
        CtrlUnitInfo currentCUInfo = this.getCurrentCtrlUnitInfo(ctx, unitInfo);
        String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
        unitInfo.setVersionNumber(versionNumber);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)unitInfo);
        OrgTypeHelper orgHelper = new OrgTypeHelper(unitInfo);
        if (orgHelper.containComplexOrgType() && (oneHelper = OrgTypeAppCenter.getInstance().getHelper(orgHelper.getComplexOrgType())) != null) {
            ICtrlUnit iCtrl = CtrlUnitFactory.getLocalInstance(ctx);
            ObjectUuidPK ctrlPK = new ObjectUuidPK(unitInfo.getMaintainCU().getId());
            currentCUInfo = iCtrl.getCtrlUnitInfo((IObjectPK)ctrlPK);
            unitInfo.setCU(currentCUInfo);
            oneHelper.addNewInfo(ctx, unitInfo, currentCUInfo);
        }
        OrgAppCtrlHelper ctrlHelper = new OrgAppCtrlHelper();
        ctrlHelper.addNewCtrl(ctx, pk, unitInfo, versionNumber);
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            OrgTypeAppCenter.getInstance().addNewInfo(ctx, unitInfo, currentCUInfo);
            unitInfo.setCU(currentCUInfo);
        }
        unitInfo.setEffectDate(Calendar.getInstance().getTime());
        super._update(ctx, pk, (IObjectValue)unitInfo);
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance(ctx);
            iNOV.updateBizView(unitInfo, false);
        }
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            this.addDelegateOrgAdmin2FI(ctx, unitInfo, versionNumber);
            OrgUnitRelationCollection col = this.dealOrgDelegateDataCommon(ctx, unitInfo, versionNumber);
            OrgUnitRelationFactory.getLocalInstance(ctx).batchAddNew(col);
        }
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(unitInfo, 1);
        if (!unitInfo.isIsCU() || unitInfo.get("isCus") == null) {
            this.otherDealRelateToOrg(ctx, unitInfo, "afterOrgAddNew", null);
            this.otherDealOrgChange(ctx, unitInfo, 1);
        }
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.ADDNEW, model);
        return pk;
    }

    private void checkNumberAndName(Context ctx, FullOrgUnitInfo unitInfo) throws OrgBlankException {
        String invalidChar;
        int i;
        String[] allInvalidChar;
        if (!StringUtils.isEmpty((String)unitInfo.getNumber())) {
            allInvalidChar = OrgToolUtils.allInvalidNumberChar(ctx);
            for (i = 0; i < allInvalidChar.length; ++i) {
                invalidChar = allInvalidChar[i];
                if (unitInfo.getNumber().trim().indexOf(invalidChar) == -1) continue;
                throw new OrgBlankException(OrgBlankException.NUMBER_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
            }
        }
        if (!StringUtils.isEmpty((String)unitInfo.getName())) {
            allInvalidChar = OrgToolUtils.allInvalidNameChar(ctx);
            for (i = 0; i < allInvalidChar.length; ++i) {
                invalidChar = allInvalidChar[i];
                if (unitInfo.getName().trim().indexOf(invalidChar) == -1) continue;
                throw new OrgBlankException(OrgBlankException.NAME_INCLUDE_FORBIDDEN_CHAR, new Object[]{invalidChar});
            }
        }
    }

    private void otherDealOrgChange(Context ctx, FullOrgUnitInfo model, int type) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)BOSTYPE, IOtherDealOrgChange.class);
            if (checks != null && checks.length > 0) {
                IOtherDealOrgChange otherDealOrgChangeCheck = null;
                block10: for (int i = 0; i < checks.length; ++i) {
                    otherDealOrgChangeCheck = (IOtherDealOrgChange)Class.forName(checks[i]).newInstance();
                    switch (type) {
                        case 1: {
                            otherDealOrgChangeCheck.afterOrgAddNew(ctx, model);
                            continue block10;
                        }
                        case 2: {
                            otherDealOrgChangeCheck.afterOrgDelete(ctx, model);
                            continue block10;
                        }
                        case 3: {
                            otherDealOrgChangeCheck.OrgUpdateAfter(ctx, model);
                            continue block10;
                        }
                        case 4: {
                            otherDealOrgChangeCheck.orgUpdateBefore(ctx, model);
                            continue block10;
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void otherDealOrgUpGrade(Context ctx, FullOrgUnitInfo model, int type) throws EASBizException, BOSException {
        try {
            String[] checks = RefCheckersDAO.getCheckers((Context)ctx, (String)BOSTYPE, IOtherDealOrgUpGrade.class);
            if (checks != null && checks.length > 0) {
                IOtherDealOrgUpGrade otherDealOrgUpGradeCheck = null;
                block7: for (int i = 0; i < checks.length; ++i) {
                    otherDealOrgUpGradeCheck = (IOtherDealOrgUpGrade)Class.forName(checks[i]).newInstance();
                    switch (type) {
                        case 1: {
                            otherDealOrgUpGradeCheck.OrgUpGradeAfter(ctx, model);
                            continue block7;
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNameNumberRepeat(Context ctx, FullOrgUnitInfo unitInfo) throws OUException, EASBizException, BOSException {
        String oql;
        if (unitInfo.getCode() != null && unitInfo.getCode().trim().length() != 0 && this.exists(ctx, oql = new StringBuffer().append("where code = '").append(unitInfo.getCode()).append("' and id <> '").append(unitInfo.getId().toString()).append("'").toString())) {
            throw new OUException(OUException.CODE_DUP);
        }
    }

    private void checkCodeRepeat(Context ctx, FullOrgUnitInfo unitInfo) throws OUException, EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)unitInfo.getCode())) {
            StringBuffer oql = new StringBuffer().append("where code = '").append(unitInfo.getCode()).append("'");
            if (unitInfo.getId() != null) {
                oql.append(" and id <>'").append(unitInfo.getId().toString()).append("'");
            }
            if (this.exists(ctx, oql.toString())) {
                throw new OUException(OUException.CODE_DUP);
            }
        }
    }

    private FullOrgUnitInfo getOldOrgUnit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        return (FullOrgUnitInfo)this._getValue(ctx, pk, sic);
    }

    private void updateNewParentLeafStatus(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException {
        if (unitInfo.getParent() != null) {
            FullOrgUnitInfo newParentInfo = unitInfo.getParent();
            ObjectUuidPK newParentPK = new ObjectUuidPK(newParentInfo.getId());
            if (newParentInfo.isIsLeaf()) {
                newParentInfo.setIsLeaf(false);
                this.innerUpdate(ctx, (IObjectPK)newParentPK, (IObjectValue)newParentInfo);
            }
        }
    }

    private void updateOldParentLeafStatus(Context ctx, FullOrgUnitInfo oldUnitInfo) throws BOSException {
        if (oldUnitInfo.getParent() != null) {
            FullOrgUnitInfo oldParentInfo = oldUnitInfo.getParent();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)oldParentInfo.getId()));
            viewInfo.setFilter(filterInfo);
            FullOrgUnitCollection unitCol = this.getFullOrgUnitCollection(ctx, viewInfo);
            if (unitCol.size() == 0) {
                ObjectUuidPK oldParentPK = new ObjectUuidPK(oldParentInfo.getId());
                oldParentInfo.setIsLeaf(true);
                this.innerUpdate(ctx, (IObjectPK)oldParentPK, (IObjectValue)oldParentInfo);
            }
        }
    }

    private void updateParent(Context ctx, IObjectPK pk, FullOrgUnitInfo unitInfo) throws EASBizException, BOSException {
        IObjectValue originalModel = null;
        FullOrgUnitInfo oldUnitInfo = this.getOldOrgUnit(ctx, pk);
        unitInfo.put("OldData", oldUnitInfo);
        try {
            originalModel = (IObjectValue)ObjectUtils.createCopy((Object)unitInfo);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        super._update(ctx, pk, (IObjectValue)unitInfo);
        this.updateNewParentLeafStatus(ctx, unitInfo);
        this.updateOldParentLeafStatus(ctx, oldUnitInfo);
        if (originalModel != null) {
            OrgLogServerUtils.log(ctx, OrgLogTypeEnum.UPDATE, originalModel);
        }
    }

    private boolean isParentChanged(Context ctx, FullOrgUnitInfo oldOrgUnit, FullOrgUnitInfo newOrgUnit) throws EASBizException, BOSException {
        FullOrgUnitInfo oldParent = oldOrgUnit.getParent();
        FullOrgUnitInfo newParent = newOrgUnit.getParent();
        String oldParentId = null;
        String newParentId = null;
        if (oldParent != null) {
            oldParentId = StringUtils.cnulls((Object)oldParent.getId());
        }
        if (newParent != null) {
            newParentId = StringUtils.cnulls((Object)newParent.getId());
        }
        return !StringUtils.equals((String)oldParentId, newParentId);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        INewOrgViewFacade iNOV;
        AdminParentChangeAroundListener adminParentChangeAround = new AdminParentChangeAroundListener(ctx, pk);
        adminParentChangeAround.before();
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)model;
        OrgToolUtils.trimNameAndNumberSpaceOfObjectInfo((DataBaseInfo)unitInfo);
        this.checkNumberAndName(ctx, unitInfo);
        if (unitInfo.get("ParentOnly") != null) {
            this.updateParent(ctx, pk, unitInfo);
            return;
        }
        FullOrgUnitInfo oldOrgUnit = this.getOldOrgUnit(ctx, pk);
        if (unitInfo.get("OldData") == null) {
            unitInfo.put("OldData", oldOrgUnit);
        }
        String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
        IObjectValue originalModel = null;
        CtrlUnitInfo currentCUInfo = this.getCurrentCtrlUnitInfo(ctx, unitInfo);
        this.otherDealRelateToOrg(ctx, unitInfo, "OrgUpdateBefore", null);
        this.otherDealOrgChange(ctx, unitInfo, 4);
        OrgTypeHelper orgHelper = new OrgTypeHelper(unitInfo);
        boolean isOrgStart = this.isOrgStart(ctx);
        if (orgHelper.containComplexOrgType()) {
            OrgTypeAppCenter.getInstance().getHelper(orgHelper.getComplexOrgType()).updateOrgInfo(ctx, pk, unitInfo, currentCUInfo, versionNumber, isOrgStart);
            super._update(ctx, pk, model);
            return;
        }
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            OrgTypeAppCenter.getInstance().updateOrgInfo(ctx, pk, unitInfo, currentCUInfo, versionNumber, isOrgStart);
        }
        try {
            originalModel = (IObjectValue)ObjectUtils.createCopy((Object)unitInfo);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"error!", (Throwable)e);
        }
        super._update(ctx, pk, (IObjectValue)unitInfo);
        if (this.isParentChanged(ctx, oldOrgUnit, unitInfo)) {
            this.updateNewParentLeafStatus(ctx, unitInfo);
            this.updateOldParentLeafStatus(ctx, oldOrgUnit);
        }
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            iNOV = NewOrgViewFacadeFactory.getLocalInstance(ctx);
            iNOV.updateBizView(unitInfo, true);
        }
        if (unitInfo.isIsCU() && unitInfo.get("isCus") != null) {
            iNOV = NewOrgViewFacadeFactory.getLocalInstance(ctx);
            iNOV.updateBizViewOnCU(unitInfo);
            if (unitInfo.isIsCompanyOrgUnit() && unitInfo.getParent() != null) {
                StringBuffer asstiantsql = new StringBuffer();
                asstiantsql.append(" update t_org_baseunit set FParentID='" + unitInfo.getParent().getId().toString() + "', ");
                asstiantsql.append(" flongnumber='" + unitInfo.getParent().getLongNumber() + "!' || fnumber");
                asstiantsql.append(" where FISASSISTANTORG = 1 and fnumber like '" + unitInfo.getNumber() + "@%' ");
                DbUtil.execute((Context)ctx, (String)asstiantsql.toString());
            }
        }
        if (unitInfo.get("isCus") == null && !orgHelper.containComplexOrgType()) {
            this.addDelegateOrgAdmin2FI(ctx, unitInfo, versionNumber);
            this.dealOrgDelegateData(ctx, unitInfo, isOrgStart, versionNumber);
        }
        boolean numberOrgNameUpdated = unitInfo.get("UpdateNumberOrName") != null;
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(unitInfo, 3);
        String orgTypeStr = unitInfo.getOrgTypeStr();
        Set newOrgTypeSet = new OrgTypeHelper(orgTypeStr).getAllSelectOrgTypeSet();
        String oldOrgTypeStr = oldOrgUnit.getOrgTypeStr();
        Set oldOrgTypeSet = new OrgTypeHelper(oldOrgTypeStr).getAllSelectOrgTypeSet();
        newOrgTypeSet.retainAll(oldOrgTypeSet);
        oldOrgTypeSet.removeAll(newOrgTypeSet);
        if (oldOrgTypeSet.size() != 0) {
            PermissionFactory.getLocalInstance((Context)ctx).delPermissoinAfterDelOrg(oldOrgTypeSet, oldOrgUnit);
        }
        this.otherDealOrgChange(ctx, unitInfo, 3);
        this.otherDealRelateToOrg(ctx, unitInfo, "afterOrgAddNew", "STOR_02");
        if (originalModel != null) {
            OrgLogServerUtils.log(ctx, OrgLogTypeEnum.UPDATE, originalModel);
        }
        if (unitInfo.isIsCompanyOrgUnit()) {
            this.otherDealRelateToOrg(ctx, unitInfo, "afterOrgAddNew", "FI_01");
        }
        this.otherDealRelateToOrg(ctx, unitInfo, "afterOrgAddNew", "STOR_01");
        if (unitInfo.isIsAdminOrgUnit()) {
            new AdminToOrgRangeHandler().afterDeal(ctx, unitInfo);
        }
        if (numberOrgNameUpdated) {
            this.otherDealRelateToOrg(ctx, unitInfo, "OrgUpdateAfter", "OrgUpdate_01");
        }
        ORMValueCacheService.getInstance().remove(ctx, unitInfo.getBOSType(), pk);
        adminParentChangeAround.after();
    }

    private void addDelegateOrgAdmin2FI(Context ctx, FullOrgUnitInfo unitInfo, String versionNumber) throws BOSException, EASBizException {
        FullOrgUnitInfo delegateFI;
        if (!unitInfo.isIsAdminOrgUnit()) {
            return;
        }
        BizParentAndDelegateInfo pdInfo = (BizParentAndDelegateInfo)unitInfo.get("PDValueInfo");
        OrgUnitRelationCollection delegateCol = new OrgUnitRelationCollection();
        delegateCol.addCollection(pdInfo.getDelegateCollection());
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        if (delegateCol.size() != 0) {
            int n = delegateCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitRelationInfo relationInfo = delegateCol.get(i);
                OrgTypeRelationInfo typeInfo = relationInfo.getTypeRelation();
                if (typeInfo == null) {
                    if (OrgType.Admin.getValue() != ((OrgType)((Object)relationInfo.get("fromType"))).getValue() || OrgType.Company.getValue() != ((OrgType)((Object)relationInfo.get("toType"))).getValue()) continue;
                    list.add(relationInfo.getToUnit());
                    continue;
                }
                if (OrgType.Admin.getValue() != typeInfo.getFromType().getValue() || OrgType.Company.getValue() != typeInfo.getToType().getValue()) continue;
                list.add(relationInfo.getToUnit());
            }
        }
        if (list.size() == 0 && (delegateFI = unitInfo.isIsCompanyOrgUnit() && unitInfo.getPartFI().isIsBizUnit() ? unitInfo : OrgUnitDefaultRelationFactory.getLocalInstance(ctx).getUpperOrgID(unitInfo.getId().toString(), 1)) != null) {
            OrgUnitRelationInfo defaultDelegateOrg = new OrgUnitRelationInfo();
            defaultDelegateOrg.setFromUnit(unitInfo);
            defaultDelegateOrg.setToUnit(delegateFI);
            OrgTypeRelationInfo orgTypeRelation = OrgTypeRelationFactory.getLocalInstance(ctx).getOrgTypeRelationInfo((IObjectPK)new ObjectUuidPK(this.admin2FITypeRelationID));
            defaultDelegateOrg.setTypeRelation(orgTypeRelation);
            defaultDelegateOrg.setVersionNumber(versionNumber);
            delegateCol.add(defaultDelegateOrg);
            pdInfo.setDelegateCollection(delegateCol);
            unitInfo.put("PDValueInfo", pdInfo);
        }
    }

    private String createKeyByInfo(OrgUnitRelationInfo info) {
        if (info == null) {
            return "";
        }
        String retStr = "";
        if (info.getFromUnit() != null && info.getFromUnit().getId() != null) {
            retStr = retStr + info.getFromUnit().getId().toString();
        }
        if (info.getToUnit() != null && info.getToUnit().getId() != null) {
            retStr = retStr + info.getToUnit().getId().toString();
        }
        if (info.getTypeRelation() != null && info.getTypeRelation().getId() != null) {
            retStr = retStr + info.getTypeRelation().getId().toString();
        }
        if (info.getVersionNumber() != null) {
            retStr = retStr + info.getVersionNumber();
        }
        if (info.get("fromType") != null) {
            retStr = retStr + info.get("fromType");
        }
        if (info.get("toType") != null) {
            retStr = retStr + info.get("toType");
        }
        return retStr;
    }

    private OrgUnitRelationCollection dealOrgDelegateDataCommon(Context ctx, FullOrgUnitInfo unitInfo, String versionNumber) throws EASBizException, BOSException {
        int i;
        BizParentAndDelegateInfo bizParent = (BizParentAndDelegateInfo)unitInfo.get("PDValueInfo");
        if (bizParent == null) {
            return new OrgUnitRelationCollection();
        }
        OrgUnitRelationCollection col = bizParent.getDelegateCollection();
        if (col == null) {
            return new OrgUnitRelationCollection();
        }
        HashSet<String> cacheSet = new HashSet<String>();
        for (i = col.size() - 1; i >= 0; --i) {
            OrgUnitRelationInfo info = col.get(i);
            String key = this.createKeyByInfo(info);
            if (cacheSet.contains(key)) {
                col.removeObject(i);
                continue;
            }
            cacheSet.add(key);
        }
        int n = col.size();
        for (i = 0; i < n; ++i) {
            OrgTypeRelationInfo typeInfo;
            OrgUnitRelationInfo info = col.get(i);
            info.setFromUnit(unitInfo);
            if (info.getFromUnit().getNumber().equals(info.getToUnit().getNumber())) {
                info.setToUnit(unitInfo);
            }
            if ((typeInfo = info.getTypeRelation()) == null || typeInfo.getId() == null) {
                OrgType toType;
                OrgType fromType = (OrgType)((Object)info.get("fromType"));
                String orgTypeRelationID = this.getOrgTypeRelationID(ctx, fromType, toType = (OrgType)((Object)info.get("toType")));
                if (orgTypeRelationID != null) {
                    if (typeInfo == null) {
                        typeInfo = new OrgTypeRelationInfo();
                    }
                    typeInfo.setId(BOSUuid.read((String)orgTypeRelationID));
                } else {
                    IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance(ctx);
                    typeInfo = iDelegate.getTypeRelationFromUnitType(fromType.getValue(), toType.getValue());
                }
                info.setTypeRelation(typeInfo);
            }
            info.setVersionNumber(versionNumber);
        }
        return col;
    }

    private void dealOrgDelegateData(Context ctx, FullOrgUnitInfo unitInfo, boolean isOrgStart, String versionNumber) throws BOSException, EASBizException {
        if (unitInfo.containsKey("notDealOrgDelegate")) {
            return;
        }
        OrgUnitRelationCollection col = this.dealOrgDelegateDataCommon(ctx, unitInfo, versionNumber);
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)unitInfo.getId().toString()));
        if (col == null || col.isEmpty()) {
            if (iUnitRel.exists(filter)) {
                iUnitRel.delete(filter);
            }
            return;
        }
        iUnitRel.delete(filter);
        for (int i = col.size() - 1; i >= 0; --i) {
            OrgUnitRelationInfo info = col.get(i);
            info.setVersionNumber(versionNumber);
        }
        if (col.size() > 0) {
            iUnitRel.batchAddNew(col);
        }
    }

    private IOrgExt getOrgExtImpl() throws BOSException {
        return ExtHelper.getOrgExtImpl();
    }

    @Override
    protected boolean _hasAssistBizRefrenceForAdmin(Context ctx, String id) throws BOSException {
        try {
            return this.getOrgExtImpl().hasAssistBizRefrenceForAdmin(ctx, id);
        }
        catch (EASBizException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _updateAssistDataForAdmin(Context ctx, String id, String parentId) throws BOSException {
        try {
            this.getOrgExtImpl().updateAssistDataForAdmin(ctx, id, parentId);
        }
        catch (EASBizException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected BizDataCheckInfo[] _hasBizRefrenceForAdmin(Context ctx, String id) throws BOSException {
        BizDataChecker checker = new BizDataChecker();
        return checker.checkBizRefrenceForAdmin(ctx, BOSUuid.read((String)id), BOSObjectType.create((String)"6A6435BE"));
    }

    @Override
    protected void _updateBizDataForAdmin(Context ctx, String id, String parentid) throws BOSException {
        BizDataChecker checker = new BizDataChecker();
        checker.updateBizDataForAdmin(ctx, BOSUuid.read((String)id), BOSUuid.read((String)parentid), BOSObjectType.create((String)"6A6435BE"));
    }

    protected void _updateCom(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.getOrgExtImpl().updateCom(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IOrgStructure iStruct;
        OrgStructureCollection structCol;
        String oql;
        if (pk.toString().equals("11111111-1111-1111-1111-111111111111CCE7AED4") || pk.toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            throw new OUException(OUException.SYSTEM_INSET_CAN_NOT_DELETE);
        }
        FullOrgUnitInfo deleteInfo = (FullOrgUnitInfo)this._getValue(ctx, pk);
        OrgTypeHelper orgHelper = new OrgTypeHelper(deleteInfo);
        if (deleteInfo.isIsCU()) {
            CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (pk.toString().equals(ctrlInfo.getId().toString())) {
                throw new OUException(OUException.NOT_DELETE_CURRENT_CU);
            }
            String oql2 = "Select * Where cu.id = '" + deleteInfo.getId().toString() + "' and id <> '" + deleteInfo.getId().toString() + "'";
            if (this._exists(ctx, oql2)) {
                throw new OUException(OUException.OU_EXIST_IN_CU);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)deleteInfo.getId().toString(), CompareType.EQUALS));
            if (this._exists(ctx, filter)) {
                throw new OUException(OUException.CU_EXIST_CHILDREN);
            }
        }
        if (this._exists(ctx, oql = "Select * Where parent.id = '" + deleteInfo.getId().toString() + "'")) {
            throw new OUException(OUException.OU_EXIST_CHILDREN);
        }
        String oql2 = "Select * Where mainOrg.id = '" + deleteInfo.getId().toString() + "'";
        if (this._exists(ctx, oql2)) {
            throw new OUException(OUException.EXIST_ASSISTANT_ORGS);
        }
        if (orgHelper.containComplexOrgType() && (structCol = (iStruct = OrgStructureFactory.getLocalInstance(ctx)).getOrgStructureCollection("Select * Where unit.id = '" + pk.toString() + "'")).size() > 0 && iStruct.exists("Select * Where parent.id = '" + structCol.get(0).getId().toString() + "'")) {
            throw new OUException(OUException.CAN_NOT_DELETE_RECORD);
        }
        ICUBDControl iBDControl = CUBDControlFactory.getLocalInstance(ctx);
        FilterInfo bdFilter = new FilterInfo();
        bdFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)deleteInfo.getId().toString(), CompareType.EQUALS));
        iBDControl.delete(bdFilter);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)pk.toString()));
        IOrgStructure iStruct2 = OrgStructureFactory.getLocalInstance(ctx);
        iStruct2.delete(filter);
        IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance(ctx);
        iDelegate.deleteSelfDelegate(pk.toString());
        DbUtil.execute((Context)ctx, (String)new StringBuffer().append("delete from T_ORG_UnitDefaultRelation where ").append("FFromUnitID = '").append(pk.toString()).append("' or FToUnitID = '").append(pk.toString()).append("'").toString());
        DbUtil.execute((Context)ctx, (String)("Update T_Org_BaseUnit set FControlUnitId = null, FPartCtrlID = null, FPartAdminID = null, FPartFIID = null, FPartSaleID = null, FPartStorageID = null, FPartPurchaseID = null, FPartCostCenterID = null, FPartProfitCenterID = null, FPartHRID = null, FPartTransportID = null Where FID = '" + pk.toString() + "'"));
        if (deleteInfo.isIsCU()) {
            OUPartReference.isReferenced(ctx, "35233503", pk.toString());
            IOUPartCtrl iCtrl = OUPartCtrlFactory.getLocalInstance(ctx);
            iCtrl.delete(filter);
        }
        if (FullOrgUnitControllerBean.getDelUserOrgRangeRef() != null) {
            FullOrgUnitControllerBean.getDelUserOrgRangeRef().deleteUserOrgRangeRef(ctx, pk);
        }
        OrgTypeAppCenter.getInstance().delOrgInfo(ctx, deleteInfo);
        super._delete(ctx, pk);
        this.dispachIntermitNumber(ctx, deleteInfo);
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(deleteInfo, 2);
        this.otherDealRelateToOrg(ctx, deleteInfo, "afterOrgDelete", null);
        this.otherDealOrgChange(ctx, deleteInfo, 2);
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.DELETE, (IObjectValue)deleteInfo);
        CacheService.getInstance().discardAll();
    }

    void dispachIntermitNumber(Context ctx, FullOrgUnitInfo bInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager;
        OrgUnitInfo rootInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.Company);
        if (rootInfo != null && (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)bInfo, rootInfo.getId().toString()) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)bInfo, rootInfo.getId().toString())) {
            iCodingRuleManager.recycleNumber((IObjectValue)bInfo, rootInfo.getId().toString(), bInfo.getNumber());
        }
    }

    private boolean isOrgStart(Context ctx) throws BOSException, EASBizException {
        INewOrgUnitFacade iNOU = NewOrgUnitFacadeFactory.getLocalInstance(ctx);
        return iNOU.isOrgStart();
    }

    private CtrlUnitInfo getCurrentCtrlUnitInfo(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        CtrlUnitInfo ctrlInfo = unitInfo.getCU() != null ? unitInfo.getCU() : ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (ctrlInfo == null) {
            throw new OUException(OUException.CU_CAN_NOT_NULL);
        }
        ICtrlUnit iCtrl = CtrlUnitFactory.getLocalInstance(ctx);
        ObjectUuidPK ctrlPK = new ObjectUuidPK(ctrlInfo.getId());
        ORMValueCacheService.getInstance().remove(ctx, ctrlInfo.getBOSType(), (IObjectPK)ctrlPK);
        ctrlInfo = iCtrl.getCtrlUnitInfo((IObjectPK)ctrlPK);
        return ctrlInfo;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Locale currentLocale = ctx.getLocale();
        String fname = new Locale("L1").equals(currentLocale) ? "FName_L1" : (new Locale("L2").equals(currentLocale) ? "FName_L2" : "FName_L3");
        String sql = "Select FNumber, " + fname + " from T_ORG_BaseUnit where FID = '" + pk.toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer sb = new StringBuffer();
        try {
            if (rowSet.next()) {
                sb.append(rowSet.getString("FNumber"));
                sb.append(" ");
                sb.append(rowSet.getString(fname));
            }
        }
        catch (SQLException se) {
            throw new BOSException("SQL Query Error!", (Throwable)se);
        }
        return sb.toString();
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    @Override
    protected void _buildAdminToHRDefaultRelation(Context ctx, IObjectValue unitInfo) throws BOSException {
        FullOrgUnitInfo info = (FullOrgUnitInfo)unitInfo;
        if (!info.isIsAdminOrgUnit()) {
            return;
        }
        try {
            String fID = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
            String fFromUnitid = info.getId().toString();
            String fToUnitid = this.getClosestUpperHROrg(ctx, info);
            if (!StringUtils.isEmpty((String)fToUnitid)) {
                String sql = "select 1 from T_ORG_UnitRelation where FFromUnitID = ? and FToUnitID = ? and FTypeRelationID = ?";
                Object[] params = new Object[]{fFromUnitid, fToUnitid, ADMIN_TO_HR_ID};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (!rs.next()) {
                    String insertSQL = "insert into T_ORG_UnitRelation values (?,?,?,?)";
                    Object[] insertParams = new Object[]{fID, fFromUnitid, fToUnitid, ADMIN_TO_HR_ID};
                    DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])insertParams);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getClosestUpperHROrg(Context ctx, FullOrgUnitInfo info) throws BOSException, EASBizException {
        for (FullOrgUnitInfo anInfo = info; anInfo != null; anInfo = anInfo.getParent()) {
            OUPartHRInfo hrInfo = anInfo.getPartHR();
            if (hrInfo == null || !hrInfo.isIsBizUnit()) continue;
            return anInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _buildAdminToFIDefaultRelation(Context ctx, IObjectValue unitInfo) throws BOSException {
        FullOrgUnitInfo info = (FullOrgUnitInfo)unitInfo;
        try {
            String fID = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
            String fFromUnitid = info.getId().toString();
            String fToUnitid = this.getClosestUpperFIOrg(ctx, info);
            if (!StringUtils.isEmpty((String)fToUnitid)) {
                String sql = "select 1 from T_ORG_UnitRelation where FFromUnitID = ? and FToUnitID = ? and FTypeRelationID = ?";
                Object[] params = new Object[]{fFromUnitid, fToUnitid, ADMIN_TO_FI_ID};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (!rs.next()) {
                    String insertSQL = "insert into T_ORG_UnitRelation values (?,?,?,?)";
                    Object[] insertParams = new Object[]{fID, fFromUnitid, fToUnitid, ADMIN_TO_FI_ID};
                    DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])insertParams);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getClosestUpperFIOrg(Context ctx, FullOrgUnitInfo info) throws BOSException, EASBizException {
        for (FullOrgUnitInfo anInfo = info; anInfo != null; anInfo = anInfo.getParent()) {
            OUPartFIInfo fiInfo = anInfo.getPartFI();
            if (fiInfo == null || !fiInfo.isIsBizUnit()) continue;
            return anInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getValue(ctx, pk);
    }

    private String getOrgTypeRelationID(Context ctx, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        IOrgTypeRelation iOrgTyepRel = OrgTypeRelationFactory.getLocalInstance(ctx);
        OrgTypeRelationInfo orgTypeRelInfo = iOrgTyepRel.getValue(fromType, toType);
        if (orgTypeRelInfo != null) {
            return orgTypeRelInfo.getId().toString();
        }
        return null;
    }

    protected void otherDealRelateToOrg(Context ctx, FullOrgUnitInfo model, String configitemName, String attributeKey) throws BOSException, EASBizException {
        List dealClassNamesList = null;
        OrgXMLElement xmlElement = null;
        String key = null;
        String value = null;
        boolean isThrowException = true;
        String description = "";
        StringBuffer errorMessage = null;
        try {
            dealClassNamesList = OrgBizConfigUtil.getInstance().getXMLBizClasses(configitemName, attributeKey);
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < dealClassNamesList.size(); ++i) {
            xmlElement = (OrgXMLElement)dealClassNamesList.get(i);
            key = xmlElement.getKey();
            value = xmlElement.getValue();
            isThrowException = xmlElement.isThrowException();
            description = xmlElement.getDescription();
            errorMessage = new StringBuffer();
            errorMessage.append("--ORG--otherDealRelateToOrg error--\n").append("key=").append(key).append("\n").append("value=").append(value).append("\n").append("description=").append(description).append("\n");
            if (StringUtils.isEmpty((String)value)) continue;
            try {
                Class<?> dealClass = Class.forName(value);
                OtherDealRelateToOrg ideal = (OtherDealRelateToOrg)dealClass.newInstance();
                ideal.afterDeal(ctx, model);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (!isThrowException) continue;
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getTreeid(OrgSpecialTalbesEnum orgTreeIdType) {
        return OrgTypeUtils.getTreeid(orgTreeIdType);
    }

    public Map getAllSubLongNuberSet(Context ctx, FullOrgUnitInfo oldOrgInfo) throws EASBizException, BOSException {
        return OrgDBHelper.getAllSubLongNumberSet(ctx, oldOrgInfo);
    }

    protected void _rebuildSpecialTables(Context ctx, IObjectPK pk, IObjectValue info, boolean isAddnew, Map treeLongNumberMap) throws BOSException, EASBizException {
        String[] sqlsToRun = null;
        String objectID = pk.toString();
        List enumList = OrgSpecialTalbesEnum.getEnumList();
        int enumValue = 0;
        Object id = null;
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)info;
        try {
            Map newLongNumberTreeMap = this.getAllSubLongNuberSet(ctx, unitInfo);
            int n = enumList.size();
            for (int i = 0; i < n; ++i) {
                OrgSpecialTalbesEnum enum1 = (OrgSpecialTalbesEnum)((Object)enumList.get(i));
                enumValue = enum1.getValue();
                if (!this.isNeedRebuildOrgViews(unitInfo, enumValue)) continue;
                OrgSpecialTablesSqlManager sqlMgr = OrgSpecialTablesSqlManager.getInstance();
                sqlsToRun = sqlMgr.getSqlByEnumValue(enumValue);
                if (isAddnew) {
                    String insertSql = sqlsToRun[1] + " and ou.FID='" + objectID + "' \n";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                    continue;
                }
                String strLongNumber = (String)treeLongNumberMap.get(this.getTreeid(enum1));
                String deleteSql = sqlsToRun[0] + " where ( FLongNumber = '" + strLongNumber + "' or FLongNumber like '" + strLongNumber + "!%') \n";
                DbUtil.execute((Context)ctx, (String)deleteSql);
                String strNewLongNumber = (String)newLongNumberTreeMap.get(this.getTreeid(enum1));
                String deleteNewSql = sqlsToRun[0] + " where ( FLongNumber = '" + strNewLongNumber + "' or FLongNumber like '" + strNewLongNumber + "!%') \n";
                DbUtil.execute((Context)ctx, (String)deleteNewSql);
                String insertSql = sqlsToRun[1] + " and ( stru.FLongNumber = '" + strNewLongNumber + "' or stru.FLongNumber like '" + strNewLongNumber + "!%') \n";
                DbUtil.execute((Context)ctx, (String)insertSql);
            }
        }
        catch (Exception e) {
            SQLException sqle;
            logger.error((Object)"Rebuild organization view tables error! \n", (Throwable)e);
            if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                logger.error((Object)"**************************** Next exception is: ***************************", (Throwable)sqle);
            }
            throw new BOSException((Throwable)e);
        }
        OrgCacheFactory.getOrgCache(ctx).clearOrgCache();
    }

    protected void _rebuildSpecialTables(Context ctx, IObjectPK pk, IObjectValue info, boolean isAddnew) throws BOSException, EASBizException {
        this._rebuildSpecialTables(ctx, pk, info, isAddnew, null);
    }

    private boolean isNeedRebuildOrgViews(FullOrgUnitInfo unitInfo, int enumValue) {
        return OrgTypeUtils.isNeedRebuildOrgViews(unitInfo, enumValue);
    }

    @Override
    protected IObjectCollection _getFullOrgUnitCollectionBySQL(Context ctx, String sql) throws BOSException {
        throw new IllegalArgumentException("not support this method after 6.1");
    }

    @Override
    protected ArrayList _getOrgIDbyAccountSchemeID(Context ctx, String accountSchemaID) throws BOSException {
        ArrayList<String> orgIDList = new ArrayList<String>();
        String sql = "select FID from T_ORG_Company where FAccountSchemeID = ? ";
        Object[] params = new Object[]{accountSchemaID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            while (rs.next()) {
                orgIDList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return orgIDList;
    }

    @Override
    protected void _batchDelBizOrg(Context ctx, IObjectValue unitInfo, int orgType) throws BOSException, EASBizException {
        FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)unitInfo;
        String orgId = orgInfo.getId().toString();
        String oql = "Select * Where mainOrg.id = '" + orgId + "'";
        if (this._exists(ctx, oql)) {
            throw new OUException(OUException.EXIST_ASSISTANT_ORGS);
        }
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(orgType);
        OrgTypeSelfInfo orgTypeSelfInfo = orgAppHelper.getOrgTypeSelfInfo();
        OrgType curOrgType = orgTypeSelfInfo.getOrgType();
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(curOrgType);
        Object[] params = new String[]{curOrgType.getAlias(), curOrgType.getAlias()};
        if (!StringUtils.isEmpty((String)orgTypeInfo.getOrgTreeID()) && OrgAppHelper.isBizChildrenExist(ctx, orgInfo, orgTypeInfo.getOrgTreeID())) {
            throw new OUException(OUException.EXISTCHILDREN_NOTDELETE, params);
        }
        OUPartReference.isReferenced(ctx, orgTypeSelfInfo.getOrgViewBosType().toString(), new ObjectUuidPK(orgInfo.getId()).toString());
        OUPartReference.isReferenced(ctx, orgTypeSelfInfo.getOrgTableBosType().toString(), new ObjectUuidPK(orgInfo.getId()).toString());
        if (unitInfo.get("OldData") == null) {
            FullOrgUnitInfo oldUnitInfo = (FullOrgUnitInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            orgInfo.put("OldData", oldUnitInfo);
        }
        this.otherDealOrgChange(ctx, orgInfo, 4);
        FullOrgUnitCollection unitCol = new FullOrgUnitCollection();
        unitCol.add(orgInfo);
        orgAppHelper.batchDelOrgInfo(ctx, unitCol);
        orgAppHelper.delStructure(ctx, unitCol);
        orgAppHelper.delPermission(ctx, unitCol);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(orgInfo.getId()), (IObjectValue)orgInfo);
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(orgInfo, 3);
        this.otherDealOrgChange(ctx, orgInfo, 3);
        AutoSealUpNoBizOrgUnitHelper.tryAutoSealNoBizOrg(ctx, orgId);
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.UPDATE, (IObjectValue)orgInfo);
        CacheService.getInstance().discardAll();
    }

    @Override
    protected void _batchDelete(Context ctx, IObjectValue unitInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)unitInfo;
        String oldOrgTypeStr = orgUnitInfo.getOrgTypeStr();
        String oql = "select * where longNumber like '" + ((FullOrgUnitInfo)unitInfo).getLongNumber() + "!%' order by longNumber desc";
        FullOrgUnitCollection orgCol = this.getFullOrgUnitCollection(ctx, oql);
        orgCol.add(orgUnitInfo);
        CtrlUnitInfo ctrlInfo = this.getCurrentCtrlUnitInfo(ctx, orgUnitInfo);
        this.delInfo(ctx, orgCol, ctrlInfo);
        orgUnitInfo.setOrgTypeStr(oldOrgTypeStr);
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(orgUnitInfo, 2);
    }

    private void delInfo(Context ctx, FullOrgUnitCollection orgUnitCol, CtrlUnitInfo ctrlInfo) throws BOSException, EASBizException {
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            return;
        }
        int colSize = orgUnitCol.size() - 1;
        ArrayList<String[]> delStructList = new ArrayList<String[]>();
        ArrayList<String[]> delList = new ArrayList<String[]>();
        ArrayList<String[]> pkList = new ArrayList<String[]>();
        FullOrgUnitCollection unitCol = new FullOrgUnitCollection();
        for (int i = 0; i <= colSize; ++i) {
            FullOrgUnitInfo deleteInfo = orgUnitCol.get(i);
            String ouID = deleteInfo.getId().toString();
            String[] params = new String[]{ouID};
            pkList.add(params);
            if (deleteInfo.isIsAssistantOrg()) {
                delStructList.add(params);
            } else {
                if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(ouID) || "00000000-0000-0000-0000-000000000000CCE7AED4".equals(ouID)) {
                    throw new OUException(OUException.SYSTEM_INSET_CAN_NOT_DELETE);
                }
                delList.add(params);
                unitCol.add(deleteInfo);
            }
            this.otherDealRelateToOrg(ctx, deleteInfo, "afterOrgDelete", null);
        }
        if (delStructList.size() > 0) {
            String delStruSql = "delete from t_org_structure where funitId = ?";
            DbUtil.executeBatch((Context)ctx, (String)delStruSql, delStructList);
            ORMValueCacheService.getInstance().discardType(ctx, new OrgStructureInfo().getBOSType());
        }
        if (delList.size() > 0) {
            String delOrgUnitSql = "delete from T_ORG_baseunit where fmainOrgid = ?";
            DbUtil.executeBatch((Context)ctx, (String)delOrgUnitSql, delList);
            String delCUBDControlSql = "delete from t_org_cubdcontrol where fcontrolunitid = ?";
            DbUtil.executeBatch((Context)ctx, (String)delCUBDControlSql, delList);
            ORMValueCacheService.getInstance().discardType(ctx, new CUBDControlInfo().getBOSType());
            String delOrgStruSql = "delete from t_org_structure where funitId = ?";
            DbUtil.executeBatch((Context)ctx, (String)delOrgStruSql, delList);
            ORMValueCacheService.getInstance().discardType(ctx, new OrgStructureInfo().getBOSType());
            String delOrgUnitRealationSql = "delete from T_ORG_UnitRelation where ffromunitid = ?";
            DbUtil.executeBatch((Context)ctx, (String)delOrgUnitRealationSql, delList);
            ORMValueCacheService.getInstance().discardType(ctx, new OrgUnitRelationInfo().getBOSType());
            String delUnitDefRelFrom = "delete from T_ORG_UnitDefaultRelation where FFromUnitID =?";
            String delUnitDefRelTo = "delete from T_ORG_UnitDefaultRelation where  FToUnitID =?";
            DbUtil.executeBatch((Context)ctx, (String)delUnitDefRelFrom, delList);
            DbUtil.executeBatch((Context)ctx, (String)delUnitDefRelTo, delList);
            ORMValueCacheService.getInstance().discardType(ctx, new OrgUnitDefaultRelationInfo().getBOSType());
            String updateOrgUnitSql = "Update T_Org_BaseUnit set FControlUnitId = null, FPartCtrlID = null, FPartAdminID = null, FPartFIID = null, FPartSaleID = null, FPartStorageID = null, FPartPurchaseID = null, FPartCostCenterID = null, FPartProfitCenterID = null, FPartHRID = null, FPartTransportID = null Where FID = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateOrgUnitSql, delList);
            if (FullOrgUnitControllerBean.getDelUserOrgRangeRef() != null) {
                FullOrgUnitControllerBean.getDelUserOrgRangeRef().batchDelUserOrgRangeRef(ctx, pkList);
            }
            String delAdminHis = "delete from T_ORG_AdminHIS where fHistoryRelateid =?";
            DbUtil.executeBatch((Context)ctx, (String)delAdminHis, delList);
            OrgTypeAppCenter.getInstance().batchDelOrgInfo(ctx, unitCol);
            OrgTypeAppCenter.getInstance().delPermission(ctx, unitCol);
        }
        if (pkList.size() > 0) {
            OUPartReference.delReferenced(ctx, BOSTYPE, pkList, "");
            String delOrgUnitSql = "delete from T_ORG_baseunit where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)delOrgUnitSql, pkList);
            ORMValueCacheService.getInstance().discardType(ctx, new FullOrgUnitInfo().getBOSType());
            OrgLogServerUtils.log(ctx, OrgLogTypeEnum.DELETE, orgUnitCol);
        }
    }

    private void delInfo(Context ctx, FullOrgUnitInfo deleteInfo) throws BOSException, EASBizException {
        String ouID = deleteInfo.getId().toString();
        if (deleteInfo.isIsAssistantOrg()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ouID));
            IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
            iStruct.delete(filter);
        } else {
            if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(ouID) || "00000000-0000-0000-0000-000000000000CCE7AED4".equals(ouID)) {
                throw new OUException(OUException.SYSTEM_INSET_CAN_NOT_DELETE);
            }
            if (deleteInfo.isIsCU()) {
                CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                if (ouID.toString().equals(ctrlInfo.getId().toString())) {
                    throw new OUException(OUException.NOT_DELETE_CURRENT_CU);
                }
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Object[] param = new Object[]{ouID};
            paramList.add(param);
            DbUtil.executeBatch((Context)ctx, (String)"delete from T_ORG_baseunit where fmainOrgid = ?", paramList);
            ICUBDControl iBDControl = CUBDControlFactory.getLocalInstance(ctx);
            FilterInfo bdFilter = new FilterInfo();
            bdFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)deleteInfo.getId().toString(), CompareType.EQUALS));
            iBDControl.delete(bdFilter);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)ouID));
            IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
            iStruct.delete(filter);
            IOrgDelegateFacade iDelegate = OrgDelegateFacadeFactory.getLocalInstance(ctx);
            iDelegate.deleteSelfDelegate(ouID);
            DbUtil.executeBatch((Context)ctx, (String)"delete from T_ORG_UnitDefaultRelation where FFromUnitID =?", paramList);
            DbUtil.executeBatch((Context)ctx, (String)"delete from T_ORG_UnitDefaultRelation where  FToUnitID=?", paramList);
            DbUtil.executeBatch((Context)ctx, (String)"Update T_Org_BaseUnit set FControlUnitId = null, FPartCtrlID = null, FPartAdminID = null, FPartFIID = null, FPartSaleID = null, FPartStorageID = null, FPartPurchaseID = null, FPartCostCenterID = null, FPartProfitCenterID = null, FPartHRID = null, FPartTransportID = null Where FID = ?", paramList);
            if (FullOrgUnitControllerBean.getDelUserOrgRangeRef() != null) {
                FullOrgUnitControllerBean.getDelUserOrgRangeRef().deleteUserOrgRangeRef(ctx, (IObjectPK)new ObjectUuidPK(ouID));
            }
            FullOrgUnitCollection unitCol = new FullOrgUnitCollection();
            unitCol.add(deleteInfo);
            OrgTypeAppCenter.getInstance().batchDelOrgInfo(ctx, unitCol);
            OrgTypeAppCenter.getInstance().delPermission(ctx, unitCol);
        }
        OUPartReference.delReferenced(ctx, BOSTYPE, ouID, "");
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(deleteInfo.getId()));
        this.dispachIntermitNumber(ctx, deleteInfo);
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables();
        this.otherDealRelateToOrg(ctx, deleteInfo, "afterOrgDelete", null);
        OrgLogServerUtils.log(ctx, OrgLogTypeEnum.DELETE, (IObjectValue)deleteInfo);
    }

    @Override
    protected void _upgradeCU(Context ctx, String unitID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(unitID);
        FullOrgUnitInfo oldUnitInfo = (FullOrgUnitInfo)this._getValue(ctx, (IObjectPK)pk);
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)oldUnitInfo.clone();
        String orgTypeStr = unitInfo.getOrgTypeStr();
        boolean isEmptyOrg = StringUtils.isEmpty((String)orgTypeStr);
        if (isEmptyOrg) {
            unitInfo.setOrgTypeStr(OrgTypeHelper.createLikeStr(OrgType.ControlUnit));
        } else {
            unitInfo.setOrgTypeStr(orgTypeStr + OrgTypeHelper.createLikeStr(OrgType.ControlUnit));
        }
        unitInfo.setIsCU(true);
        String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
        unitInfo.setVersionNumber(versionNumber);
        CUBDControlCollection controlCol = CUBDControlUtils.loadDefaultCUBDControl(ctx);
        if (controlCol != null) {
            unitInfo.put("CUBDControl", (Object)controlCol);
        }
        OrgAppCtrlHelper ctrlHelper = new OrgAppCtrlHelper();
        ctrlHelper.addNewCtrl(ctx, (IObjectPK)pk, unitInfo, versionNumber);
        if (!isEmptyOrg && orgTypeStr.indexOf(OrgType.Admin.getName()) > 0) {
            this.updateOUPartAdmin(ctx, unitInfo, oldUnitInfo);
        }
        FullOrgUnitInfo orgUnit = null;
        try {
            Object obj = ObjectUtils.createCopy((Object)unitInfo);
            if (obj instanceof FullOrgUnitInfo) {
                orgUnit = (FullOrgUnitInfo)obj;
                orgUnit.put("OldData", oldUnitInfo);
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"error!", (Throwable)e);
        }
        super._update(ctx, (IObjectPK)pk, (IObjectValue)unitInfo);
        this.updateChildFullOrgUnit(ctx, unitInfo);
        OrgSpecialTablesRebuildFacadeFactory.getLocalInstance(ctx).rebuildSpecialTables(unitInfo, 5);
        this.addCURange(ctx, unitInfo);
        this.getClass();
        this.otherDealOrgUpGrade(ctx, unitInfo, 1);
        if (orgUnit != null) {
            OrgLogServerUtils.log(ctx, OrgLogTypeEnum.UPDATE, (IObjectValue)orgUnit);
        }
    }

    public void updateOUPartAdmin(Context ctx, FullOrgUnitInfo unitInfo, FullOrgUnitInfo oldUnitInfo) throws BOSException, EASBizException {
        if (unitInfo == null || unitInfo.getCU() == null || oldUnitInfo == null || oldUnitInfo.getCU() == null) {
            throw new BOSException("unitInfo can't be null");
        }
        StringBuffer updateSql = new StringBuffer(100);
        updateSql.append("UPDATE t_org_oupartadmin ").append(" set fcontrolunitid=?").append(" where funitid in (select fid from t_org_baseunit where fcontrolunitid =?").append(" and (flongnumber=?").append(" or flongnumber like ?))");
        String longNumber = oldUnitInfo.getLongNumber();
        Object[] params = new String[]{unitInfo.getCU().getId().toString(), oldUnitInfo.getCU().getId().toString(), longNumber, longNumber + "!%"};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
        ORMValueCacheService.getInstance().discardType(ctx, new OUPartAdmin().getType());
    }

    private void addCURange(Context ctx, FullOrgUnitInfo unitInfo) throws EASBizException, BOSException {
        String autoAddCu2Admin = ParamManager.getParamValue((Context)ctx, null, (String)"AutoAddOrg");
        if ("true".equalsIgnoreCase(autoAddCu2Admin)) {
            Administrator.addcu2admin((Context)ctx, (FullOrgUnitInfo)unitInfo);
            Administrator.addCURange((Context)ctx, (FullOrgUnitInfo)unitInfo);
        }
    }

    private void updateParentFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        if (unitInfo != null && unitInfo.getParent() != null && unitInfo.getParent().getId() != null) {
            String parentId = unitInfo.getParent().getId().toString();
            String oql = " where parent='" + parentId + "' and id!='" + unitInfo.getId().toString() + "'";
            if (!this.exists(ctx, oql)) {
                String updateSql = "update t_org_baseUnit set fisleaf=1 where fid=?";
                Object[] params = new String[]{unitInfo.getParent().getId().toString()};
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
                ORMValueCacheService.getInstance().remove(ctx, unitInfo.getBOSType(), parentId);
            }
        }
    }

    private void updateChildFullOrgUnit(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException {
        StringBuffer updateSql = new StringBuffer(50);
        updateSql.append("UPDATE t_org_baseUnit ").append(" set fcontrolunitid=?").append(" where flongnumber like ?");
        Object[] params = new String[]{unitInfo.getCU().getId().toString(), unitInfo.getLongNumber() + "!%"};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
        ORMValueCacheService.getInstance().discardType(ctx, unitInfo.getBOSType());
    }

    private static IDelUserOrgRangeRef getDelUserOrgRangeRef() throws BOSException {
        try {
            if (delUserOrgRangeRef == null) {
                Class<?> delClass = Class.forName("com.kingdee.eas.basedata.org.helper.DelUserOrgRangeRefImpl");
                delUserOrgRangeRef = (IDelUserOrgRangeRef)delClass.newInstance();
            }
            return delUserOrgRangeRef;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("ClassNotFoundException: " + e));
            throw new BOSException("ClassNotFoundException: " + e);
        }
        catch (InstantiationException e) {
            logger.error((Object)("InstantiationException: " + e));
            throw new BOSException("InstantiationException: " + e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("IllegalAccessException: " + e));
            throw new BOSException("IllegalAccessException: " + e);
        }
    }

    @Override
    protected void _batchSyncFromAdminTree(Context ctx) throws BOSException, EASBizException {
        if (OrgHelper.isSupportSyncFromAdmin(ctx)) {
            SyncOrgUnitStructHelper.syncBaseUnitStructFromAdmin(ctx);
        }
    }
}

