/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnit;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class OrgAppUtils {
    public static int IN_CLAUSE_COUNT = 100;
    private static Logger logger = Logger.getLogger(OrgAppUtils.class);

    public static void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)model;
        OrgUnitInfo parentInfo = (OrgUnitInfo)unitInfo.get("$ParentUnit$");
        OrgTreeInfo treeInfo = (OrgTreeInfo)unitInfo.get("$TreeInfo$");
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance(ctx);
        if (parentInfo != null) {
            OrgStructureInfo parentStrucInfo = iStruct.getValue(treeInfo, parentInfo);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.name", (Object)unitInfo.getName()));
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentStrucInfo.getId()));
            if (unitInfo.isIsGrouping()) {
                filter.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("unit.isGrouping", (Object)new Integer(1), CompareType.NOTEQUALS));
            }
            if (unitInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfo.getId(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            IOrgStructure iOrgStruct = OrgStructureFactory.getLocalInstance(ctx);
            OrgStructureCollection results = iOrgStruct.getOrgStructureCollection(view);
            if (results.size() > 0) {
                throw new OrgException(OrgException.DUPLICATE_UNIT_NAME);
            }
        }
    }

    public static void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgUnitInfo unitInfo = (OrgUnitInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)unitInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (unitInfo.getId() != null) {
            FilterItemInfo filterItem2 = new FilterItemInfo("id", (Object)unitInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem2);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IOrgUnit iOrgUnit = OrgUnitFactory.getLocalInstance(ctx);
        OrgUnitCollection results = iOrgUnit.getOrgUnitCollection(view);
        if (results.size() > 0) {
            throw new OrgException(OrgException.DUPLICATE_UNIT_NUMBER);
        }
    }

    public static String[] getAncestor(String longNumber) {
        if (longNumber == null || longNumber.length() == 0) {
            return new String[0];
        }
        String[] element = longNumber.split("!");
        String[] ancestor = new String[element.length];
        ancestor[0] = element[0];
        for (int i = 1; i < element.length; ++i) {
            ancestor[i] = ancestor[i - 1] + "!" + element[i];
        }
        return ancestor;
    }

    public static void executeOrgViewSql(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, params[0].toString());
            ps.setString(2, params[1].toString());
            ps.setInt(3, (Integer)params[2]);
            ps.setInt(4, (Integer)params[3]);
            ps.setBoolean(5, (Boolean)params[4]);
            ps.setString(6, params[5].toString());
            if (params[6] == null) {
                ps.setNull(7, 1);
            } else {
                ps.setString(7, (String)params[6]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    protected static void _isReferenced(Context ctx, String strBos, IObjectPK pk) throws BOSException, EASBizException {
        BizReference ref = null;
        try {
            ref = OrgAppUtils.getReference(ctx, strBos, BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"error when checking org reference!", (Throwable)e);
        }
        if (ref != null) {
            throw new ObjectReferedException((Object)ref);
        }
    }

    public static BizReference getReference(Context ctx, String strBos, BOSUuid objID) throws BizReferenceException {
        Connection conn = null;
        ResultSet rs = null;
        BizReference reference = null;
        try {
            conn = OrgAppUtils.getConnection(ctx);
        }
        catch (SQLException ex) {
            throw new BizReferenceException(BizReferenceException.DB_CONNECTION_ERR, ex.getCause());
        }
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        String matched = "select FRefTableName,FRefFieldName,FRefEntityName,FRefEntityAlias_L1,FRefEntityAlias_L2,FRefEntityAlias_L3 FROM T_SYS_EntityRef where FIsBosFK=1 and FBosType= ? ";
        boolean found = false;
        try {
            stat1 = conn.prepareStatement(matched);
            stat1.setString(1, strBos);
            rs = stat1.executeQuery();
            String sql0 = "select 1 where exists( select 1 from ";
            String id = objID.toString();
            ResultSet rsTemp = null;
            while (rs.next()) {
                StringBuffer sql = new StringBuffer();
                sql.append(sql0);
                sql.append(rs.getString(1));
                sql.append(" where ");
                sql.append(rs.getString(2));
                sql.append(" = ?");
                stat2 = conn.prepareStatement(sql.toString());
                stat2.setString(1, id);
                rsTemp = stat2.executeQuery();
                if (!rsTemp.next()) continue;
                found = true;
                break;
            }
            if (found) {
                reference = new BizReference();
                reference.setRefTableName(rs.getString(1));
                reference.setRefFieldName(rs.getString(2));
                reference.setRefEntityName(rs.getString(3));
                reference.setRefEntityAlias_L1(rs.getString(4));
                reference.setRefEntityAlias_L2(rs.getString(5));
                reference.setRefEntityAlias_L3(rs.getString(6));
            }
        }
        catch (SQLException e2) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e2);
        }
        finally {
            SQLUtils.cleanup(stat2);
            SQLUtils.cleanup((Statement)stat1);
            SQLUtils.cleanup((Connection)conn);
        }
        return reference;
    }

    protected static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }
}

