/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationException;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.app.AbstractOrgTypeRelationControllerBean;
import com.kingdee.eas.common.EASBizException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class OrgTypeRelationControllerBean
extends AbstractOrgTypeRelationControllerBean {
    @Override
    protected IObjectValue _getValue(Context ctx, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fromType", (Object)new Integer(fromType.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("toType", (Object)new Integer(toType.getValue())));
        viewInfo.setFilter(filterInfo);
        OrgTypeRelationCollection col = this.getOrgTypeRelationCollection(ctx, viewInfo);
        if (col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected void _batchAddnew(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        if (col == null || col.size() == 0) {
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            this.checkExistTypeRelation(ctx, col.getObject(i));
        }
        StringBuffer insertSql = new StringBuffer("INSERT INTO T_ORG_TypeRelation(FID, FFromType, FToType, FCreatorID, FLastUpdateUserID, FExistReverseDelegate) ").append("VALUES (?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(insertSql.toString());
            OrgTypeRelationCollection relationCol = (OrgTypeRelationCollection)col;
            for (int i = 0; i < relationCol.size(); ++i) {
                OrgTypeRelationInfo relationInfo = relationCol.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)relationInfo.getBOSType()).toString());
                pstmt.setInt(2, relationInfo.getFromType().getValue());
                pstmt.setInt(3, relationInfo.getToType().getValue());
                pstmt.setString(4, "00000000-0000-0000-0000-00000000000013B7DE7F");
                pstmt.setString(5, "00000000-0000-0000-0000-00000000000013B7DE7F");
                pstmt.setInt(6, 0);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkFTSame(ctx, model);
        this.checkExistTypeRelation(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkFTSame(ctx, model);
        this.checkExistTypeRelation(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkFTSame(Context ctx, IObjectValue model) throws OrgTypeRelationException {
        OrgType toType;
        OrgTypeRelationInfo relationInfo = (OrgTypeRelationInfo)model;
        OrgType fromType = relationInfo.getFromType();
        if (fromType.equals((Object)(toType = relationInfo.getToType()))) {
            throw new OrgTypeRelationException(OrgTypeRelationException.EXIST_SAME_ORGTYPE);
        }
    }

    private void checkExistTypeRelation(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OrgTypeRelationInfo relationInfo = (OrgTypeRelationInfo)model;
        OrgType fromType = relationInfo.getFromType();
        OrgType toType = relationInfo.getToType();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fromType", (Object)new Integer(fromType.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("toType", (Object)new Integer(toType.getValue())));
        if (relationInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)relationInfo.getId(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new OrgTypeRelationException(OrgTypeRelationException.EXIST_DEFINE_ORGTYPERELATION, new String[]{fromType.toString(), toType.toString()});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk.toString().startsWith("00000000-0000-0000-0000-000000000")) {
            throw new OrgException(OrgException.CAN_NOT_DELETE_INIALDATA);
        }
        super._delete(ctx, pk);
    }
}

