/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncOrgUnitStructHelper {
    private static Logger logger = Logger.getLogger((String)SyncOrgUnitStructHelper.class.getName());

    public static boolean checkOrgIsSync(Context ctx, String orgId) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT 1 ");
        sqlBuilder.append("FROM t_org_baseunit unit inner join T_ORG_admin admin on unit.FID = admin.FID ");
        sqlBuilder.append("where unit.FPARENTID = admin.FPARENTID and unit.fid=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{orgId});
        try {
            return rs.next();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void syncOrgUnitParentByAdmin(Context ctx, IObjectPK orgPk) throws EASBizException, BOSException {
        String adminParentId;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo(orgPk);
            adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo(orgPk);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        if (fullOrgUnitInfo == null || adminOrgUnitInfo == null) {
            return;
        }
        FullOrgUnitInfo orgParent = fullOrgUnitInfo.getParent();
        AdminOrgUnitInfo adminParent = adminOrgUnitInfo.getParent();
        if (adminParent == null || adminParent.getId() == null || orgParent == null || orgParent.getId() == null) {
            return;
        }
        String orgParentId = orgParent.getId().toString();
        if (orgParentId.equals(adminParentId = adminParent.getId().toString())) {
            return;
        }
        NewOUInnerFacadeFactory.getLocalInstance(ctx).ouShift(orgPk, (IObjectPK)new ObjectStringPK(adminParentId));
    }

    public static void syncBaseUnitStructFromAdmin(Context ctx) throws BOSException, EASBizException {
        INewOUInnerFacade iNewOUInnerFacade = NewOUInnerFacadeFactory.getLocalInstance(ctx);
        List<Map<String, String>> diffParentOrgList = SyncOrgUnitStructHelper.getOrgDiffParentData(ctx);
        if (!diffParentOrgList.isEmpty()) {
            for (Map<String, String> diffOrgMap : diffParentOrgList) {
                ObjectStringPK ouPK = new ObjectStringPK(diffOrgMap.get("ID"));
                String adminOrgParetID = diffOrgMap.get("PARENTID");
                if (StringUtils.isEmpty((String)adminOrgParetID)) continue;
                iNewOUInnerFacade.ouShift((IObjectPK)ouPK, (IObjectPK)new ObjectStringPK(adminOrgParetID));
            }
        }
    }

    private static List<Map<String, String>> getOrgDiffParentData(Context ctx) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT unit.fid as fid,unit.FLONGNUMBER ,admin.FPARENTID as fParentId ");
        sqlBuilder.append("FROM t_org_baseunit unit inner join T_ORG_admin admin on unit.FID = admin.FID ");
        sqlBuilder.append("where unit.FPARENTID <> admin.FPARENTID and unit.FISOUSEALUP = 0 and admin.FISSEALUP =0");
        sqlBuilder.append("order by unit.flongnumber desc");
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("ID", rs.getString("fid"));
                map.put("PARENTID", rs.getString("fParentId"));
                data.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return data;
    }
}

