/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.basedata.org.FIAccountRangeFactory;
import com.kingdee.eas.basedata.org.FIAccountRangeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Map;

public class FIAccountRangeDI
extends AbstractDataTransmission {
    protected String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.org.ImportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FIAccountRangeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this.getController(ctx).addnew(coreBaseInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        Locale currentLocale = ctx.getLocale();
        String fiOrgNumber = (String)((DataToken)hsData.get((Object)"FFIOrgUnitId_number")).data;
        if (StringUtils.isEmpty((String)fiOrgNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"FIOrgNumberIsNotEmpty", (Locale)currentLocale));
        }
        String profitOrgNumber = (String)((DataToken)hsData.get((Object)"FProfitOrgUnitId_number")).data;
        if (StringUtils.isEmpty((String)profitOrgNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ProfitOrgNumberIsNotEmpty", (Locale)currentLocale));
        }
        FIAccountRangeInfo fiAccountRangeInfo = new FIAccountRangeInfo();
        String oqlFi = "select id,number,isCompanyOrgUnit,partFI.accountTable.id,partFI.isBizUnit where number = '" + fiOrgNumber + "'";
        String oqlProfit = "select id,number,isProfitOrgUnit,partFI.accountTable.id,partProfitCenter.isBizUnit where number = '" + profitOrgNumber + "'";
        try {
            FullOrgUnitCollection fiCol = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitCollection(oqlFi);
            FullOrgUnitCollection prifitCol = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitCollection(oqlProfit);
            FullOrgUnitInfo fiInfo = fiCol.get(0);
            FullOrgUnitInfo profitInfo = prifitCol.get(0);
            if (fiInfo != null && profitInfo != null) {
                if (!fiInfo.isIsCompanyOrgUnit()) {
                    throw new TaskExternalException(fiInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"NeedsFIOrg", (Locale)currentLocale));
                }
                if (!profitInfo.isIsProfitOrgUnit() || !profitInfo.getPartProfitCenter().isIsBizUnit()) {
                    throw new TaskExternalException(profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"ProfitOrgNeedsBizUnit", (Locale)currentLocale));
                }
                FullOrgUnitInfo toUnit = null;
                try {
                    OrgUnitRelationInfo relationInfo = OrgUnitRelationFactory.getLocalInstance(ctx).getOrgUnitRelationInfo("select tounit.partFi.accountTable where fromUnit.id = '" + profitInfo.getId().toString() + "' and TYPERELATION.FROMTYPE = 6");
                    toUnit = relationInfo.getToUnit();
                }
                catch (ObjectNotFoundException e) {
                    throw new TaskExternalException(profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"NoFIOrgFound", (Locale)currentLocale));
                }
                if (toUnit.getPartFI().getAccountTable() == null) {
                    throw new TaskExternalException(fiInfo.getNumber() + " | " + profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"EntrustFiOrgAcTableEmpty", (Locale)currentLocale));
                }
                if (fiInfo.getPartFI().getAccountTable() == null) {
                    throw new TaskExternalException(fiInfo.getNumber() + " | " + profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"EntrustFiOrgAcTableEmpty", (Locale)currentLocale));
                }
                if (!fiInfo.getPartFI().getAccountTable().getId().toString().equals(toUnit.getPartFI().getAccountTable().getId().toString())) throw new TaskExternalException(fiInfo.getNumber() + " | " + profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"FIAccountAndProfitAccountIncon", (Locale)currentLocale));
                fiAccountRangeInfo.setFIOrgUnitId(fiInfo);
                fiAccountRangeInfo.setProfitOrgUnitId(profitInfo);
                if (!FIAccountRangeFactory.getLocalInstance((Context)ctx).exists("where FiOrgUnitid.id = '" + fiInfo.getId().toString() + "' and ProfitOrgUnitId.id='" + profitInfo.getId().toString() + "'")) return fiAccountRangeInfo;
                throw new TaskExternalException(fiInfo.getNumber() + " | " + profitInfo.getNumber() + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"AccountRangeExisted", (Locale)currentLocale));
            }
            if (fiInfo == null) {
                throw new TaskExternalException(fiOrgNumber + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"OrgNumberNotExisted", (Locale)currentLocale));
            }
            if (profitInfo != null) return fiAccountRangeInfo;
            throw new TaskExternalException(profitOrgNumber + " : " + ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"OrgNumberNotExisted", (Locale)currentLocale));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }
}

