/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OrgToolForShrHelper {
    private static Logger logger = Logger.getLogger((String)OrgToolForShrHelper.class.getName());

    public static synchronized String sealAllNoBizOrg() throws Exception {
        try {
            Context ctx = ContextUtils.getContextFromSession();
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (!Administrator.isSuperAdmin((IObjectPK)new ObjectStringPK(currentUserInfo.getId().toString()))) {
                return "\u65e0\u6cd5\u6267\u884c\uff0c\u6b64\u64cd\u4f5c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u53ef\u6267\u884c\uff01";
            }
            logger.error((Object)"\u6279\u91cf\u5c01\u5b58SHR\u7684\u65e0\u6548\u7ec4\u7ec7\u5355\u5143-\u5f00\u59cb...");
            OrgToolForShrHelper.init(ctx);
            String bakTableName = OrgToolForShrHelper.bak(ctx);
            OrgToolForShrHelper.sealNoBizOrg(ctx, bakTableName);
            logger.error((Object)"\u6279\u91cf\u5c01\u5b58SHR\u7684\u65e0\u6548\u7ec4\u7ec7\u5355\u5143-\u7ed3\u675f\u3002");
            return "\u6279\u91cf\u5c01\u5b58SHR\u7684\u65e0\u6548\u7ec4\u7ec7\u5355\u5143\u6210\u529f\uff01";
        }
        catch (Exception e) {
            logger.error((Object)"\u6279\u91cf\u5c01\u5b58SHR\u7684\u65e0\u6548\u7ec4\u7ec7\u5355\u5143-\u4e2d\u65ad\uff01");
            logger.error((Object)("\u6267\u884c\u5931\u8d25\uff1a" + e));
            throw e;
        }
    }

    private static void sealNoBizOrg(Context ctx, String bakTableName) throws BOSException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance(ctx);
        INewOUInnerFacade iNewOUInnerFacade = NewOUInnerFacadeFactory.getLocalInstance(ctx);
        FullOrgUnitCollection fullOrgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection("select * where isOUSealUp = 0 order by longnumber desc");
        for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(i);
            String unitId = fullOrgUnitInfo.getId().toString();
            try {
                try {
                    OrgToolForShrHelper.checkBizPropertiesSealedUp(ctx, fullOrgUnitInfo);
                }
                catch (Exception e) {
                    logger.error((Object)("\u5c01\u5b58\u7ec4\u7ec7\u9884\u6821\u9a8c\u5931\u8d25" + fullOrgUnitInfo.getLongNumber()));
                    OrgToolForShrHelper.logDb(ctx, bakTableName, unitId, 0, "\u7ec4\u7ec7\u9884\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u6267\u884c\u5c01\u5b58\u64cd\u4f5c\uff0c\u6821\u9a8c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                    continue;
                }
                iNewOUInnerFacade.ouSealUp(unitId);
                OrgToolForShrHelper.logDb(ctx, bakTableName, unitId, 2, "success");
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)("\u5c01\u5b58\u7ec4\u7ec7" + fullOrgUnitInfo.getLongNumber()));
                OrgToolForShrHelper.logDb(ctx, bakTableName, unitId, 1, e.getMessage());
            }
        }
    }

    private static void init(Context ctx) throws BOSException {
        String historySql = "If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='t_org_shr_ouSealHistory') Create Table t_org_shr_ouSealHistory (fbakTable varchar(44),forgid VARCHAR(44),fsealupSuccess INT ,exceptionError VARCHAR(4000))";
        DbUtil.execute((Context)ctx, (String)historySql);
    }

    private static String bak(Context ctx) throws BOSException {
        String bakTableName = "T_ORG_BASEUnit" + System.currentTimeMillis();
        String bakSql = "SELECT * into " + bakTableName + " FROM T_ORG_BASEUnit";
        DbUtil.execute((Context)ctx, (String)bakSql);
        return bakTableName;
    }

    private static void logDb(Context ctx, String bakTable, String orgid, Integer sealupSuccess, String exceptionError) throws BOSException {
        try {
            String sql = "insert into t_org_shr_ouSealHistory(fbakTable,forgid,fsealupSuccess,exceptionError) values (?,?,?,?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bakTable, orgid, sealupSuccess, exceptionError});
        }
        catch (Exception e) {
            logger.error((Object)("\u8bb0\u5f55\u5c01\u5b58\u65e5\u5fd7\u5931\u8d25\uff1abakTable" + bakTable + ";orgid:" + orgid + ";sealupSuccess:" + sealupSuccess + ";exceptionError:" + exceptionError));
        }
    }

    private static void checkBizPropertiesSealedUp(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        String unitID = unitInfo.getId().toString();
        Iterator it = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo().iterator();
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
        IDynamicObject iDO = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String oql = "Select isSealUp Where unit.id = '" + unitID + "'";
        while (it.hasNext()) {
            OUPartCoreBaseInfo ouPartBaseInfo;
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
            if (OrgType.NONE == orgTypeInfo.getOrgType()) continue;
            OrgTypeSelfInfo orgTypeSelfInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType()).getOrgTypeSelfInfo();
            if (!orgTypeHelper.isOrgType(orgTypeInfo.getOrgType()) || (ouPartBaseInfo = (OUPartCoreBaseInfo)iDO.getValue(orgTypeSelfInfo.getOrgTableBosType(), oql)).getBoolean("isSealUp")) continue;
            Object[] params = new String[]{orgTypeInfo.getOrgType().getAlias()};
            throw new OUException(OUException.CANT_OUSEALUP_NOTSEALUP, params);
        }
    }
}

