/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.helper.orgtypeimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartBaseInfo;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.OrgVersionServerUtils;
import com.kingdee.eas.basedata.org.app.helper.orgtypeimpl.IOrgUnitInfoFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class OrgQueryHelper {
    private static Logger logger = Logger.getLogger((String)OrgQueryHelper.class.getName());

    public static OrgUnitCollection createOrgUnitVersionCollection(Context ctx, ResultSet rs, IOrgUnitInfoFactory orgFactory) throws Exception {
        OrgUnitCollection hrVersionCol = new OrgUnitCollection();
        while (rs.next()) {
            OrgUnitInfo versionInfo = OrgQueryHelper.createOrgUnitVersionInfo(ctx, rs, orgFactory);
            hrVersionCol.add(versionInfo);
        }
        return hrVersionCol;
    }

    public static OrgUnitInfo createOrgUnitVersionInfo(Context ctx, ResultSet rs, IOrgUnitInfoFactory orgFactory) throws Exception {
        OrgUnitInfo retOrgInfo = OrgVersionServerUtils.createOrgUnitVersionInfo(ctx, orgFactory.createOrgInfo(), rs);
        String versionNumber = retOrgInfo.getVersionNumber();
        String parentId = rs.getString("FParentID");
        if (parentId != null && parentId.trim().length() != 0) {
            OrgUnitInfo parentVersionInfo = orgFactory.createOrgInfo();
            parentVersionInfo.setId(BOSUuid.read((String)parentId));
            parentVersionInfo.setVersionNumber(versionNumber);
            retOrgInfo.put("parent", parentVersionInfo);
        }
        retOrgInfo.setBoolean("isBizUnit", rs.getBoolean("FIsBizUnit"));
        retOrgInfo.setBoolean("isSealUp", rs.getBoolean("FIsSealUp"));
        retOrgInfo.setDate("propertySealUpDate", rs.getDate("FPropertySealUpDate"));
        return retOrgInfo;
    }

    public static OUPartBaseInfo createOUPartVersionInfo(Context ctx, ResultSet rs, OUPartBaseInfo retInfo) throws Exception {
        String versionNumber = rs.getString("FVersionNumber");
        String id = rs.getString("FID");
        retInfo.setVersionNumber(versionNumber);
        retInfo.setId(BOSUuid.read((String)id));
        String unitId = rs.getString("FUnitID");
        if (unitId != null && unitId.trim().length() != 0) {
            FullOrgUnitInfo fullVersionInfo = new FullOrgUnitInfo(versionNumber, BOSUuid.read((String)unitId));
            retInfo.setUnit(fullVersionInfo);
        }
        retInfo.setIsBizUnit(rs.getBoolean("FIsBizUnit"));
        retInfo.setIsSealUp(rs.getBoolean("FIsSealUp"));
        retInfo.setPropertySealUpDate(rs.getDate("FPropertySealUpDate"));
        return retInfo;
    }

    public static OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql, OUPartBaseInfo retInfo) throws BOSException, EASBizException {
        return OrgQueryHelper.getOUPartVersionInfo(ctx, selectSql, retInfo, null);
    }

    public static OUPartCoreBaseInfo getOUPartVersionInfo(Context ctx, String selectSql, OUPartBaseInfo retInfo, Object[] params) throws BOSException, EASBizException {
        if (selectSql == null) {
            throw new BOSException("selectSql can't be null!");
        }
        Connection cn = null;
        Statement stmt = null;
        IRowSet rs = null;
        try {
            rs = params != null && params.length > 0 ? DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])params) : DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (!rs.next()) {
                OUPartCoreBaseInfo oUPartCoreBaseInfo = null;
                return oUPartCoreBaseInfo;
            }
            OUPartBaseInfo partHRVersionInfo = OrgQueryHelper.createOUPartVersionInfo(ctx, (ResultSet)rs, retInfo);
            if (rs.next()) {
                throw new BOSException("Too many records with selectSql: " + selectSql);
            }
            OUPartBaseInfo oUPartBaseInfo = partHRVersionInfo;
            return oUPartBaseInfo;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, stmt, cn);
        }
    }
}

