/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.log;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.BizParentAndDelegateInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ObjectValueForOrgUnitUtils;
import com.kingdee.eas.basedata.org.OrgAlterPageEnum;
import com.kingdee.eas.basedata.org.OrgLogCollection;
import com.kingdee.eas.basedata.org.OrgLogInfo;
import com.kingdee.eas.basedata.org.OrgLogTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.app.log.OrgLogQueue;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgLogServerUtils {
    private static Logger logger = Logger.getLogger((String)OrgLogServerUtils.class.getName());
    private static String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.org.OrgLogResource";
    private static final String[] SPECIAL_ADDNEW_PROPERTIES = new String[]{"isCompanyOrgUnit", "isAdminOrgUnit", "isSaleOrgUnit", "isPurchaseOrgUnit", "isStorageOrgUnit", "isProfitOrgUnit", "isCostOrgUnit", "isHROrgUnit", "isTransportOrgUnit", "isQualityOrgUnit"};
    private static final String[] SPECIAL_OU_PART_PROPERTIES = new String[]{"partCtrl", "partAdmin", "partFI", "partSale", "partStorage", "partPurchase", "partCostCenter", "partProfitCenter", "partHR", "partUnionGroup", "partTransport", "partQuality"};

    public static OrgAlterPageEnum convert(String propertyName) {
        if ("isCompanyOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_COMPANY;
        }
        if ("isAdminOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_ADMIN;
        }
        if ("isSaleOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_SALE;
        }
        if ("isPurchaseOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_PURCHASE;
        }
        if ("isStorageOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_STORAGE;
        }
        if ("isProfitOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_PROFITCENTER;
        }
        if ("isCostOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_COSTCENTER;
        }
        if ("isHROrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_HRO;
        }
        if ("isTransportOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_TRANSPORT;
        }
        if ("isQualityOrgUnit".equals(propertyName)) {
            return OrgAlterPageEnum.PAGE_QUALITY;
        }
        return null;
    }

    public static OrgAlterPageEnum convert(BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (!bosType.equals((Object)orgTypeInfo.getBosType()) && !bosType.equals((Object)orgTypeInfo.getPartBosType())) continue;
            return orgTypeInfo.getOrgAlterEnum();
        }
        return null;
    }

    public static OrgAlterPageEnum convert(OrgType type) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(type);
        if (orgTypeInfo == null) {
            return null;
        }
        return orgTypeInfo.getOrgAlterEnum();
    }

    public static String convertToExtentedProperty(String propertyName) {
        if ("isCompanyOrgUnit".equals(propertyName)) {
            return "OUPartFI";
        }
        if ("isAdminOrgUnit".equals(propertyName)) {
            return "OUPartAdmin";
        }
        if ("isSaleOrgUnit".equals(propertyName)) {
            return "OUPartSale";
        }
        if ("isPurchaseOrgUnit".equals(propertyName)) {
            return "OUPartPurchase";
        }
        if ("isStorageOrgUnit".equals(propertyName)) {
            return "OUPartStorage";
        }
        if ("isProfitOrgUnit".equals(propertyName)) {
            return "OUPartProfitCenter";
        }
        if ("isCostOrgUnit".equals(propertyName)) {
            return "OUPartCostCenter";
        }
        if ("isHROrgUnit".equals(propertyName)) {
            return "OUPartHR";
        }
        if ("isTransportOrgUnit".equals(propertyName)) {
            return "OUPartTransport";
        }
        if ("isQualityOrgUnit".equals(propertyName)) {
            return "OUPartQuality";
        }
        return null;
    }

    public static void log(Context ctx, OrgLogTypeEnum alterType, IObjectValue model) {
        FullOrgUnitCollection orgUnitCol = new FullOrgUnitCollection();
        orgUnitCol.add((FullOrgUnitInfo)model);
        OrgLogServerUtils.log(ctx, alterType, orgUnitCol);
    }

    public static void log(Context ctx, OrgLogTypeEnum alterType, FullOrgUnitCollection orgUnitCol) {
        int i;
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            return;
        }
        OrgLogCollection logCol = new OrgLogCollection();
        for (i = 0; i < orgUnitCol.size(); ++i) {
            FullOrgUnitInfo orgUnitInfo = orgUnitCol.get(i);
            OrgLogCollection orgLogCol = OrgLogServerUtils.produceOrgLogCollection(ctx, alterType, (IObjectValue)orgUnitInfo);
            logCol.addCollection(orgLogCol);
        }
        try {
            for (i = 0; i < logCol.size(); ++i) {
                OrgLogInfo logInfo = logCol.get(i);
                OrgLogServerUtils.writeLog(ctx, logInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void log(Context ctx, OrgLogTypeEnum alterType) {
        OrgLogServerUtils.log(ctx, OrgAlterPageEnum.PAGE_BASIC, alterType, null);
    }

    public static void log(Context ctx, OrgAlterPageEnum alterPage, OrgLogTypeEnum alterType, IObjectValue model) {
        try {
            OrgLogCollection logCol = OrgLogServerUtils.produceOrgLogCollection(ctx, alterPage, alterType, model);
            for (int i = 0; i < logCol.size(); ++i) {
                OrgLogInfo logInfo = logCol.get(i);
                OrgLogServerUtils.writeLog(ctx, logInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void log(Context ctx, IObjectValue unitInfo, OrgUnitInfo oldParent, OrgUnitInfo newParent) {
        try {
            OrgLogInfo logInfo = OrgLogServerUtils.getUpdateOrgLogInfoByCompareBizParent(ctx, unitInfo, oldParent, newParent);
            if (logInfo != null) {
                OrgLogServerUtils.writeLog(ctx, logInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void log(Context ctx, IObjectValue unitInfo, OrgUnitRelationCollection oldDelegateCol, OrgUnitRelationCollection newDelegateCol) {
        try {
            OrgLogCollection logCol = OrgLogServerUtils.getUpdateOrgLogColByCompareDelegation(ctx, unitInfo, oldDelegateCol, newDelegateCol);
            for (int i = 0; i < logCol.size(); ++i) {
                OrgLogInfo logInfo = logCol.get(i);
                OrgLogServerUtils.writeLog(ctx, logInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void writeLog(Context ctx, OrgLogInfo logInfo) throws SQLException {
        IObjectPK logPk = OrgLogServerUtils.beginLog(ctx, logInfo);
        if (OrgLogQueue.getInstance().size() < 1024) {
            logInfo.put("context", ctx);
            OrgLogQueue.getInstance().enqueue(logInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            return;
        }
        OrgLogServerUtils.directWriteLog(ctx, logInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private static IObjectPK beginLog(Context ctx, OrgLogInfo logInfo) {
        String afterImage;
        String logItemName = "";
        Locale locale = ctx.getLocale();
        String orgUnitName = logInfo.get("FOrgUnitName_" + locale) == null ? null : logInfo.get("FOrgUnitName_" + locale).toString();
        String orgUnitNumber = logInfo.get("FOrgUnitNumber") == null ? null : logInfo.get("FOrgUnitNumber").toString();
        OrgAlterPageEnum alterPage = (OrgAlterPageEnum)((Object)logInfo.get("FAlterPage"));
        OrgLogTypeEnum alterType = (OrgLogTypeEnum)((Object)logInfo.get("FAlterType"));
        String alterFieldAlias = logInfo.get("FAlterFieldAlias_" + locale) == null ? null : logInfo.get("FAlterFieldAlias_" + locale).toString();
        String alterFieldName = logInfo.get("FAlterFieldName") == null ? null : logInfo.get("FAlterFieldName").toString();
        String changeDescription = logInfo.get("FChangeDescription_" + locale) == null ? null : logInfo.get("FChangeDescription_" + locale).toString();
        String beforeImage = logInfo.get("FBeforeImage_" + locale) == null ? null : logInfo.get("FBeforeImage_" + locale).toString();
        String string = afterImage = logInfo.get("FAfterImage_" + locale) == null ? null : logInfo.get("FAfterImage_" + locale).toString();
        if (alterPage == OrgAlterPageEnum.PAGE_BASIC) {
            switch (alterType.getValue()) {
                case 1: {
                    logItemName = "OU_AddNew";
                    break;
                }
                case 2: {
                    logItemName = "OU_Update";
                    break;
                }
                case 3: {
                    logItemName = "OU_Delete";
                    break;
                }
                case 6: {
                    logItemName = "OU_SealUp";
                    break;
                }
                case 7: {
                    logItemName = "OU_UnSealUp";
                    break;
                }
                case 8: {
                    logItemName = "OU_Shift";
                    break;
                }
                default: {
                    if ("isCU".equals(alterFieldName)) {
                        logItemName = "OU_UpgradeCU";
                        break;
                    }
                    logItemName = "OU_Update";
                    break;
                }
            }
        } else {
            switch (alterType.getValue()) {
                case 6: {
                    logItemName = "OU_BizSealUp";
                    break;
                }
                case 7: {
                    logItemName = "OU_BizUnSealUp";
                    break;
                }
                default: {
                    logItemName = "OU_Update";
                }
            }
        }
        StringBuilder detailMsg = new StringBuilder();
        if (!StringUtils.isEmpty((String)orgUnitName)) {
            detailMsg.append("\u7ec4\u7ec7\u540d\u79f0: ").append(orgUnitName).append("; ");
        }
        if (!StringUtils.isEmpty((String)orgUnitNumber)) {
            detailMsg.append("\u7ec4\u7ec7\u7f16\u7801: ").append(orgUnitNumber).append("; ");
        }
        detailMsg.append("\u53d8\u66f4\u9875\u7b7e: ").append((Object)alterPage).append("; ");
        detailMsg.append("\u53d8\u66f4\u7c7b\u578b: ").append((Object)alterType).append("; ");
        if (!StringUtils.isEmpty((String)changeDescription)) {
            detailMsg.append("\u53d8\u66f4\u63cf\u8ff0: ").append(changeDescription).append("; ");
        }
        if (!StringUtils.isEmpty((String)alterFieldAlias)) {
            detailMsg.append("\u53d8\u66f4\u5b57\u6bb5: ").append(alterFieldAlias).append("; ");
        }
        if (!StringUtils.isEmpty((String)beforeImage)) {
            detailMsg.append("\u53d8\u66f4\u524d\u6570\u636e: ").append(beforeImage).append("; ");
        }
        if (!StringUtils.isEmpty((String)afterImage)) {
            detailMsg.append("\u53d8\u66f4\u540e\u6570\u636e: ").append(afterImage);
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)(alterPage.toString() + (Object)((Object)alterType)), (BOSObjectType)new FullOrgUnitInfo().getBOSType(), (IObjectPK)ctx.getCaller(), (String)detailMsg.toString(), (String)logItemName);
        return logPk;
    }

    private static void writeLog(Context ctx, OrgLogInfo logInfo, PreparedStatement stmtIns) throws SQLException {
        if (OrgLogQueue.getInstance().size() < 1024) {
            logInfo.put("context", ctx);
            OrgLogQueue.getInstance().enqueue(logInfo);
            return;
        }
        OrgLogServerUtils.setDirectWiriteLogPS(logInfo, stmtIns);
    }

    private static void putLogQueue(Context ctx, OrgLogInfo logInfo) {
        if (OrgLogQueue.getInstance().size() < 1024) {
            logInfo.put("context", ctx);
            OrgLogQueue.getInstance().enqueue(logInfo);
        }
    }

    private static void setDirectWiriteLogPS(OrgLogInfo logInfo, PreparedStatement stmtIns) throws SQLException {
        OrgLogServerUtils.checkOrgLogInfo(logInfo);
        stmtIns.setString(1, logInfo.get("FID").toString());
        stmtIns.setString(2, logInfo.get("FOrgUnitID").toString());
        stmtIns.setString(3, logInfo.get("FOrgUnitNumber") == null ? null : logInfo.get("FOrgUnitNumber").toString());
        stmtIns.setString(4, logInfo.get("FOrgUnitName_L1") == null ? null : logInfo.get("FOrgUnitName_L1").toString());
        stmtIns.setString(5, logInfo.get("FOrgUnitName_L2") == null ? null : logInfo.get("FOrgUnitName_L2").toString());
        stmtIns.setString(6, logInfo.get("FOrgUnitName_L3") == null ? null : logInfo.get("FOrgUnitName_L3").toString());
        stmtIns.setInt(7, ((OrgAlterPageEnum)((Object)logInfo.get("FAlterPage"))).getValue());
        stmtIns.setInt(8, ((OrgLogTypeEnum)((Object)logInfo.get("FAlterType"))).getValue());
        stmtIns.setString(9, logInfo.get("FAlterFieldName") == null ? null : logInfo.get("FAlterFieldName").toString());
        stmtIns.setString(10, logInfo.get("FAlterFieldAlias_L1") == null ? null : logInfo.get("FAlterFieldAlias_L1").toString());
        stmtIns.setString(11, logInfo.get("FAlterFieldAlias_L2") == null ? null : logInfo.get("FAlterFieldAlias_L2").toString());
        stmtIns.setString(12, logInfo.get("FAlterFieldAlias_L3") == null ? null : logInfo.get("FAlterFieldAlias_L3").toString());
        stmtIns.setString(13, logInfo.get("FBeforeImageID") == null ? null : logInfo.get("FBeforeImageID").toString());
        stmtIns.setString(14, logInfo.get("FBeforeImage_L1") == null ? null : logInfo.get("FBeforeImage_L1").toString());
        stmtIns.setString(15, logInfo.get("FBeforeImage_L2") == null ? null : logInfo.get("FBeforeImage_L2").toString());
        stmtIns.setString(16, logInfo.get("FBeforeImage_L3") == null ? null : logInfo.get("FBeforeImage_L3").toString());
        stmtIns.setString(17, logInfo.get("FAfterImageID") == null ? null : logInfo.get("FAfterImageID").toString());
        stmtIns.setString(18, logInfo.get("FAfterImage_L1") == null ? null : logInfo.get("FAfterImage_L1").toString());
        stmtIns.setString(19, logInfo.get("FAfterImage_L2") == null ? null : logInfo.get("FAfterImage_L2").toString());
        stmtIns.setString(20, logInfo.get("FAfterImage_L3") == null ? null : logInfo.get("FAfterImage_L3").toString());
        stmtIns.setTimestamp(21, (Timestamp)logInfo.get("FAlterTime"));
        stmtIns.setString(22, logInfo.get("FAlterUserID").toString());
        stmtIns.setString(23, logInfo.get("FChangeDescription_l1") == null ? null : logInfo.get("FChangeDescription_l1").toString());
        stmtIns.setString(24, logInfo.get("FChangeDescription_l2") == null ? null : logInfo.get("FChangeDescription_l2").toString());
        stmtIns.setString(25, logInfo.get("FChangeDescription_l3") == null ? null : logInfo.get("FChangeDescription_l3").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void directWriteLog(Context ctx, OrgLogInfo logInfo) throws SQLException {
        String insOrgLogSql = OrgLogServerUtils.getInsertOrgLogSql();
        Connection conn = null;
        PreparedStatement stmtIns = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmtIns = conn.prepareStatement(insOrgLogSql);
            OrgLogServerUtils.setDirectWiriteLogPS(logInfo, stmtIns);
            stmtIns.execute();
        }
        finally {
            if (stmtIns != null) {
                try {
                    stmtIns.close();
                }
                catch (Exception exception) {}
                stmtIns = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
                conn = null;
            }
        }
    }

    private static void checkOrgLogInfo(OrgLogInfo logInfo) {
        if (logInfo.get("FID") == null) {
            throw new IllegalArgumentException("FID can't be null!");
        }
        if (logInfo.get("FOrgUnitID") == null) {
            throw new IllegalArgumentException("FOrgUnitID can't be null!");
        }
        if (logInfo.get("FAlterPage") == null) {
            throw new IllegalArgumentException("FAlterPage can't be null!");
        }
        if (logInfo.get("FAlterType") == null) {
            throw new IllegalArgumentException("FAlterType can't be null!");
        }
        if (logInfo.get("FAlterTime") == null) {
            throw new IllegalArgumentException("FAlterTime can't be null!");
        }
        if (logInfo.get("FAlterUserID") == null) {
            throw new IllegalArgumentException("FUpdateUserID can't be null!");
        }
    }

    private static String getInsertOrgLogSql() {
        StringBuffer insertLogSql = new StringBuffer("INSERT INTO T_ORG_Log");
        insertLogSql.append("(FID, FOrgUnitID, FOrgUnitNumber, ");
        insertLogSql.append("FOrgUnitName_L1, FOrgUnitName_L2, FOrgUnitName_L3, ");
        insertLogSql.append("FAlterPage, FAlterType, FAlterFieldName, ");
        insertLogSql.append("FAlterFieldAlias_L1, FAlterFieldAlias_L2, FAlterFieldAlias_L3, ");
        insertLogSql.append("FBeforeImageID, FBeforeImage_L1, FBeforeImage_L2, FBeforeImage_L3, ");
        insertLogSql.append("FAfterImageID, FAfterImage_L1, FAfterImage_L2, FAfterImage_L3, ");
        insertLogSql.append("FAlterTime, FAlterUserID,FChangeDescription_l1,FChangeDescription_l2,FChangeDescription_l3) ");
        insertLogSql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return insertLogSql.toString();
    }

    private static OrgLogCollection produceOrgLogCollection(Context ctx, OrgLogTypeEnum alterType, IObjectValue model) {
        FullOrgUnitInfo oldUnitInfo;
        OrgLogCollection col;
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)model;
        OrgLogCollection logCol = new OrgLogCollection();
        if (alterType.getValue() == 1 || alterType.getValue() == 3) {
            OrgLogInfo logInfo = OrgLogServerUtils.getBasicOrgLogInfo(ctx, alterType, (IObjectValue)unitInfo);
            logCol.add(logInfo);
        } else if (alterType.getValue() == 2 && (col = OrgLogServerUtils.createOrgLogCollectionByComparing(ctx, (IObjectValue)unitInfo, oldUnitInfo = (FullOrgUnitInfo)unitInfo.get("OldData"), unitInfo)) != null) {
            logCol = col;
        }
        return logCol;
    }

    private static OrgLogCollection produceOrgLogCollection(Context ctx, OrgAlterPageEnum alterPage, OrgLogTypeEnum alterType, IObjectValue unitInfo) {
        OrgLogCollection logCol = new OrgLogCollection();
        OrgLogInfo logInfo = OrgLogServerUtils.getBasicOrgLogInfo(ctx, alterType, unitInfo);
        logInfo.put("FAlterPage", (Object)alterPage);
        logCol.add(logInfo);
        return logCol;
    }

    private static OrgLogInfo getBasicOrgLogInfo(Context ctx, OrgLogTypeEnum alterType, IObjectValue unitInfo) {
        OrgLogInfo logInfo = new OrgLogInfo();
        logInfo.put("FID", BOSUuid.create((BOSObjectType)logInfo.getBOSType()).toString());
        if (unitInfo != null) {
            logInfo.put("FOrgUnitID", unitInfo.get("id").toString());
            logInfo.put("FOrgUnitNumber", unitInfo.get("number").toString());
            OrgLogServerUtils.setOrgUnitName(ctx, logInfo, unitInfo);
            if (alterType.getValue() == 2) {
                Object obj = unitInfo.get("changeDescription");
                String changeDesription = StringUtils.cnulls((Object)obj);
                String chageDescription_l1 = "";
                String chageDescription_l2 = "";
                String chageDescription_l3 = "";
                if (ctx.getLocale() != null && "l2".equals(ctx.getLocale().toString().toLowerCase())) {
                    chageDescription_l2 = changeDesription;
                    chageDescription_l3 = STConverter.sc2tc((String)changeDesription);
                } else if (ctx.getLocale() != null && "l3".equals(ctx.getLocale().toString().toLowerCase())) {
                    chageDescription_l3 = changeDesription;
                    chageDescription_l2 = STConverter.tc2sc((String)changeDesription);
                } else if (ctx.getLocale() != null && "l1".equals(ctx.getLocale().toString().toLowerCase())) {
                    chageDescription_l1 = changeDesription;
                    chageDescription_l2 = changeDesription;
                    chageDescription_l3 = changeDesription;
                }
                logInfo.put("FChangeDescription_l1", chageDescription_l1);
                logInfo.put("FChangeDescription_l2", chageDescription_l2);
                logInfo.put("FChangeDescription_l3", chageDescription_l3);
                logInfo.setChangeDescription(changeDesription);
            }
        } else {
            logInfo.put("FOrgUnitID", "00000000-0000-0000-0000-000000000000CCE7AED4");
        }
        logInfo.put("FAlterPage", (Object)OrgAlterPageEnum.PAGE_BASIC);
        logInfo.put("FAlterType", (Object)alterType);
        logInfo.put("FAlterTime", new Timestamp(System.currentTimeMillis()));
        logInfo.put("FAlterUserID", ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        return logInfo;
    }

    private static OrgLogCollection createOrgLogCollectionByComparing(Context ctx, IObjectValue unitInfo, FullOrgUnitInfo oldUnitInfo, FullOrgUnitInfo newUnitInfo) {
        OrgLogCollection col;
        if (ctx == null) {
            return null;
        }
        if (oldUnitInfo == newUnitInfo) {
            return null;
        }
        if (oldUnitInfo == null || newUnitInfo == null) {
            return null;
        }
        OrgLogCollection logCol = new OrgLogCollection();
        HashSet<String> maskPropertySet = new HashSet<String>();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(oldUnitInfo.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (!(property instanceof OwnPropertyInfo) || ObjectValueForOrgUnitUtils.ownPropertyEquals((IObjectValue)oldUnitInfo, (IObjectValue)newUnitInfo, (OwnPropertyInfo)property)) continue;
            OrgLogInfo logInfo = OrgLogServerUtils.getUpdateOrgLogInfo(ctx, unitInfo, (IObjectValue)oldUnitInfo, (IObjectValue)newUnitInfo, property);
            logCol.add(logInfo);
            if (!OrgLogServerUtils.isSpecialAddnewProperties(property.getName())) continue;
            maskPropertySet.add(OrgLogServerUtils.convertToExtentedProperty(property.getName()));
        }
        for (PropertyInfo property : pc) {
            if (!(property instanceof LinkPropertyInfo) || maskPropertySet.contains(property.getName())) continue;
            IObjectValue oldChildObject = (IObjectValue)oldUnitInfo.get(property.getName());
            IObjectValue newChildObject = (IObjectValue)newUnitInfo.get(property.getName());
            if (OrgLogServerUtils.isSpecialOUPartProperties(property.getName())) {
                OrgLogCollection col2 = OrgLogServerUtils.createOrgLogCollectionByComparing(ctx, unitInfo, oldChildObject, newChildObject);
                if (col2 == null || col2.size() <= 0) continue;
                logCol.addCollection(col2);
                continue;
            }
            if (ObjectValueForOrgUnitUtils.objectValueEqualsPk(ctx, oldChildObject, newChildObject)) continue;
            OrgLogInfo logInfo = OrgLogServerUtils.getUpdateOrgLogInfo(ctx, unitInfo, (IObjectValue)oldUnitInfo, (IObjectValue)newUnitInfo, property);
            logCol.add(logInfo);
        }
        BizParentAndDelegateInfo oldPDInfo = (BizParentAndDelegateInfo)oldUnitInfo.get("PDValueInfo");
        BizParentAndDelegateInfo newPDInfo = (BizParentAndDelegateInfo)newUnitInfo.get("PDValueInfo");
        if (oldPDInfo != null && newPDInfo != null && (col = OrgLogServerUtils.getOrgLogFromBizParentAndDelegateInfo(ctx, unitInfo, oldPDInfo, newPDInfo)) != null && col.size() > 0) {
            logCol.addCollection(col);
        }
        return logCol;
    }

    private static OrgLogCollection getOrgLogFromBizParentAndDelegateInfo(Context ctx, IObjectValue unitInfo, BizParentAndDelegateInfo oldPDInfo, BizParentAndDelegateInfo newPDInfo) {
        OrgUnitRelationCollection newDelegateCol;
        assert (oldPDInfo != null && newPDInfo != null);
        OrgLogCollection logCol = new OrgLogCollection();
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : orgTypeInfoCol) {
            OrgLogInfo logInfo;
            if (OrgType.NONE == orgTypeInfo.getOrgType() || (logInfo = OrgLogServerUtils.getUpdateOrgLogInfoByCompareBizParent(ctx, unitInfo, oldPDInfo.getParentOrg(orgTypeInfo.getOrgType()), newPDInfo.getParentOrg(orgTypeInfo.getOrgType()))) == null) continue;
            logCol.add(logInfo);
        }
        OrgUnitRelationCollection oldDelegateCol = oldPDInfo.getDelegateCollection();
        OrgLogCollection col = OrgLogServerUtils.getUpdateOrgLogColByCompareDelegation(ctx, unitInfo, oldDelegateCol, newDelegateCol = newPDInfo.getDelegateCollection());
        if (col != null && col.size() > 0) {
            logCol.addCollection(col);
        }
        return logCol;
    }

    private static OrgLogInfo getUpdateOrgLogInfoByCompareBizParent(Context ctx, IObjectValue unitInfo, OrgUnitInfo oldParent, OrgUnitInfo newParent) {
        if (oldParent == null && newParent == null) {
            return null;
        }
        if (oldParent != null && newParent != null && oldParent.getId().toString().equals(newParent.getId().toString())) {
            return null;
        }
        OrgLogInfo logInfo = OrgLogServerUtils.getBasicOrgLogInfo(ctx, OrgLogTypeEnum.UPDATE, unitInfo);
        BOSObjectType bosType = oldParent != null ? oldParent.getBOSType() : newParent.getBOSType();
        logInfo.put("FAlterPage", (Object)OrgLogServerUtils.convert(bosType));
        logInfo.put("FAlterFieldName", "biz parent");
        OrgLogServerUtils.setAlterFieldAlias(ctx, logInfo, bosType);
        if (oldParent != null) {
            OrgLogServerUtils.setBeforeImage(ctx, logInfo, oldParent);
        }
        if (newParent != null) {
            OrgLogServerUtils.setAfterImage(ctx, logInfo, newParent);
        }
        return logInfo;
    }

    private static OrgLogCollection getUpdateOrgLogColByCompareDelegation(Context ctx, IObjectValue unitInfo, OrgUnitRelationCollection oldDelegateCol, OrgUnitRelationCollection newDelegateCol) {
        OrgLogInfo logInfo;
        TypeRelation key;
        OrgLogCollection logCol = new OrgLogCollection();
        HashMap<TypeRelation, OrgUnitRelationList> oldDelegateMap = new HashMap<TypeRelation, OrgUnitRelationList>();
        if (oldDelegateCol != null) {
            int n = oldDelegateCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitRelationInfo oldDelegateInfo = oldDelegateCol.get(i);
                OrgType fromType = null;
                OrgType toType = null;
                OrgTypeRelationInfo typeInfo = oldDelegateInfo.getTypeRelation();
                if (typeInfo != null) {
                    fromType = typeInfo.getFromType();
                    toType = typeInfo.getToType();
                } else {
                    fromType = (OrgType)((Object)oldDelegateInfo.get("fromType"));
                    toType = (OrgType)((Object)oldDelegateInfo.get("toType"));
                }
                TypeRelation key2 = new TypeRelation(fromType, toType);
                OrgUnitRelationList relList = (OrgUnitRelationList)oldDelegateMap.get(key2);
                if (relList != null) {
                    relList.toUnitList.add(oldDelegateInfo.getToUnit());
                    continue;
                }
                ArrayList<FullOrgUnitInfo> toUnitList = new ArrayList<FullOrgUnitInfo>();
                toUnitList.add(oldDelegateInfo.getToUnit());
                relList = new OrgUnitRelationList(fromType, toType, toUnitList);
                oldDelegateMap.put(key2, relList);
            }
        }
        HashMap<TypeRelation, OrgUnitRelationList> newDelegateMap = new HashMap<TypeRelation, OrgUnitRelationList>();
        if (newDelegateCol != null) {
            int n = newDelegateCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitRelationInfo newDelegateInfo = newDelegateCol.get(i);
                OrgType fromType = null;
                OrgType toType = null;
                OrgTypeRelationInfo typeInfo = newDelegateInfo.getTypeRelation();
                if (typeInfo != null) {
                    fromType = typeInfo.getFromType();
                    toType = typeInfo.getToType();
                } else {
                    fromType = (OrgType)((Object)newDelegateInfo.get("fromType"));
                    toType = (OrgType)((Object)newDelegateInfo.get("toType"));
                }
                TypeRelation key3 = new TypeRelation(fromType, toType);
                OrgUnitRelationList relList = (OrgUnitRelationList)newDelegateMap.get(key3);
                if (relList != null) {
                    relList.toUnitList.add(newDelegateInfo.getToUnit());
                    continue;
                }
                ArrayList<FullOrgUnitInfo> toUnitList = new ArrayList<FullOrgUnitInfo>();
                toUnitList.add(newDelegateInfo.getToUnit());
                relList = new OrgUnitRelationList(fromType, toType, toUnitList);
                newDelegateMap.put(key3, relList);
            }
        }
        for (Map.Entry entry : oldDelegateMap.entrySet()) {
            OrgUnitRelationList newRelationList;
            key = (TypeRelation)entry.getKey();
            OrgUnitRelationList oldRelationList = (OrgUnitRelationList)entry.getValue();
            logInfo = OrgLogServerUtils.getUpdateOrgLogInfoByCompareDelegation(ctx, unitInfo, oldRelationList, newRelationList = (OrgUnitRelationList)newDelegateMap.get(key));
            if (logInfo == null) continue;
            logCol.add(logInfo);
        }
        for (Map.Entry entry : newDelegateMap.entrySet()) {
            key = (TypeRelation)entry.getKey();
            OrgUnitRelationList newRelationList = (OrgUnitRelationList)entry.getValue();
            OrgUnitRelationList oldRelationList = (OrgUnitRelationList)oldDelegateMap.get(key);
            if (oldRelationList != null || (logInfo = OrgLogServerUtils.getUpdateOrgLogInfoByCompareDelegation(ctx, unitInfo, oldRelationList, newRelationList)) == null) continue;
            logCol.add(logInfo);
        }
        return logCol;
    }

    private static OrgLogInfo getUpdateOrgLogInfoByCompareDelegation(Context ctx, IObjectValue unitInfo, OrgUnitRelationList oldRelationList, OrgUnitRelationList newRelationList) {
        if (oldRelationList == null && newRelationList == null) {
            return null;
        }
        if (OrgLogServerUtils.equalsOrgUnitRelationList(oldRelationList, newRelationList)) {
            return null;
        }
        OrgLogInfo logInfo = OrgLogServerUtils.getBasicOrgLogInfo(ctx, OrgLogTypeEnum.UPDATE, unitInfo);
        boolean hasSet = false;
        if (oldRelationList != null) {
            hasSet = true;
            logInfo.put("FAlterPage", (Object)OrgLogServerUtils.convert(oldRelationList.fromType));
            logInfo.put("FAlterFieldName", "unit relation");
            OrgLogServerUtils.setAlterFieldAlias(ctx, logInfo, oldRelationList.fromType, oldRelationList.toType);
            OrgLogServerUtils.setBeforeImage(ctx, logInfo, oldRelationList);
        }
        if (newRelationList != null) {
            if (!hasSet) {
                logInfo.put("FAlterPage", (Object)OrgLogServerUtils.convert(newRelationList.fromType));
                logInfo.put("FAlterFieldName", "unit relation");
                OrgLogServerUtils.setAlterFieldAlias(ctx, logInfo, newRelationList.fromType, newRelationList.toType);
            }
            OrgLogServerUtils.setAfterImage(ctx, logInfo, newRelationList);
        }
        return logInfo;
    }

    private static boolean equalsOrgUnitRelationList(OrgUnitRelationList source, OrgUnitRelationList target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            if (!source.fromType.equals((Object)target.fromType)) {
                return false;
            }
            if (!source.toType.equals((Object)target.toType)) {
                return false;
            }
            if (source.toUnitList.size() != target.toUnitList.size()) {
                return false;
            }
            for (FullOrgUnitInfo toUnit : source.toUnitList) {
                String id = toUnit.getId().toString();
                boolean equal = false;
                for (int i = 0; i < target.toUnitList.size(); ++i) {
                    if (!id.equals(((FullOrgUnitInfo)target.toUnitList.get(i)).getId().toString())) continue;
                    equal = true;
                    break;
                }
                if (equal) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static OrgLogCollection createOrgLogCollectionByComparing(Context ctx, IObjectValue unitInfo, IObjectValue oldObject, IObjectValue newObject) {
        if (ctx == null) {
            return null;
        }
        if (oldObject == newObject) {
            return null;
        }
        if (oldObject == null || newObject == null) {
            return null;
        }
        OrgLogCollection logCol = new OrgLogCollection();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(oldObject.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo property : pc) {
            if (property instanceof OwnPropertyInfo) {
                if (ObjectValueForOrgUnitUtils.ownPropertyEquals(oldObject, newObject, (OwnPropertyInfo)property)) continue;
                OrgLogInfo logInfo = OrgLogServerUtils.getUpdateOrgLogInfo(ctx, unitInfo, oldObject, newObject, property);
                logCol.add(logInfo);
                continue;
            }
            if (!(property instanceof LinkPropertyInfo)) continue;
            boolean composite = ObjectValueForOrgUnitUtils.isComposite(entity, (LinkPropertyInfo)property);
            IObjectValue oldChildObject = (IObjectValue)oldObject.get(property.getName());
            IObjectValue newChildObject = (IObjectValue)newObject.get(property.getName());
            if (composite) {
                OrgLogCollection col = OrgLogServerUtils.createOrgLogCollectionByComparing(ctx, unitInfo, oldChildObject, newChildObject);
                if (col == null || col.size() <= 0) continue;
                logCol.addCollection(col);
                continue;
            }
            if (ObjectValueForOrgUnitUtils.objectValueEqualsPk(ctx, oldChildObject, newChildObject)) continue;
            OrgLogInfo logInfo = OrgLogServerUtils.getUpdateOrgLogInfo(ctx, unitInfo, oldObject, newObject, property);
            logCol.add(logInfo);
        }
        return logCol;
    }

    private static OrgLogInfo getUpdateOrgLogInfo(Context ctx, IObjectValue unitInfo, IObjectValue oldObject, IObjectValue newObject, PropertyInfo property) {
        if (OrgLogServerUtils.isSpecialAddnewProperties(property.getName())) {
            OrgLogInfo logInfo = null;
            logInfo = oldObject.getBoolean(property.getName()) ? OrgLogServerUtils.getBasicOrgLogInfo(ctx, OrgLogTypeEnum.DELETE, unitInfo) : OrgLogServerUtils.getBasicOrgLogInfo(ctx, OrgLogTypeEnum.ADDNEW, unitInfo);
            logInfo.put("FAlterPage", (Object)OrgLogServerUtils.convert(property.getName()));
            return logInfo;
        }
        OrgLogInfo logInfo = OrgLogServerUtils.getBasicOrgLogInfo(ctx, OrgLogTypeEnum.UPDATE, unitInfo);
        OrgAlterPageEnum alterPage = OrgLogServerUtils.convert(oldObject.getBOSType());
        if (alterPage != null) {
            logInfo.put("FAlterPage", (Object)alterPage);
        }
        logInfo.put("FAlterFieldName", property.getName());
        OrgLogServerUtils.setAlterFieldAlias(ctx, logInfo, property);
        OrgLogServerUtils.setBeforeImage(ctx, logInfo, property, oldObject);
        OrgLogServerUtils.setAfterImage(ctx, logInfo, property, newObject);
        return logInfo;
    }

    private static boolean isSpecialAddnewProperties(String propertyName) {
        for (int i = 0; i < SPECIAL_ADDNEW_PROPERTIES.length; ++i) {
            if (!SPECIAL_ADDNEW_PROPERTIES[i].equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecialOUPartProperties(String propertyName) {
        for (int i = 0; i < SPECIAL_OU_PART_PROPERTIES.length; ++i) {
            if (!SPECIAL_OU_PART_PROPERTIES[i].equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private static void setOrgUnitName(Context ctx, OrgLogInfo logInfo, IObjectValue unitInfo) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        String key = "FOrgUnitName_";
        LanguageCollection langCol = soluctionInfo.getLanguages();
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            Locale locale = langInfo.getLocale();
            String value = TypeConversionUtils.objToString((Object)unitInfo.get("name", locale));
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setAlterFieldAlias(Context ctx, OrgLogInfo logInfo, PropertyInfo property) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        String key = "FAlterFieldAlias_";
        LanguageCollection langCol = soluctionInfo.getLanguages();
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            Locale locale = langInfo.getLocale();
            String value = property.getAlias(locale);
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setAlterFieldAlias(Context ctx, OrgLogInfo logInfo, BOSObjectType bosType) {
        OrgTypeInfo curOrgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(bosType);
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        String res_name = "FIELD_SUPERIO";
        String key = "FAlterFieldAlias_";
        LanguageCollection langCol = soluctionInfo.getLanguages();
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            Locale locale = langInfo.getLocale();
            String value = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)res_name, (Locale)locale);
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value + curOrgTypeInfo.getOrgType().getAlias(locale));
        }
    }

    private static void setAlterFieldAlias(Context ctx, OrgLogInfo logInfo, OrgType fromType, OrgType toType) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        String key = "FAlterFieldAlias_";
        LanguageCollection langCol = soluctionInfo.getLanguages();
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            Locale locale = langInfo.getLocale();
            String fromTypeAlias = fromType.getAlias(locale);
            String toTypeAlias = toType.getAlias(locale);
            String value = fromTypeAlias + " " + ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"DELEGATE", (Locale)locale) + " " + toTypeAlias;
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setBeforeImage(Context ctx, OrgLogInfo logInfo, PropertyInfo property, IObjectValue newObject) {
        int i;
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FBeforeImage_";
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProperty = (OwnPropertyInfo)property;
            for (i = 0; i < langCol.size(); ++i) {
                String value = TypeConversionUtils.objToString((Object)newObject.get(ownProperty.getName()));
                LanguageInfo langInfo = langCol.get(i);
                Locale locale = langInfo.getLocale();
                if (ownProperty.isMultilingual()) {
                    value = TypeConversionUtils.objToString((Object)newObject.get(ownProperty.getName(), locale));
                }
                if (ownProperty.getDataType() == DataType.BOOLEAN) {
                    if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
                        value = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"YES", (Locale)locale);
                    } else if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
                        value = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"NO", (Locale)locale);
                    }
                }
                if (ownProperty.getDataType() == DataType.ENUM) {
                    value = OrgLogServerUtils.getEnumValueAlias(ownProperty, value, locale);
                }
                if (value == null) continue;
                String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
                logInfo.put(keyWithPostfix, value);
            }
        }
        if (property instanceof LinkPropertyInfo) {
            IObjectValue childObjectValue = (IObjectValue)newObject.get(property.getName());
            if (childObjectValue == null) {
                return;
            }
            logInfo.put("FBeforeImageID", childObjectValue.get("id"));
            for (i = 0; i < langCol.size(); ++i) {
                LanguageInfo langInfo = langCol.get(i);
                String number = childObjectValue.getString("number");
                String name = TypeConversionUtils.objToString((Object)childObjectValue.get("name", langInfo.getLocale()));
                String value = null;
                if (number != null && name != null) {
                    value = number + " " + name;
                } else if (number != null) {
                    value = number;
                } else if (name != null) {
                    value = name;
                }
                if (value == null) continue;
                String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
                logInfo.put(keyWithPostfix, value);
            }
        }
    }

    private static void setBeforeImage(Context ctx, OrgLogInfo logInfo, OrgUnitInfo oldParent) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        logInfo.put("FBeforeImageID", oldParent.getId().toString());
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FBeforeImage_";
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String number = oldParent.getNumber();
            String name = oldParent.getName(langInfo.getLocale());
            String value = null;
            if (number != null && name != null) {
                value = number + " " + name;
            } else if (number != null) {
                value = number;
            } else if (name != null) {
                value = name;
            }
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setBeforeImage(Context ctx, OrgLogInfo logInfo, OrgUnitRelationList oldRelationList) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FBeforeImage_";
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String value = "";
            for (FullOrgUnitInfo unitInfo : oldRelationList.toUnitList) {
                String number = unitInfo.getNumber();
                String name = unitInfo.getName(langInfo.getLocale());
                String tempStr = "";
                if (number != null && name != null) {
                    tempStr = number + " " + name;
                } else if (number != null) {
                    tempStr = number;
                } else if (name != null) {
                    tempStr = name;
                }
                if (value.length() > 0) {
                    value = value + "; " + tempStr;
                    continue;
                }
                value = tempStr;
            }
            if (value == null || value.trim().length() <= 0) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setAfterImage(Context ctx, OrgLogInfo logInfo, PropertyInfo property, IObjectValue newObject) {
        int i;
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FAfterImage_";
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProperty = (OwnPropertyInfo)property;
            for (i = 0; i < langCol.size(); ++i) {
                String value = TypeConversionUtils.objToString((Object)newObject.get(ownProperty.getName()));
                LanguageInfo langInfo = langCol.get(i);
                Locale locale = langInfo.getLocale();
                if (ownProperty.isMultilingual()) {
                    value = TypeConversionUtils.objToString((Object)newObject.get(ownProperty.getName(), locale));
                }
                if (ownProperty.getDataType() == DataType.BOOLEAN) {
                    if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
                        value = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"YES", (Locale)locale);
                    } else if ("0".equals(value) || "false".equalsIgnoreCase(value)) {
                        value = ResourceBase.getString((String)RESOURCE_FILE_NAME, (String)"NO", (Locale)locale);
                    }
                }
                if (ownProperty.getDataType() == DataType.ENUM) {
                    value = OrgLogServerUtils.getEnumValueAlias(ownProperty, value, locale);
                }
                if (value == null) continue;
                String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
                logInfo.put(keyWithPostfix, value);
            }
        }
        if (property instanceof LinkPropertyInfo) {
            IObjectValue childObjectValue = (IObjectValue)newObject.get(property.getName());
            if (childObjectValue == null) {
                return;
            }
            logInfo.put("FAfterImageID", childObjectValue.get("id"));
            for (i = 0; i < langCol.size(); ++i) {
                LanguageInfo langInfo = langCol.get(i);
                String number = childObjectValue.getString("number");
                String name = TypeConversionUtils.objToString((Object)childObjectValue.get("name", langInfo.getLocale()));
                String value = null;
                if (number != null && name != null) {
                    value = number + " " + name;
                } else if (number != null) {
                    value = number;
                } else if (name != null) {
                    value = name;
                }
                if (value == null) continue;
                String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
                logInfo.put(keyWithPostfix, value);
            }
        }
    }

    private static void setAfterImage(Context ctx, OrgLogInfo logInfo, OrgUnitInfo newParent) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        logInfo.put("FAfterImageID", newParent.getId().toString());
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FAfterImage_";
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String number = newParent.getNumber();
            String name = newParent.getName(langInfo.getLocale());
            String value = null;
            if (number != null && name != null) {
                value = number + " " + name;
            } else if (number != null) {
                value = number;
            } else if (name != null) {
                value = name;
            }
            if (value == null) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static void setAfterImage(Context ctx, OrgLogInfo logInfo, OrgUnitRelationList newRelationList) {
        SolutionInfo soluctionInfo = OrgLogServerUtils.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String key = "FAfterImage_";
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String value = "";
            for (FullOrgUnitInfo unitInfo : newRelationList.toUnitList) {
                String number = unitInfo.getNumber();
                String name = unitInfo.getName(langInfo.getLocale());
                String tempStr = null;
                if (number != null && name != null) {
                    tempStr = number + " " + name;
                } else if (number != null) {
                    tempStr = number;
                } else if (name != null) {
                    tempStr = name;
                }
                if (value.length() > 0) {
                    value = value + "; " + tempStr;
                    continue;
                }
                value = tempStr;
            }
            if (value == null || value.trim().length() <= 0) continue;
            String keyWithPostfix = key + langInfo.getPostfix().toUpperCase();
            logInfo.put(keyWithPostfix, value);
        }
    }

    private static String getEnumValueAlias(OwnPropertyInfo property, String value, Locale locale) {
        if (value == null) {
            return null;
        }
        BizEnumInfo enumInfo = property.getEnumType(MDHostType.RUNTIME);
        BizEnumValueType enumValueType = enumInfo.getDataType();
        if (enumValueType == BizEnumValueType.INTEGER) {
            BizEnumValueInfo enumValueInfo = enumInfo.getInnerEnumValue(Integer.valueOf(value).intValue());
            return enumValueInfo.getAlias(locale);
        }
        if (enumValueType == BizEnumValueType.LONG) {
            BizEnumValueInfo enumValueInfo = enumInfo.getInnerEnumValue(Long.valueOf(value).longValue());
            return enumValueInfo.getAlias(locale);
        }
        if (enumValueType == BizEnumValueType.FLOAT) {
            BizEnumValueInfo enumValueInfo = enumInfo.getInnerEnumValue(Float.valueOf(value).floatValue());
            return enumValueInfo.getAlias(locale);
        }
        if (enumValueType == BizEnumValueType.DOUBLE) {
            BizEnumValueInfo enumValueInfo = enumInfo.getInnerEnumValue(Double.valueOf(value).doubleValue());
            return enumValueInfo.getAlias(locale);
        }
        if (enumValueType == BizEnumValueType.STRING) {
            BizEnumValueInfo enumValueInfo = enumInfo.getInnerEnumValue(value);
            return enumValueInfo.getAlias(locale);
        }
        return null;
    }

    private static SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    private static class OrgUnitRelationList {
        OrgType fromType;
        OrgType toType;
        ArrayList toUnitList;

        public OrgUnitRelationList(OrgType fromType, OrgType toType, ArrayList toUnitList) {
            this.fromType = fromType;
            this.toType = toType;
            this.toUnitList = toUnitList;
        }
    }

    private static class TypeRelation {
        OrgType fromType;
        OrgType toType;

        public TypeRelation(OrgType fromType, OrgType toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeRelation)) {
                return false;
            }
            TypeRelation type = (TypeRelation)obj;
            return this.fromType.getValue() == type.fromType.getValue() && this.toType.getValue() == type.toType.getValue();
        }

        public int hashCode() {
            return this.fromType.getValue() * 10 + this.toType.getValue();
        }
    }
}

