/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.f7.OrgF7Helper;
import com.kingdee.eas.basedata.org.util.OrgF7FilterUtil;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class OrgPermissionFilterService {
    private static Logger logger = Logger.getLogger((String)OrgPermissionFilterService.class.getName());

    public static FilterInfo getAuthorizedOrgsFilter(OrgAssistInfo assistInfo, OrgViewType viewType, OrgTreeInfo treeInfo) throws BOSException {
        assert (viewType != null);
        if (assistInfo.isCUFilter() || assistInfo.isNeedAddOrgRange()) {
            try {
                AbstractOrgViewType orgViewType = null;
                orgViewType = viewType == OrgViewType.UNIONDEBT ? new UnionOrgViewType(assistInfo, viewType, treeInfo.getId().toString()) : (viewType == OrgViewType.RESPONSECENTER ? new ResponsecenterOrgViewType(assistInfo, viewType, treeInfo.getId().toString()) : new OtherOrgViewType(assistInfo, viewType, treeInfo.getId().toString()));
                return ((AbstractOrgViewType)orgViewType).getOrgPermissionFilter();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private static class OtherOrgViewType
    extends AbstractOrgViewType {
        private OtherOrgViewType(OrgAssistInfo assistInfo, OrgViewType viewType, String treeID) {
            super(assistInfo, viewType, treeID);
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.assistInfo.isCUFilter()) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("unit.cu.id", (Object)this.assistInfo.getCuID(), CompareType.EQUALS));
                if (this.assistInfo.isCUFilterIncludeSub()) {
                    filter.getFilterItems().add(new FilterItemInfo("unit.cu.longNumber", (Object)(OrgF7FilterUtil.getCULongNumber(null, this.assistInfo.getCuID()) + "!%"), CompareType.LIKE));
                    filter.setMaskString("(#0 or #1)");
                }
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                return OrgF7Helper.getFilterByOrgRange("unit.cu.id", this.assistInfo.getUserPK().toString(), 10);
            }
            return filter;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.assistInfo.isCUFilter()) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.viewType, true, this.assistInfo.isCUFilterIncludeSub());
                try {
                    filter = new FilterInfo("unit.id in (" + paramSQL + ")");
                }
                catch (ParserException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                return OrgF7Helper.getFilterByOrgRange("unit.id", this.assistInfo.getUserPK().toString(), OrgF7Helper.getOrgRangeType(this.viewType));
            }
            return filter;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            String paramSQL = null;
            if (this.assistInfo.isCUFilter()) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.assistInfo.getUiPK(), this.assistInfo.getActionPK(), this.viewType, true, this.assistInfo.isCUFilterIncludeSub());
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.assistInfo.getUserPK(), null, this.assistInfo.getUiPK(), this.assistInfo.getActionPK(), this.viewType, false, false);
            }
            try {
                filter = new FilterInfo("unit.id in (" + paramSQL + ")");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return filter;
        }
    }

    private static class ResponsecenterOrgViewType
    extends AbstractOrgViewType {
        private ResponsecenterOrgViewType(OrgAssistInfo assistInfo, OrgViewType viewType, String treeID) {
            super(assistInfo, viewType, treeID);
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            return null;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            return null;
        }
    }

    private static class UnionOrgViewType
    extends AbstractOrgViewType {
        private UnionOrgViewType(OrgAssistInfo assistInfo, OrgViewType viewType, String treeID) {
            super(assistInfo, viewType, treeID);
        }

        @Override
        protected FilterInfo getOrgPermissionFilter() throws BOSException, EASBizException {
            FilterInfo filter = super.getOrgPermissionFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.treeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)0, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("unit.partFI.isSealUp", (Object)0, CompareType.EQUALS));
            filter.setMaskString("#0 or (#1 and #2 and #3)");
            return filter;
        }

        @Override
        protected FilterInfo buildAdminFilter() throws BOSException, EASBizException {
            FilterInfo filter = new FilterInfo();
            if (this.assistInfo.isCUFilter()) {
                filter.getFilterItems().add(new FilterItemInfo("unit.cu.id", (Object)this.assistInfo.getCuID(), CompareType.EQUALS));
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                return OrgF7Helper.getFilterByOrgRange("unit.cu.id", this.assistInfo.getUserPK().toString(), 10);
            }
            return filter;
        }

        @Override
        protected FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            if (this.assistInfo.isCUFilter()) {
                String paramSQL = OrgF7FilterUtil.buildParamSQL(this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.viewType, true, false);
                try {
                    filter = new FilterInfo("unit.id in (" + paramSQL + ")");
                }
                catch (ParserException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                return OrgF7Helper.getFilterByOrgRange("unit.id", this.assistInfo.getUserPK().toString(), OrgF7Helper.getOrgRangeType(this.viewType));
            }
            return filter;
        }

        @Override
        protected FilterInfo buildPermItemFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            String paramSQL = null;
            if (this.assistInfo.isCUFilter()) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.assistInfo.getUserPK(), this.assistInfo.getCuID(), this.assistInfo.getUiPK(), this.assistInfo.getActionPK(), this.viewType, true, false);
            } else if (this.assistInfo.isNeedAddOrgRange()) {
                paramSQL = NewOrgF7FacadeFactory.getRemoteInstance().getPermSQLByUIPKAndActionPK(this.assistInfo.getUserPK(), null, this.assistInfo.getUiPK(), this.assistInfo.getActionPK(), this.viewType, false, false);
            }
            try {
                filter = new FilterInfo("unit.id in (" + paramSQL + ")");
            }
            catch (ParserException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return filter;
        }
    }

    private static abstract class AbstractOrgViewType {
        protected OrgAssistInfo assistInfo;
        protected OrgViewType viewType;
        protected String treeID;

        private AbstractOrgViewType(OrgAssistInfo assistInfo, OrgViewType viewType, String treeID) {
            this.assistInfo = assistInfo;
            this.viewType = viewType;
            this.treeID = treeID;
        }

        protected FilterInfo getOrgPermissionFilter() throws BOSException, EASBizException {
            FilterInfo filter = null;
            filter = OrgF7Helper.isAdminType(null, this.assistInfo.getUserPK()) ? this.buildAdminFilter() : (this.assistInfo.getUiPK() == null || this.assistInfo.getActionPK() == null ? this.buildOrgRangeFilter() : this.buildPermItemFilter());
            return filter;
        }

        protected abstract FilterInfo buildPermItemFilter() throws BOSException, EASBizException;

        protected abstract FilterInfo buildOrgRangeFilter() throws BOSException, EASBizException;

        protected abstract FilterInfo buildAdminFilter() throws BOSException, EASBizException;
    }
}

