/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.metadata.config;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaDataConfiguration {
    public static final String DEFAULT_META_DATA_CONFIG = "/com/kingdee/eas/basedata/org/metadata/config/OrgMetaDataConfig.xml";
    private static Map configs = new HashMap();
    private File file;
    private URL url;
    private XMLConfiguration xmlConfig;

    private MetaDataConfiguration(String fileName) {
        this.file = MetaDataConfiguration.getFile(fileName);
    }

    private MetaDataConfiguration(URL url) {
        this.url = url;
    }

    private static File getFile(String name) {
        File file;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (!(file = new File(name)).isAbsolute()) {
            file = new File(MetaDataConfiguration.getUserDirectory(), name);
        }
        return file;
    }

    private static File getUserDirectory() {
        String root = System.getProperty("user.dir");
        return new File(root);
    }

    public static MetaDataConfiguration getInstance() {
        return MetaDataConfiguration.getInstance(MetaDataConfiguration.class.getResource(DEFAULT_META_DATA_CONFIG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaDataConfiguration getInstance(String fileName) {
        File file = MetaDataConfiguration.getFile(fileName);
        MetaDataConfiguration config = (MetaDataConfiguration)configs.get(file.toString());
        if (config != null) return config;
        Class<MetaDataConfiguration> clazz = MetaDataConfiguration.class;
        synchronized (MetaDataConfiguration.class) {
            if (config != null) return config;
            config = new MetaDataConfiguration(fileName);
            config.load();
            configs.put(file.toString(), config);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaDataConfiguration getInstance(URL url) {
        MetaDataConfiguration config = (MetaDataConfiguration)configs.get(url.toString());
        if (config != null) return config;
        Class<MetaDataConfiguration> clazz = MetaDataConfiguration.class;
        synchronized (MetaDataConfiguration.class) {
            if (config != null) return config;
            config = new MetaDataConfiguration(url);
            config.load();
            configs.put(url.toString(), config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return config;
        }
    }

    public void store() {
        this.xmlConfig.store();
    }

    private void load() {
        if (this.file == null && this.url == null) {
            throw new IllegalStateException("Config file not setting.");
        }
        if (this.file != null && this.file.exists()) {
            this.xmlConfig = XMLConfiguration.getInstance((File)this.file);
        } else if (this.url != null) {
            this.xmlConfig = XMLConfiguration.getInstance((URL)this.url);
        } else {
            throw new IllegalStateException("Config file not setting.");
        }
    }

    public void addConfigItem(ConfigurationItem item) {
        this.xmlConfig.addConfigItem(item);
    }

    public ConfigurationItem getConfigItem(String name) {
        return this.xmlConfig.getConfigItem(name);
    }

    public List getConfigItemList(String name) {
        return this.xmlConfig.getConfigItemList(name);
    }

    public ConfigurationItem getConfigItemByPath(String path) {
        return this.xmlConfig.getConfigItemByPath(path);
    }

    public List getConfigItemListByPath(String path) {
        return this.xmlConfig.getConfigItemListByPath(path);
    }

    public void removeConfigItem(String name) {
        this.xmlConfig.removeConfigItem(name);
    }

    public void removeAll() {
        this.xmlConfig.removeAll();
    }

    public void dump(PrintStream ps) {
        this.xmlConfig.dump(ps);
    }
}

