/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientVersion {
    private static final Logger LOGGER;
    public static final String VERSION;

    private static final String getVersionFromPropertyFile() throws Exception {
        Properties version = new Properties();
        try (InputStream inputStream = ClientVersion.class.getResourceAsStream("/com/kingdee/bos/rabbitmq/config.properties");){
            version.load(inputStream);
        }
        if (version.getProperty("com.rabbitmq.client.version") == null) {
            throw new IllegalStateException("Coulnd't find version property in property file");
        }
        return version.getProperty("com.rabbitmq.client.version");
    }

    private static final String getVersionFromPackage() {
        if (ClientVersion.class.getPackage().getImplementationVersion() == null) {
            throw new IllegalStateException("Couldn't get version with Package#getImplementationVersion");
        }
        return ClientVersion.class.getPackage().getImplementationVersion();
    }

    private static final String getDefaultVersion() {
        return "0.0.0";
    }

    static {
        String version;
        LOGGER = LoggerFactory.getLogger(ClientVersion.class);
        try {
            version = ClientVersion.getVersionFromPropertyFile();
        }
        catch (Exception e1) {
            LOGGER.warn("Couldn't get version from property file", (Throwable)e1);
            try {
                version = ClientVersion.getVersionFromPackage();
            }
            catch (Exception e2) {
                LOGGER.warn("Couldn't get version with Package#getImplementationVersion", (Throwable)e1);
                version = ClientVersion.getDefaultVersion();
            }
        }
        VERSION = version;
    }
}

