/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.nio;

import com.kingdee.bos.rabbitmq.amqp.impl.nio.FrameBuilder;
import com.kingdee.bos.rabbitmq.amqp.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineFrameBuilder
extends FrameBuilder {
    private final SSLEngine sslEngine;
    private final ByteBuffer cipherBuffer;

    public SslEngineFrameBuilder(SSLEngine sslEngine, ByteBuffer plainIn, ByteBuffer cipherIn, ReadableByteChannel channel) {
        super(channel, plainIn);
        this.sslEngine = sslEngine;
        this.cipherBuffer = cipherIn;
    }

    @Override
    protected boolean somethingToRead() throws IOException {
        SSLEngineResult result;
        if (this.applicationBuffer.hasRemaining()) {
            return true;
        }
        this.applicationBuffer.clear();
        block6: while (true) {
            result = this.sslEngine.unwrap(this.cipherBuffer, this.applicationBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this.applicationBuffer.flip();
                    if (this.applicationBuffer.hasRemaining()) {
                        return true;
                    }
                    this.applicationBuffer.clear();
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("buffer overflow in read");
                }
                case BUFFER_UNDERFLOW: {
                    this.cipherBuffer.compact();
                    int read = NioHelper.read(this.channel, this.cipherBuffer);
                    if (read == 0) {
                        return false;
                    }
                    this.cipherBuffer.flip();
                    continue block6;
                }
                case CLOSED: {
                    throw new SSLException("closed in read");
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
    }
}

