/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.guava;

import com.kingdee.bos.rabbitmq.guava.ComparatorOrdering;
import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.bos.rabbitmq.guava.NaturalOrdering;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array = Ordering.toArray(elements);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    static Object[] toArray(Iterable<?> iterable) {
        return Ordering.toCollection(iterable).toArray();
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : Lists.newArrayList(iterable.iterator());
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> type) {
        ArrayList<? extends T> list = Lists.newArrayList(iterator);
        return Ordering.toArray(list, type);
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        Collection<T> collection = Ordering.toCollection(iterable);
        T[] array = Ordering.newArray(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }
}

