/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.productor.mqfactory;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.entity.ProductorParamEntity;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQFactory;
import com.kingdee.bos.rabbitmq.productor.publish.MessagePublisher;
import com.kingdee.bos.rabbitmq.util.CollectionUtils;
import com.kingdee.bos.rabbitmq.util.RabbitMQReflectInvokeUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class MQProductor {
    private static Logger logger = Logger.getLogger((String)MQProductor.class.getName());

    public static void publish(String name, String message) throws Exception {
        logger.info((Object)"the third system the productor publish message to MQ server begin...");
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(message)) {
            logger.error((Object)"The productor send message param is null.");
            throw new RuntimeException("the productor publish MQ message,the parameter is null.");
        }
        List<MessagePublisher> pubList = MQProductor.createPublishers(name);
        for (MessagePublisher pub : pubList) {
            try {
                pub.publish(message);
                pub.close();
            }
            catch (Exception e) {
                logger.error((Object)("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u6d88\u606f\uff1a\u3010" + message + "\u3011\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
        }
        logger.info((Object)"the third system the productor publish message to MQ server end...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchPublish(String name, List<String> messages) throws Exception {
        logger.info((Object)"the third system the productor batch publish message to MQ server begin...");
        if (StringUtils.isEmpty(name) || CollectionUtils.isEmpty(messages)) {
            logger.error((Object)"The productor send message param is null.");
            throw new RuntimeException("the productor publish MQ message,the parameter is null.");
        }
        List<MessagePublisher> pubList = MQProductor.createPublishers(name);
        for (MessagePublisher pub : pubList) {
            try {
                for (String message : messages) {
                    pub.publish(message);
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6279\u91cf\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
            finally {
                if (null == pub) continue;
                try {
                    pub.close();
                }
                catch (Exception e1) {
                    logger.error((Object)"\u7b2c\u4e09\u65b9\u7cfb\u7edf\u53d1\u9001\u6d88\u606f\uff0c\u5173\u95edchannel\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e1);
                }
            }
        }
        logger.info((Object)"the third system the productor batch publish message to MQ server end...");
    }

    private static List<MessagePublisher> createPublishers(String name) {
        MQFactory factory = MQFactory.getPublisher(name);
        if (null == factory) {
            logger.error((Object)"the productor publish MQ message,get proudctor information is null.");
            throw new RuntimeException("the productor publish MQ message,get proudctor information is null.");
        }
        List<MessagePublisher> pubList = factory.createSimplePublisher();
        return pubList;
    }

    public static void publish(ProductorParamEntity paramEntity, String message, JSONObject productorExt) throws Exception {
        logger.info((Object)"The ierp system productor publish message begin...");
        if (null == paramEntity || null == productorExt) {
            logger.error((Object)"the ierp system productor publish message,method parameter is null.");
            throw new RuntimeException("the ierp system productor publish message,method parameter is null.");
        }
        if (null == paramEntity.getMqConnnection()) {
            logger.error((Object)"the ierp system productor publish message,MQ connection parameter is null.");
            throw new RuntimeException("the ierp system productor publish message,MQ connection parameter is null.");
        }
        try (MessagePublisher publish = null;){
            MQFactory factory = MQFactory.get();
            if (null == factory) {
                logger.error((Object)"the IERP system create RabbitMQ factory failed......");
                throw new RuntimeException("the IERP sytem create RabbitMQ factory failed.");
            }
            publish = factory.createSimplePublisher(paramEntity.getRegion(), paramEntity.getQueueName(), paramEntity.getAutoSubscribeClass(), paramEntity.getMqConnnection(), productorExt);
            publish.publish(message);
            if (!StringUtils.isEmpty(message)) {
                RabbitMQReflectInvokeUtils.publishMsgHandcapacity(message.getBytes());
            }
        }
        logger.info((Object)"The ierp system productor publish message end...");
    }

    public static void easPublish(ProductorParamEntity paramEntity, String message) throws Exception {
        if (null == paramEntity) {
            logger.error((Object)"the eas system productor publish message,method parameter is null.");
            throw new RuntimeException("the eas system productor publish message,method parameter is null.");
        }
        if (null == paramEntity.getMqConnnection()) {
            logger.error((Object)"the eas system productor publish message,MQ connection parameter is null.");
            throw new RuntimeException("the eas system productor publish message,MQ connection parameter is null.");
        }
        if (null == paramEntity.getExtInfo()) {
            logger.error((Object)"the eas system productor publish message,MQ extend message is null.");
            throw new RuntimeException("the eas system productor publish message,MQ extend message is null.");
        }
        try (MessagePublisher publish = null;){
            MQFactory factory = MQFactory.get();
            if (null == factory) {
                logger.error((Object)"the EAS system create RabbitMQ factory failed......");
                throw new RuntimeException("the EAS system create RabbitMQ factory failed.");
            }
            publish = factory.createSimplePublisher(paramEntity.getRegion(), paramEntity.getQueueName(), paramEntity.getAutoSubscribeClass(), paramEntity.getTag(), paramEntity.getMqConnnection(), paramEntity.getExtInfo());
            publish.publish(message);
        }
    }

    public static void easPublish(List<ProductorParamEntity> paramEntitys, String message) throws Exception {
        for (ProductorParamEntity p : paramEntitys) {
            MQProductor.easPublish(p, message);
        }
    }
}

