/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.tools.jsonrpc;

import com.kingdee.bos.rabbitmq.amqp.AMQP;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.StringRpcServer;
import com.kingdee.bos.rabbitmq.tools.json.JSONReader;
import com.kingdee.bos.rabbitmq.tools.json.JSONWriter;
import com.kingdee.bos.rabbitmq.tools.jsonrpc.ProcedureDescription;
import com.kingdee.bos.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonRpcServer
extends StringRpcServer {
    public ServiceDescription serviceDescription;
    public Class<?> interfaceClass;
    public Object interfaceInstance;

    public JsonRpcServer(Channel channel, Class<?> interfaceClass, Object interfaceInstance) throws IOException {
        super(channel);
        this.init(interfaceClass, interfaceInstance);
    }

    private void init(Class<?> interfaceClass, Object interfaceInstance) {
        this.interfaceClass = interfaceClass;
        this.interfaceInstance = interfaceInstance;
        this.serviceDescription = new ServiceDescription(interfaceClass);
    }

    public JsonRpcServer(Channel channel, String queueName, Class<?> interfaceClass, Object interfaceInstance) throws IOException {
        super(channel, queueName);
        this.init(interfaceClass, interfaceInstance);
    }

    @Override
    public String handleStringCall(String requestBody, AMQP.BasicProperties replyProperties) {
        String replyBody = this.doCall(requestBody);
        return replyBody;
    }

    public String doCall(String requestBody) {
        Object result;
        Object[] params;
        String method;
        Object id;
        try {
            Map request = (Map)new JSONReader().read(requestBody);
            if (request == null) {
                return JsonRpcServer.errorResponse(null, 400, "Bad Request", null);
            }
            if (!"1.1".equals(request.get("version"))) {
                return JsonRpcServer.errorResponse(null, 505, "JSONRPC version not supported", null);
            }
            id = request.get("id");
            method = (String)request.get("method");
            List parmList = (List)request.get("params");
            params = parmList.toArray();
        }
        catch (ClassCastException cce) {
            return JsonRpcServer.errorResponse(null, 400, "Bad Request", null);
        }
        if (method.equals("system.describe")) {
            return JsonRpcServer.resultResponse(id, this.serviceDescription);
        }
        if (method.startsWith("system.")) {
            return JsonRpcServer.errorResponse(id, 403, "System methods forbidden", null);
        }
        try {
            result = this.matchingMethod(method, params).invoke(this.interfaceInstance, params);
        }
        catch (Throwable t) {
            return JsonRpcServer.errorResponse(id, 500, "Internal Server Error", t);
        }
        return JsonRpcServer.resultResponse(id, result);
    }

    public Method matchingMethod(String methodName, Object[] params) {
        ProcedureDescription proc = this.serviceDescription.getProcedure(methodName, params.length);
        return proc.internal_getMethod();
    }

    public static String errorResponse(Object id, int code, String message, Object errorArg) {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("name", "JSONRPCError");
        err.put("code", code);
        err.put("message", message);
        err.put("error", errorArg);
        return JsonRpcServer.response(id, "error", err);
    }

    public static String resultResponse(Object id, Object result) {
        return JsonRpcServer.response(id, "result", result);
    }

    public static String response(Object id, String label, Object value) {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("version", "1.1");
        if (id != null) {
            resp.put("id", id);
        }
        resp.put(label, value);
        String respStr = new JSONWriter().write(resp);
        return respStr;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }
}

