/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.util;

import com.kingdee.eas.rabbitmq.rabbit.MQDataRecordTreeInfo;
import java.util.HashMap;
import java.util.Map;

public class MQThreadLocalUtil {
    private static ThreadLocal<Integer> CURRENT_PAGE = new ThreadLocal();
    private static ThreadLocal<Boolean> IS_INIT = new ThreadLocal();
    private static ThreadLocal<Object> TASK_NUMBER = new ThreadLocal();
    private static ThreadLocal<Object> TASK_ID = new ThreadLocal();
    private static ThreadLocal<Map<String, MQDataRecordTreeInfo>> TREE_MAP = new ThreadLocal();

    public static boolean isInit() {
        if (IS_INIT.get() == null) {
            return false;
        }
        return IS_INIT.get();
    }

    public static void setInit() {
        IS_INIT.set(true);
    }

    public static int getCurrentPage() {
        Integer nowPage = CURRENT_PAGE.get();
        if (nowPage == null) {
            return 1;
        }
        CURRENT_PAGE.set(nowPage + 1);
        return nowPage;
    }

    public static String getTaskNumber() {
        Object number = TASK_NUMBER.get();
        return number == null ? "" : number.toString();
    }

    public static void setTaskNumber(Object number) {
        TASK_NUMBER.set(number);
    }

    public static String getTaskId() {
        Object taskId = TASK_ID.get();
        return taskId == null ? "" : taskId.toString();
    }

    public static void setTaskId(Object taskId) {
        TASK_ID.set(taskId);
    }

    public static MQDataRecordTreeInfo getTreeInfo(String taskNumber) {
        if (TREE_MAP.get() == null) {
            return null;
        }
        return TREE_MAP.get().get(taskNumber);
    }

    public static void setTreeId(String taskNumber, MQDataRecordTreeInfo info) {
        Map<Object, Object> infoMap = null;
        infoMap = TREE_MAP.get() == null ? new HashMap() : TREE_MAP.get();
        infoMap.put(taskNumber, info);
        TREE_MAP.set(infoMap);
    }

    public static void clear() {
        CURRENT_PAGE.set(1);
        IS_INIT.set(false);
        TASK_NUMBER.set("");
        TASK_ID.set("");
        if (TREE_MAP.get() != null) {
            TREE_MAP.get().clear();
        }
    }
}

