/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.SelfReqException;
import com.kingdee.eas.base.apply.SelfReqStatuEnum;
import com.kingdee.eas.base.apply.SelfReqTypeFactory;
import com.kingdee.eas.base.apply.SelfReqTypeInfo;
import com.kingdee.eas.base.apply.app.AbstractSelfReqBillControllerBean;
import com.kingdee.eas.base.apply.app.selfreq.handler.SelfReqServiceManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SelfReqBillControllerBean
extends AbstractSelfReqBillControllerBean {
    private static final long serialVersionUID = 1223623777798093999L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.apply.app.SelfReqBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SelfReqBillInfo info = (SelfReqBillInfo)model;
        this.verifyInput(ctx, info);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelfReqBillInfo info = (SelfReqBillInfo)model;
        this.verifyInput(ctx, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelfReqBillInfo selfReqBillInfo = this.getSelfReqBillInfo(ctx, pk);
        if (selfReqBillInfo.getStatu() != null && selfReqBillInfo.getStatu() != SelfReqStatuEnum.DRAFT) {
            throw new SelfReqException(SelfReqException.NOT_DELETE_ERROR);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            SelfReqBillInfo selfReqBillInfo = this.getSelfReqBillInfo(ctx, pk);
            if (selfReqBillInfo.getStatu() != null && selfReqBillInfo.getStatu() != SelfReqStatuEnum.DRAFT) {
                throw new SelfReqException(SelfReqException.NOT_DELETE_ERROR);
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        ObjectStringPK pk = new ObjectStringPK(billId.toString());
        SelfReqBillInfo selfReqBillInfo = this.getSelfReqBillInfo(ctx, (IObjectPK)pk);
        selfReqBillInfo.setStatu(SelfReqStatuEnum.CHECKING);
        UserInfo auditor = new UserInfo();
        auditor.setId(auditorId);
        selfReqBillInfo.setAuditor(auditor);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)selfReqBillInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SelfReqBillInfo selfReqBillInfo;
        SelfReqBillInfo info = (SelfReqBillInfo)model;
        this.verifyInput(ctx, info);
        if (info.getId() != null && !StringUtils.isEmpty((String)info.getId().toString()) && (selfReqBillInfo = this.getSelfReqBillInfo(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()))).getStatu() != SelfReqStatuEnum.DRAFT) {
            throw new SelfReqException(SelfReqException.REPEAT_SUBMIT_ERROR);
        }
        info.setStatu(SelfReqStatuEnum.SUBMIT);
        info.setSubmitDate(new Timestamp(System.currentTimeMillis()));
        SelfReqServiceManager.getInstance().reqServiceBefore(ctx, info, null);
        return super._submit(ctx, (IObjectValue)info);
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        ObjectStringPK pk = new ObjectStringPK(billId.toString());
        SelfReqBillInfo selfReqBillInfo = this.getSelfReqBillInfo(ctx, (IObjectPK)pk);
        selfReqBillInfo.setStatu(SelfReqStatuEnum.CHECKED);
        UserInfo auditor = new UserInfo();
        auditor.setId(auditorId);
        selfReqBillInfo.setAuditor(auditor);
        this.update(ctx, (IObjectPK)pk, selfReqBillInfo);
        boolean serviceDealSuccess = false;
        SelfReqTypeInfo selfReqTypeInfo = SelfReqTypeFactory.getLocalInstance(ctx).getSelfReqTypeInfo((IObjectPK)new ObjectStringPK(selfReqBillInfo.getSelfReqType().getId().toString()));
        boolean isNeedManualProcess = selfReqTypeInfo.isIsNeedManualProcess();
        try {
            boolean isDealService = SelfReqServiceManager.getInstance().invokeServiceBefore(ctx, selfReqBillInfo, null);
            if (isDealService) {
                SelfReqServiceManager.getInstance().invokeService(ctx, selfReqBillInfo, null);
            }
            serviceDealSuccess = true;
        }
        catch (Exception e) {
            serviceDealSuccess = false;
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (!serviceDealSuccess) {
            selfReqBillInfo.setStatu(SelfReqStatuEnum.DEALFAILED);
            this.update(ctx, (IObjectPK)pk, selfReqBillInfo);
        } else if (!isNeedManualProcess) {
            selfReqBillInfo.setStatu(SelfReqStatuEnum.CLOSE);
            selfReqBillInfo.setClosedDate(new Timestamp(System.currentTimeMillis()));
            this.update(ctx, (IObjectPK)pk, selfReqBillInfo);
        } else {
            selfReqBillInfo.setStatu(SelfReqStatuEnum.DEALING);
            this.update(ctx, (IObjectPK)pk, selfReqBillInfo);
        }
    }

    @Override
    protected boolean _beforeServiceCheckDeal(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectStringPK pk = new ObjectStringPK(billId.toString());
        SelfReqBillInfo selfReqBillInfo = this.getSelfReqBillInfo(ctx, (IObjectPK)pk);
        if (selfReqBillInfo.getStatu() == SelfReqStatuEnum.DEALING) {
            boolean isDealAfterService = SelfReqServiceManager.getInstance().invokeServiceAfter(ctx, selfReqBillInfo, null);
            if (isDealAfterService) {
                selfReqBillInfo.setStatu(SelfReqStatuEnum.CLOSE);
                selfReqBillInfo.setClosedDate(new Timestamp(System.currentTimeMillis()));
                this.update(ctx, (IObjectPK)pk, selfReqBillInfo);
            }
            return isDealAfterService;
        }
        return true;
    }

    private void verifyInput(Context ctx, SelfReqBillInfo info) throws EASBizException, BOSException {
        boolean exists;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new SelfReqException(SelfReqException.CHECKNUMBLANK);
        }
        if (info.getNumber().length() > 80) {
            throw new SelfReqException(SelfReqException.CHECKNUMOVERLIMIT, new Object[]{100});
        }
        if (info.getReqUser() == null) {
            throw new SelfReqException(SelfReqException.REQUSER_IS_NOT_BLANK);
        }
        if (info.getSelfReqType() == null) {
            throw new SelfReqException(SelfReqException.REQTYPE_IS_NOT_BLANK);
        }
        if (info.getReqReason() == null || StringUtils.isEmpty((String)info.getReqReason().trim())) {
            throw new SelfReqException(SelfReqException.REQREASON_IS_NOT_BLANK);
        }
        if (info.getId() == null ? (exists = this.exists(ctx, "where number = '" + info.getNumber() + "'")) : (exists = this.exists(ctx, "where number = '" + info.getNumber() + "' and id <> '" + info.getId().toString() + "'"))) {
            throw new SelfReqException(SelfReqException.SERVICE_NUMBER_IS_REPEAT);
        }
    }
}

