/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app.selfreq.handler.ca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.apply.CASelfReqException;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ReqBillExtendInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ca.CABaseServiceHandler;
import com.kingdee.eas.base.permission.UsbKeyUserMapCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.common.EASBizException;

public class CAReqServiceHandler
extends CABaseServiceHandler {
    @Override
    public void reqServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        super.reqServiceBefore(ctx, info, extendInfo);
        boolean isAssignCA = this.isAssignCA(ctx, info.getReqUser().getId().toString());
        if (isAssignCA) {
            throw new CASelfReqException(CASelfReqException.HAVA_ASSIGN_CA);
        }
    }

    @Override
    public boolean invokeServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        super.invokeServiceBefore(ctx, info, extendInfo);
        UsbKeyUserMapInfo usbKeyUserMapInfo = this.getUsbKeyUserMapInfo(ctx, info.getReqUser().getId().toString());
        return usbKeyUserMapInfo == null;
    }

    @Override
    public void invokeService(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        UserInfo userInfo = info.getReqUser();
        this.assignUser(ctx, userInfo);
    }

    @Override
    public boolean invokeServiceAfter(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        super.invokeServiceAfter(ctx, info, extendInfo);
        UsbKeyUserMapInfo usbKeyUserMapInfo = this.getUsbKeyUserMapInfo(ctx, info.getReqUser().getId().toString());
        return UserUSBKeyStateEnum.NORMAL == usbKeyUserMapInfo.getState();
    }

    private void assignUser(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        UsbKeyUserMapInfo usbKeyUserInfo = new UsbKeyUserMapInfo();
        usbKeyUserInfo.setUser(userInfo);
        usbKeyUserInfo.setState(UserUSBKeyStateEnum.NOTINIT);
        UsbKeyUserMapCollection usbKeyUserMapCol = new UsbKeyUserMapCollection();
        usbKeyUserMapCol.add(usbKeyUserInfo);
        UsbKeyUserMapFactory.getLocalInstance((Context)ctx).addnewMany(usbKeyUserMapCol);
    }
}

