/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.EASServerException;
import com.kingdee.eas.base.attachment.IServerConfig;
import com.kingdee.eas.base.attachment.ServerConfigCollection;
import com.kingdee.eas.base.attachment.ServerConfigFactory;
import com.kingdee.eas.base.attachment.ServerConfigInfo;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ServerConfigHelper {
    private static Logger logger = Logger.getLogger((String)ServerConfigHelper.class.getName());

    public static String getEASServerPath(Context ctx, String attachmentId) throws BOSException, EASBizException {
        return ServerConfigHelper.getEASServerPath(ctx, ServerConfigHelper.getServerDirectory(ctx), attachmentId);
    }

    public static String getEASServerPath(Context ctx, String serverDirectory, String attachmentId) throws EASBizException, BOSException {
        return ServerConfigHelper.getEASServerPath(ctx, serverDirectory, AttachmentHelper.getAttachmentInfo(ctx, attachmentId));
    }

    public static String getEASServerPath(Context ctx, AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        return ServerConfigHelper.getEASServerPath(ctx, ServerConfigHelper.getServerDirectory(ctx), attachmentInfo);
    }

    public static String getEASServerPath(Context ctx, String serverDirectory, AttachmentInfo attachmentInfo) {
        StringBuffer tmpPath = new StringBuffer();
        if (StringUtils.isEmpty((String)attachmentInfo.getAttachID())) {
            attachmentInfo.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        }
        Date firstDayOfWeek = ServerConfigHelper.getFirstDayOfWeek(attachmentInfo.getAttachID());
        String busobjtype = "";
        busobjtype = attachmentInfo.getBoAttchAsso() == null || attachmentInfo.getBoAttchAsso().size() == 0 ? "kingdee" : attachmentInfo.getBoAttchAsso().get(0).getAssoBusObjType();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        serverDirectory = StringUtils.isEmpty((String)serverDirectory) ? "" : serverDirectory + "/";
        tmpPath.append(serverDirectory).append(busobjtype).append("/").append(format.format(firstDayOfWeek)).append("/").append(attachmentInfo.getAttachID()).append("_").append(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date())).append(".").append(attachmentInfo.getSimpleName());
        return tmpPath.toString();
    }

    public static String getEASServerPath4Obs(Context ctx, String serverDirectory, AttachmentInfo attachmentInfo) {
        StringBuffer tmpPath = new StringBuffer();
        if (StringUtils.isEmpty((String)attachmentInfo.getAttachID())) {
            attachmentInfo.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        }
        Date firstDayOfWeek = ServerConfigHelper.getFirstDayOfWeek(attachmentInfo.getAttachID());
        String busobjtype = "";
        busobjtype = attachmentInfo.getBoAttchAsso() == null || attachmentInfo.getBoAttchAsso().size() == 0 ? "kingdee" : attachmentInfo.getBoAttchAsso().get(0).getAssoBusObjType();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        serverDirectory = StringUtils.isEmpty((String)serverDirectory) ? "" : serverDirectory + "/";
        tmpPath.append(serverDirectory).append(busobjtype).append("/").append(format.format(firstDayOfWeek));
        return tmpPath.toString();
    }

    public static ServerConfigInfo getServerConfigInfo(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("path"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1"));
        view.setSelector(sic);
        view.setFilter(filter);
        ServerConfigCollection scc = ServerConfigHelper.getIServerConfig(ctx).getServerConfigCollection(view);
        if (scc != null && scc.size() == 1) {
            return scc.get(0);
        }
        throw new EASServerException(EASServerException.SERVERNOTSTART);
    }

    public static String getServerDirectory(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("path"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1"));
        view.setSelector(sic);
        view.setFilter(filter);
        ServerConfigCollection scc = ServerConfigHelper.getIServerConfig(ctx).getServerConfigCollection(view);
        if (scc != null && scc.size() == 1) {
            return scc.get(0).getPath();
        }
        throw new EASServerException(EASServerException.SERVERNOTSTART);
    }

    public static IServerConfig getIServerConfig(Context ctx) throws BOSException {
        if (ctx == null) {
            return ServerConfigFactory.getRemoteInstance();
        }
        return ServerConfigFactory.getLocalInstance(ctx);
    }

    public static void saveServerPath(Context ctx, String attachmentId, String serverPath) throws EASBizException, BOSException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        attachmentInfo.setRemotePath(serverPath);
        attachmentInfo.setFtp(null);
        attachmentInfo.setFile(null);
        attachmentInfo.setStorageType(AttachmentStorageTypeEnum.EASSERVER);
        AttachmentHelper.getIAttachment(ctx).update((IObjectPK)new ObjectUuidPK(attachmentId), attachmentInfo);
    }

    public static InputStream getFileFromEASServer(Context ctx, String attachmentId) throws EASBizException, BOSException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        String filePath = attachmentInfo.getRemotePath();
        File file = new File(filePath);
        try {
            FileInputStream input = new FileInputStream(file);
            return input;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            throw new EASServerException(EASServerException.FILENOTFOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContent(Context ctx, String attachmentId, byte[] content) throws EASBizException, BOSException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        String filePath = attachmentInfo.getRemotePath();
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            logger.info((Object)"----\u5220\u9664\u9644\u4ef6\u6210\u529f");
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            int count;
            file.createNewFile();
            out = new FileOutputStream(file);
            in = new ByteArrayInputStream(content);
            byte[] chunk = new byte[1024];
            while ((count = in.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContent(Context ctx, String attachmentId, String fileId) throws EASBizException, BOSException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        String filePath = attachmentInfo.getRemotePath();
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            logger.info((Object)"----\u5220\u9664\u9644\u4ef6\u6210\u529f");
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            int count;
            file.createNewFile();
            out = new FileOutputStream(file);
            in = new FileInputStream(fileId);
            byte[] chunk = new byte[1024];
            while ((count = in.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static void deleteFromEASServer(Context ctx, String attachmentId) throws EASBizException, BOSException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
        String filePath = attachmentInfo.getRemotePath();
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            logger.info((Object)"----\u5220\u9664\u9644\u4ef6\u6210\u529f");
        }
    }

    public static Date getFirstDayOfWeek(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        try {
            date = format.parse(time);
        }
        catch (ParseException e) {
            logger.error((Object)("time = " + time));
            logger.error((Object)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getMonth(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        try {
            date = format.parse(time);
        }
        catch (ParseException e) {
            logger.error((Object)("time = " + time));
            logger.error((Object)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTime();
    }
}

