/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.attachment.AttachmentBizObjTypeDetailInfo;
import com.kingdee.eas.base.attachment.AttachmentBizObjTypeInfo;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentBizObjTypeBuilder;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AttachmentBizObjBuilder
extends AbstractAttachmentBizObjTypeBuilder {
    Logger logger = Logger.getLogger((String)AttachmentBizObjBuilder.class.getName());

    @Override
    public void buildBizObjEntityName() {
        for (int i = 0; i < this.buildSourceList.size(); ++i) {
            AttachmentBizObjTypeInfo info;
            String bizObjType = this.buildSourceList.get(i).toString();
            String entityName = this.getEntityAlias(this.ctx, BOSObjectType.create((String)bizObjType));
            if (this.buildResult.get(bizObjType) == null) {
                info = new AttachmentBizObjTypeInfo();
                info.setBizObjType(bizObjType);
                info.setBizObjEntityName(entityName);
                this.buildResult.put(bizObjType, info);
                continue;
            }
            info = (AttachmentBizObjTypeInfo)this.buildResult.get(bizObjType);
            info.setBizObjEntityName(entityName);
            this.buildResult.put(bizObjType, info);
        }
    }

    private String getEntityAlias(Context ctx, BOSObjectType bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        try {
            entity = loader.getEntity(bosType);
        }
        catch (MetaDataNotFoundException me) {
            this.logger.info((Object)"not find mata !", (Throwable)me);
            return bosType.toString();
        }
        if (entity == null) {
            this.logger.info((Object)("bosType to entity is null, bosType is:" + bosType));
            return bosType.toString();
        }
        String name = entity.getAlias();
        this.logger.info((Object)("class is:" + entity.getClass().getName()));
        if (name == null) {
            name = entity.getName();
        }
        return name;
    }

    private List getPeritemNameByBizType(String bizType) throws BOSException {
        if (StringUtils.isEmpty((String)bizType)) {
            return null;
        }
        String oql = " where objectType = '" + bizType + "'";
        IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)this.ctx);
        PermItemCollection permItemCol = iPermItem.getPermItemCollection(oql);
        if (permItemCol == null || permItemCol.isEmpty()) {
            this.logger.info((Object)"....... query permItem is null");
            return null;
        }
        ArrayList<AttachmentBizObjTypeDetailInfo> retList = new ArrayList<AttachmentBizObjTypeDetailInfo>();
        for (int i = 0; i < permItemCol.size(); ++i) {
            if (!permItemCol.get(i).getOperationType().getValue().equals("READ") || permItemCol.get(i).getType() == PermItemType.SYSTEM_ADMIN_FUNCTION) continue;
            AttachmentBizObjTypeDetailInfo detailInfo = new AttachmentBizObjTypeDetailInfo();
            detailInfo.setPermissionItem(permItemCol.get(i).getName());
            retList.add(detailInfo);
        }
        return retList;
    }

    @Override
    public void buildBizObjPermissionItem() throws BOSException {
        for (int i = 0; i < this.buildSourceList.size(); ++i) {
            String bizObjType = this.buildSourceList.get(i).toString();
            this.logger.info((Object)(" begin query perItem by bizType is:" + bizObjType));
            List permDetailList = this.getPeritemNameByBizType(bizObjType);
            AttachmentBizObjTypeInfo info = null;
            info = this.buildResult.get(bizObjType) == null ? new AttachmentBizObjTypeInfo() : (AttachmentBizObjTypeInfo)this.buildResult.get(bizObjType);
            info.setBizObjPermissionItemList(permDetailList);
            this.buildResult.put(bizObjType, info);
        }
    }
}

