/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.IObsConfig;
import com.kingdee.eas.base.attachment.ObsConfigFactory;
import com.kingdee.eas.base.attachment.ObsConfigHelper;
import com.kingdee.eas.base.attachment.ObsConfigInfo;
import com.kingdee.eas.base.attachment.ObsHandleFacadeFactory;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentObsHandleFacadeControllerBean;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.common.EASBizException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AttachmentObsHandleFacadeControllerBean
extends AbstractAttachmentObsHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.AttachmentObsHandleFacadeControllerBean");

    @Override
    protected boolean _upload(Context ctx, IObjectValue attachmentInfo) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo2 = (AttachmentInfo)attachmentInfo;
        byte[] file = attachmentInfo2.getFile();
        ObsConfigInfo obsConfig = ObsConfigHelper.getObsConfig(ctx);
        String remotePath = ObsConfigHelper.getRemotePath(ctx, obsConfig.getObsBucketName(), attachmentInfo2);
        obsConfig.setObsBucketName(remotePath);
        String newAttachId = null;
        int isAttachNameDuplication = ObsHandleFacadeFactory.getLocalInstance(ctx).upload(obsConfig, file, attachmentInfo2.getAttachID() + "." + attachmentInfo2.getSimpleName());
        if (isAttachNameDuplication == Integer.parseInt("200")) {
            this.updateAttachment(ctx, attachmentInfo2, remotePath, obsConfig);
            return true;
        }
        if (isAttachNameDuplication == Integer.parseInt("0")) {
            SecureRandom random = new SecureRandom();
            newAttachId = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + random.nextInt(9999);
            isAttachNameDuplication = ObsHandleFacadeFactory.getLocalInstance(ctx).upload(obsConfig, file, newAttachId + "." + attachmentInfo2.getSimpleName());
            if (isAttachNameDuplication == Integer.parseInt("200")) {
                attachmentInfo2.setAttachID(newAttachId);
                this.updateAttachment(ctx, attachmentInfo2, remotePath, obsConfig);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean _uploadBigFile(Context ctx, IObjectValue attachmentInfo, String fileUrl) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo2 = (AttachmentInfo)attachmentInfo;
        ObsConfigInfo obsConfig = ObsConfigHelper.getObsConfig(ctx);
        String remotePath = ObsConfigHelper.getRemotePath(ctx, obsConfig.getObsBucketName(), attachmentInfo2);
        obsConfig.setObsBucketName(remotePath);
        String newAttachId = null;
        int isAttachNameDuplication = ObsHandleFacadeFactory.getLocalInstance(ctx).uploadFile(obsConfig, fileUrl, attachmentInfo2.getAttachID() + "." + attachmentInfo2.getSimpleName());
        if (isAttachNameDuplication == Integer.parseInt("200")) {
            this.updateAttachment(ctx, attachmentInfo2, remotePath, obsConfig);
            return true;
        }
        if (isAttachNameDuplication == Integer.parseInt("0")) {
            SecureRandom random = new SecureRandom();
            newAttachId = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + random.nextInt(9999);
            isAttachNameDuplication = ObsHandleFacadeFactory.getLocalInstance(ctx).uploadFile(obsConfig, fileUrl, newAttachId + "." + attachmentInfo2.getSimpleName());
            if (isAttachNameDuplication == 200) {
                attachmentInfo2.setAttachID(newAttachId);
                this.updateAttachment(ctx, attachmentInfo2, remotePath, obsConfig);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean _delete(Context ctx, String attachmentId) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfoByObs(ctx, attachmentId);
        ObsConfigInfo obsInfo = attachmentInfo.getObs();
        if (obsInfo != null && obsInfo.getId() != null) {
            ObsConfigInfo obsConfig = this.getObsConfig(ctx, attachmentInfo.getObs().getId().toString());
            obsConfig.setObsBucketName(attachmentInfo.getRemotePath());
            return ObsHandleFacadeFactory.getLocalInstance(ctx).delete(obsConfig, attachmentInfo.getAttachID() + "." + attachmentInfo.getSimpleName());
        }
        logger.error((Object)("Debug(\u5f02\u5e38\u9644\u4ef6\uff1a)" + attachmentId));
        return false;
    }

    @Override
    protected byte[] _download(Context ctx, String attachmentId) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo = AttachmentHelper.getAttachmentInfoByObs(ctx, attachmentId);
        ObsConfigInfo obsConfig = this.getObsConfig(ctx, attachmentInfo.getObs().getId().toString());
        obsConfig.setObsBucketName(attachmentInfo.getRemotePath());
        return ObsHandleFacadeFactory.getLocalInstance(ctx).download(obsConfig, attachmentInfo.getAttachID() + "." + attachmentInfo.getSimpleName());
    }

    @Override
    protected boolean _updateContent(Context ctx, IObjectValue attachmentInfo) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo2 = (AttachmentInfo)attachmentInfo;
        ObsConfigInfo obsConfigInfo = this.getObsConfig(ctx, attachmentInfo2.getObs().getId().toString());
        String remotePath = attachmentInfo2.getRemotePath();
        obsConfigInfo.setObsBucketName(remotePath);
        byte[] file = attachmentInfo2.getFile();
        ObsHandleFacadeFactory.getLocalInstance(ctx).upload(obsConfigInfo, file, attachmentInfo2.getAttachID() + "." + attachmentInfo2.getSimpleName());
        return true;
    }

    @Override
    protected boolean _updateFileUrl(Context ctx, IObjectValue attachmentInfo, String fileUrl) throws BOSException, EASBizException {
        AttachmentInfo attachmentInfo2 = (AttachmentInfo)attachmentInfo;
        ObsConfigInfo obsConfigInfo = this.getObsConfig(ctx, attachmentInfo2.getObs().getId().toString());
        String remotePath = attachmentInfo2.getRemotePath();
        obsConfigInfo.setObsBucketName(remotePath);
        ObsHandleFacadeFactory.getLocalInstance(ctx).uploadFile(obsConfigInfo, fileUrl, attachmentInfo2.getAttachID() + "." + attachmentInfo2.getSimpleName());
        return false;
    }

    private void updateAttachment(Context ctx, AttachmentInfo attachmentInfo, String remotePath, ObsConfigInfo obsConfig) throws EASBizException, BOSException {
        attachmentInfo.setRemotePath(remotePath);
        attachmentInfo.setObs(obsConfig);
        attachmentInfo.setFile(null);
        attachmentInfo.setStorageType(AttachmentStorageTypeEnum.OBS);
        AttachmentFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(attachmentInfo.getId().toString()), attachmentInfo);
    }

    private ObsConfigInfo getObsConfig(Context ctx, String obsId) throws BOSException, EASBizException {
        IObsConfig iObsConfig = ObsConfigFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accessKeyId"));
        sic.add(new SelectorItemInfo("accessKeySecret"));
        sic.add(new SelectorItemInfo("endpoint"));
        sic.add(new SelectorItemInfo("obsBucketName"));
        ObsConfigInfo obsConfigInfo = iObsConfig.getObsConfigInfo((IObjectPK)new ObjectUuidPK(obsId), sic);
        return obsConfigInfo;
    }
}

