/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentSizeControllerBean;
import com.kingdee.eas.base.attachment.security.AttachmentSecurityHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AttachmentSizeControllerBean
extends AbstractAttachmentSizeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.AttachmentSizeControllerBean");
    private static final double ATTACHMENT_SIZE = 50.0;

    @Override
    protected double _getFileSize(Context ctx) throws BOSException {
        try {
            double attSize = this.getAttachementSize(ctx);
            if (attSize != -1.0) {
                return attSize;
            }
            this.insertAttachmentSize(ctx, 50.0);
            return 50.0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    @Override
    protected boolean _updateFileSize(Context ctx, double fileSize) throws BOSException {
        try {
            if (this.getAttachementSize(ctx) == -1.0) {
                this.insertAttachmentSize(ctx, fileSize);
            } else {
                String sql = "update T_BAS_AttachmentSize set ffilesize = " + fileSize;
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    private double getAttachementSize(Context ctx) throws SQLException {
        try {
            String sql = "select ffilesize from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                return set.getDouble("ffilesize");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return -1.0;
    }

    private void insertAttachmentSize(Context ctx, double attsize) throws BOSException {
        BOSUuid uuid = BOSUuid.create((String)"5EC169A4");
        String sql = "insert into T_BAS_AttachmentSize (fid,ffilesize,FIsEnableWhiteList) values ('" + uuid.toString() + "'," + attsize + ",1)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected String _getFileType(Context ctx) throws BOSException {
        String fileType = null;
        try {
            String sql = "select FfileType from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                fileType = set.getString("FfileType");
                return fileType;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return fileType;
    }

    @Override
    protected boolean _updateFileType(Context ctx, String fileType) throws BOSException {
        try {
            if (this.getAttachementSize(ctx) == -1.0) {
                this.insertAttachmentSize(ctx, 50.0);
            }
            String sql = "update T_BAS_AttachmentSize set FfileType = '" + fileType + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    protected String _getWhiteList(Context ctx) throws BOSException {
        String fWhiteList = null;
        try {
            String sql = "select FWhiteList from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                fWhiteList = set.getString("FWhiteList");
                return fWhiteList;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return fWhiteList;
    }

    @Override
    protected String _getBlackList(Context ctx) throws BOSException {
        String fBlackList = null;
        try {
            String sql = "select FBlackList from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                fBlackList = set.getString("FBlackList");
                return fBlackList;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return fBlackList;
    }

    @Override
    protected boolean _IsEnableWhiteList(Context ctx) throws BOSException {
        boolean isEnableWhiteList = true;
        try {
            String sql = "select FIsEnableWhiteList from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                isEnableWhiteList = set.getBoolean("FIsEnableWhiteList");
                return isEnableWhiteList;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isEnableWhiteList;
    }

    @Override
    protected boolean _updateWhiteList(Context ctx, String whiteList, boolean isEnableWhiteList) throws BOSException {
        try {
            if (this.getAttachementSize(ctx) == -1.0) {
                this.insertAttachmentSize(ctx, 50.0);
            }
            this.checkListIsCorrect(whiteList);
            String sql = "update T_BAS_AttachmentSize set FWhiteList = '" + whiteList + "' , FIsEnableWhiteList = " + (isEnableWhiteList ? 1 : 0);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    protected boolean _updateBlackList(Context ctx, String blackList, boolean isEnableWhiteList) throws BOSException {
        try {
            if (this.getAttachementSize(ctx) == -1.0) {
                this.insertAttachmentSize(ctx, 50.0);
            }
            this.checkListIsCorrect(blackList);
            String sql = "update T_BAS_AttachmentSize set FBlackList = '" + blackList + "' , FIsEnableWhiteList = " + (isEnableWhiteList ? 1 : 0);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void checkListIsCorrect(String pattern) throws BOSException {
        if (!StringUtils.isEmpty((String)pattern)) {
            String[][] result = AttachmentSecurityHelper.getPatternString(pattern);
            String[] errorList = result[1];
            boolean hasErrorItem = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < errorList.length; ++i) {
                if (errorList[i] == null) continue;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(errorList[i]);
                hasErrorItem = true;
            }
            if (hasErrorItem) {
                throw new BOSException("\u683c\u5f0f\uff1a" + sb.toString() + "\u76ee\u524d\u4e0d\u652f\u6301\u9644\u4ef6\u5185\u5bb9\u6821\u9a8c\uff01");
            }
        }
    }

    @Override
    protected boolean _isAttachmentEncrypt(Context ctx) throws BOSException {
        boolean isAttachmentEncrypt = false;
        try {
            String sql = "select FIsAttachmentEncrypt from T_BAS_AttachmentSize";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (set.next()) {
                isAttachmentEncrypt = set.getBoolean("FIsAttachmentEncrypt");
                return isAttachmentEncrypt;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isAttachmentEncrypt;
    }

    @Override
    protected boolean _updateIsAttachEncrypt(Context ctx, boolean isEncrypt) throws BOSException {
        try {
            String sql = "update T_BAS_AttachmentSize set FIsAttachmentEncrypt = " + (isEncrypt ? 1 : 0);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

