/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.common;

import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.common.EASBizException;
import java.io.File;
import java.io.Serializable;

public class SimpleAttachmentInfo
implements Serializable {
    private String mainname = "";
    private String extname = "";
    private String code = "";
    private String description = "";
    private boolean isShared = false;
    private byte[] content = new byte[0];
    private String shareRange = "";
    private String beizhu;
    private String attachType;
    private String attachTypeEnum;
    private String fileUrl;
    private long length;

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getAttachType() {
        return this.attachType;
    }

    public void setAttachType(String attachType) {
        this.attachType = attachType;
    }

    public String getAttachTypeEnum() {
        return this.attachTypeEnum;
    }

    public void setAttachTypeEnum(String attachTypeEnum) {
        this.attachTypeEnum = attachTypeEnum;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMainName() {
        return this.mainname;
    }

    public void setMainName(String mainname) {
        this.mainname = mainname;
    }

    public String getExtName() {
        return this.extname;
    }

    public void setExtName(String extname) {
        this.extname = extname;
    }

    public boolean getIsShared() {
        return this.isShared;
    }

    public void setIsShared(boolean isShared) {
        this.isShared = isShared;
    }

    public String getShareRange() {
        return this.shareRange;
    }

    public void setShareRange(String shareRange) {
        this.shareRange = shareRange;
    }

    public String getBeizhu() {
        return this.beizhu;
    }

    public void setBeizhu(String beizhu) {
        this.beizhu = beizhu;
    }

    public void checkFileSize(double limitSize) throws EASBizException {
        double maxFileSize = limitSize * 1024.0 * 1024.0;
        if (this.content != null) {
            if (this.content.length == 0) {
                throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
            }
            if ((double)this.content.length > maxFileSize) {
                throw new AttachmentException(AttachmentException.FILESIZENOTALLOWED, new String[]{String.valueOf(limitSize)});
            }
        } else {
            if (this.fileUrl == null) {
                throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
            }
            File uploadFile = new File(this.fileUrl);
            if (!uploadFile.exists() || uploadFile.length() == 0L) {
                throw new AttachmentException(AttachmentException.FILECONTENTNOTGIVEN);
            }
            if ((double)uploadFile.length() > maxFileSize) {
                throw new AttachmentException(AttachmentException.FILESIZENOTALLOWED, new String[]{String.valueOf(limitSize)});
            }
        }
    }
}

