/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.ftp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.FtpException;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentRandom;
import com.kingdee.eas.base.attachment.util.AttachmentEncryptUtil;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.log4j.Logger;

public class AttachmentDownloadClient {
    Logger logger = Logger.getLogger(AttachmentDownloadClient.class);
    private OutputStream out;
    IAttachmentFtpFacade iAttachmentFacade;

    public AttachmentDownloadClient(IAttachmentFtpFacade attachmentFacade) {
        this.iAttachmentFacade = attachmentFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(String fileId) throws EASBizException, BOSException {
        block25: {
            try {
                String bosID = "";
                AttachmentInfo attachmentInfo = new AttachmentInfo();
                Context ctx = null;
                if (ConfigMDUtil.isClient()) {
                    bosID = AttachmentHandleFacadeFactory.getRemoteInstance().getBosID(fileId);
                    attachmentInfo = AttachmentFactory.getRemoteInstance().getAttachmentInfo("select name,isEncrypt where id = '" + fileId + "'");
                } else {
                    ctx = ConfigMDUtil.getContext();
                    bosID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getBosID(fileId);
                    attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo("select name,isEncrypt where id = '" + fileId + "'");
                }
                String logName = "";
                this.logger.error((Object)("\u5f53\u524dbosID\u4e3a\uff1a" + bosID));
                logName = StringUtils.isEmpty((String)bosID) ? attachmentInfo.getName() : this.getLogInfo(bosID) + " " + attachmentInfo.getName();
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"download", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(fileId), (String)logName, (String)"bs_attachment_attachment_download");
                if (this.iAttachmentFacade == null) {
                    this.iAttachmentFacade = AttachmentFtpFacadeFactory.getRemoteInstance();
                }
                long startPos = 0L;
                AttachmentFtpInfo.init();
                AttachmentRandom.setUUIDToThread(UUID.randomUUID().toString());
                while (true) {
                    byte[] content = this.iAttachmentFacade.downloadFile(fileId, startPos);
                    if (attachmentInfo != null && attachmentInfo.getIsEncrypt() == 1 && content != null && content.length > 0) {
                        try {
                            content = AttachmentEncryptUtil.decrypt(content);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (content == null || content.length == 0) break;
                    this.out.write(content);
                    this.out.flush();
                }
                this.logger.error((Object)"*****AttachmentDownloadClient*****content is null**************");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                MsgBox.showError((String)e.getMessage());
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
                if (e.getMessage().indexOf("Failed to open file") > -1 || e.getMessage().indexOf("The system cannot find the file") > -1 || e.getMessage().indexOf("No such file or directory") > -1) {
                    MsgBox.showError((String)Resrcs.getString("ObjectNotFound"));
                    break block25;
                }
                if (e.getMessage().indexOf("Connection refused") > -1 || e.getMessage().indexOf("Connection timed out") > -1 || e.getMessage().indexOf("Access is denied") > -1 || e.getMessage().indexOf("Software caused connection abort") > -1 || e.getMessage().indexOf("Not logged in") > -1 || e.getMessage().indexOf("Control channel unexpectedly closed") > -1) {
                    throw new FtpException(FtpException.FTPCONNECTEDFAIL);
                }
                throw e;
            }
            finally {
                AttachmentRandom.setUUIDToThread(null);
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e);
                    }
                }
            }
        }
    }

    private String getLogInfo(String boId) {
        String logName = "BOSType[00ABCDEF]";
        try {
            DataBaseInfo info;
            BOSUuid uuid = BOSUuid.read((String)boId);
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(uuid.getType());
            IObjectValue data = null;
            if (ConfigMDUtil.isClient()) {
                data = DynamicObjectFactory.getRemoteInstance().getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            } else {
                Context ctx = ConfigMDUtil.getContext();
                data = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            }
            if (data instanceof DataBaseInfo) {
                info = (DataBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else if (data instanceof CoreBillBaseInfo) {
                info = (CoreBillBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else {
                logName = entity.getAlias() + " " + boId;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return logName;
    }

    public byte[] downLoad2tyte(String fileId) throws EASBizException, BOSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setOutputStream(out);
        this.downLoad(fileId);
        return out.toByteArray();
    }

    public void downLoad(String fileId, String fileName) throws EASBizException, BOSException {
        if (this.out == null) {
            this.out = this.getOutput(fileName);
        }
        this.downLoad(fileId);
    }

    private OutputStream getOutput(String fileName) {
        try {
            return new FileOutputStream(new File(fileName));
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setIAttachmentFacade(IAttachmentFtpFacade attachmentFacade) {
        this.iAttachmentFacade = attachmentFacade;
    }
}

