/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.obs;

import com.kingdee.eas.base.attachment.obs.OBSHandler;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.Owner;
import com.obs.services.model.Permission;
import com.obs.services.model.StorageClassEnum;
import java.io.IOException;
import java.util.List;

public class ObsBucketOperation {
    private String endPoint;
    private String ak;
    private String sk;
    private String bucketLocation;

    public ObsBucketOperation(String endPoint, String ak, String sk) {
        this.endPoint = endPoint;
        this.ak = ak;
        this.sk = sk;
    }

    public ObsBucketOperation(String endPoint, String ak, String sk, String bucketLocation) {
        this.endPoint = endPoint;
        this.ak = ak;
        this.sk = sk;
        this.bucketLocation = bucketLocation;
    }

    public ObsClient getObsClient() {
        OBSHandler obsHandler = new OBSHandler(this.ak, this.sk, this.endPoint);
        return obsHandler.getObsClient();
    }

    public void createBucket(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        try {
            ObsBucket response = obsClient.createBucket(bucketName);
            System.out.println(response.getRequestId());
        }
        catch (ObsException e) {
            System.out.println("HTTP Code:" + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message:" + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBucketByParam(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        obsBucket.setBucketStorageClass(StorageClassEnum.STANDARD);
        obsBucket.setLocation(this.bucketLocation);
        try {
            ObsBucket response = obsClient.createBucket(obsBucket);
            System.out.println(response.getRequestId());
        }
        catch (ObsException e) {
            System.out.println("HTTP Code:" + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message:" + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            System.out.println();
        }
        finally {
            obsClient.close();
        }
    }

    public List<ObsBucket> getAllBucket() throws IOException {
        ObsClient obsClient = this.getObsClient();
        ListBucketsRequest request = new ListBucketsRequest();
        request.setQueryLocation(true);
        List buckets = obsClient.listBuckets(request);
        for (ObsBucket bucket : buckets) {
            System.out.println("Bucket Name:" + bucket.getBucketName());
            System.out.println("Create Date:" + bucket.getCreationDate());
            System.out.println("Location:" + bucket.getLocation());
            System.out.println();
        }
        obsClient.close();
        return buckets;
    }

    public void removeBucket(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            obsClient.deleteBucket(bucketName);
            obsClient.close();
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public BucketMetadataInfoResult getBucketMetadata(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            BucketMetadataInfoRequest request = new BucketMetadataInfoRequest("bucketname");
            request.setOrigin("http://www.a.com");
            BucketMetadataInfoResult result = obsClient.getBucketMetadata(request);
            System.out.println("\t:" + result.getDefaultStorageClass());
            System.out.println("\t:" + result.getAllowOrigin());
            System.out.println("\t:" + result.getMaxAge());
            System.out.println("\t:" + result.getAllowHeaders());
            System.out.println("\t:" + result.getAllowMethods());
            System.out.println("\t:" + result.getExposeHeaders());
            return result;
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public void setBucketAcl(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            AccessControlList acl = new AccessControlList();
            Owner owner = new Owner();
            owner.setId("ownerid");
            acl.setOwner(owner);
            acl.grantPermission((GranteeInterface)new CanonicalGrantee("userid"), Permission.PERMISSION_FULL_CONTROL);
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, Permission.PERMISSION_READ);
            obsClient.setBucketAcl(bucketName, acl);
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public void setBucketPolicy(String bucketName, String policy) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            obsClient.setBucketPolicy(bucketName, policy);
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public String getBucketPolicy(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            String policy = obsClient.getBucketPolicy(bucketName);
            System.out.println("\t" + policy);
            return policy;
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public void deleteBucketPolicy(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            obsClient.deleteBucketPolicy(bucketName);
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public String getBucketLocation(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            String bucketLocation = obsClient.getBucketLocation(bucketName);
            return bucketLocation;
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public BucketStorageInfo getBucketStorageInfo(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            BucketStorageInfo storageInfo = obsClient.getBucketStorageInfo(bucketName);
            System.out.println("\t" + storageInfo.getObjectNumber());
            System.out.println("\t" + storageInfo.getSize());
            return storageInfo;
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public void setBucketQuota(String bucketName, BucketQuota quota) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            obsClient.setBucketQuota(bucketName, quota);
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public BucketQuota getBucketQuota(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            BucketQuota quota = obsClient.getBucketQuota("bucketname");
            return quota;
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public void setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketPolicy) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        if (exist) {
            obsClient.setBucketStoragePolicy(bucketName, bucketPolicy);
        } else {
            System.out.println("Not exist:" + bucketName);
        }
    }

    public StorageClassEnum getBucketStoragePolicy(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.headBucket(bucketName);
        BucketStoragePolicyConfiguration storgePolicy = new BucketStoragePolicyConfiguration();
        if (exist) {
            return storgePolicy.getBucketStorageClass();
        }
        System.out.println("Not exist:" + bucketName);
        return null;
    }

    public boolean bucketIsExists(String bucketName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        if (bucketName.contains("/")) {
            String[] strings = bucketName.split("/", 2);
            bucketName = strings[0];
        }
        return obsClient.headBucket(bucketName);
    }
}

