/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.enterprisedt.net.ftp.internal;

import com.kingdee.enterprisedt.net.ftp.EventListener;
import com.kingdee.enterprisedt.net.ftp.FTPMessageListener;
import com.kingdee.enterprisedt.net.ftp.FTPProgressMonitor;
import com.kingdee.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.kingdee.enterprisedt.net.ftp.TransferDirection;

public class EventAggregator
implements FTPMessageListener,
FTPProgressMonitor,
FTPProgressMonitorEx {
    private EventListener eventListener;
    private String connId;
    private String remoteFile;

    public EventAggregator(EventListener eventListener) {
        this(null, eventListener);
    }

    public EventAggregator(String connId, EventListener eventListener) {
        this.connId = connId;
        this.eventListener = eventListener;
    }

    public void setConnId(String connId) {
        this.connId = connId;
    }

    @Override
    public void logCommand(String cmd) {
        if (this.eventListener != null) {
            this.eventListener.commandSent(this.connId, cmd);
        }
    }

    @Override
    public void logReply(String reply) {
        if (this.eventListener != null) {
            this.eventListener.replyReceived(this.connId, reply);
        }
    }

    @Override
    public void bytesTransferred(long count) {
        if (this.eventListener != null) {
            this.eventListener.bytesTransferred(this.remoteFile, this.connId, count);
        }
    }

    @Override
    public void transferComplete(TransferDirection direction, String remoteFile) {
        if (this.eventListener != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.eventListener.downloadCompleted(this.connId, remoteFile);
            } else if (direction.equals(TransferDirection.UPLOAD)) {
                this.eventListener.uploadCompleted(this.connId, remoteFile);
            }
        }
    }

    @Override
    public void transferStarted(TransferDirection direction, String remoteFile) {
        this.remoteFile = remoteFile;
        if (this.eventListener != null) {
            if (direction.equals(TransferDirection.DOWNLOAD)) {
                this.eventListener.downloadStarted(this.connId, remoteFile);
            } else if (direction.equals(TransferDirection.UPLOAD)) {
                this.eventListener.uploadStarted(this.connId, remoteFile);
            }
        }
    }
}

