/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.billdigest.util.format.Accessor;
import com.kingdee.bos.billdigest.util.format.Json;
import com.kingdee.bos.billdigest.util.format.LazyAccessor;
import java.util.ArrayList;
import java.util.Map;

public class Expression {
    private static Accessor[] EMPTY = new Accessor[0];
    private String obj;
    private Accessor[] accessors;

    public Expression(String expr) {
        String[] tmp = expr.split("\\.");
        this.obj = tmp[0];
        ArrayList<LazyAccessor> accessors = new ArrayList<LazyAccessor>(tmp.length);
        for (int i = 1; i < tmp.length; ++i) {
            if (tmp[i].length() <= 0) continue;
            accessors.add(new LazyAccessor(tmp[i]));
        }
        this.accessors = accessors.size() == 0 ? EMPTY : accessors.toArray(new Accessor[accessors.size()]);
    }

    public Object eval(Map<String, Object> ctx) {
        Object value = ctx.get(this.obj);
        for (Accessor accessor : this.accessors) {
            if (value == null) break;
            value = accessor.getProperty(value);
        }
        return value;
    }

    public static boolean isExpr(String s) {
        if (!Json.isLetter(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '0' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$' || c == '.') continue;
            return false;
        }
        return true;
    }
}

