/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.provider.BotFuncManager;
import com.kingdee.bos.bot.engine.sql.BotExprSyntaxAnalyzer;
import com.kingdee.bos.bot.engine.sql.FieldMappingType;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class BotCoreExprAnalyzer {
    private FieldMappingType mappingType = null;
    private String realValue = null;
    private BotFuncManager funcManager = null;
    private boolean formatCheckError = false;

    public BotCoreExprAnalyzer(BotFuncManager funcManager) {
        this.funcManager = funcManager;
    }

    BotFuncManager getFuncManager() {
        return this.funcManager;
    }

    void setFuncManager(BotFuncManager funcManager) {
        this.funcManager = funcManager;
    }

    public static String formatKsciptExpr(String expression) throws BOSException, KScriptException {
        CodeStmt stmt;
        int i;
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        boolean lineCount = false;
        boolean bHasVarDeclLine = false;
        StringBuffer sb = new StringBuffer();
        ArrayList<CodeStmt> realStmtList = new ArrayList<CodeStmt>();
        int size = stmtList.size();
        for (i = 0; i < size; ++i) {
            stmt = (CodeStmt)stmtList.get(i);
            if (!(stmt instanceof VarDeclStmt)) {
                realStmtList.add(stmt);
                continue;
            }
            bHasVarDeclLine = true;
        }
        size = realStmtList.size();
        for (i = 0; i < size; ++i) {
            stmt = (CodeStmt)realStmtList.get(i);
            stmt.output(sb, null);
        }
        String val = sb.toString();
        if (realStmtList.size() == 1 && val.charAt(val.length() - 1) == ';') {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    public void checkExpressMappingType(String expression) throws BOSException, KScriptException {
        this.mappingType = new FieldMappingType(0, false);
        if (StringUtils.isEmpty((String)expression)) {
            throw new BOSException("The expression can't be null");
        }
        this.analyzeExpression(expression);
    }

    private void analyzeExpression(String expression) throws BOSException, KScriptException {
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        boolean lineCount = false;
        boolean bHasVarDeclLine = false;
        ArrayList<CodeStmt> realStmtList = new ArrayList<CodeStmt>();
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            if (!(stmt instanceof VarDeclStmt)) {
                realStmtList.add(stmt);
                continue;
            }
            bHasVarDeclLine = true;
        }
        if (realStmtList.size() == 1) {
            CodeStmt stmt = (CodeStmt)realStmtList.get(0);
            this.analyzeScriptCodeExpr(stmt);
        } else {
            this.mappingType.setType(12);
        }
    }

    private void analyzeScriptCodeExpr(CodeStmt stmt) throws BOSException, KScriptException {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            this.analyzeScriptCodeExpr(0, expr);
        } else {
            this.mappingType.setType(13);
        }
    }

    private void analyzeScriptCodeExpr(int level, CodeExpr expr) throws BOSException, KScriptException {
        if (expr == null) {
            return;
        }
        if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
            this.mappingType.setType(0);
            this.realValue = expr.toString();
            if (expr instanceof StringExpr) {
                this.realValue = "'" + this.realValue.substring(1, this.realValue.length() - 1) + "'";
            }
        } else if (expr instanceof IdentifierExpr) {
            this.mappingType.setIdentifier(true);
        } else if (expr instanceof PropertyExpr) {
            this.mappingType.setType(1);
        } else {
            BotExprSyntaxAnalyzer methodAnlyzer = new BotExprSyntaxAnalyzer(this);
            methodAnlyzer.analyzeScriptCodeExpr(expr);
            FieldMappingType tmpMappingType = methodAnlyzer.getExprByMappingType();
            if (tmpMappingType.isIdentifier()) {
                this.mappingType.setIdentifier(true);
            }
            this.mappingType.setType(tmpMappingType.getType());
        }
    }

    public String getRealValue() {
        return this.realValue;
    }

    public FieldMappingType getMappingType() {
        return this.mappingType;
    }
}

