/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bot.engine.provider.BotFuncManager;
import com.kingdee.bos.bot.engine.sql.BotCoreExprAnalyzer;
import com.kingdee.bos.bot.engine.sql.FieldMappingType;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BotFormulaExprVerifier {
    private static final Logger logger = Logger.getLogger(BotFormulaExprVerifier.class);
    private static final String RESXFILE = "com.kingdee.eas.base.botp.BotpFunctionResx";
    private Locale locale = null;
    private List funcProviderList = new ArrayList();
    private BotFuncManager funcManager = null;

    public BotFormulaExprVerifier(Locale locale, List funcProviderList) {
        this.locale = locale;
        this.funcProviderList = funcProviderList;
        this.funcManager = new BotFuncManager(locale, funcProviderList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validate(Component parent, String formulaString) throws BOSException, KScriptException {
        String msg = EASResource.getString((String)RESXFILE, (String)"FUNCTION_FORMAT_ERROR");
        try {
            FieldMappingType mappingType = null;
            BotCoreExprAnalyzer analyzer = new BotCoreExprAnalyzer(this.funcManager);
            analyzer.checkExpressMappingType(formulaString);
            mappingType = analyzer.getMappingType();
            if (mappingType.getType() != 11 && mappingType.getType() != 12 && mappingType.getType() != 13) return true;
        }
        catch (Exception e) {
            logger.error((Object)msg, (Throwable)e);
            MsgBox.showWarning((Component)parent, (String)msg.replaceAll("<p>", "\r\n"));
            return false;
        }
        return true;
    }
}

