/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.common.BotEntityUtils;
import com.kingdee.bos.bot.engine.common.BoteBaseUtils;
import com.kingdee.bos.bot.engine.common.BoteThirdObjectCache;
import com.kingdee.bos.bot.engine.common.BotpScriptFuncAnalyzer;
import com.kingdee.bos.bot.engine.common.BotpScriptThirdObjAnalyzer;
import com.kingdee.bos.bot.engine.core.BotStructEntityInfo;
import com.kingdee.bos.bot.engine.core.BotStructManager;
import com.kingdee.bos.bot.engine.core.BotStructPropertyInfo;
import com.kingdee.bos.bot.engine.core.BoteParamCollection;
import com.kingdee.bos.bot.engine.core.BoteParamInfo;
import com.kingdee.bos.bot.engine.provider.BotFuncManager;
import com.kingdee.bos.bot.engine.provider.BotFuncParamCollection;
import com.kingdee.bos.bot.engine.provider.BotFuncParamInfo;
import com.kingdee.bos.bot.engine.sql.BotCodeExprConverter;
import com.kingdee.bos.bot.engine.sql.BotCoreExprAnalyzer;
import com.kingdee.bos.bot.engine.sql.BotSqlUtils;
import com.kingdee.bos.bot.engine.sql.BotTempTableManager;
import com.kingdee.bos.bot.engine.sql.BoteWhereExprManager;
import com.kingdee.bos.bot.engine.sql.DataSqlHandler;
import com.kingdee.bos.bot.engine.sql.FieldMappingType;
import com.kingdee.bos.bot.engine.sql.FieldNameMappingManager;
import com.kingdee.bos.bot.engine.sql.FuncParamListInfo;
import com.kingdee.bos.bot.engine.sql.MappingSegmentSetInfo;
import com.kingdee.bos.bot.engine.sql.SQLSrcTableManager;
import com.kingdee.bos.bot.engine.sql.TableCreateSqlManager;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.formula.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.bot.BOTAggregateCollection;
import com.kingdee.bos.metadata.bot.BOTAggregateInfo;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleCollection;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleInfo;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpDynamicFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpFormulaFunctions;
import com.kingdee.eas.base.botp.util.BotpScriptFuncDeclare;
import com.kingdee.eas.base.botp.util.BotpScriptUtils;
import com.kingdee.eas.base.btp.IBotpBatchFormulaFunctions;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BotSqlBuilder {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.bot.engine.sql.BotSqlBuilder");
    public static final String DAP_REFCLASS = "com.kingdee.eas.base.dap.DAPAssistant";
    public static final String DAP_REF_PROPERTYS = "entries.account";
    public static final String DAP_DEST_PROPNAME = "entries.assistRecords.assGrp";
    private static final String ISENTRIES = "isEntries";
    private String entityKeyField = "id";
    private Context ctx = null;
    private Connection conn = null;
    private Map allDestFiledsMap = new HashMap();
    private Map nameMappingEntityToTable = new HashMap();
    private Map nameMappingTableToEntity = new HashMap();
    private Map nameMappingSegmentToTable = new HashMap();
    private Map tempTableColumnsMap = new HashMap();
    private Map entityEntryStruMap = new HashMap();
    private Map groupPropertysMap = new HashMap();
    private Map sumPropertysMap = new HashMap();
    private TableCreateSqlManager tableCreateSqlManager = null;
    private FieldNameMappingManager fieldNameMappingManager = new FieldNameMappingManager();
    private BoteParamCollection params = null;
    private String strTempTableCreateSql = null;
    private List tempTableInsertSqlList = new ArrayList();
    private Map allValueCacheMap = new HashMap();
    private String mainTableName = "";
    private BotTempTableManager tempTableManager = null;
    private Map extPropertys = new HashMap();
    private boolean isDAP = false;
    private BotFuncManager funcManager = null;
    private List funcProviderList = new ArrayList();

    private void initFuncProviderList(BOTMappingInfo mappingInfo) {
        this.funcProviderList.add(new BotpFormulaFunctions(this.ctx.getLocale()));
        this.funcProviderList.add(new BotpDynamicFormulaFunctions(this.ctx, mappingInfo.getSrcEntity(), mappingInfo.getDestEntity()));
        try {
            Object clz = BOTPTools.getProviderClassObject("BOTP_EXTENDFUNCIONS");
            if (clz != null && clz instanceof IFormulaFunctions) {
                this.funcProviderList.add((IFormulaFunctions)clz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean isDAP() {
        return this.isDAP;
    }

    public void setDAP(boolean isDAP) {
        this.isDAP = isDAP;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    public BotSqlBuilder(Context ctx, Connection conn, BoteParamCollection params, List funcProviderList, BotTempTableManager tempTableManager) {
        this.ctx = ctx;
        this.conn = conn;
        this.params = params;
        this.tempTableManager = tempTableManager;
        this.funcManager = new BotFuncManager(ctx.getLocale(), funcProviderList);
    }

    public String getEntityKeyField() {
        return this.entityKeyField;
    }

    public void setEntityKeyField(String entityKeyField) {
        this.entityKeyField = entityKeyField;
    }

    protected void clear() {
        this.fieldNameMappingManager.clear();
        this.allDestFiledsMap.clear();
        this.strTempTableCreateSql = "";
        this.tempTableInsertSqlList.clear();
    }

    public String getTempTableCreateSql() throws BOSException, EASBizException {
        if (this.strTempTableCreateSql == null) {
            this.strTempTableCreateSql = this.buildMainTempTableSQL();
        }
        return this.strTempTableCreateSql;
    }

    public Map getGroupPropertysMap() {
        return this.groupPropertysMap;
    }

    protected String buildMainTempTableSQL() throws BOSException, EASBizException {
        EntityObjectInfo srcEntity = null;
        EntityObjectInfo destEntity = null;
        if (this.params == null) {
            return "";
        }
        this.clear();
        this.tableCreateSqlManager = new TableCreateSqlManager();
        this.tableCreateSqlManager.setFieldNameMappingManager(this.fieldNameMappingManager);
        for (int k = 0; k < this.params.size(); ++k) {
            BoteParamInfo param = this.params.get(k);
            BOTMappingInfo mappingInfo = param.getMappingInfo();
            this.initFuncProviderList(mappingInfo);
            if (k == 0) {
                destEntity = mappingInfo.getDestEntity();
                this.tableCreateSqlManager.setDestEntity(destEntity);
            }
            srcEntity = mappingInfo.getSrcEntity();
            this.tableCreateSqlManager.setSrcEntity(srcEntity);
            BOTRuleCollection botRuleCols = mappingInfo.getRules();
            int count = botRuleCols.size();
            for (int i = 0; i < count; ++i) {
                BOTRuleInfo botRuleInfo = botRuleCols.get(i);
                this.buildTempTableSqlByRuleInfo(mappingInfo, botRuleInfo);
            }
            if (botRuleCols.size() <= 0) continue;
            this.buildTempTableSqlByGroupCols(mappingInfo, botRuleCols.get(0));
        }
        String sql = this.tableCreateSqlManager.getCreateSql();
        return sql;
    }

    public List getTempTableInsertSqlList() throws BOSException, EASBizException {
        return this.tempTableInsertSqlList;
    }

    private void analyzeDataFilterInfo(BOTMappingInfo mappingInfo, Map dataFilterMap, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException {
        BOTExtMappingInfo extMappingInfo = mappingInfo.getExtRule();
        if (extMappingInfo == null) {
            return;
        }
        String dataFilter = extMappingInfo.getDataFilter();
        if (StringUtils.isEmpty((String)dataFilter)) {
            return;
        }
        try {
            EntityViewInfo view = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 1);
            FilterCollection entryFilters = view.getEntryFilters();
            FilterInfo filterInfo = view.getFilter();
            if (filterInfo != null) {
                String filterValue = this.transfromFilterInfo(filterInfo, srcTableManager);
                dataFilterMap.put("__src", filterValue);
            }
            for (int i = 0; i < entryFilters.size(); ++i) {
                FilterInfo entryFilterInfo = entryFilters.get(i);
                if (entryFilterInfo == null) continue;
                String entryName = entryFilterInfo.getEntryName();
                String entryFilterValue = this.transfromFilterInfo(entryFilterInfo, srcTableManager);
                dataFilterMap.put(entryName, entryFilterValue);
            }
        }
        catch (Exception e) {
            throw new BOSException("Parse DataFilterInfo Error!   info=" + dataFilter, (Throwable)e);
        }
    }

    private String transfromFilterInfo(FilterInfo filterInfo, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException {
        String result = "";
        FilterItemCollection items = filterInfo.getFilterItems();
        String entryName = filterInfo.getEntryName();
        for (int i = 0; i < items.size(); ++i) {
            FilterItemInfo itemInfo = items.get(i);
            String propertyName = itemInfo.getPropertyName();
            Object compareValue = itemInfo.getCompareValue();
            if (!StringUtils.isEmpty((String)entryName)) {
                propertyName = entryName + "." + itemInfo.getPropertyName();
            }
            String realPropertyName = this.getJoinFieldNameBySrcPropName(srcTableManager, propertyName);
            itemInfo.setPropertyName(realPropertyName);
        }
        filterInfo.setEntryName(null);
        result = filterInfo.toString();
        return result;
    }

    public boolean insertTempTableData(BOSObjectType destBosType, String[] srcObjectIDList, String[] entryNames, String[] srcEntryIDList, BOTMappingInfo mappingInfo, String tableName) throws BOSException, EASBizException {
        long lFuncTime = 0L;
        this.tempTableInsertSqlList.clear();
        String sql = "";
        BOTRuleCollection botRuleCols = mappingInfo.getRules();
        int count = botRuleCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRuleInfo botRuleInfo = botRuleCols.get(i);
            try {
                SQLSrcTableManager srcTableManager = new SQLSrcTableManager(this.ctx, mappingInfo.getSrcEntity());
                HashMap dataFilterMap = new HashMap();
                this.analyzeDataFilterInfo(mappingInfo, dataFilterMap, srcTableManager);
                String insertDataSql = this.innerBuildInsertSQLForEntryRule(mappingInfo, botRuleInfo, tableName, entryNames, srcTableManager);
                if (!StringUtils.isEmpty((String)insertDataSql)) {
                    BoteWhereExprManager whereManager = new BoteWhereExprManager(mappingInfo.getSrcEntity(), srcObjectIDList, entryNames, srcEntryIDList, srcTableManager);
                    whereManager.init(dataFilterMap);
                    int n = whereManager.size();
                    for (int k = 0; k < n; ++k) {
                        String whereSql = whereManager.getWhereExpr(k);
                        sql = insertDataSql + whereSql;
                        try {
                            this.tempTableManager.executeSQL(sql);
                            continue;
                        }
                        catch (Exception e) {
                            throw new BOSException(e.getMessage() + ", sql=" + sql, (Throwable)e);
                        }
                    }
                }
                long ts = System.currentTimeMillis();
                this.excuteComplexExpressionByRule(mappingInfo, botRuleInfo, srcTableManager);
                long te = System.currentTimeMillis();
                lFuncTime += te - ts;
                continue;
            }
            catch (SQLException e) {
                throw new BOSException("Insert TempTable Data Error!" + e.getMessage() + ",  sql = " + sql, (Throwable)e);
            }
        }
        return true;
    }

    private Interpreter initInterpreter() {
        Interpreter interpreter = new Interpreter(this.ctx);
        for (int i = 0; i < this.funcProviderList.size(); ++i) {
            interpreter.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
        }
        interpreter.setSupportDebug(true);
        interpreter.setDebugEnv(DebugEnv.getDebugEnv());
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        return interpreter;
    }

    protected void excuteComplexExpressionByRule(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException, SQLException {
        try {
            int i;
            String strFilter = BotEntityUtils.getTempTableFilterByRuleInfo(mappingInfo, botRuleInfo);
            ArrayList<MappingSegmentSetInfo> bizFuncSegments = new ArrayList<MappingSegmentSetInfo>();
            ArrayList<MappingSegmentSetInfo> complexSegment = new ArrayList<MappingSegmentSetInfo>();
            HashMap resultList = new HashMap();
            BOTRuleSegmentCollection botRuleSegCols = botRuleInfo.getRuleSegments();
            int size = botRuleSegCols.size();
            for (i = 0; i < size; ++i) {
                BOTRuleSegmentInfo botRuleSegInfo = botRuleSegCols.get(i);
                String key = mappingInfo.getId().toString() + botRuleInfo.getId().toString() + botRuleSegInfo.getId().toString();
                MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)this.allDestFiledsMap.get(key);
                if (segmentSetInfo == null) {
                    throw new BOSException("Can't find key[" + key + "] in alllDestFiledList!  mappingInfo=" + mappingInfo.getName() + ",  botRuleInfo=" + botRuleInfo.getName() + ", botRuleSegInfo=" + botRuleSegInfo);
                }
                if (segmentSetInfo.getMappingType().getType() == 4) {
                    bizFuncSegments.add(segmentSetInfo);
                    continue;
                }
                if (segmentSetInfo.getMappingType().getType() != 13 && segmentSetInfo.getMappingType().getType() != 12) continue;
                complexSegment.add(segmentSetInfo);
            }
            this.prepareThirdObjCache(this.ctx, botRuleInfo, strFilter);
            for (i = 0; i < bizFuncSegments.size(); ++i) {
                MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)bizFuncSegments.get(i);
                String destPropertyName = segmentSetInfo.getDestPropertyName();
                BotFuncParamCollection result = this.evalBotpSQLFunction(segmentSetInfo, strFilter);
                if (result == null || result.size() <= 0) continue;
                String fullDestPropName = BoteBaseUtils.getRealDestFieldName(destPropertyName);
                this.addCachedResultValue(fullDestPropName, result);
            }
            if (complexSegment.size() > 0) {
                String sql = "select * from " + this.mainTableName + " where " + strFilter;
                ResultSet rs = BotSqlUtils.executeQuery(this.conn, sql.toString());
                ArrayList<HashMap<String, Object>> ctxs = new ArrayList<HashMap<String, Object>>();
                Set keys = this.fieldNameMappingManager.getTableFieldNameMap().keySet();
                while (rs.next()) {
                    String seqID = rs.getString("bot_FID");
                    HashMap<String, Object> ctx = new HashMap<String, Object>();
                    ctx.put("bot_FID", seqID);
                    for (String key : keys) {
                        Object obj = rs.getObject(key);
                        String mappingKey = this.fieldNameMappingManager.getEntityFieldNameByTableName(key);
                        if (!mappingKey.startsWith("bot_src")) continue;
                        mappingKey = mappingKey.substring(3);
                        ctx.put("_" + mappingKey, obj);
                    }
                    ctxs.add(ctx);
                }
                Interpreter interpreter = this.initInterpreter();
                for (int i2 = 0; i2 < complexSegment.size(); ++i2) {
                    MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)complexSegment.get(i2);
                    this.evalComplexSegMent(segmentSetInfo, ctxs, interpreter);
                }
            }
            this.excuteComplexExpressionDAPByRule(mappingInfo, botRuleInfo, srcTableManager);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void excuteComplexExpressionDAPByRule(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException, SQLException {
        try {
            int i;
            String strFilter = BotEntityUtils.getTempTableFilterByRuleInfo(mappingInfo, botRuleInfo);
            ArrayList<MappingSegmentSetInfo> bizFuncSegments = new ArrayList<MappingSegmentSetInfo>();
            HashMap resultList = new HashMap();
            BOTExtSetRuleCollection extSetRules = botRuleInfo.getExtSetRules();
            for (i = 0; i < extSetRules.size(); ++i) {
                BOTExtSetRuleInfo extRuleInfo = extSetRules.get(i);
                BOTExtSetRuleSegmentCollection extSetRuleSegCols = extRuleInfo.getRuleSegments();
                boolean j = false;
                while (i < extSetRuleSegCols.size()) {
                    BOTExtSetRuleSegmentInfo extSetSegInfo = extSetRuleSegCols.get(i);
                    String key = mappingInfo.getId().toString() + "__" + botRuleInfo.getId().toString() + "__" + extRuleInfo.getId().toString() + "__" + extSetSegInfo.getId().toString();
                    MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)this.allDestFiledsMap.get(key);
                    if (segmentSetInfo == null) {
                        throw new BOSException("Can't find key[" + key + "] in alllDestFiledList!  mappingInfo=" + mappingInfo.getName() + ",  botRuleInfo=" + botRuleInfo.getName() + ", extRuleInfo=" + extRuleInfo + ", extSegInfo=" + extSetSegInfo);
                    }
                    if (segmentSetInfo.getMappingType().getType() == 4) {
                        bizFuncSegments.add(segmentSetInfo);
                    }
                    ++i;
                }
            }
            for (i = 0; i < bizFuncSegments.size(); ++i) {
                MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)bizFuncSegments.get(i);
                String destPropertyName = segmentSetInfo.getDestPropertyName();
                BotFuncParamCollection result = this.evalBotpSQLFunction(segmentSetInfo, strFilter);
                if (result == null || result.size() <= 0) continue;
                String fullDestPropName = BoteBaseUtils.getRealDestFieldName(destPropertyName);
                this.addCachedResultValue(fullDestPropName, result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void prepareThirdObjCache(Context ctx, BOTRuleInfo botRuleInfo, String strFilter) throws BOSException, EASBizException, SQLException {
        BotpScriptThirdObjAnalyzer analyzer = new BotpScriptThirdObjAnalyzer();
        analyzer.analyzeScriptRuleInfo(ctx, botRuleInfo);
        Map thirdBizObjPropertyMap = analyzer.getThirdBizObjPropertyMap();
        this.prepareThirdObjPropertyBatch(ctx, botRuleInfo, thirdBizObjPropertyMap, strFilter);
    }

    private void preCacheFunciton(Context ctx, BOTRuleInfo botRuleInfo, String strFilter) throws KScriptException, DataAccessException {
        BotpScriptFuncAnalyzer analyzer = new BotpScriptFuncAnalyzer();
        analyzer.analyzeScriptMapping(ctx, botRuleInfo);
        Map funcMap = analyzer.getFuncMap();
        this.preCacheFuncitonBatch(ctx, funcMap, strFilter);
    }

    private void preCacheFuncitonBatch(Context ctx, Map funcMap, String strFilter) {
        block2: for (BotpScriptFuncDeclare func : funcMap.values()) {
            IBotpBatchFormulaFunctions batchProvider = null;
            String funcName = func.getFuncName();
            Map paramsMap = func.getParamsMap();
            for (int i = 0; i < this.funcProviderList.size(); ++i) {
                IFunctionProvider funcProvider = (IFunctionProvider)this.funcProviderList.get(i);
                if (funcProvider == null || !funcProvider.existFunction(funcName) || !(funcProvider instanceof IBotpBatchFormulaFunctions) || !(batchProvider = (IBotpBatchFormulaFunctions)funcProvider).isBatchFucntion(funcName)) continue;
                try {
                    this.preEvalBatchFunciton(ctx, (IFunctionProvider)batchProvider, funcName, strFilter, paramsMap);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                continue block2;
            }
        }
    }

    public void preEvalBatchFunciton(Context ctx, IFunctionProvider batchProvider, String funcName, String strFilter, Map paramsMap) throws BOSException {
        if (batchProvider == null) {
            return;
        }
        ArrayList paramListColl = new ArrayList();
        HashMap<String, String> existMap = new HashMap<String, String>();
        for (List paramExprList : paramsMap.values()) {
            boolean bIsConst = BotSqlBuilder.isAllConstExpr(paramExprList);
            if (bIsConst) {
                Object srcObj = null;
                ArrayList<Object> paramList = new ArrayList<Object>(paramExprList.size());
                paramList.add(ctx);
                for (int j = 0; j < paramExprList.size(); ++j) {
                    CodeExpr pramExpr = (CodeExpr)paramExprList.get(j);
                    Object param = BotSqlBuilder.getParamValue(ctx, srcObj, pramExpr.toString());
                    paramList.add(param);
                }
                StringBuffer sb = new StringBuffer();
                int size = paramList.size();
                for (int k = 0; k < size; ++k) {
                    if (paramList.get(k) instanceof Context) {
                        sb.append(((Context)paramList.get(k)).getContextID());
                        continue;
                    }
                    sb.append(paramList.get(k));
                }
                String key = sb.toString();
                if (existMap.containsKey(key)) continue;
                existMap.put(key, key);
                paramListColl.add(paramList);
                continue;
            }
            BotpScriptUtils utils = new BotpScriptUtils();
            ArrayList<String> exprList = new ArrayList<String>(paramExprList.size());
            for (int j = 0; j < paramExprList.size(); ++j) {
                CodeExpr paramExpr = (CodeExpr)paramExprList.get(j);
                if (paramExpr instanceof StringExpr) {
                    exprList.add(((StringExpr)paramExpr).getJavaString());
                    continue;
                }
                exprList.add(paramExpr.toString());
            }
        }
    }

    private static Object getParamValue(Context ctx, Object srcObj, String pramExpr) throws BOSException {
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__src", srcObj);
        Interpreter interpreter = new Interpreter(ctx);
        localCtx.put("__bosContext", ctx);
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        interpreter.setDefaultObject(srcObj);
        String expr = pramExpr.toString();
        if (expr == null || expr.length() == 0) {
            return null;
        }
        Object paramVal = interpreter.eval(expr, localCtx);
        return paramVal;
    }

    private static boolean isAllConstExpr(List paramExprList) throws BOSException {
        boolean bIsConst = true;
        for (int i = 0; i < paramExprList.size(); ++i) {
            CodeExpr expr = (CodeExpr)paramExprList.get(i);
            if (expr instanceof IdentifierExpr) {
                bIsConst = false;
                continue;
            }
            if (expr instanceof MethodInvokeExpr) {
                bIsConst = false;
                continue;
            }
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) continue;
            bIsConst = false;
        }
        return bIsConst;
    }

    private void prepareThirdObjPropertyBatch(Context ctx, BOTRuleInfo botRuleInfo, Map thirdBizObjPropertyMap, String strFilter) throws BOSException, EASBizException, SQLException {
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select bot_FID");
            for (String fieldName : thirdBizObjPropertyMap.keySet()) {
                String columnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(fieldName);
                sql.append("," + columnName);
            }
            sql.append(" from " + this.mainTableName + " where " + strFilter);
            rs = BotSqlUtils.executeQuery(this.conn, sql.toString());
            HashMap<String, ArrayList<Object>> thirdIDsMap = new HashMap<String, ArrayList<Object>>();
            while (rs.next()) {
                for (String fieldName : thirdBizObjPropertyMap.keySet()) {
                    String columnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(fieldName);
                    int dataType = BotSqlUtils.getDataTypeByName(rs, columnName);
                    Object paramVal = BotSqlUtils.getDataFromDr(dataType, rs, columnName);
                    ArrayList<Object> thirdIDsList = (ArrayList<Object>)thirdIDsMap.get(fieldName);
                    if (thirdIDsList == null) {
                        thirdIDsList = new ArrayList<Object>();
                        thirdIDsMap.put(fieldName, thirdIDsList);
                    }
                    thirdIDsList.add(paramVal);
                }
            }
            for (String fieldName : thirdBizObjPropertyMap.keySet()) {
                List thirdIDsList = (List)thirdIDsMap.get(fieldName);
                if (thirdIDsMap.size() <= 0) continue;
                List propertyList = (List)thirdBizObjPropertyMap.get(fieldName);
                this.prepareThirdObjPropertyType(ctx, thirdIDsList, propertyList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void prepareThirdObjPropertyType(Context ctx, List thirdIDsList, List propertyList) throws KScriptException, BOSException {
        if (thirdIDsList == null || thirdIDsList.size() <= 0 || propertyList == null) {
            return;
        }
        Object entity = null;
        BOSObjectType bosType = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String strIDsValue = BoteBaseUtils.idList2SQLString(thirdIDsList);
        SelectorItemCollection selectors = new SelectorItemCollection();
        for (int i = 0; i < propertyList.size(); ++i) {
            selectors.add(new SelectorItemInfo((String)propertyList.get(i)));
        }
        viewInfo.setSelector(selectors);
        FilterItemInfo item = new FilterItemInfo("id", (Object)strIDsValue, CompareType.INCLUDE);
        filter.getFilterItems().add(item);
        viewInfo.setFilter(filter);
        String firstID = (String)thirdIDsList.get(0);
        bosType = BOSUuid.read((String)firstID).getType();
        IObjectCollection coll = Utils.getObjectCollection((Context)ctx, (BOSObjectType)bosType, (EntityViewInfo)viewInfo);
        if (coll == null || coll.size() <= 0) {
            return;
        }
        BoteThirdObjectCache.getInstance(ctx).prepare(coll);
    }

    private BotFuncParamCollection evalBotpSQLFunction(MappingSegmentSetInfo segmentSetInfo, String strFilter) throws BOSException, EASBizException, SQLException {
        boolean kk = false;
        Object result = null;
        FieldMappingType mappingType = segmentSetInfo.getMappingType();
        if (mappingType.getType() == 13 || mappingType.getType() == 11) {
            throw new BOSException("The special syntax is unsupported!  segmentSetInfo=" + segmentSetInfo);
        }
        if (mappingType.getType() == 12) {
            return this.evalMultiLineSQLFunction(segmentSetInfo, strFilter);
        }
        if (mappingType.getType() == 4) {
            return this.evalBizSQLFunction(segmentSetInfo, strFilter);
        }
        throw new BOSException();
    }

    private void evalComplexSegMent(MappingSegmentSetInfo segmentSetInfo, List<HashMap<String, Object>> ctxs, Interpreter interpreter) throws BOSException, EASBizException, SQLException {
        String strExpression = segmentSetInfo.getSrcExpression();
        String destPropertyName = segmentSetInfo.getDestPropertyName();
        destPropertyName = BoteBaseUtils.getRealDestFieldName(destPropertyName);
        for (HashMap<String, Object> ctx : ctxs) {
            String seqID = (String)ctx.get("bot_FID");
            Object result = interpreter.eval(strExpression, ctx);
            HashMap<String, Object> tempMap = (HashMap<String, Object>)this.allValueCacheMap.get(seqID);
            if (tempMap == null) {
                tempMap = new HashMap<String, Object>();
                this.allValueCacheMap.put(seqID, tempMap);
            }
            tempMap.put(destPropertyName, result);
        }
    }

    private BotFuncParamCollection evalMultiLineSQLFunction(MappingSegmentSetInfo segmentSetInfo, String strFilter) throws BOSException, EASBizException, SQLException {
        String strExpression = segmentSetInfo.getSrcExpression();
        KScriptParser parser = new KScriptParser(strExpression);
        parser.parse();
        List stmtList = parser.stmtList;
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt codeStmt = (CodeStmt)stmtList.get(i);
        }
        CodeStmt stmt = (CodeStmt)stmtList.get(0);
        return this.evalBizSQLFunction(segmentSetInfo, strFilter);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BotFuncParamCollection evalBizSQLFunction(MappingSegmentSetInfo segmentSetInfo, String strFilter) throws BOSException, EASBizException, SQLException {
        block33: {
            funcParams = null;
            rs = null;
            strExpression = segmentSetInfo.getSrcExpression();
            parser = new KScriptParser(strExpression);
            parser.parse();
            stmtList = parser.stmtList;
            stmt = (CodeStmt)stmtList.get(0);
            try {
                if (!(stmt instanceof ExprStmt)) {
                    var9_9 = null;
                    return var9_9;
                }
                expr = ((ExprStmt)stmt).expr;
                if (!(expr instanceof MethodInvokeExpr)) {
                    var10_14 = null;
                    return var10_14;
                }
                methodExpr = (MethodInvokeExpr)expr;
                methodName = methodExpr.methodName;
                if (!this.funcManager.isBizFunction(methodName)) {
                    var12_18 = null;
                    return var12_18;
                }
                func = this.funcManager.getBizFunction(methodName);
                exprParams = methodExpr.paramList;
                funcParamList = new FuncParamListInfo();
                for (j = 0; j < exprParams.size(); ++j) {
                    paramExpr = (CodeExpr)exprParams.get(j);
                    if (paramExpr instanceof BigDecimalExpr || paramExpr instanceof StringExpr || paramExpr instanceof IntExpr || paramExpr instanceof FloatExpr || paramExpr instanceof BoolExpr || paramExpr instanceof DoubleExpr || paramExpr instanceof LongExpr || paramExpr instanceof NullExpr) {
                        funcParamList.add(paramExpr, false);
                        continue;
                    }
                    if (paramExpr instanceof IdentifierExpr) {
                        funcParamList.add(paramExpr, false);
                        continue;
                    }
                    if (paramExpr instanceof PropertyExpr == false) throw new BOSException("The parameter <" + expr.toString() + "> is unsupported!");
                    funcParamList.add(paramExpr, true);
                }
                funcParams = new BotFuncParamCollection();
                if (funcParamList.hasProperty()) {
                    sql = new StringBuffer();
                    sql.append("select bot_FID");
                    for (i = 0; i < funcParamList.size(); ++i) {
                        exprItem = funcParamList.getExpr(i);
                        if (!funcParamList.isProperty(i)) continue;
                        columnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(((PropertyExpr)exprItem).toString());
                        sql.append("," + columnName);
                    }
                    sql.append(" from " + this.mainTableName + " where " + strFilter);
                    rs = BotSqlUtils.executeQuery(this.conn, sql.toString());
                    break block33;
                }
                paramList = new ArrayList<Object>();
                for (i = 0; i < funcParamList.size(); ++i) {
                    tempVal = this.getFuncParamValue(funcParamList.getExpr(i));
                    paramList.add(tempVal);
                }
                sql = new StringBuffer();
                sql.append("select bot_FID");
                sql.append(" from " + this.mainTableName + " where " + strFilter);
                rs = BotSqlUtils.executeQuery(this.conn, sql.toString());
                while (rs.next()) {
                    seqID = rs.getString("bot_FID");
                    paramInfo = new BotFuncParamInfo(seqID, paramList);
                    funcParams.add(paramInfo);
                }
                while (true) {
                    func.evalSQLFunction(this.ctx, methodName, funcParams);
                    return funcParams;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception var24_41) {}
            }
        }
        while (true) {
            if (!rs.next()) ** continue;
            seqID = rs.getString("bot_FID");
            paramList = new ArrayList<Object>();
            for (i = 0; i < funcParamList.size(); ++i) {
                exprItem = funcParamList.getExpr(i);
                if (funcParamList.isProperty(i)) {
                    columnName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(((PropertyExpr)exprItem).toString());
                    dataType = BotSqlUtils.getDataTypeByName(rs, columnName);
                    paramVal = BotSqlUtils.getDataFromDr(dataType, rs, columnName);
                    paramList.add(paramVal);
                    continue;
                }
                tempVal = this.getFuncParamValue(exprItem);
                paramList.add(tempVal);
            }
            paramInfo = new BotFuncParamInfo(seqID, paramList);
            funcParams.add(paramInfo);
        }
    }

    private BotFuncParamCollection evalMultiLineSQLFunction(ResultSet rs) {
        return null;
    }

    private void addCachedResultValue(String destPropertyName, BotFuncParamCollection params) {
        if (params == null) {
            return;
        }
        int n = params.size();
        for (int i = 0; i < n; ++i) {
            BotFuncParamInfo info = params.get(i);
            String seqID = info.getSeq();
            Object result = info.getResult();
            HashMap<String, Object> tempMap = (HashMap<String, Object>)this.allValueCacheMap.get(seqID);
            if (tempMap == null) {
                tempMap = new HashMap<String, Object>();
                this.allValueCacheMap.put(seqID, tempMap);
            }
            tempMap.put(destPropertyName, result);
        }
    }

    public Object getCachedResultValue(String seqID, String destPropertyName) {
        Map tempMap = (Map)this.allValueCacheMap.get(seqID);
        if (tempMap != null) {
            return tempMap.get(destPropertyName);
        }
        return null;
    }

    public boolean isCachedResultValue(String seqID, String destPropertyName) {
        Map tempMap = (Map)this.allValueCacheMap.get(seqID);
        return tempMap != null && tempMap.keySet().contains(destPropertyName);
    }

    protected String innerBuildInsertSQLForEntryRule(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo, String tableName, String[] entryNames, SQLSrcTableManager srcTableManager) throws BOSException, EASBizException {
        DataSqlHandler dataSqlHandler = new DataSqlHandler();
        StringBuffer sb = new StringBuffer();
        if (mappingInfo == null || botRuleInfo == null) {
            logger.error((Object)("Illegal parameter error, mappingInfo=" + mappingInfo + ", botRuleInfo=" + botRuleInfo));
            return "";
        }
        try {
            BOTRuleSegmentCollection botRuleSegCols = botRuleInfo.getRuleSegments();
            sb.append("INSERT INTO " + tableName + "(");
            int size = botRuleSegCols.size();
            for (int i = 0; i < size; ++i) {
                boolean bIsSimple = true;
                BOTRuleSegmentInfo botRuleSegInfo = botRuleSegCols.get(i);
                String key = mappingInfo.getId().toString() + botRuleInfo.getId().toString() + botRuleSegInfo.getId().toString();
                MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)this.allDestFiledsMap.get(key);
                if (segmentSetInfo == null) {
                    throw new BOSException("Can't find key[" + key + "] in alllDestFiledList!  mappingInfo=" + mappingInfo.getName() + ",  botRuleInfo=" + botRuleInfo.getName() + ", botRuleSegInfo=" + botRuleSegInfo);
                }
                this.innerCreateSrcDataSQL(botRuleSegInfo, segmentSetInfo, srcTableManager, dataSqlHandler);
            }
            BOTExtSetRuleCollection extSetRules = botRuleInfo.getExtSetRules();
            for (int i = 0; i < extSetRules.size(); ++i) {
                BOTExtSetRuleInfo extRuleInfo = extSetRules.get(i);
                BOTExtSetRuleSegmentCollection extSegments = extRuleInfo.getRuleSegments();
                for (int j = 0; j < extSegments.size(); ++j) {
                    BOTExtSetRuleSegmentInfo extSetSegInfo = extSegments.get(j);
                    this.extPropertys.put(extSetSegInfo.getDestPropertyName(), "");
                    String key = mappingInfo.getId().toString() + "__" + botRuleInfo.getId().toString() + "__" + extRuleInfo.getId().toString() + "__" + extSetSegInfo.getId().toString();
                    MappingSegmentSetInfo segmentSetInfo = (MappingSegmentSetInfo)this.allDestFiledsMap.get(key);
                    if (segmentSetInfo == null) {
                        throw new BOSException("Can't find key[" + key + "] in alllDestFiledList!  mappingInfo=" + mappingInfo.getName() + ",  botRuleInfo=" + botRuleInfo.getName() + ", extRuleInfo=" + extRuleInfo.getId() + ", extSegInfo=" + extSetSegInfo);
                    }
                    this.innerCreateSrcDataSQLByDAP(extRuleInfo, extSetSegInfo, segmentSetInfo, srcTableManager, dataSqlHandler);
                }
            }
            List srcFields = this.tableCreateSqlManager.getAllSrcFields();
            for (int i = 0; i < srcFields.size(); ++i) {
                String srcFieldName = (String)srcFields.get(i);
                String realSrcName = this.getJoinFieldNameBySrcPropName(srcTableManager, srcFieldName);
                String realDestName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(srcFieldName);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            }
            dataSqlHandler.appendNewField("bot_FID", "newBOSID('BOTP')");
            dataSqlHandler.appendNewField("bot_tmp_SrcEntity", "'" + mappingInfo.getSrcEntity().getType().toString() + "'");
            dataSqlHandler.appendNewField("bot_tmp_MappingID", "'" + mappingInfo.getId().toString() + "'");
            dataSqlHandler.appendNewField("bot_tmp_RuleID", "'" + botRuleInfo.getId().toString() + "'");
            String tableAlias = srcTableManager.getTableAliasByEntityPath("__src");
            String entryName = "__src.entry";
            if (entryNames != null && entryNames.length > 0) {
                entryName = "__src." + entryNames[0];
            }
            String entryTableAlias = srcTableManager.getTableAliasByEntityPath(entryName);
            String srcID = srcTableManager.getColumnNameByPropName(tableAlias, "id");
            String srcEntryID = srcTableManager.getColumnNameByPropName(entryTableAlias, "id");
            dataSqlHandler.appendNewField("bot_tmp_SrcID", srcID);
            dataSqlHandler.appendNewField("bot_tmp_EntryID", srcEntryID);
            String allDestColumnName = dataSqlHandler.getAllDestColumnName();
            String allSrcDataValue = dataSqlHandler.getAllSrcDataValue();
            sb.append(allDestColumnName);
            sb.append(" ) select  ");
            sb.append(allSrcDataValue);
            sb.append(srcTableManager.toString());
        }
        catch (Exception e) {
            throw new BOSException("Build sql for InsertDataSql for TempTable Error!" + e.getMessage() + ",  mappingName=" + mappingInfo.getName() + ",  botRuleInfo=" + (Object)((Object)botRuleInfo.getGroups()), (Throwable)e);
        }
        return sb.toString();
    }

    protected void innerCreateSrcDataSQL(BOTRuleSegmentInfo botRuleSegInfo, MappingSegmentSetInfo segmentSetInfo, SQLSrcTableManager srcTableManager, DataSqlHandler dataSqlHandler) throws BOSException, EASBizException {
        String destPropertyName = botRuleSegInfo.getDestPropertyName();
        String srcPropertyName = botRuleSegInfo.getSrcPropertyName();
        String strExpression = botRuleSegInfo.getExpression();
        if (StringUtils.isEmpty((String)srcPropertyName) && StringUtils.isEmpty((String)strExpression)) {
            return;
        }
        String realSrcName = "";
        String realDestName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(destPropertyName);
        if (!StringUtils.isEmpty((String)srcPropertyName)) {
            realSrcName = this.getJoinFieldNameBySrcPropName(srcTableManager, srcPropertyName);
            dataSqlHandler.appendNewField(realDestName, realSrcName);
        } else {
            String realExpression = BotCoreExprAnalyzer.formatKsciptExpr(strExpression);
            FieldMappingType mappingType = segmentSetInfo.getMappingType();
            if (0 == mappingType.getType()) {
                realSrcName = segmentSetInfo.getSrcExpression();
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (1 == mappingType.getType()) {
                realSrcName = this.getJoinFieldNameBySrcPropName(srcTableManager, realExpression);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (2 == mappingType.getType() || 3 == mappingType.getType()) {
                realSrcName = this.innerGetSrcForSimpleExpr(srcTableManager, segmentSetInfo);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (4 != mappingType.getType() && 13 != mappingType.getType() && 12 != mappingType.getType()) {
                throw new BOSException("Format Error!  expression = <" + strExpression + ">");
            }
        }
    }

    protected void innerCreateSrcDataSQLByDAP(BOTExtSetRuleInfo extRuleInfo, BOTExtSetRuleSegmentInfo extSetRuleSegInfo, MappingSegmentSetInfo segmentSetInfo, SQLSrcTableManager srcTableManager, DataSqlHandler dataSqlHandler) throws BOSException, EASBizException {
        String refClass = DAP_REFCLASS;
        String refPropertys = DAP_REF_PROPERTYS;
        String destDAPPropName = DAP_DEST_PROPNAME;
        String destPropertyName = destDAPPropName + "." + extSetRuleSegInfo.getDestPropertyName();
        String srcPropertyName = extSetRuleSegInfo.getSrcPropertyName();
        String strExpression = extSetRuleSegInfo.getExpression();
        String alias = extSetRuleSegInfo.getAlias();
        if (StringUtils.isEmpty((String)srcPropertyName) && StringUtils.isEmpty((String)strExpression)) {
            return;
        }
        String realSrcName = "";
        String realDestName = this.fieldNameMappingManager.getTableFieldNameByEntityFieldName(destPropertyName);
        if (!StringUtils.isEmpty((String)srcPropertyName)) {
            realSrcName = this.getJoinFieldNameBySrcPropName(srcTableManager, srcPropertyName);
            dataSqlHandler.appendNewField(realDestName, realSrcName);
        } else {
            String realExpression = BotCoreExprAnalyzer.formatKsciptExpr(strExpression);
            FieldMappingType mappingType = segmentSetInfo.getMappingType();
            if (0 == mappingType.getType()) {
                realSrcName = segmentSetInfo.getSrcExpression();
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (1 == mappingType.getType()) {
                realSrcName = this.getJoinFieldNameBySrcPropName(srcTableManager, realExpression);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (3 == mappingType.getType()) {
                realSrcName = this.innerGetSrcForBaseFunc(srcTableManager, segmentSetInfo);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (2 == mappingType.getType()) {
                realSrcName = this.innerGetSrcForSimpleExpr(srcTableManager, segmentSetInfo);
                dataSqlHandler.appendNewField(realDestName, realSrcName);
            } else if (4 != mappingType.getType()) {
                throw new BOSException("Format Error!  expression = <" + strExpression + ">");
            }
        }
        if (realSrcName == null || realSrcName.equalsIgnoreCase("")) {
            // empty if block
        }
    }

    protected String innerGetSrcForSimpleExpr(SQLSrcTableManager srcTableManager, MappingSegmentSetInfo segmentSetInfo) throws BOSException, EASBizException {
        String realSrcExpr = null;
        FieldMappingType mappingType = segmentSetInfo.getMappingType();
        if (mappingType.isIdentifier()) {
            String expression = segmentSetInfo.getSrcExpression();
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            if (stmtList.size() > 1) {
                throw new BOSException("Error,  expression=" + expression);
            }
            CodeStmt stmt = (CodeStmt)stmtList.get(0);
            if (stmt instanceof ExprStmt) {
                realSrcExpr = BotCodeExprConverter.transform2SQL((ExprStmt)stmt, srcTableManager);
            }
        } else {
            realSrcExpr = segmentSetInfo.getSrcExpression();
            realSrcExpr = BotCodeExprConverter.transform2SQL(realSrcExpr, srcTableManager);
        }
        return realSrcExpr;
    }

    protected String innerGetSrcForBaseFunc(SQLSrcTableManager srcTableManager, MappingSegmentSetInfo segmentSetInfo) throws BOSException, EASBizException {
        String realSrcExpr = null;
        FieldMappingType mappingType = segmentSetInfo.getMappingType();
        if (mappingType.isIdentifier()) {
            String expression = segmentSetInfo.getSrcExpression();
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            if (stmtList.size() > 1) {
                throw new BOSException("Error,  expression=" + expression);
            }
            CodeStmt stmt = (CodeStmt)stmtList.get(0);
            if (stmt instanceof ExprStmt) {
                realSrcExpr = BotCodeExprConverter.transform2SQL((ExprStmt)stmt, srcTableManager);
            }
        } else {
            realSrcExpr = segmentSetInfo.getSrcExpression();
        }
        return realSrcExpr;
    }

    protected String innerGetSrcForBizFunc(SQLSrcTableManager srcTableManager, MappingSegmentSetInfo segmentSetInfo) throws BOSException, EASBizException {
        String realSrcExpr = null;
        FieldMappingType mappingType = segmentSetInfo.getMappingType();
        if (mappingType.isIdentifier()) {
            String expression = segmentSetInfo.getSrcExpression();
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            if (stmtList.size() > 1) {
                throw new BOSException("Error,  expression=" + expression);
            }
            CodeStmt stmt = (CodeStmt)stmtList.get(0);
            if (stmt instanceof ExprStmt) {
                realSrcExpr = BotCodeExprConverter.transform2SQL((ExprStmt)stmt, srcTableManager);
            }
        } else {
            realSrcExpr = segmentSetInfo.getSrcExpression();
        }
        return realSrcExpr;
    }

    protected String getJoinFieldNameBySrcPropName(SQLSrcTableManager srcTableManager, String propertyName) throws BOSException, EASBizException {
        String newVal;
        if (StringUtils.isEmpty((String)propertyName)) {
            throw new BOSException("Illegal Parameter,  propertyName=" + propertyName);
        }
        String srcPropertyName = propertyName;
        if (!srcPropertyName.startsWith("__src.")) {
            srcPropertyName = "__src." + srcPropertyName;
        }
        if (!StringUtils.isEmpty((String)(newVal = srcTableManager.getColumnNameFromCache(srcPropertyName)))) {
            return newVal;
        }
        String newFieldName = "";
        String newTBAliasName = "";
        String[] names = StringUtils.split((String)srcPropertyName, (String)".");
        EntityObjectInfo currEntity = srcTableManager.getMainEntity();
        PropertyInfo realProp = null;
        EntityObjectInfo ownerEntity = srcTableManager.getMainEntity();
        StringBuffer entityPath = new StringBuffer();
        int max = names.length;
        for (int i = 0; i < max; ++i) {
            String name = names[i];
            if (i > 0) {
                PropertyInfo prop = (PropertyInfo)currEntity.getInheritedPropertiesRuntime().getObject((Object)name);
                if (prop == null || !(prop instanceof OwnPropertyInfo) && !(prop instanceof LinkPropertyInfo)) {
                    throw new BOSException("Error,  propertyName=" + propertyName + ",  name=" + name + ",  currEntity=" + currEntity + ", prop=" + prop);
                }
                if (i == max - 1) {
                    realProp = prop;
                } else {
                    LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                    RelationshipInfo relationShip = linkProp.getRelationship();
                    EntityObjectInfo clientObj = relationShip.getClientObject();
                    EntityObjectInfo supplierObj = relationShip.getSupplierObject();
                    boolean isEntry = BotSqlBuilder.checkIsEntryLink(linkProp, currEntity);
                    String newTableAlias = srcTableManager.processJoinTable(currEntity, supplierObj, linkProp, entityPath.toString(), isEntry);
                    currEntity = supplierObj;
                    ownerEntity = supplierObj;
                    newTBAliasName = newTableAlias;
                }
                entityPath.append("." + name);
                continue;
            }
            newTBAliasName = "T0";
            entityPath.append(name);
        }
        newFieldName = !realProp.getMappingField().isMultilingual() ? realProp.getMappingField().getName() : realProp.getMappingField().getName() + "_" + this.ctx.getLocale();
        newVal = newTBAliasName + "." + newFieldName.toString();
        if (!StringUtils.isEmpty((String)newVal)) {
            srcTableManager.setResult(srcPropertyName, newVal);
        }
        return newVal;
    }

    private void buildTempTableSqlByGroupCols(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo) throws BOSException, EASBizException {
        BOTGroupingInfo groupInfo;
        int j;
        BOTGroupingCollection botGroupCols = botRuleInfo.getGroups();
        Object[] objArray = botGroupCols.toArray();
        botGroupCols.clear();
        for (j = 0; j < objArray.length; ++j) {
            groupInfo = (BOTGroupingInfo)objArray[j];
            botGroupCols.add(groupInfo);
        }
        for (j = 0; j < botGroupCols.size(); ++j) {
            groupInfo = botGroupCols.get(j);
            String groupingProperty = groupInfo.getGroupingProperty();
            int groupingLevel = groupInfo.getGroupingLevel();
            if (groupingLevel != 1 || !groupingProperty.startsWith("__src")) continue;
            this.tableCreateSqlManager.processTempTableFieldSql(groupingProperty);
        }
    }

    private void buildTempTableSqlByRuleInfo(BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo) throws BOSException, EASBizException {
        BOTRuleSegmentCollection botRuleSegCols = botRuleInfo.getRuleSegments();
        int size = botRuleSegCols.size();
        for (int i = 0; i < size; ++i) {
            boolean bIsSimple = true;
            BOTRuleSegmentInfo botRuleSegInfo = botRuleSegCols.get(i);
            String destPropertyName = botRuleSegInfo.getDestPropertyName();
            String srcPropertyName = botRuleSegInfo.getSrcPropertyName();
            String strExpression = botRuleSegInfo.getExpression();
            if (StringUtils.isEmpty((String)srcPropertyName) && StringUtils.isEmpty((String)strExpression)) {
                throw new BOSException("BOTRuleSegmentInfo format error!  botRuleSegInfo=" + botRuleSegInfo);
            }
            try {
                MappingSegmentSetInfo segmentSetInfo = this.buildMappingSegmentSetInfo(destPropertyName, srcPropertyName, strExpression, mappingInfo, botRuleInfo, 0);
                this.tableCreateSqlManager.addField(segmentSetInfo.getDestPropertyName(), segmentSetInfo);
                String key = mappingInfo.getId().toString() + botRuleInfo.getId().toString() + botRuleSegInfo.getId().toString();
                this.allDestFiledsMap.put(key, segmentSetInfo);
                continue;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage() + ", srcPropertyName=" + srcPropertyName + ", destPropertyName=" + destPropertyName + ", strExpression=" + strExpression, (Throwable)e);
            }
        }
        BOTExtSetRuleCollection extSetRules = botRuleInfo.getExtSetRules();
        for (int i = 0; i < extSetRules.size(); ++i) {
            BOTExtSetRuleInfo extRuleInfo = extSetRules.get(i);
            String refClass = DAP_REFCLASS;
            String refPropertys = DAP_REF_PROPERTYS;
            String destDAPPropName = DAP_DEST_PROPNAME;
            BOTExtSetRuleSegmentCollection extSegments = extRuleInfo.getRuleSegments();
            for (int j = 0; j < extSegments.size(); ++j) {
                BOTExtSetRuleSegmentInfo extSegInfo = extSegments.get(j);
                String destPropertyName = destDAPPropName + "." + extSegInfo.getDestPropertyName();
                String srcPropertyName = extSegInfo.getSrcPropertyName();
                String strExpression = extSegInfo.getExpression();
                String alias = extSegInfo.getAlias();
                if (StringUtils.isEmpty((String)srcPropertyName) && StringUtils.isEmpty((String)strExpression)) {
                    throw new BOSException("BOTExtSetRuleSegmentInfo format error!  extSegInfo=" + extSegInfo);
                }
                try {
                    String key;
                    MappingSegmentSetInfo segmentSetInfo;
                    if ("asstActType".equalsIgnoreCase(extSegInfo.getDestPropertyName())) {
                        segmentSetInfo = this.buildMappingSegmentSetInfo(destPropertyName, srcPropertyName, strExpression, mappingInfo, botRuleInfo, 1);
                        this.tableCreateSqlManager.addField(segmentSetInfo.getDestPropertyName(), segmentSetInfo);
                        key = mappingInfo.getId().toString() + "__" + botRuleInfo.getId().toString() + "__" + extRuleInfo.getId().toString() + "__" + extSegInfo.getId().toString();
                        this.allDestFiledsMap.put(key, segmentSetInfo);
                        continue;
                    }
                    if ("refObject".equalsIgnoreCase(extSegInfo.getDestPropertyName())) {
                        segmentSetInfo = this.buildMappingSegmentSetInfo(destPropertyName, srcPropertyName, strExpression, mappingInfo, botRuleInfo, 1);
                        this.tableCreateSqlManager.addField(segmentSetInfo.getDestPropertyName(), segmentSetInfo);
                        key = mappingInfo.getId().toString() + "__" + botRuleInfo.getId().toString() + "__" + extRuleInfo.getId().toString() + "__" + extSegInfo.getId().toString();
                        this.allDestFiledsMap.put(key, segmentSetInfo);
                        continue;
                    }
                    segmentSetInfo = this.buildMappingSegmentSetInfo(destPropertyName, srcPropertyName, strExpression, mappingInfo, botRuleInfo, 1);
                    this.tableCreateSqlManager.addField(segmentSetInfo.getDestPropertyName(), segmentSetInfo);
                    key = mappingInfo.getId().toString() + "__" + botRuleInfo.getId().toString() + "__" + extRuleInfo.getId().toString() + "__" + extSegInfo.getId().toString();
                    this.allDestFiledsMap.put(key, segmentSetInfo);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException("srcPropertyName=" + srcPropertyName + ", destPropertyName=" + destPropertyName + ", strExpression=" + strExpression, (Throwable)e);
                }
            }
        }
    }

    private MappingSegmentSetInfo buildMappingSegmentSetInfo(String destPropertyName, String srcPropertyName, String strExpression, BOTMappingInfo mappingInfo, BOTRuleInfo botRuleInfo, int type) throws BOSException, EASBizException {
        FieldMappingType mappingType = null;
        MappingSegmentSetInfo segmentSetInfo = null;
        String realExpression = srcPropertyName;
        if (StringUtils.isEmpty((String)srcPropertyName)) {
            realExpression = strExpression;
            BotCoreExprAnalyzer analyzer = new BotCoreExprAnalyzer(this.funcManager);
            analyzer.checkExpressMappingType(strExpression);
            mappingType = analyzer.getMappingType();
            if (mappingType.getType() == 0 && analyzer.getRealValue() != null) {
                realExpression = analyzer.getRealValue();
            }
        } else {
            mappingType = new FieldMappingType(1, false);
        }
        if (mappingType == null) {
            throw new BOSException("The mappingType can't be null");
        }
        String[] names = StringUtils.split((String)destPropertyName, (String)".");
        segmentSetInfo = new MappingSegmentSetInfo(destPropertyName, mappingType, realExpression, mappingInfo);
        return segmentSetInfo;
    }

    protected FieldMappingType getFieldMappingType(String strExpression) throws BOSException, EASBizException {
        FieldMappingType mappingType = null;
        BotCoreExprAnalyzer analyzer = new BotCoreExprAnalyzer(this.funcManager);
        analyzer.checkExpressMappingType(strExpression);
        mappingType = analyzer.getMappingType();
        return mappingType;
    }

    public Map getAllDestFiledsMap() {
        return this.allDestFiledsMap;
    }

    public BotStructManager analyzeDestFiledsEntityStruct(EntityObjectInfo entity) throws BOSException, EASBizException {
        if (this.allDestFiledsMap == null) {
            return null;
        }
        BotStructManager manager = new BotStructManager();
        manager.setEntityKeyField(this.getEntityKeyField());
        BotStructEntityInfo rootStructInfo = new BotStructEntityInfo(entity);
        rootStructInfo.setEntityPath("__dest");
        manager.setRootStructInfo(rootStructInfo);
        BotStructEntityInfo currStruct = null;
        EntityObjectInfo currEntity = null;
        for (MappingSegmentSetInfo segmentSetInfo : this.allDestFiledsMap.values()) {
            String destPropName = segmentSetInfo.getDestPropertyName();
            if (!destPropName.startsWith("__dest")) {
                destPropName = "__dest." + destPropName;
            }
            String[] names = StringUtils.split((String)destPropName, (String)".");
            int level = 0;
            StringBuffer nameBuff = new StringBuffer();
            for (int i = 0; i < names.length - 1; ++i) {
                PropertyInfo prop;
                ++level;
                if (currStruct != null) {
                    currEntity = currStruct.getEntity();
                }
                String name = names[i];
                if (nameBuff.length() > 0) {
                    nameBuff.append(".");
                }
                nameBuff.append(name);
                BotStructEntityInfo nextStruct = manager.get(nameBuff.toString());
                if (nextStruct != null) {
                    currStruct = nextStruct;
                    continue;
                }
                if (!currEntity.getInheritedNoDuplicatedPropertiesRuntime().containsKey((Object)name) || !((prop = (PropertyInfo)currEntity.getInheritedNoDuplicatedPropertiesRuntime().getObject((Object)name)) instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                EntityObjectInfo subEntity = this.getRefObjectByLinkProp(linkProp, currEntity);
                if (BotSqlBuilder.checkIsEntryLink(linkProp, currEntity)) {
                    nextStruct = new BotStructEntityInfo(subEntity);
                    nextStruct.setEntityPath(nameBuff.toString());
                    nextStruct.setParentLinkName(name);
                    currStruct.addEntity(nextStruct);
                    currStruct = nextStruct;
                    manager.add(nameBuff.toString(), nextStruct);
                    continue;
                }
                nextStruct = new BotStructEntityInfo(subEntity, false);
                nextStruct.setEntityPath(nameBuff.toString());
                nextStruct.setParentLinkName(name);
                currStruct.addEntity(nextStruct);
                currStruct = nextStruct;
                manager.add(nameBuff.toString(), nextStruct);
            }
            String propName = names[names.length - 1];
            currEntity = currStruct.getEntity();
            PropertyInfo prop = (PropertyInfo)currEntity.getInheritedNoDuplicatedPropertiesRuntime().getObject((Object)propName);
            if (prop == null) continue;
            segmentSetInfo.setPropertyInfo(prop);
            DataTableInfo tableInfo = currEntity.getTable();
            ColumnInfo columnInfo = prop.getMappingField();
            int dataType = columnInfo.getSQLType();
            BotStructPropertyInfo property = new BotStructPropertyInfo(currStruct, prop);
            property.setSumField(false);
            property.setColumnName(this.tableCreateSqlManager.getColumnByField(destPropName));
            property.setDataType(dataType);
            property.setLevel(level);
            property.setFullPropName(destPropName);
            property.setPropName(propName);
            if (this.checkIsSumField(destPropName)) {
                property.setSumField(true);
            }
            currStruct.getProperties().put(propName, property);
            manager.add(property);
        }
        if (this.groupPropertysMap != null) {
            BotStructEntityInfo rootStruct = manager.getRootStructInfo();
            this.processEntityGroupField(rootStruct);
        }
        return manager;
    }

    private void processEntityGroupField(BotStructEntityInfo structInfo) throws BOSException, EASBizException {
        String currEntityPath = structInfo.getEntityPath();
        for (String fullGroupFldName : this.groupPropertysMap.values()) {
            if (!fullGroupFldName.startsWith("__dest")) {
                fullGroupFldName = "__dest." + fullGroupFldName;
            }
            String groupEntityPath = this.getGroupParentEntutyPath(fullGroupFldName);
            String groupFieldName = this.getRealGroupFldName(fullGroupFldName);
            if (!groupEntityPath.equalsIgnoreCase(currEntityPath)) continue;
            EntityObjectInfo currEntity = structInfo.getEntity();
            structInfo.addGroupProperty(fullGroupFldName);
        }
        List children = structInfo.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            BotStructEntityInfo subStructInfo = (BotStructEntityInfo)children.get(i);
            this.processEntityGroupField(subStructInfo);
        }
    }

    private String getGroupParentEntutyPath(String propertyName) throws BOSException {
        if (StringUtils.isEmpty((String)propertyName)) {
            return propertyName;
        }
        int idx = propertyName.lastIndexOf(".");
        if (idx <= 0) {
            return propertyName;
        }
        return propertyName.substring(0, idx);
    }

    private String getRealGroupFldName(String propertyName) throws BOSException {
        if (StringUtils.isEmpty((String)propertyName)) {
            return propertyName;
        }
        int idx = propertyName.lastIndexOf(".");
        if (idx <= 0) {
            return propertyName;
        }
        return propertyName.substring(idx + 1);
    }

    public boolean checkIsGroupProperty(String propertyName) throws BOSException, EASBizException {
        return this.groupPropertysMap.containsKey(propertyName);
    }

    public boolean checkIsSumField(String propertyName) throws BOSException, EASBizException {
        return this.sumPropertysMap.containsKey(propertyName);
    }

    public TableCreateSqlManager getTableCreateSqlManager() {
        return this.tableCreateSqlManager;
    }

    public static boolean checkIsEntryLink(LinkPropertyInfo property, EntityObjectInfo parentEntity) throws BOSException {
        RelationshipInfo relation = property.getRelationship();
        return relation.getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty(ISENTRIES));
    }

    public EntityObjectInfo getEntryObjectByLinkProp(LinkPropertyInfo property, EntityObjectInfo parentEntity) throws BOSException, EASBizException {
        RelationshipInfo relation = property.getRelationship();
        String parentEntityName = parentEntity.getFullName();
        if (relation.getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty(ISENTRIES))) {
            if (relation.getClientObject().getFullName().equals(parentEntityName) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                return relation.getSupplierObject();
            }
            if (relation.getSupplierObject().getFullName().equals(parentEntityName) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                return relation.getClientObject();
            }
        }
        return null;
    }

    public EntityObjectInfo getRefObjectByLinkProp(LinkPropertyInfo property, EntityObjectInfo parentEntity) throws BOSException, EASBizException {
        RelationshipInfo relation = property.getRelationship();
        String parentEntityName = parentEntity.getFullName();
        if (relation.getClientObject().getFullName().equals(parentEntityName)) {
            return relation.getSupplierObject();
        }
        if (relation.getSupplierObject().getFullName().equals(parentEntityName)) {
            return relation.getClientObject();
        }
        return null;
    }

    public void processGroupAndAggregateSet(BOTMappingInfo mappingInfo) throws BOSException {
        BOTAggregateCollection botAggregateCols = mappingInfo.getAggregateCollection();
        BOTRuleCollection botRuleCols = mappingInfo.getRules();
        BOTRuleInfo botRuleInfo = botRuleCols.get(0);
        BOTGroupingCollection botGrpCols = botRuleInfo.getGroups();
        HashMap entryNameToGrpNameListMap = new HashMap();
        int size = botGrpCols.size();
        for (int i = 0; i < size; ++i) {
            BOTGroupingInfo botGrpInfo = botGrpCols.get(i);
            String destGrpName = botGrpInfo.getGroupingProperty();
            if (!destGrpName.startsWith("__dest")) {
                destGrpName = "__dest." + destGrpName;
            }
            this.groupPropertysMap.put(destGrpName, destGrpName);
        }
        HashMap entryNameToAggregateNameListMap = new HashMap();
        int size2 = botAggregateCols.size();
        for (int i = 0; i < size2; ++i) {
            BOTAggregateInfo botAggregateInfo = botAggregateCols.get(i);
            String destAggregateName = botAggregateInfo.getPropertyName();
            if (!destAggregateName.startsWith("__dest.")) {
                destAggregateName = "__dest." + destAggregateName;
            }
            this.sumPropertysMap.put(destAggregateName, destAggregateName);
        }
    }

    private Object getFuncParamValue(CodeExpr expr) throws BOSException, EASBizException, SQLException {
        if (expr instanceof StringExpr) {
            return ((StringExpr)expr).getJavaString();
        }
        return expr.toString();
    }

    public Map getExtPropertys() {
        return this.extPropertys;
    }

    private String getSrcBillIDStr(IObjectCollection srcObjCols) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < srcObjCols.size(); ++i) {
            Object id = srcObjCols.getObject(i).get("id");
            if (id == null) continue;
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'" + id + "'");
        }
        return sb.toString();
    }

    private class GrpValueStructure {
        private IObjectValue destObj;
        private Map entryGrpCtx;

        public GrpValueStructure(IObjectValue destObj, Map entryGrpCtx) {
            this.destObj = destObj;
            this.entryGrpCtx = entryGrpCtx;
        }
    }

    private class GrpKeyStructure {
        private String entryName;
        private List grpPropsNameList;
        private List aggregatePropsNameList;
        private List mergeCharsPropsNameList;
        private List mergeCharsPropsExpList;
        private IObjectCollection ownerCollection;

        public GrpKeyStructure(String entryName, List grpList, List aggregateList, List mergeCharsList, List mergeCharsExpList, IObjectCollection ownerCollection) {
            this.entryName = entryName;
            this.grpPropsNameList = grpList;
            this.aggregatePropsNameList = aggregateList;
            this.mergeCharsPropsNameList = mergeCharsList;
            this.mergeCharsPropsExpList = mergeCharsExpList;
            this.ownerCollection = ownerCollection;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof GrpKeyStructure) {
                return this.entryName.equals(((GrpKeyStructure)obj).entryName);
            }
            return result;
        }

        public int hashCode() {
            return this.entryName.hashCode();
        }
    }

    private class EntityEntryStructure {
        private static final String ISENTRIES = "isEntries";
        private int level;
        private EntityObjectInfo entryEntity;
        private EntityEntryStructure owner;
        private Map entryVerticalMap;

        public EntityEntryStructure(int level, EntityObjectInfo entity, EntityEntryStructure owner) {
            this.level = level;
            this.entryEntity = entity;
            this.owner = owner;
            this.buildVerticalStructure();
        }

        public Map buildHorizontalStructure(String prefix) {
            HashMap entryHorizontalMap = new HashMap();
            this.transformVerticalToHorizonStructure(prefix, this.entryVerticalMap, entryHorizontalMap);
            return entryHorizontalMap;
        }

        private void transformVerticalToHorizonStructure(String prefix, Map entryVerticalMap, Map entryHorizontalMap) {
            Set key = entryVerticalMap.keySet();
            for (String propName : key) {
                EntityEntryStructure entry = (EntityEntryStructure)entryVerticalMap.get(propName);
                String entryPrefix = prefix == null ? propName : prefix + "." + propName;
                entryHorizontalMap.put(entryPrefix, entry);
                this.transformVerticalToHorizonStructure(entryPrefix, entry.entryVerticalMap, entryHorizontalMap);
            }
        }

        private void buildVerticalStructure() {
            this.entryVerticalMap = new HashMap();
            PropertyCollection props = this.entryEntity.getInheritedNoDuplicatedProperties();
            for (PropertyInfo propInfo : props) {
                RelationshipInfo relation;
                if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
                EntityObjectInfo relateEntity = null;
                if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getSupplierObject();
                } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getClientObject();
                }
                if (relateEntity == null) continue;
                EntityEntryStructure entryInfo = new EntityEntryStructure(this.level + 1, relateEntity, this);
                this.entryVerticalMap.put(propInfo.getName(), entryInfo);
            }
        }
    }
}

