/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.sql.SerializableByteArrayInputStream;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class BotSqlUtils {
    private Context ctx = null;

    public BotSqlUtils(Context ctx) {
        this.ctx = ctx;
    }

    public Connection getConnection() throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            return cn;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
    }

    public static void executeSQL(Context ctx, String sql) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public void executeSQL(String sql) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(List sqlList) throws SQLException {
        int[] nArray;
        long t0 = System.currentTimeMillis();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.createStatement();
            int n = sqlList.size();
            for (int i = 0; i < n; ++i) {
                if (StringUtils.isEmpty((String)((String)sqlList.get(i)))) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            int[] val = stmt.executeBatch();
            long t1 = System.currentTimeMillis();
            nArray = val;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return nArray;
    }

    public int[] executeBatch(String sql, List paramList) throws SQLException {
        int[] nArray;
        long t0 = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            ps = conn.prepareStatement(sql);
            int n = paramList.size();
            for (int i = 0; i < n; ++i) {
                Map params = (Map)paramList.get(i);
                if (params == null) continue;
                for (Object keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = (Integer)keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        byte[] value = val[1].toString().getBytes();
                        SerializableByteArrayInputStream is = new SerializableByteArrayInputStream(value);
                        ps.setAsciiStream(index, (InputStream)is, value.length);
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
                ps.addBatch();
            }
            int[] val = ps.executeBatch();
            long t1 = System.currentTimeMillis();
            nArray = val;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        return nArray;
    }

    public static ResultSet executeQuery(Connection conn, String sql, Map params) throws SQLException {
        PreparedStatement ps = null;
        ps = conn.prepareStatement(sql);
        if (params != null) {
            for (Object keyValue : params.keySet()) {
                if (keyValue == null) continue;
                int index = (Integer)keyValue;
                Object[] val = (Object[])params.get(keyValue);
                if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                    byte[] value = val[1].toString().getBytes();
                    SerializableByteArrayInputStream is = new SerializableByteArrayInputStream(value);
                    ps.setAsciiStream(index, (InputStream)is, value.length);
                    continue;
                }
                if (val[0].equals(SQLType.INT)) {
                    if (val[1] instanceof Integer) {
                        ps.setInt(index, (Integer)val[1]);
                        continue;
                    }
                    ps.setInt(index, Integer.parseInt(val[1].toString()));
                    continue;
                }
                ps.setObject(index, val[1]);
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    public static ResultSet executeQuery(Connection conn, String sql) throws SQLException {
        return BotSqlUtils.executeQuery(conn, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getDataFromDr(int dataType, ResultSet rset, int index) throws SQLException {
        data = null;
        try {
            switch (dataType) {
                case 1: 
                case 12: {
                    return rset.getString(index);
                }
                case -7: {
                    b = rset.getInt(index) == 1;
                    return b;
                }
                case 4: {
                    return new Integer(rset.getInt(index));
                }
                case 3: {
                    return rset.getBigDecimal(index);
                }
                case 91: {
                    return rset.getDate(index);
                }
                case 92: {
                    return rset.getTime(index);
                }
                case 93: {
                    return rset.getTimestamp(index);
                }
                case -5: {
                    return new Long(rset.getLong(index));
                }
                case 2: {
                    return rset.getBigDecimal(index);
                }
                case 6: 
                case 8: {
                    return new Double(rset.getDouble(index));
                }
                case 2004: {
                    in = null;
                    try {
                        in = rset.getBinaryStream(index);
                        if (in == null) {
                            var6_7 = data;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var11_15) {
                        try {
                            in.close();
                            throw var11_15;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw var11_15;
                    }
                    try {
                        in.close();
                        return var6_7;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return var6_7;
lbl-1000:
                    // 1 sources

                    {
                        blockSize = 1024;
                        block = new byte[1024];
                        byteOut = new ByteArrayOutputStream();
                        len = -1;
                        do {
                            try {
                                len = in.read(block);
                            }
                            catch (IOException e1) {
                                throw new SQLException(e1.getMessage());
                            }
                            if (len <= 0) continue;
                            byteOut.write(block, 0, len);
                        } while (len == 1024);
                        data = byteOut.toByteArray();
                    }
                    try {
                        in.close();
                        return data;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return data;
                    }
                }
                case 2005: {
                    return rset.getString(index);
                }
            }
            return data;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getDataFromDr(int dataType, ResultSet rset, String columnName) throws SQLException {
        data = null;
        try {
            switch (dataType) {
                case 1: 
                case 12: {
                    return rset.getString(columnName);
                }
                case -7: {
                    b = rset.getInt(columnName) == 1;
                    return b;
                }
                case 4: {
                    return new Integer(rset.getInt(columnName));
                }
                case 3: {
                    return rset.getBigDecimal(columnName);
                }
                case 91: {
                    return rset.getDate(columnName);
                }
                case 92: {
                    return rset.getTime(columnName);
                }
                case 93: {
                    return rset.getTimestamp(columnName);
                }
                case -5: {
                    return new Long(rset.getLong(columnName));
                }
                case 2: {
                    return rset.getBigDecimal(columnName);
                }
                case 6: 
                case 8: {
                    return new Double(rset.getDouble(columnName));
                }
                case 2004: {
                    in = null;
                    try {
                        in = rset.getBinaryStream(columnName);
                        if (in == null) {
                            var6_7 = data;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var11_15) {
                        try {
                            in.close();
                            throw var11_15;
                        }
                        catch (IOException e) {
                            throw new SQLException(e.getMessage());
                        }
                    }
                    try {
                        in.close();
                        return var6_7;
                    }
                    catch (IOException e) {
                        throw new SQLException(e.getMessage());
                    }
lbl-1000:
                    // 1 sources

                    {
                        blockSize = 1024;
                        block = new byte[1024];
                        byteOut = new ByteArrayOutputStream();
                        len = -1;
                        do {
                            try {
                                len = in.read(block);
                            }
                            catch (IOException e1) {
                                throw new SQLException(e1.getMessage());
                            }
                            if (len <= 0) continue;
                            byteOut.write(block, 0, len);
                        } while (len == 1024);
                        data = byteOut.toByteArray();
                    }
                    try {
                        in.close();
                        return data;
                    }
                    catch (IOException e) {
                        throw new SQLException(e.getMessage());
                    }
                }
                case 2005: {
                    return rset.getString(columnName);
                }
            }
            return data;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static int getDataTypeByName(ResultSet rset, String fieldName) throws SQLException {
        ResultSetMetaData metaData = rset.getMetaData();
        int fieldCount = rset.getMetaData().getColumnCount();
        for (int i = 1; i <= fieldCount; ++i) {
            String cName = metaData.getColumnName(i);
            if (!cName.equalsIgnoreCase(fieldName)) continue;
            return metaData.getColumnType(i);
        }
        return 12;
    }
}

