/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class ObjectValueUtil {
    public static void checkPropertyBlank(IObjectValue model, String propertyName) throws EASBizException {
        ObjectValueUtil.checkPropertyBlank(model, propertyName, null);
    }

    public static void checkPropertyBlank(IObjectValue model, String propertyName, String propertyAlias) throws EASBizException {
        Object o = model.get(propertyName);
        if (o == null || o.toString().length() == 0) {
            if (propertyName.equals("name")) {
                throw new EASBizException(EASBizException.CHECKNUMBLANK);
            }
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    public static void checkMPropertyBlank(Context ctx, IObjectValue model, String propertyName) throws EASBizException {
        ObjectValueUtil.checkMPropertyBlank(model, propertyName, null);
    }

    public static void checkMPropertyBlank(Context ctx, IObjectValue model, String propertyName, String propertyAlias) throws EASBizException {
        ObjectValueUtil.checkPropertyBlank(model, propertyName, propertyAlias);
    }

    public static void checkMPropertyBlank(IObjectValue model, String propertyName) throws EASBizException {
        ObjectValueUtil.checkMPropertyBlank(null, model, propertyName);
    }

    public static void checkMPropertyBlank(IObjectValue model, String propertyName, String propertyAlias) throws EASBizException {
        ObjectValueUtil.checkMPropertyBlank(null, model, propertyName, propertyAlias);
    }

    public static void checkPropertyDup(Context ctx, IObjectValue model, String propertyName, String propertyAlias) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(propertyName, model.get(propertyName));
        filter.getFilterItems().add(filterItem);
        if (model.get(model.getPKField()) != null) {
            filterItem = new FilterItemInfo(model.getPKField(), model.get(model.getPKField()), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        Connection conn = null;
        ORMappingDAO dao = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            dao = new ORMappingDAO(model.getBOSType(), ctx, conn);
            if (dao.exists(filter)) {
                if (propertyName.equals("name")) {
                    throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{model.get(propertyName)});
                }
                throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{model.get(propertyName)});
            }
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void checkPropertyDup(Context ctx, IObjectValue model, String propertyName) throws BOSException, EASBizException {
        ObjectValueUtil.checkPropertyDup(ctx, model, propertyName, null);
    }

    public static void checkMPropertyDup(Context ctx, IObjectValue model, String propertyName, String propertyAlias) throws BOSException, EASBizException {
        ObjectValueUtil.checkPropertyDup(ctx, model, propertyName, propertyAlias);
    }

    public static void checkMPropertyDup(Context ctx, IObjectValue model, String propertyName) throws BOSException, EASBizException {
        ObjectValueUtil.checkMPropertyDup(ctx, model, propertyName, null);
    }
}

