/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.runtime;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTAggregateInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.exception.AggregateException;
import com.kingdee.bos.metadata.bot.exception.BoteException;
import com.kingdee.bos.metadata.bot.exception.GroupingException;
import com.kingdee.bos.metadata.bot.exception.NotSupportedException;
import com.kingdee.bos.metadata.bot.exception.TODOException;
import com.kingdee.bos.metadata.bot.exception.TransformException;
import com.kingdee.bos.metadata.bot.exception.UnexpectedException;
import com.kingdee.bos.metadata.bot.runtime.AggregateInfo;
import com.kingdee.bos.metadata.bot.runtime.AggregateKey;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.bot.runtime.GroupKeyInfo;
import com.kingdee.bos.metadata.bot.runtime.RelationKey;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotEngine {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.runtime.BotEngine");
    private final Context ctx;
    private List funcProviderList = new ArrayList();

    public BotEngine(Context ctx) {
        this.ctx = ctx;
    }

    public void addFunctionProvider(IFunctionProvider funcProvider) throws KScriptException {
        this.funcProviderList.add(funcProvider);
    }

    public List getFunctionProviderList() {
        return this.funcProviderList;
    }

    public IObjectCollection transform(List scrObjList, BOTRelationCollection relationCol, BOTMappingCollection mappingInfoCol) throws Exception {
        if (mappingInfoCol == null || mappingInfoCol.size() == 0) {
            throw new IllegalArgumentException("mappingInfoArray invalid");
        }
        BOTMappingInfo firstMappingInfo = mappingInfoCol.get(0);
        EntityObjectInfo destEntity = firstMappingInfo.getDestEntity();
        IObjectCollection destObjCol = Utils.newObjectCollectionInstance((EntityObjectInfo)destEntity);
        HashMap groupKeyMap = new HashMap();
        HashMap aggregateInfoMap = new HashMap();
        HashMap relationMap = new HashMap();
        int mapsSize = mappingInfoCol.size();
        for (int mapIndex = 0; mapIndex < mapsSize; ++mapIndex) {
            BOTMappingInfo mappingInfo = mappingInfoCol.get(mapIndex);
            BOTRuleCollection ruleCol = mappingInfo.getRules();
            int rulesSize = ruleCol.size();
            for (int ruleIndex = 0; ruleIndex < rulesSize; ++ruleIndex) {
                BOTRuleInfo rule = ruleCol.get(ruleIndex);
                IObjectCollection scrObjCol = (IObjectCollection)scrObjList.get(mapIndex);
                int size = scrObjCol.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue obj = scrObjCol.getObject(i);
                    this.transform(obj, destObjCol, rule, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, relationCol);
                }
            }
        }
        for (Map.Entry aggInfoEntry : aggregateInfoMap.entrySet()) {
            AggregateKey aggregateKey = (AggregateKey)aggInfoEntry.getKey();
            AggregateInfo aggInfo = (AggregateInfo)aggInfoEntry.getValue();
            IObjectValue entryObj = (IObjectValue)groupKeyMap.get(aggregateKey.groupKey);
            String aggregateExpr = aggInfo.agggrateExpr;
            if (entryObj == null) {
                throw new AggregateException("Aggregate error. " + aggregateKey.groupKey + " 's entry Object value is null.");
            }
            HashMap<String, Object> scriptCtx = new HashMap<String, Object>();
            scriptCtx.put(aggInfo.prefix, entryObj);
            scriptCtx.put(aggInfo.destPropFullName, aggInfo.valueList);
            Interpreter interpreter = new Interpreter();
            for (int i = 0; i < this.funcProviderList.size(); ++i) {
                interpreter.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            interpreter.setProperyExprOwnerNullIgore(true);
            interpreter.setForBot(true);
            Object val = interpreter.eval(aggregateExpr, scriptCtx);
            String[] propNameItemArray = aggregateKey.destPropName.split("\\.");
            String propName = propNameItemArray[propNameItemArray.length - 1];
            entryObj.put(propName, val);
        }
        return destObjCol;
    }

    public static boolean instanceOf(Context ctx, IObjectValue val, BOSObjectType bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        for (EntityObjectInfo entity = loader.getEntity(val.getBOSType()); entity != null; entity = entity.getBaseEntity()) {
            if (!entity.getType().equals((Object)bosType)) continue;
            return true;
        }
        return false;
    }

    public GroupInfo getGroupInfo(BOTMappingInfo mappingInfo) {
        GroupItemInfo[] groupItemArray = null;
        int i = 0;
        BOTRuleCollection ruleCol = mappingInfo.getRules();
        int size = ruleCol.size();
        if (i < size) {
            BOTRuleInfo rule = ruleCol.get(i);
            BOTGroupingCollection groups = rule.getGroups();
            groupItemArray = new GroupItemInfo[groups.size()];
            int groupsSize = groups.size();
            for (int j = 0; j < groupsSize; ++j) {
                int level = groups.get(j).getGroupingLevel();
                String propName = groups.get(j).getGroupingProperty();
                groupItemArray[j] = new GroupItemInfo(propName, level);
            }
        }
        return new GroupInfo(groupItemArray);
    }

    public void transform(IObjectValue srcObj, IObjectCollection destObjCol, BOTRuleInfo ruleInfo, BOTMappingInfo mappingInfo, Map groupKeyMap, Map aggregateInfoMap, Map relationMap, BOTRelationCollection relationCollection) throws Exception {
        int ruleColSize = mappingInfo.getRules().size();
        for (int ruleIndex = 0; ruleIndex < ruleColSize; ++ruleIndex) {
            BOTGroupingCollection groups = mappingInfo.getRules().get(ruleIndex).getGroups();
            Object[] objArray = groups.toArray();
            Arrays.sort(objArray, BOTGroupingInfoComparator.instance);
            groups.clear();
            for (int j = 0; j < objArray.length; ++j) {
                groups.add((BOTGroupingInfo)objArray[j]);
            }
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
        EntityObjectInfo rootEntity = loader.getEntity(srcObj.getBOSType());
        HashMap identMap = new HashMap();
        List srcPrefixList = this.computeIdent(ruleInfo, identMap);
        assert (srcPrefixList.get(0).equals(""));
        List oneToManyPrefixList = this.computeOneToManyPrefix(srcPrefixList, identMap, rootEntity);
        assert (oneToManyPrefixList.get(0).equals(""));
        if (oneToManyPrefixList.size() == 1) {
            HashMap<String, IObjectValue> iterContext = new HashMap<String, IObjectValue>();
            iterContext.put("", srcObj);
            this.transformEntry("", srcObj, srcObj, iterContext, ruleInfo, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, destObjCol, relationCollection);
        }
        int size = oneToManyPrefixList.size();
        for (int i = 1; i < size; ++i) {
            String prefix = (String)oneToManyPrefixList.get(i);
            HashMap<String, IObjectValue> iterContext = new HashMap<String, IObjectValue>();
            iterContext.put("", srcObj);
            this.iteratorEntryAndTransform(srcObj, prefix, rootEntity, iterContext, ruleInfo, destObjCol, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, relationCollection);
        }
    }

    private void iteratorEntryAndTransform(IObjectValue srcObj, String prefix, EntityObjectInfo rootEntity, Map iterContext, BOTRuleInfo ruleInfo, IObjectCollection destObjCol, BOTMappingInfo mappingInfo, Map groupKeyMap, Map aggregateInfoMap, Map relationMap, BOTRelationCollection relationCollection) throws Exception {
        String[] propNameArray = prefix.split("\\.");
        EntityObjectInfo currentEntity = rootEntity;
        for (int propNameArrayIndex = 0; propNameArrayIndex < propNameArray.length; ++propNameArrayIndex) {
            EntityObjectInfo clientEntity;
            String propName = propNameArray[propNameArrayIndex];
            PropertyInfo propInfo = null;
            LinkPropertyInfo linkProp = null;
            Object val = srcObj.get(propName);
            propInfo = currentEntity.getPropertyByNameRuntime(propName);
            linkProp = (LinkPropertyInfo)propInfo;
            if (this.isOneToManyLink(linkProp, currentEntity)) {
                if (propNameArrayIndex != propNameArray.length - 1) {
                    throw new TransformException("not suport multi-level entry");
                }
                IObjectCollection objCol = (IObjectCollection)val;
                IObjectCollection resultCol = (IObjectCollection)Class.forName(objCol.getClass().getName()).newInstance();
                BOTRuleSegmentCollection segmentCol = ruleInfo.getRuleSegments();
                HashMap<String, String[]> entryDetailPropNameMap = new HashMap<String, String[]>();
                int size = segmentCol.size();
                for (int index = 0; index < size; ++index) {
                    String[] propNames;
                    BOTRuleSegmentInfo segment = segmentCol.get(index);
                    String srcPropName = segment.getSrcPropertyName();
                    if (srcPropName == null || srcPropName.length() == 0 || !(propNames = srcPropName.split("\\."))[0].equalsIgnoreCase(propName) || propNames.length != 3 || entryDetailPropNameMap.containsKey(srcPropName)) continue;
                    entryDetailPropNameMap.put(srcPropName, propNames);
                }
                for (int objColIndex = 0; objColIndex < objCol.size(); ++objColIndex) {
                    IObjectValue entryObjVal = objCol.getObject(objColIndex);
                    Map detailObjValMap = this.getEntityDetailProp(entryObjVal, entryDetailPropNameMap);
                    if (detailObjValMap.size() > 0) {
                        this.expandDetailProperty(entryDetailPropNameMap, detailObjValMap, 0, entryObjVal, resultCol, new HashMap());
                        continue;
                    }
                    resultCol.addObject(entryObjVal);
                }
                if (resultCol.size() > 0) {
                    int size2 = resultCol.size();
                    for (int j = 0; j < size2; ++j) {
                        IObjectValue objVal = resultCol.getObject(j);
                        iterContext.put(prefix, objVal);
                        if (propNameArrayIndex != propNameArray.length - 1) continue;
                        this.transformEntry(prefix, srcObj, objVal, iterContext, ruleInfo, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, destObjCol, relationCollection);
                    }
                }
                if (objCol.size() == 0) {
                    this.transformEntry(prefix, srcObj, srcObj, iterContext, ruleInfo, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, destObjCol, relationCollection);
                }
            }
            currentEntity = clientEntity = linkProp.getRelationship().getChildObject(currentEntity);
        }
    }

    private void transformEntry(String prefix, IObjectValue srcObj, IObjectValue entryObj, Map iterContext, BOTRuleInfo ruleInfo, BOTMappingInfo mappingInfo, Map groupKeyMap, Map aggregateInfoMap, Map relationMap, IObjectCollection destObjCol, BOTRelationCollection relationCollection) throws Exception {
        Interpreter interpreter = new Interpreter(this.ctx);
        for (int i = 0; i < this.funcProviderList.size(); ++i) {
            interpreter.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
        }
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        interpreter.setDefaultObject((Object)srcObj);
        HashMap<String, IObjectValue> scriptCtx = new HashMap<String, IObjectValue>();
        scriptCtx.putAll(iterContext);
        scriptCtx.put("__src", srcObj);
        if (prefix != null && prefix.trim().length() != 0) {
            scriptCtx.put("__src." + prefix, entryObj);
            scriptCtx.put(prefix, entryObj);
        }
        BOTRuleSegmentCollection segmentCol = ruleInfo.getRuleSegments();
        HashMap<String, Object> destValMap = new HashMap<String, Object>(segmentCol.size());
        HashMap<String, Object> aggregateValMap = new HashMap<String, Object>();
        int segColSize = segmentCol.size();
        for (int segIndex = 0; segIndex < segColSize; ++segIndex) {
            BOTRuleSegmentInfo segmentInfo = segmentCol.get(segIndex);
            String expr = segmentInfo.getSrcPropertyName();
            if (expr == null || expr.trim().length() == 0) {
                expr = segmentInfo.getExpression();
            }
            String segmentDestPropName = segmentInfo.getDestPropertyName();
            boolean isAggregateDestProperty = this.isAggreageteProperty(mappingInfo, segmentDestPropName);
            Object srcVal = interpreter.eval(expr, scriptCtx);
            String destPropName = segmentInfo.getDestPropertyName();
            if (!isAggregateDestProperty) {
                destValMap.put(destPropName, srcVal);
                continue;
            }
            aggregateValMap.put(destPropName, srcVal);
        }
        IObjectValue destObj = this.setDestObjectValue(prefix, srcObj, entryObj, mappingInfo, ruleInfo, groupKeyMap, destValMap, relationMap, destObjCol, relationCollection);
        for (Map.Entry entry : aggregateValMap.entrySet()) {
            String destPropName = (String)entry.getKey();
            Object srcVal = entry.getValue();
            this.setAggregateInfo(prefix, mappingInfo, ruleInfo, destObj, destPropName, groupKeyMap, destValMap, aggregateInfoMap, srcVal);
        }
    }

    private void setAggregateInfo(String prefix, BOTMappingInfo mappingInfo, BOTRuleInfo ruleInfo, IObjectValue srcObj, String destPropName, Map groupKeyMap, Map valMap, Map aggregateInfoMap, Object val) throws Exception {
        String[] destPropNameArray = destPropName.split("\\.");
        int groupLevel = destPropNameArray.length;
        String[] groupPropNames = this.getGroupPropNames(groupLevel, ruleInfo.getGroups());
        GroupKeyInfo groupKey_new = this.getGroupKey(valMap, groupPropNames);
        Iterator itor = groupKeyMap.entrySet().iterator();
        Map.Entry entry = itor.next();
        GroupKeyInfo groupKey = null;
        while (entry != null) {
            groupKey = (GroupKeyInfo)entry.getKey();
            if (groupKey.groupuLevel == groupLevel) break;
            entry = itor.next();
        }
        if (groupKey == null) {
            throw new Exception("Aggregate error, cannot found groupKey at level " + groupLevel);
        }
        groupKey_new.groupuLevel = groupKey.groupuLevel;
        groupKey_new.isSomeParent = groupKey.isSomeParent;
        AggregateKey aggregateKey = new AggregateKey(groupKey_new, destPropName);
        AggregateInfo aggInfo = (AggregateInfo)aggregateInfoMap.get(aggregateKey);
        if (aggInfo == null) {
            aggInfo = new AggregateInfo();
            aggInfo.prefix = prefix;
            aggInfo.srcObj = srcObj;
            aggInfo.destPropFullName = destPropName;
            int size = mappingInfo.getAggregateCollection().size();
            for (int i = 0; i < size; ++i) {
                BOTAggregateInfo botAggInfoDef = mappingInfo.getAggregateCollection().get(i);
                if (!destPropName.equalsIgnoreCase(botAggInfoDef.getPropertyName())) continue;
                aggInfo.agggrateExpr = botAggInfoDef.getAggregateExpression();
            }
            if (aggInfo.agggrateExpr == null) {
                throw new RuntimeException("Fatal Error");
            }
            aggregateInfoMap.put(aggregateKey, aggInfo);
        }
        if (!groupKey_new.isSomeParent) {
            aggInfo.valueList.add(val);
        }
    }

    private boolean isAggreageteProperty(BOTMappingInfo mappingInfo, String segmentDestPropName) {
        int size = mappingInfo.getAggregateCollection().size();
        for (int i = 0; i < size; ++i) {
            BOTAggregateInfo botAggInfo = mappingInfo.getAggregateCollection().get(i);
            String destPropName = botAggInfo.getPropertyName();
            if (!destPropName.equalsIgnoreCase(segmentDestPropName)) continue;
            return true;
        }
        return false;
    }

    private IObjectValue setDestObjectValue(String prefix, IObjectValue srcObj, IObjectValue entryObj, BOTMappingInfo mappingInfo, BOTRuleInfo ruleInfo, Map groupKeyMap, Map destValMap, Map relationMap, IObjectCollection destObjCol, BOTRelationCollection relationCollection) throws Exception {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
        EntityObjectInfo destEntity = loader.getEntity((IMetaDataPK)new MetaDataPK(mappingInfo.getDestEntityFullName()));
        String[] destPropNameArray = new String[destValMap.size()];
        destValMap.keySet().toArray(destPropNameArray);
        int maxGroupLevel = this.getMaxGroupLevel(ruleInfo.getGroups());
        if (maxGroupLevel < 1) {
            throw new TransformException("maxGroupLevel is" + maxGroupLevel);
        }
        IObjectValue destObj = null;
        GroupKeyInfo parentGroupKey = null;
        for (int level = 1; level <= maxGroupLevel; ++level) {
            String[] groupPropNames = this.getGroupPropNames(level, ruleInfo.getGroups());
            GroupKeyInfo groupKey = this.getGroupKey(destValMap, groupPropNames);
            groupKey.groupuLevel = level;
            IObjectValue groupedObjVal = (IObjectValue)groupKeyMap.get(groupKey);
            if (groupedObjVal == null) {
                EntityObjectInfo entity = this.getDestObjectEntity(mappingInfo, level, destPropNameArray);
                groupedObjVal = Utils.newObjectValueInstance((EntityObjectInfo)entity);
                groupKeyMap.put(groupKey, groupedObjVal);
                String srcObjIds = srcObj.getString(srcObj.getPKField());
                groupedObjVal.setExtendedProperty("_srcObjIds_", srcObjIds);
            } else {
                String srcObjIds = groupedObjVal.getExtendedProperty("_srcObjIds_");
                String objId = srcObj.getString(srcObj.getPKField());
                if (srcObjIds != null && srcObjIds.length() > 0 && srcObjIds.indexOf(objId) == -1) {
                    srcObjIds = srcObjIds + "," + objId;
                    groupedObjVal.setExtendedProperty("_srcObjIds_", srcObjIds);
                } else {
                    groupKey.isSomeParent = true;
                    groupKeyMap.remove(groupKey);
                    groupKeyMap.put(groupKey, groupedObjVal);
                }
            }
            String[] levelPropNames = this.getPropNames(level, destPropNameArray);
            String entryName = null;
            String entryFullName = null;
            if (level > 1) {
                Map prefixMap = this.computeOneToManyPrefix(groupPropNames, destEntity);
                if (prefixMap.size() != 1) {
                    throw new TransformException("computeOneToManyPrefix invalid");
                }
                entryFullName = (String)prefixMap.keySet().iterator().next();
                String[] entryPropNameArray = entryFullName.split("\\.");
                if (entryPropNameArray.length == 0) {
                    throw new TransformException("entryPropNameArray invalid");
                }
                entryName = entryPropNameArray[entryPropNameArray.length - 1];
            }
            for (int index = 0; index < levelPropNames.length; ++index) {
                String propName = entryName == null ? levelPropNames[index] : levelPropNames[index].substring(entryFullName.length() + 1);
                Object val = destValMap.get(levelPropNames[index]);
                boolean isPkField = false;
                if (propName != null && propName.equals(groupedObjVal.getPKField())) {
                    isPkField = true;
                }
                if (isPkField && groupedObjVal.get(propName) != null) continue;
                groupedObjVal.put(propName, val);
            }
            if (level == 1) {
                if (!destObjCol.containsObject(groupedObjVal)) {
                    destObjCol.addObject(groupedObjVal);
                }
                destObj = groupedObjVal;
            } else if (level > 1) {
                if (parentGroupKey == null) {
                    throw new TransformException("parent group key is null");
                }
                IObjectValue parentObj = (IObjectValue)groupKeyMap.get(parentGroupKey);
                if (parentObj == null) {
                    throw new TransformException("parent object is null");
                }
                Object val = parentObj.get(entryName);
                if (!(val instanceof IObjectCollection)) {
                    throw new TransformException("entry object invalid, it's a " + val.getClass().getName());
                }
                IObjectCollection entryObjCol = (IObjectCollection)val;
                if (!entryObjCol.containsObject(groupedObjVal)) {
                    entryObjCol.addObject(groupedObjVal);
                }
            }
            if (mappingInfo.getId() != null) {
                BOTRelationInfo relation = this.getBOTRelation(mappingInfo, srcObj, destObj, relationMap, relationCollection);
                this.addRelationEntry(srcObj, entryObj, ruleInfo, destValMap, destEntity, destPropNameArray, destObj, level, groupedObjVal, relation);
            }
            parentGroupKey = groupKey;
        }
        return destObj;
    }

    private void addRelationEntry(IObjectValue srcObj, IObjectValue entryObj, BOTRuleInfo ruleInfo, Map destValMap, EntityObjectInfo destEntity, String[] destPropNameArray, IObjectValue destObj, int level, IObjectValue objVal, BOTRelationInfo relation) {
        for (int index = 0; index < destPropNameArray.length; ++index) {
            String destPropertyName = destPropNameArray[index];
            String srcEntryPropName = ruleInfo.getSrcDetailEntryName();
            for (int ruleIndex = 0; ruleIndex < ruleInfo.getRuleSegments().size(); ++ruleIndex) {
                String itemPropname;
                PropertyInfo propInfo;
                BOTRuleSegmentInfo ruleSegment = ruleInfo.getRuleSegments().get(ruleIndex);
                String ruleSegmentDestPropName = ruleSegment.getDestPropertyName();
                String destEntryPropName = this.getEntryName(destEntity, ruleSegmentDestPropName);
                String srcPropertyName = ruleSegment.getSrcPropertyName();
                if (srcPropertyName == null || srcPropertyName.trim().length() == 0) {
                    srcPropertyName = ruleSegment.getExpression();
                }
                String srcEntryID = entryObj.getString(entryObj.getPKField());
                String destEntryID = objVal.getString(objVal.getPKField());
                Object val = destValMap.get(destPropertyName);
                if (!ruleSegmentDestPropName.equalsIgnoreCase(destPropertyName)) continue;
                int destPropLevel = 1;
                EntityObjectInfo curEntity = destEntity;
                String[] items = ruleSegmentDestPropName.split("\\.");
                for (int i = 0; i < items.length && (propInfo = destEntity.getPropertyByNameRuntime(itemPropname = items[i])) instanceof LinkPropertyInfo; ++i) {
                    boolean isManyLink;
                    LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                    RelationshipInfo relationship = linkProp.getRelationship();
                    CardinalityType cardinality = relationship.getChildCardinality(destEntity);
                    boolean bl = isManyLink = cardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || cardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED);
                    if (!isManyLink) break;
                    ++destPropLevel;
                    curEntity = relationship.getChildObject(curEntity);
                }
                if (destPropLevel != level || !ruleSegment.isRegInRelation()) continue;
                this.addRelationEntry(relation, srcObj, destObj, srcEntryPropName, destEntryPropName, srcEntryID, destEntryID, ruleSegment.getSrcPropertyName(), destPropertyName, val);
            }
        }
    }

    private String getEntryName(EntityObjectInfo rootEntity, String propFullName) {
        LinkPropertyInfo linkProp;
        String propName;
        PropertyInfo propInfo;
        String[] propNameArray = propFullName.split("\\.");
        StringBuffer buff = new StringBuffer();
        EntityObjectInfo currentEntity = rootEntity;
        for (int i = 0; i < propNameArray.length && (propInfo = currentEntity.getPropertyByNameRuntime(propName = propNameArray[i])) instanceof LinkPropertyInfo && this.isOneToManyLink(linkProp = (LinkPropertyInfo)propInfo, currentEntity); ++i) {
            currentEntity = linkProp.getRelationship().getChildObject(currentEntity);
            if (buff.length() != 0) {
                buff.append('.');
            }
            buff.append(propName);
        }
        return buff.toString();
    }

    private void addRelationEntry(BOTRelationInfo relation, IObjectValue srcObject, IObjectValue destObject, String srcEntryPropName, String destEntryPropName, String srcEntryID, String destEntryID, String srcPropertyName, String destPropertyName, Object destFieldValue) {
        Object objkey = srcObject.get(srcObject.getPKField());
        String srcObjectID = objkey == null ? "" : objkey.toString();
        objkey = destObject.get(destObject.getPKField());
        String destObjectID = objkey == null ? "" : objkey.toString();
        BOTRelationEntryInfo entry = null;
        boolean isNew = true;
        int size = relation.getRelationEntries().size();
        for (int i = 0; i < size; ++i) {
            BOTRelationEntryInfo item = relation.getRelationEntries().get(i);
            if (!item.getSrcObjectID().equals(srcObjectID) || !item.getDestObjectID().equals(destObjectID) || item.getSrcEntryID() == null || !item.getSrcEntryID().equals(srcEntryID) || item.getDestEntryID() == null || !item.getDestEntryID().equals(destEntryID) || item.getSrcEntryPropName() == null || !item.getSrcEntryPropName().equals(srcEntryPropName) || item.getDestPropertyName() == null || !item.getDestPropertyName().equals(destPropertyName) || (item.getSrcPropertyName() == null || !item.getSrcPropertyName().equals(srcPropertyName)) && (item.getSrcPropertyName() != null || srcPropertyName != null) || item.getDestEntryPropName() == null || !item.getDestEntryPropName().equals(destEntryPropName)) continue;
            isNew = false;
            entry = item;
            break;
        }
        if (isNew) {
            entry = new BOTRelationEntryInfo();
        }
        entry.setSrcObjectID(srcObjectID);
        entry.setDestObjectID(destObjectID);
        entry.setSrcEntryPropName(srcEntryPropName);
        entry.setDestEntryPropName(destEntryPropName);
        entry.setSrcEntryID(srcEntryID);
        entry.setDestEntryID(destEntryID);
        entry.setSrcPropertyName(srcPropertyName);
        entry.setDestPropertyName(destPropertyName);
        entry.setValue(destFieldValue.toString());
        if (isNew) {
            relation.getRelationEntries().add(entry);
        }
    }

    private Map computeOneToManyPrefix(String[] groupPropNames, EntityObjectInfo rootEntity) {
        HashMap<String, ArrayList<String>> identMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < groupPropNames.length; ++i) {
            String propName;
            PropertyInfo propInfo;
            String groupName = groupPropNames[i];
            String[] propNameArray = groupName.split("\\.");
            EntityObjectInfo currentEntity = rootEntity;
            int lastOneToManyIndex = -1;
            for (int j = 0; j < propNameArray.length && (propInfo = currentEntity.getPropertyByNameRuntime(propName = propNameArray[j])) != null && !(propInfo instanceof OwnPropertyInfo); ++j) {
                EntityObjectInfo clientEntity;
                if (!(propInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                if (this.isOneToManyLink(linkProp, currentEntity)) {
                    lastOneToManyIndex = j;
                }
                currentEntity = clientEntity = linkProp.getRelationship().getChildObject(currentEntity);
            }
            String realPrefix = lastOneToManyIndex == -1 ? "" : ORMUtils.concat((String[])propNameArray, (int)0, (int)(lastOneToManyIndex + 1), (char)'.');
            ArrayList<String> propList = (ArrayList<String>)identMap.get(realPrefix);
            if (propList == null) {
                propList = new ArrayList<String>();
                identMap.put(realPrefix, propList);
            }
            propList.add(groupName);
        }
        return identMap;
    }

    private EntityObjectInfo getDestObjectEntity(BOTMappingInfo mappingInfo, int level, String[] destPropNameArray) {
        EntityObjectInfo entity;
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
        EntityObjectInfo destEntity = loader.getEntity((IMetaDataPK)new MetaDataPK(mappingInfo.getDestEntityFullName()));
        if (level == 1) {
            String destEntityName = mappingInfo.getDestEntityFullName();
            entity = loader.getEntity((IMetaDataPK)new MetaDataPK(destEntityName));
        } else {
            String propName;
            PropertyInfo propInfo;
            Map prefixMap = this.computeOneToManyPrefix(destPropNameArray, destEntity);
            String[] prefixArray = new String[prefixMap.size()];
            prefixMap.keySet().toArray(prefixArray);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < prefixArray.length; ++i) {
                int commaCount = 0;
                for (int j = 0; j < prefixArray[i].length(); ++j) {
                    char c = prefixArray[i].charAt(j);
                    if (c != '.') continue;
                    ++commaCount;
                }
                if ("".equals(prefixArray[i]) || commaCount + 2 != level) continue;
                list.add(prefixArray[i]);
            }
            if (list.size() > 1) {
                throw new NotSupportedException("not support mutil entry in group array.");
            }
            if (list.size() == 0) {
                throw new BoteException("prefixArray is null");
            }
            String prefix = (String)list.get(0);
            String[] propNameArray = prefix.split("\\.");
            EntityObjectInfo currentEntity = destEntity;
            int lastOneToManyIndex = -1;
            for (int i = 0; i < propNameArray.length && (propInfo = currentEntity.getPropertyByNameRuntime(propName = propNameArray[i])) != null && !(propInfo instanceof OwnPropertyInfo); ++i) {
                EntityObjectInfo clientEntity;
                if (!(propInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                if (this.isOneToManyLink(linkProp, currentEntity)) {
                    lastOneToManyIndex = i;
                }
                currentEntity = clientEntity = linkProp.getRelationship().getChildObject(currentEntity);
            }
            entity = currentEntity;
        }
        return entity;
    }

    private GroupKeyInfo getGroupKey(Map valMap, String[] groupPropNames) {
        Object[] objArray = new Object[groupPropNames.length];
        for (int groupItemIndex = 0; groupItemIndex < objArray.length; ++groupItemIndex) {
            Object val = valMap.get(groupPropNames[groupItemIndex]);
            if (val instanceof IObjectValue) {
                IObjectValue objVal = (IObjectValue)val;
                BOSObjectType bosType = objVal.getBOSType();
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
                EntityObjectInfo entity = loader.getEntity(bosType);
                LogicalKeyInfo logicalKey = entity.getLogicalKey();
                if (logicalKey == null) {
                    throw new GroupingException("logicalKey is null.");
                }
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() == 0) {
                    throw new GroupingException("logicalKey's properties is empty.");
                }
                if (keyPropCol.size() == 1) {
                    String propName = keyPropCol.get(0).getName();
                    Object keyVal = objVal.get(propName);
                    if (keyVal instanceof BOSUuid) {
                        keyVal = keyVal.toString();
                    }
                    objArray[groupItemIndex] = keyVal;
                    continue;
                }
                Object[] arrayVal = new Object[keyPropCol.size()];
                int size = keyPropCol.size();
                for (int i = 0; i < size; ++i) {
                    String propName = keyPropCol.get(i).getName();
                    arrayVal[i] = objVal.get(propName);
                }
                objArray[groupItemIndex] = arrayVal;
                continue;
            }
            objArray[groupItemIndex] = val;
        }
        return new GroupKeyInfo(objArray);
    }

    private String[] getPropNames(int level, String[] destPropNameArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < destPropNameArray.length; ++i) {
            int commaCount = 0;
            for (int j = 0; j < destPropNameArray[i].length(); ++j) {
                char c = destPropNameArray[i].charAt(j);
                if (c != '.') continue;
                ++commaCount;
            }
            if (commaCount != level - 1) continue;
            list.add(destPropNameArray[i]);
        }
        String[] rtnVal = new String[list.size()];
        list.toArray(rtnVal);
        return rtnVal;
    }

    private String[] getGroupPropNames(int level, BOTGroupingCollection groups) {
        ArrayList<String> list = new ArrayList<String>();
        int size = groups.size();
        for (int groupIndex = 0; groupIndex < size; ++groupIndex) {
            int groupLevel = groups.get(groupIndex).getGroupingLevel();
            if (groupLevel != level) continue;
            list.add(groups.get(groupIndex).getGroupingProperty());
        }
        String[] rtnVal = new String[list.size()];
        list.toArray(rtnVal);
        return rtnVal;
    }

    private int getMaxGroupLevel(BOTGroupingCollection groups) {
        int maxLevel = -1;
        int size = groups.size();
        for (int i = 0; i < size; ++i) {
            int level = groups.get(i).getGroupingLevel();
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    private List computeOneToManyPrefix(List prefixList, Map identMap, EntityObjectInfo rootEntity) {
        HashSet<String> oneToManyPrefixSet = new HashSet<String>();
        int size = prefixList.size();
        for (int i = 0; i < size; ++i) {
            String propName;
            PropertyInfo propInfo;
            String prefix = (String)prefixList.get(i);
            if (prefix.equals("")) {
                oneToManyPrefixSet.add("");
                continue;
            }
            String[] propNameArray = prefix.split("\\.");
            EntityObjectInfo currentEntity = rootEntity;
            int lastOneToManyIndex = -1;
            for (int j = 0; j < propNameArray.length && (propInfo = currentEntity.getPropertyByNameRuntime(propName = propNameArray[j])) != null && !(propInfo instanceof OwnPropertyInfo); ++j) {
                if (propInfo instanceof LinkPropertyInfo) {
                    EntityObjectInfo clientEntity;
                    LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                    if (this.isOneToManyLink(linkProp, currentEntity)) {
                        lastOneToManyIndex = j;
                    }
                    currentEntity = clientEntity = linkProp.getRelationship().getChildObject(currentEntity);
                }
                if (j != propNameArray.length - 1) continue;
            }
            String realPrefix = this.adjustIdentMap(identMap, prefix, propNameArray, lastOneToManyIndex);
            oneToManyPrefixSet.add(realPrefix);
        }
        ArrayList oneToManyPrefix = new ArrayList(oneToManyPrefixSet);
        Collections.sort(oneToManyPrefix);
        return oneToManyPrefix;
    }

    private String adjustIdentMap(Map identMap, String prefix, String[] propNameArray, int lastOneToManyIndex) {
        String realPrefix = lastOneToManyIndex == -1 ? "" : ORMUtils.concat((String[])propNameArray, (int)0, (int)(lastOneToManyIndex + 1));
        List identList = (List)identMap.remove(prefix);
        assert (identList != null);
        ArrayList realIdentList = (ArrayList)identMap.get(realPrefix);
        if (realIdentList == null) {
            realIdentList = new ArrayList();
            identMap.put(realPrefix, realIdentList);
        }
        realIdentList.addAll(identList);
        return realPrefix;
    }

    private boolean isOneToManyLink(LinkPropertyInfo linkProp, EntityObjectInfo currentEntity) {
        return linkProp.getRelationship().getChildCardinality(currentEntity).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || linkProp.getRelationship().getChildCardinality(currentEntity).equals((Object)CardinalityType.ONE_TO_UNBOUNDED);
    }

    private List computeIdent(BOTRuleInfo ruleInfo, Map identMap) throws KScriptException {
        HashSet<String> prefixSet = new HashSet<String>();
        HashSet srcIdentSet = new HashSet();
        BOTRuleSegmentCollection segmentCol = ruleInfo.getRuleSegments();
        int size = segmentCol.size();
        for (int i = 0; i < size; ++i) {
            BOTRuleSegmentInfo segment = segmentCol.get(i);
            String srcExpr = segment.getSrcPropertyName();
            if (srcExpr == null || srcExpr.length() == 0) {
                srcExpr = segment.getExpression();
            }
            BotUtil.computeIdent(srcExpr, srcIdentSet);
        }
        ArrayList srcIdentList = new ArrayList(srcIdentSet);
        int size2 = srcIdentList.size();
        for (int i = 0; i < size2; ++i) {
            int commaIndex;
            String ident = (String)srcIdentList.get(i);
            if (ident.startsWith("__src.")) {
                ident = ident.substring("__src.".length());
            }
            String prefix = (commaIndex = ident.indexOf(46)) < 0 ? "" : ident.substring(0, commaIndex);
            prefixSet.add(prefix);
            ArrayList<String> list = (ArrayList<String>)identMap.get(prefix);
            if (list == null) {
                list = new ArrayList<String>();
                identMap.put(prefix, list);
            }
            list.add(ident);
        }
        ArrayList srcPrefixList = new ArrayList(prefixSet);
        Collections.sort(srcIdentList);
        Collections.sort(srcPrefixList);
        return srcPrefixList;
    }

    public boolean isEntryExpr(EntityObjectInfo entity, String expr) {
        return false;
    }

    private BOTRelationInfo getBOTRelation(BOTMappingInfo botMapping, IObjectValue srcObject, IObjectValue destObject, Map relationInfoMap, BOTRelationCollection relationCollection) {
        String destObjectID;
        Object objkey = srcObject.get(srcObject.getPKField());
        String srcObjectID = objkey == null ? "" : objkey.toString();
        RelationKey key = new RelationKey(srcObjectID, destObjectID = (objkey = destObject.get(destObject.getPKField())) == null ? "" : objkey.toString());
        if (relationInfoMap.containsKey(key)) {
            return (BOTRelationInfo)relationInfoMap.get(key);
        }
        BOTRelationInfo relation = new BOTRelationInfo();
        EntityObjectInfo srcEntity = botMapping.getSrcEntity();
        relation.setSrcEntityID(srcEntity.getType().toString());
        relation.setSrcObjectID(srcObjectID);
        relation.setDestEntityID(botMapping.getDestEntity().getType().toString());
        relation.setDestObjectID(destObjectID);
        relation.setDate(new Date());
        relation.setOperatorID("unknown");
        relation.setBOTMappingID(botMapping.get(botMapping.getPKField()).toString());
        relation.setType(0);
        relationCollection.add(relation);
        relationInfoMap.put(key, relation);
        return relation;
    }

    private Map getEntityDetailProp(IObjectValue objVal, Map detailPropMap) {
        HashMap<String, IObjectCollection> detailObjValMap = new HashMap<String, IObjectCollection>();
        Iterator keyItor = detailPropMap.keySet().iterator();
        for (int detailPropIndex = 0; detailPropIndex < detailPropMap.size(); ++detailPropIndex) {
            String ddpColKey;
            IObjectCollection ddpCol;
            String key = (String)keyItor.next();
            String[] propNameArray = (String[])detailPropMap.get(key);
            Object srcDetailObj = objVal.get(propNameArray[1]);
            if (!(srcDetailObj instanceof IObjectCollection) || (ddpCol = (IObjectCollection)srcDetailObj).size() <= 1 || detailObjValMap.get(ddpColKey = propNameArray[0] + "." + propNameArray[1]) != null) continue;
            detailObjValMap.put(ddpColKey, ddpCol);
        }
        return detailObjValMap;
    }

    private void expandDetailProperty(Map detailPropMap, Map detailObjValMap, int detailPropMapIndex, IObjectValue objVal, IObjectCollection resultCol, Map prefixValue) throws Exception {
        String[] dePropName = detailObjValMap.keySet().toArray(new String[0]);
        IObjectCollection ddpCol = (IObjectCollection)detailObjValMap.get(dePropName[detailPropMapIndex]);
        for (int i = 0; i < ddpCol.size(); ++i) {
            String[] prefixValueKeys;
            IObjectValue newEntity = (IObjectValue)((PropertyContainer)objVal).clone();
            newEntity.setBOSUuid("id", BOSUuid.create((BOSObjectType)newEntity.getBOSType()));
            IObjectValue ddp = (IObjectValue)((PropertyContainer)ddpCol.getObject(i)).clone();
            prefixValue.put(dePropName[detailPropMapIndex], ddp);
            if (detailPropMapIndex + 1 < detailObjValMap.size()) {
                this.expandDetailProperty(detailPropMap, detailObjValMap, detailPropMapIndex + 1, objVal, resultCol, prefixValue);
                prefixValueKeys = (String[])prefixValue.keySet().toArray();
                prefixValue.remove(prefixValueKeys[prefixValue.size() - 1]);
                continue;
            }
            for (int j = 0; j < prefixValue.size(); ++j) {
                String[] prefixValueKeys2 = prefixValue.keySet().toArray(new String[0]);
                this.rewriteObjVal(newEntity, prefixValueKeys2[j], 1, (IObjectValue)prefixValue.get(prefixValueKeys2[j]));
            }
            prefixValueKeys = prefixValue.keySet().toArray(new String[0]);
            prefixValue.remove(prefixValueKeys[prefixValue.size() - 1]);
            resultCol.addObject(newEntity);
        }
    }

    private void rewriteObjVal(Object entryObj, String propertyName, int level, IObjectValue propertyVal) {
        String[] propertyArrays = propertyName.split("\\.");
        IObjectValue objVal = null;
        if (level >= propertyArrays.length) {
            throw new UnexpectedException("unexpect property: '" + propertyName + "', object level is " + level);
        }
        if (!(entryObj instanceof IObjectValue)) {
            throw new TODOException("unexpect IObjectValue: '" + entryObj.getClass() + "'");
        }
        objVal = (IObjectValue)entryObj;
        IObjectCollection objSubCol = (IObjectCollection)objVal.get(propertyArrays[level]);
        objSubCol.clear();
        objSubCol.addObject(propertyVal);
    }

    public IObjectCollection transform(IObjectCollection scrObjCol, BOTRelationCollection relationCol, BOTMappingCollection mappingInfoCol) throws Exception {
        if (mappingInfoCol == null || mappingInfoCol.size() == 0) {
            throw new IllegalArgumentException("mappingInfoArray invalid");
        }
        BOTMappingInfo firstMappingInfo = mappingInfoCol.get(0);
        EntityObjectInfo destEntity = firstMappingInfo.getDestEntity();
        IObjectCollection destObjCol = Utils.newObjectCollectionInstance((EntityObjectInfo)destEntity);
        HashMap groupKeyMap = new HashMap();
        HashMap aggregateInfoMap = new HashMap();
        HashMap relationMap = new HashMap();
        int mapsSize = mappingInfoCol.size();
        for (int mapIndex = 0; mapIndex < mapsSize; ++mapIndex) {
            BOTMappingInfo mappingInfo = mappingInfoCol.get(mapIndex);
            BOTRuleCollection ruleCol = mappingInfo.getRules();
            EntityObjectInfo srcEntity = mappingInfo.getSrcEntity();
            BOSObjectType type = srcEntity.getType();
            int rulesSize = ruleCol.size();
            for (int ruleIndex = 0; ruleIndex < rulesSize; ++ruleIndex) {
                BOTRuleInfo rule = ruleCol.get(ruleIndex);
                int size = scrObjCol.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue obj = scrObjCol.getObject(i);
                    if (!BotEngine.instanceOf(this.ctx, obj, type)) continue;
                    this.transform(obj, destObjCol, rule, mappingInfo, groupKeyMap, aggregateInfoMap, relationMap, relationCol);
                }
            }
        }
        for (Map.Entry aggInfoEntry : aggregateInfoMap.entrySet()) {
            AggregateKey aggregateKey = (AggregateKey)aggInfoEntry.getKey();
            AggregateInfo aggInfo = (AggregateInfo)aggInfoEntry.getValue();
            IObjectValue entryObj = (IObjectValue)groupKeyMap.get(aggregateKey.groupKey);
            String aggregateExpr = aggInfo.agggrateExpr;
            if (entryObj == null) {
                throw new AggregateException("Aggregate error. " + aggregateKey.groupKey + " 's value is null.");
            }
            HashMap<String, Object> scriptCtx = new HashMap<String, Object>();
            scriptCtx.put(aggInfo.prefix, entryObj);
            scriptCtx.put(aggInfo.destPropFullName, aggInfo.valueList);
            Interpreter interpreter = new Interpreter();
            for (int i = 0; i < this.funcProviderList.size(); ++i) {
                interpreter.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            interpreter.setProperyExprOwnerNullIgore(true);
            interpreter.setForBot(true);
            Object val = interpreter.eval(aggregateExpr, scriptCtx);
            String[] propNameItemArray = aggregateKey.destPropName.split("\\.");
            String propName = propNameItemArray[propNameItemArray.length - 1];
            entryObj.put(propName, val);
        }
        return destObjCol;
    }

    static class BOTGroupingInfoComparator
    implements Comparator {
        public static BOTGroupingInfoComparator instance = new BOTGroupingInfoComparator();

        BOTGroupingInfoComparator() {
        }

        public int compare(Object a, Object b) {
            return this.compare((BOTGroupingInfo)a, (BOTGroupingInfo)b);
        }

        public int compare(BOTGroupingInfo a, BOTGroupingInfo b) {
            if (a == null || b == null) {
                throw new IllegalArgumentException();
            }
            if (a.getGroupingLevel() > b.getGroupingLevel()) {
                return 1;
            }
            if (a.getGroupingLevel() < b.getGroupingLevel()) {
                return -1;
            }
            return a.getGroupingProperty().compareTo(b.getGroupingProperty());
        }
    }

    class GroupItemInfo {
        private final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.runtime.GroupItemInfo");
        String propName;
        int level;

        public GroupItemInfo(String propName, int level) {
            this.propName = propName;
            this.level = level;
        }
    }

    class GroupInfo {
        public GroupItemInfo[] items;

        public GroupInfo(GroupItemInfo[] items) {
            this.items = items;
        }
    }
}

