/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.bot.trace.impl;

import com.kingdee.bos.bot.engine.common.GzCompressionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class BotpTraceRoolingFileAppender
extends RollingFileAppender {
    private String datePattern = "";
    private String fileSuffix = "";

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public void rollOver() {
        this.fileSuffix = new SimpleDateFormat(this.datePattern).format(new Date(System.currentTimeMillis()));
        File target = null;
        File file = null;
        file = new File(this.fileName);
        int fileNumber = GzCompressionUtils.getFileNumber(file.getParent());
        for (int i = fileNumber - 1; i >= 0; --i) {
            file = new File(this.fileName + this.fileSuffix + "." + i);
            if (!file.exists()) continue;
            target = new File(this.fileName + this.fileSuffix + "." + (i + 1));
            file.renameTo(target);
        }
        target = new File(this.fileName + this.fileSuffix + "." + 0);
        this.closeFile();
        file = new File(this.fileName);
        file.renameTo(target);
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ",false)call failed."), (Throwable)e);
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize) {
            this.rollOver();
        }
        super.subAppend(event);
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void closeFile() {
        if (this.qw != null) {
            try {
                this.qw.close();
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("Could not close " + this.qw), (Throwable)e);
            }
        }
    }
}

