/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.CacheRouterManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.app.BOTPConfigInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.Null;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class BOTObjectCache {
    private static final Logger logger = Logger.getLogger((String)BOTObjectCache.class.getName());
    private final Map cache = new HashMap();
    private final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
    private final Map ObjNotFoundCache = new HashMap();
    private Context ctx;
    private long queueMax = 1000L;
    private static final CopyOnWriteArraySet cacheSet = new CopyOnWriteArraySet();
    private boolean isOpenMemCache = false;
    private boolean isHasMemCache = false;
    private CustomCacheService billCache = new CustomCacheService("botp.objectBillCache");
    private String currentBotMappingInfoID = null;
    private List customKeyList = new ArrayList();
    private int inCacheCount = 0;
    private int notInCacheCount = 0;
    private static final String METHODNAME_GETVALUE = "getValue";
    private static ThreadLocal threadCtx = new ThreadLocal(){

        protected Object initialValue() {
            return new BOTObjectCache();
        }
    };

    public String getSize() {
        return "\u5168\u5c40cacheSet:" + cacheSet.size() + "; \u7ebf\u7a0bcache:" + this.cache.size();
    }

    protected boolean needCache(Context ctx, BOSObjectType bosType) {
        ICacheConfig config = CacheConfigManager.getConfig();
        return this.isOpenMemCache && ctx != null && config != null && config.needServerCache() && config.needCache(bosType);
    }

    private BOTObjectCache() {
        if (CacheRouterManager.getInstance().getCustomRouter("botp.objectBillCache") != null) {
            this.isHasMemCache = true;
        }
    }

    private void setisOpenMemCache(boolean isOpenMemCache) {
        this.isOpenMemCache = isOpenMemCache && this.isHasMemCache;
    }

    private void setqueueMax(long queueMax) {
        this.queueMax = queueMax;
    }

    private void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public void setMappingId(String id) {
        this.currentBotMappingInfoID = id;
    }

    public int getInCacheCount() {
        return this.inCacheCount;
    }

    public int getNotInCacheCount() {
        return this.notInCacheCount;
    }

    public static BOTObjectCache getInstance(Context ctx) {
        BOTObjectCache botCache = (BOTObjectCache)threadCtx.get();
        botCache.setContext(ctx);
        botCache.setisOpenMemCache(BOTPConfigInfo.getConfigInstance().isMemCacheOpen());
        botCache.setqueueMax(BOTPConfigInfo.getConfigInstance().getMaxCacheNum());
        return botCache;
    }

    public void disCardCustomeCache() {
        for (int i = 0; i < this.customKeyList.size(); ++i) {
            this.billCache.remove(this.customKeyList.get(i).toString());
        }
        this.customKeyList.clear();
    }

    public void clear() {
        cacheSet.removeAll(this.cache.keySet());
        this.queue.removeAll(this.cache.keySet());
        this.cache.clear();
        this.ObjNotFoundCache.clear();
        if (this.isOpenMemCache) {
            this.disCardCustomeCache();
        }
        this.currentBotMappingInfoID = null;
    }

    private void innerPutObject(Object key, Object value) {
        if (this.isOpenMemCache && value instanceof CoreBillBaseInfo && this.currentBotMappingInfoID != null) {
            String genKey = this.generateKey(key.toString());
            if (this.billCache.contains(genKey)) {
                return;
            }
            this.billCache.put(genKey, value);
            this.customKeyList.add(genKey);
        } else {
            if (this.cache.containsKey(key)) {
                return;
            }
            this.cache.put(key, value);
            this.queue.add(key);
            cacheSet.add(key);
            if ((long)cacheSet.size() > this.queueMax) {
                Object removeKey = this.queue.remove();
                cacheSet.remove(removeKey);
                this.cache.remove(removeKey);
            }
            if ((long)this.cache.size() > this.queueMax) {
                logger.error((Object)("BotpObeject\u7f13\u5b58\u6700\u5927\u503c\u63a7\u5236\u5931\u6548-----\u7ebf\u7a0bcache.size():" + this.cache.size() + "; \u5168\u5c40cacheSet.size()" + cacheSet.size()));
                cacheSet.removeAll(this.cache.keySet());
                this.queue.removeAll(this.cache.keySet());
                this.cache.clear();
            }
        }
    }

    public void prepare(IObjectCollection col) {
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue obj = col.getObject(i);
            this.innerPutObject(obj.get(obj.getPKField()).toString(), obj);
        }
    }

    public IObjectValue get(String objId) throws DataAccessException {
        BOSObjectType bosType = BOSUuid.read((String)objId).getType();
        return this.get(bosType, objId);
    }

    public Object getObject(String objId) {
        Object obj = this.cache.get(objId);
        return obj;
    }

    public void putObject(String objId, Object obj) {
        this.innerPutObject(objId, obj);
    }

    private void innerHandleParamEntityView(Context ctx, IObjectPK pk, EntityViewInfo view, String MethodName, Object[] params, boolean isSetDefaultSelector, BOSObjectType type) throws InvalidDAOMetaDataException {
        if (pk != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = null;
            bo = this instanceof ICommonBOSType && ((ICommonBOSType)this).getPK() != null ? loader.getEntity(((ICommonBOSType)this).getPK()) : loader.getEntity(type);
            FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)bo, (IObjectPK)pk);
            view.setFilter(filterData);
            if (isSetDefaultSelector && bo.getDefaultView() != null) {
                SelectorItemCollection selector = bo.getDefaultView().getSelector();
                view.setSelector(selector);
            }
        }
    }

    private String generateKey(String id) {
        return id + "|" + this.currentBotMappingInfoID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IObjectValue get(BOSObjectType type, String objId) throws DataAccessException {
        IObjectValue obj = null;
        if (this.isOpenMemCache && this.currentBotMappingInfoID != null) {
            String genKey = this.generateKey(objId.toString());
            obj = (IObjectValue)this.billCache.get(genKey);
        }
        if (obj == null) {
            obj = (IObjectValue)this.cache.get(objId);
        }
        if (obj == null) {
            Object obj2 = this.ObjNotFoundCache.get(objId);
            if (obj2 == Null.NULL) {
                ++this.inCacheCount;
                return null;
            }
            ++this.notInCacheCount;
            Connection cn = null;
            BOSUuid uuid = BOSUuid.read((String)objId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            try {
                cn = EJBFactory.getConnection((Context)this.ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)type, (Context)this.ctx, (Connection)cn);
                if (this.needCache(this.ctx, type)) {
                    EntityViewInfo view = new EntityViewInfo();
                    Object[] params = new Object[]{pk};
                    this.innerHandleParamEntityView(this.ctx, (IObjectPK)pk, view, METHODNAME_GETVALUE, params, true, type);
                    String viewEcode = view.encode();
                    obj = ORMValueCacheService.getInstance().get(this.ctx, type, (IObjectPK)pk, viewEcode);
                    if (obj != null) return obj;
                    obj = dao.getValue((IObjectPK)pk);
                    ORMValueCacheService.getInstance().put(this.ctx, type, (IObjectPK)pk, viewEcode, obj);
                    return obj;
                }
                obj = dao.getValue((IObjectPK)pk);
                this.innerPutObject(objId, obj);
                return obj;
            }
            catch (SQLException sqle) {
                throw new SQLAccessException(sqle);
            }
            catch (ObjectNotFoundException da) {
                this.ObjNotFoundCache.put(objId, Null.NULL);
                throw da;
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        } else {
            ++this.inCacheCount;
        }
        return obj;
    }

    public void prepareObjectByID(BOSObjectType type, List idList, SelectorItemCollection selectors) throws DataAccessException {
        ArrayList<String> newIdList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            Object obj2;
            String objId = (String)idList.get(i);
            IObjectValue obj = (IObjectValue)this.cache.get(objId);
            if (obj != null || (obj2 = this.ObjNotFoundCache.get(objId)) == Null.NULL) continue;
            newIdList.add(objId);
        }
        if (newIdList.size() >= 0) {
            this.innerPrepareObjectByID(type, newIdList, selectors);
        }
    }

    protected void innerPrepareObjectByID(BOSObjectType type, List idList, SelectorItemCollection selectors) throws DataAccessException {
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        FilterItemInfo item = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(item);
        view.setFilter(info);
        if (selectors != null && selectors.size() > 0) {
            view.setSelector(selectors);
        }
        IObjectCollection objColl = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)type, (Context)this.ctx, (Connection)cn);
            objColl = dao.getCollection(view);
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        catch (ObjectNotFoundException da) {
            for (int i = 0; i < idList.size(); ++i) {
                this.ObjNotFoundCache.put(idList.get(i), Null.NULL);
            }
            throw da;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (objColl != null && objColl.size() > 0) {
            for (int i = 0; i < objColl.size(); ++i) {
                IObjectValue val = objColl.getObject(i);
                if (val.get("id") == null) continue;
                this.innerPutObject(val.get("id").toString(), val);
            }
        }
    }
}

