/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.formula.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.bot.BOTDynFunctionCollection;
import com.kingdee.bos.metadata.bot.BOTDynFunctionFactory;
import com.kingdee.bos.metadata.bot.BOTDynFunctionInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BotpDynamicFormulaFunctions
implements IFormulaFunctions {
    private static final Logger logger = Logger.getLogger(BotpDynamicFormulaFunctions.class);
    public static String ARGS = "_ARG";
    private EntityObjectInfo srcEntity = null;
    private EntityObjectInfo destEntity = null;
    private static String RES = "com.kingdee.eas.base.botp.BotpDynFunctionResource";
    private Vector funcInfos = null;
    Interpreter interpreter = null;

    public BotpDynamicFormulaFunctions(Context ctx, EntityObjectInfo srcEntity, EntityObjectInfo destEntity) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.loadFunctions(ctx);
    }

    private FilterInfo getEntityFilter() {
        String baseClass = "com.kingdee.eas.framework.app";
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("isShare", (Object)Boolean.TRUE);
        StringBuffer maskString = new StringBuffer("(#0");
        int step = 1;
        EntityObjectInfo entity = this.srcEntity;
        do {
            filter.appendFilterItem("srcBostype", (Object)entity.getType().toString());
            maskString.append(" or #" + step);
            ++step;
        } while ((entity = entity.getParent()) != null && entity.getFullName() != null && entity.getFullName().indexOf(baseClass) < 0);
        entity = this.destEntity;
        do {
            filter.appendFilterItem("destBostype", (Object)entity.getType().toString());
            maskString.append(" or #" + step);
            ++step;
        } while ((entity = entity.getParent()) != null && entity.getFullName() != null && entity.getFullName().indexOf(baseClass) < 0);
        filter.appendFilterItem("enable", (Object)Boolean.TRUE);
        maskString.append(") and #" + step);
        filter.setMaskString(maskString.toString());
        return filter;
    }

    private void loadFunctions(Context ctx) {
        if (ctx != null) {
            try {
                this.funcInfos = (Vector)BOTObjectCache.getInstance(ctx).get("funcInfos||forDynamicFunction");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.funcInfos == null) {
            BOTDynFunctionCollection col = null;
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = this.getEntityFilter();
                view.setFilter(filter);
                col = ctx == null ? BOTDynFunctionFactory.getRemoteInstance().getCollection(view) : BOTDynFunctionFactory.getLocalInstance(ctx).getCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)"errors occured when getting  BOTDynFunctionCollection!");
            }
            this.funcInfos = new Vector();
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    BOTDynFunctionInfo botDynFunctionInfo = col.get(i);
                    this.addBOTDynFunctionInfo(botDynFunctionInfo);
                }
            }
            if (ctx != null) {
                BOTObjectCache.getInstance(ctx).putObject("funcInfos||forDynamicFunction", this.funcInfos);
            }
        }
    }

    private void addBOTDynFunctionInfo(BOTDynFunctionInfo botDynFunctionInfo) {
        String[] params;
        if (this.funcInfos == null) {
            return;
        }
        String paramStr = botDynFunctionInfo.getParams();
        if (paramStr != null) {
            params = paramStr.split("[|]");
            for (int i = 0; i < params.length; ++i) {
                String[] str = params[i].split("!");
                params[i] = str[0];
            }
        } else {
            params = new String[]{};
        }
        FuncInfo info = new FuncInfo(botDynFunctionInfo.getName(), botDynFunctionInfo.getDescription(), botDynFunctionInfo.getExpression(), params);
        this.funcInfos.add(info);
    }

    private void initInterpreter(Context ctx, List funcProviderList) {
        if (this.interpreter == null) {
            try {
                this.interpreter = (Interpreter)BOTObjectCache.getInstance(ctx).get("interpreter||forDynamicFunction");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.interpreter == null) {
                this.interpreter = new Interpreter(ctx);
                for (int i = 0; i < funcProviderList.size(); ++i) {
                    this.interpreter.addFunctionProvider((IFunctionProvider)funcProviderList.get(i));
                }
                this.interpreter.setSupportDebug(true);
                this.interpreter.setDebugEnv(DebugEnv.getDebugEnv());
                this.interpreter.setProperyExprOwnerNullIgore(true);
                this.interpreter.setForBot(true);
                BOTObjectCache.getInstance(ctx).putObject("interpreter||forDynamicFunction", this.interpreter);
            }
        }
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        Context ctx = (Context)paramList.get(0);
        Map localCtx = (Map)paramList.get(1);
        List funcProviderList = (List)paramList.get(2);
        if (ctx == null || funcProviderList == null || localCtx == null) {
            return null;
        }
        this.loadFunctions(ctx);
        this.initInterpreter(ctx, funcProviderList);
        String[] params = this.getParams(funcName);
        int i = 0;
        while (i + 3 < paramList.size()) {
            localCtx.put(params[i], paramList.get(i + 3));
            ++i;
        }
        String expr = this.getExpression(funcName);
        Object reVal = null;
        try {
            reVal = this.interpreter.eval(expr, localCtx);
        }
        catch (InterpreterException e) {
            logger.error((Object)e);
            return null;
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage());
            return null;
        }
        return reVal;
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get(i)).getName();
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        return EASResource.getString((String)RES, (String)"dynfunction");
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get(i)).getName())) continue;
            return ((FuncInfo)this.funcInfos.get(i)).getDesc();
        }
        return null;
    }

    private String getExpression(String funcName) {
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get(i)).getName())) continue;
            return ((FuncInfo)this.funcInfos.get(i)).getExpr();
        }
        return null;
    }

    private String[] getParams(String funcName) {
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get(i)).getName())) continue;
            return ((FuncInfo)this.funcInfos.get(i)).getArgs();
        }
        return null;
    }

    class FuncInfo {
        String name;
        String desc;
        String expr;
        String[] args;

        public FuncInfo(String name, String desc, String expr, String[] args) {
            this.name = name;
            this.desc = desc;
            this.expr = expr;
            this.args = args;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setExpr(String expr) {
            this.expr = expr;
        }

        public FuncInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String[] getArgs() {
            return this.args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }
    }
}

