/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.formula.kscript.debug.IScriptFormater;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.util.StringUtil;
import org.apache.log4j.Logger;

public class BotpScriptFormater
implements IScriptFormater {
    private static final Logger logger = Logger.getLogger(BotpScriptFormater.class);
    private static final String SRCFLAG = "__src";
    private static final String DESTFLAG = "__dest";
    private EntityObjectInfo srcEntity = null;
    private EntityObjectInfo destEntity = null;

    public String formatExpression(String expression) {
        if (this.srcEntity != null && this.srcEntity.getObjectValueClass() != null && this.srcEntity.getObjectValueClass().length() > 0) {
            expression = expression.replaceAll(BotpScriptFormater.getEntityObjectValueName(this.srcEntity), SRCFLAG);
        }
        if (this.destEntity != null && this.destEntity.getObjectValueClass() != null && this.destEntity.getObjectCollectionClass().length() > 0) {
            expression = expression.replaceAll(BotpScriptFormater.getEntityObjectValueName(this.destEntity), DESTFLAG);
        }
        logger.debug((Object)expression);
        return expression;
    }

    public void setSrcEntity(EntityObjectInfo srcEntity) {
        this.srcEntity = srcEntity;
    }

    public void setDestEntity(EntityObjectInfo destEntity) {
        this.destEntity = destEntity;
    }

    public String unFormatExpression(String expression) {
        if (expression != null && expression.length() > 0) {
            if (this.srcEntity != null && this.srcEntity.getObjectValueClass() != null && this.srcEntity.getObjectValueClass().length() > 0) {
                expression = expression.replaceAll(SRCFLAG, BotpScriptFormater.getEntityObjectValueName(this.srcEntity));
            }
            if (this.destEntity != null && this.destEntity.getObjectValueClass() != null && this.destEntity.getObjectCollectionClass().length() > 0) {
                expression = expression.replaceAll(DESTFLAG, BotpScriptFormater.getEntityObjectValueName(this.destEntity));
            }
            if (expression.indexOf("formula_result;") > -1) {
                return expression;
            }
        }
        return "";
    }

    private static String getEntityObjectValueName(EntityObjectInfo entity) {
        String[] packs = StringUtil.split((String)entity.getObjectValueClass(), (String)".");
        return packs[packs.length - 1];
    }
}

