/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BotpUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.botp.util.BotpUtils");
    public static final String SERVER_CONFIG_PROP = "bos.config";
    public static final String USERDIR_CONFIG_PROP = "user.dir";
    private static final String CONFIG_FILE_NAME = "BOTPConfig.properties";
    private static final String RULECONFIG_FILE_NAME = "BOTPRuleConfig.properties";
    private static final String VALIDATE_ENTRY_VALUE = "ValidateEntryValue";

    private BotpUtils() {
    }

    public static byte[] loadFile2Stream(String filePath) throws BOSException {
        File f = new File(filePath);
        return BotpUtils.loadFile2Stream(f);
    }

    public static byte[] loadFile2Stream(File file) throws BOSException {
        int len = new Long(file.length()).intValue();
        byte[] template = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fis.read(template);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return template;
    }

    public static String loadFile2Text(String filePath) throws BOSException {
        StringBuffer sb = new StringBuffer();
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(filePath, "r");
            long filePointer = 0L;
            long length = file.length();
            while (filePointer < length) {
                String s = file.readLine();
                sb.append(s).append("\n");
                filePointer = file.getFilePointer();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static void appendText2File(String filePath, String text) throws BOSException {
        RandomAccessFile file = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            file = new RandomAccessFile(filePath, "rw");
            file.seek(file.length());
            file.write(text.getBytes());
        }
        catch (Exception e) {
            logger.warn((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void createText2File(String filePath, String text) throws BOSException {
        RandomAccessFile file = null;
        try {
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            file = new RandomAccessFile(filePath, "rw");
            file.seek(file.length());
            file.write(text.getBytes());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean needLog(Context ctx) throws BOSException {
        String configFile = BotpUtils.getSrvBOTPConfigFileName(ctx);
        if (configFile == null) {
            return false;
        }
        File file = new File(configFile);
        if (!file.exists()) {
            return false;
        }
        Properties p = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            p.load(stream);
            String userName = ctx.getUserName().toLowerCase();
            if (p.containsKey(userName) || p.containsKey(userName.toUpperCase())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean needValidateEntryValue(Context ctx) throws BOSException {
        String configFile = BotpUtils.getSrvBOTPRuleConfigFileName(ctx);
        if (configFile == null) {
            return true;
        }
        File file = new File(configFile);
        if (!file.exists()) {
            return true;
        }
        Properties p = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            p.load(stream);
            if (!p.containsKey(VALIDATE_ENTRY_VALUE)) {
                boolean bl = true;
                return bl;
            }
            int value = Integer.parseInt(p.get(VALIDATE_ENTRY_VALUE).toString());
            boolean bl = value == 1;
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSrvBOTPConfigFileName(Context ctx) {
        return BotpUtils.getFile(CONFIG_FILE_NAME).getAbsolutePath();
    }

    public static String getSrvBOTPRuleConfigFileName(Context ctx) {
        return BotpUtils.getFile(RULECONFIG_FILE_NAME).getAbsolutePath();
    }

    public static void createUserBOTPLog(Context ctx, String text, boolean isNew) throws BOSException {
        if (isNew) {
            BotpUtils.createText2File(BotpUtils.getUserBOTPLogFile(ctx), text);
        } else {
            BotpUtils.appendText2File(BotpUtils.getUserBOTPLogFile(ctx), text);
        }
    }

    public static void createUserBOTPLog(Context ctx, DAPTransformResult result) throws BOSException {
        StringBuffer sb = new StringBuffer(new Date().toLocaleString());
        sb.append("\tDAP transform result...\n");
        sb.append("Voucher Type:");
        IObjectCollection vouchers = result.getVoucherCollection();
        sb.append("Voucher Info...\n");
        for (int i = 0; i < vouchers.size(); ++i) {
            sb.append(vouchers.getObject(i).toString()).append("\n");
        }
        BOTRelationCollection botrs = result.getRelationCollection();
        sb.append("Relation Info...\n");
        for (int i = 0; i < botrs.size(); ++i) {
            sb.append(botrs.get(i).toString()).append("\n");
        }
        BotpUtils.createUserBOTPLog(ctx, sb.toString(), false);
    }

    public static void createUserBOTPLog(Context ctx, BTPTransformResult result) throws BOSException {
        StringBuffer sb = new StringBuffer(new Date().toLocaleString());
        sb.append("\tBTP transform result...\n");
        sb.append("Bills Info...\n");
        IObjectCollection bills = result.getBills();
        for (int i = 0; i < bills.size(); ++i) {
            sb.append(bills.getObject(i).toString()).append("\n");
        }
        BOTRelationCollection botrs = result.getBOTRelationCollection();
        sb.append("Relation Info...\n");
        for (int i = 0; i < botrs.size(); ++i) {
            sb.append(botrs.get(i).toString()).append("\n");
        }
        BotpUtils.createUserBOTPLog(ctx, sb.toString(), false);
    }

    public static String getUserBOTPLogFile(Context ctx) {
        String metaDataPath = Utils.getMetadataSrc((Context)ctx);
        if (metaDataPath != null && metaDataPath.length() > 0) {
            metaDataPath = StringUtils.replace((String)metaDataPath, (String)"\\", (String)"/");
            metaDataPath = metaDataPath.substring(0, metaDataPath.lastIndexOf("/") + 1);
            String userName = ctx.getUserName();
            String logFile = userName + "_BOTP.log";
            metaDataPath = metaDataPath + logFile;
        }
        return metaDataPath;
    }

    public static File getServerRoot() {
        String root = System.getProperty(SERVER_CONFIG_PROP);
        if (root == null) {
            root = System.getProperty(USERDIR_CONFIG_PROP);
        } else {
            if (File.separatorChar != '/') {
                root = root.replace('/', File.separatorChar);
            }
            root = root.substring(0, root.lastIndexOf(File.separatorChar));
        }
        return new File(root);
    }

    public static File getFile(String name) {
        File file;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (!(file = new File(name)).isAbsolute()) {
            file = new File(BotpUtils.getServerRoot(), name);
        }
        return file;
    }

    public static Object dynCallFunction(Object destObj, String funcName, Object[] args) {
        if (destObj == null || funcName == null) {
            return null;
        }
        Method method = null;
        try {
            Class[] paramType = null;
            if (args != null && args.length > 0) {
                int max = args.length;
                paramType = new Class[max];
                for (int i = 0; i < max; ++i) {
                    paramType[i] = args[i].getClass();
                }
            }
            if ((method = BotpUtils.getDynObjectFunction(destObj, funcName, paramType)) != null) {
                return method.invoke(destObj, args);
            }
        }
        catch (Exception e) {
            logger.error((Object)("DynCall function error! function=" + funcName + ", args=" + args + ", object=" + destObj), (Throwable)e);
        }
        return null;
    }

    public static Method getDynObjectFunction(Object destObj, String funcName, Class[] paramsType) {
        if (destObj == null || funcName == null) {
            return null;
        }
        Method method = null;
        try {
            method = paramsType != null && paramsType.length > 0 ? destObj.getClass().getMethod(funcName, paramsType) : destObj.getClass().getMethod(funcName, null);
            return method;
        }
        catch (Throwable e) {
            logger.error((Object)("The function [" + funcName + "] is not exist!  object=" + destObj), e);
            return null;
        }
    }

    public static String formatStrLength(String str, int leng, String strFix) {
        if (!StringUtils.isEmpty((String)str) && leng > str.length()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < leng - str.length(); ++i) {
                sb.append(strFix);
            }
            sb.append(str);
            return sb.toString();
        }
        return str;
    }

    public static StringBuffer countHGExpr(BOTRuleSegmentInfo accountSeg, BOTRuleSegmentInfo ruleHead_CompanyInfo, BOTRuleSegmentInfo hgSegInfo) {
        StringBuffer accountExpression = BotpUtils.getAccountExpr(accountSeg);
        StringBuffer acountExpr2 = BotpUtils.recountAccountExpr(ruleHead_CompanyInfo, accountExpression);
        StringBuffer hgExpr = BotpUtils.countHGExpr(hgSegInfo, accountExpression, acountExpr2);
        return hgExpr;
    }

    public static StringBuffer getAccountExpr(BOTRuleSegmentInfo accountSeg) {
        StringBuffer accountExpression = new StringBuffer();
        String srcPropertyName = accountSeg.getSrcPropertyName();
        if (!StringUtils.isEmpty((String)srcPropertyName)) {
            accountExpression.append("com.kingdee.eas.basedata.master.app.AccountView account = ").append(srcPropertyName).append(";");
        } else {
            String acctString = accountSeg.getExpression().replaceFirst("return ", "\r\n com.kingdee.eas.basedata.master.app.AccountView account = ");
            if (acctString.indexOf("formula_result") != -1) {
                acctString = acctString.replaceAll("formula_result", "formula_result_account");
            }
            accountExpression.append(acctString).append("\r\n");
        }
        return accountExpression;
    }

    public static StringBuffer recountAccountExpr(BOTRuleSegmentInfo ruleHead_CompanyInfo, StringBuffer accountExpression) {
        if (ruleHead_CompanyInfo == null) {
            return new StringBuffer();
        }
        if (accountExpression.toString().contains("__BOTgetAccountInSpecifiedFiOrg")) {
            return accountExpression;
        }
        StringBuffer acountExpr2 = new StringBuffer();
        if (ruleHead_CompanyInfo != null && ruleHead_CompanyInfo.getSrcPropertyName() != null && ruleHead_CompanyInfo.getSrcPropertyName().length() > 0) {
            if (accountExpression.toString().indexOf("var __src;") == -1) {
                acountExpr2.append("var __src;\r\n");
            }
            acountExpr2.append("if(account!=null && " + ruleHead_CompanyInfo.getSrcPropertyName() + "!=null) { account = __BOTgetAccountInSpecifiedFiOrg( account.number,");
            acountExpr2.append(ruleHead_CompanyInfo.getSrcPropertyName());
            acountExpr2.append(");}\r\n");
        } else {
            String companyInfo = ruleHead_CompanyInfo.getExpression();
            if (ruleHead_CompanyInfo.getExpression().indexOf("return formula_result") > -1) {
                companyInfo = companyInfo.replaceAll("formula_result", "formula_result_company");
                if (accountExpression.toString().indexOf("var __src;") > -1) {
                    companyInfo = companyInfo.replaceAll("var __src;", "");
                }
                companyInfo = companyInfo.replaceAll("return formula_result_company;", "");
            } else {
                companyInfo = ruleHead_CompanyInfo.getExpression().replaceAll("return ", "var formula_result_company = ");
            }
            acountExpr2.append(companyInfo).append("\r\n");
            acountExpr2.append("if(account!=null && formula_result_company!=null) { account = __BOTgetAccountInSpecifiedFiOrg( account.number,formula_result_company);}\r\n");
        }
        return acountExpr2;
    }

    private static StringBuffer countHGExpr(BOTRuleSegmentInfo hgSegInfo, StringBuffer accountExpression, StringBuffer acountExpr2) {
        StringBuffer hgExpr = new StringBuffer();
        String oldHgExpression = hgSegInfo.getExpression();
        String hgDetailExpr = oldHgExpression.substring(oldHgExpression.indexOf("java.util.HashMap map = new java.util.HashMap();"));
        StringBuffer tempBuffer = null;
        tempBuffer = StringUtils.equals((String)accountExpression.toString(), (String)acountExpr2.toString()) ? accountExpression : accountExpression.append(acountExpr2);
        if (!tempBuffer.toString().contains("var __src;")) {
            hgDetailExpr = "var __src;\r\n" + hgDetailExpr;
        }
        hgExpr = accountExpression.append(hgDetailExpr);
        return hgExpr;
    }
}

