/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BtpMulBizOrgInfo;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.IMultiOrgBizInfo;
import java.util.HashMap;
import java.util.List;

public class BtpMulBizOrgUtils {
    protected static EntityViewInfo getFilterByCheckMultiOrg(List orgIDList) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        HashMap<String, String> orgIDMap = new HashMap<String, String>();
        StringBuffer buffOrgIDs = new StringBuffer();
        for (int i = 0; i < orgIDList.size(); ++i) {
            String orgID = (String)orgIDList.get(i);
            if (orgIDMap.containsKey(orgID)) continue;
            if (orgIDMap.size() > 0) {
                buffOrgIDs.append(",");
            }
            buffOrgIDs.append("'" + orgID + "'");
            orgIDMap.put(orgID, orgID);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)buffOrgIDs.toString(), CompareType.INNER);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("CU.*");
        view.setSelector(selectors);
        return view;
    }

    private static CtrlUnitInfo checkCUByMultiOrgID(List orgIDList) throws Exception {
        CtrlUnitInfo cu = null;
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = BtpMulBizOrgUtils.getFilterByCheckMultiOrg(orgIDList);
        CoreBaseCollection orgs = iFullOrgUnit.getCollection(view);
        HashMap<String, CtrlUnitInfo> cuMap = new HashMap<String, CtrlUnitInfo>();
        if (orgs != null && orgs.size() > 0) {
            for (int i = 0; i < orgs.size(); ++i) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)orgs.get(i);
                CtrlUnitInfo tempCu = orgInfo.getCU();
                cuMap.put(tempCu.getId().toString(), tempCu);
            }
        }
        if (cuMap.size() < 0) {
            throw new DAPException(BTPException.NOMAPPINGORGPERM);
        }
        if (cuMap.size() > 1) {
            throw new DAPException(BTPException.NOMAPPINGORGPERM);
        }
        Object[] cuArray = cuMap.values().toArray();
        cu = (CtrlUnitInfo)cuArray[0];
        return cu;
    }

    private static CoreBaseCollection getOrgCollectionByIDs(List orgIDList) throws Exception {
        if (orgIDList == null) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = BtpMulBizOrgUtils.getFilterByCheckMultiOrg(orgIDList);
        CoreBaseCollection orgInfoColl = iFullOrgUnit.getCollection(view);
        return orgInfoColl;
    }

    public static IMultiOrgBizInfo getMultiOrgBizInfoToCUMode(IMultiOrgBizInfo mulBizOrgInfo) throws Exception {
        BtpMulBizOrgInfo newBiz = null;
        if (mulBizOrgInfo != null) {
            List orgIDList = mulBizOrgInfo.getOrgIDList();
            CoreBaseCollection orgColl = BtpMulBizOrgUtils.getOrgCollectionByIDs(orgIDList);
            if (orgColl != null && orgColl.size() > 0) {
                newBiz = new BtpMulBizOrgInfo();
                for (int i = 0; i < orgColl.size(); ++i) {
                    FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)orgColl.get(i);
                    String orgID = orgInfo.getId().toString();
                    CtrlUnitInfo tempCu = orgInfo.getCU();
                    String cuID = tempCu.getId().toString();
                    newBiz.addCtrlUnit(tempCu);
                    newBiz.addID(cuID, mulBizOrgInfo.getIDList(orgID));
                    newBiz.addEntryID(cuID, mulBizOrgInfo.getEntryIDList(orgID));
                }
            } else {
                throw new BOSException((Throwable)new IllegalArgumentException("OrgInfoList is null!  orgIDList=" + orgIDList));
            }
        }
        return newBiz;
    }
}

