/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QuerySolutionUtils {
    private static final Logger logger = Logger.getLogger(QuerySolutionUtils.class);
    private static final int defaultReturnMaxCount = 1000;

    public static QuerySolutionCollection getUserAndUserOrgQuerySolutions(Context ctx, String parentUIName, String queryName) throws Exception {
        try {
            IQuerySolutionFacade iQuerySolutionFacade = null;
            iQuerySolutionFacade = ctx == null ? QuerySolutionFacadeFactory.getRemoteInstance() : QuerySolutionFacadeFactory.getLocalInstance(ctx);
            return iQuerySolutionFacade.getQuerySolutions(parentUIName, queryName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    public static QuerySolutionCollection getQuerySolutionColForFastQuery(Context ctx, String parentUIName, String queryName) throws Exception {
        QuerySolutionCollection myQuerySolutionCol = QuerySolutionUtils.getUserAndUserOrgQuerySolutions(ctx, parentUIName, queryName);
        myQuerySolutionCol = QuerySolutionUtils.justOneDefaultSolutionVisible(myQuerySolutionCol);
        QuerySolutionCollection ret = new QuerySolutionCollection();
        String currentUserId = null;
        currentUserId = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ctx.getCaller().toString();
        int size = myQuerySolutionCol.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo info = myQuerySolutionCol.get(i);
            if (!StringUtils.equals((String)StringUtils.cnulls((Object)info.getOwner()), (String)currentUserId)) continue;
            ret.add(info);
        }
        return ret;
    }

    public static QuerySolutionCollection getAllQuerySolutionColForFastQuery(Context ctx, String parentUIName, String queryName) throws Exception {
        QuerySolutionCollection myQuerySolutionCol = QuerySolutionUtils.getUserAndUserOrgQuerySolutions(ctx, parentUIName, queryName);
        QuerySolutionCollection shareQuerySolutionCol = QuerySolutionUtils.getOrgSharedQuerySolutions(ctx, parentUIName, queryName);
        if (myQuerySolutionCol == null) {
            myQuerySolutionCol = shareQuerySolutionCol;
        } else if (shareQuerySolutionCol != null) {
            myQuerySolutionCol.addCollection(shareQuerySolutionCol);
        }
        myQuerySolutionCol = QuerySolutionUtils.justOneDefaultSolutionVisible(myQuerySolutionCol);
        return myQuerySolutionCol;
    }

    public static SelectorItemCollection getSimpleQuerySolutionSelector() {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("name"));
        selectorCol.add(new SelectorItemInfo("owner"));
        selectorCol.add(new SelectorItemInfo("parentUIName"));
        selectorCol.add(new SelectorItemInfo("shareType"));
        selectorCol.add(new SelectorItemInfo("solutionType"));
        selectorCol.add(new SelectorItemInfo("isUserDefaultSolu"));
        selectorCol.add(new SelectorItemInfo("rowCount"));
        return selectorCol;
    }

    private static SelectorItemCollection getQuerySolutionFullSelector() {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("name"));
        selectorCol.add(new SelectorItemInfo("owner"));
        selectorCol.add(new SelectorItemInfo("shareType"));
        selectorCol.add(new SelectorItemInfo("solutionType"));
        selectorCol.add(new SelectorItemInfo("queryObjectName"));
        selectorCol.add(new SelectorItemInfo("entityViewInfo"));
        selectorCol.add(new SelectorItemInfo("lockedEntityViewInfo"));
        selectorCol.add(new SelectorItemInfo("orgID"));
        selectorCol.add(new SelectorItemInfo("parentUIName"));
        selectorCol.add(new SelectorItemInfo("QueryPanelInfo.*"));
        selectorCol.add(new SelectorItemInfo("isUserDefaultSolu"));
        selectorCol.add(new SelectorItemInfo("rowCount"));
        selectorCol.add(new SelectorItemInfo("tableParams"));
        selectorCol.add(new SelectorItemInfo("dynQuery.*"));
        selectorCol.add(new SelectorItemInfo("printSolution"));
        return selectorCol;
    }

    public static QuerySolutionInfo getFullQuerySolution(Context ctx, String querySolutionId) throws Exception {
        IQuerySolution iQuerySolution = null;
        iQuerySolution = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionInfo ret = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectStringPK(querySolutionId), QuerySolutionUtils.getQuerySolutionFullSelector());
        return ret;
    }

    public static QuerySolutionCollection getOrgSharedQuerySolutions(Context ctx, String parentUIName, String queryName) throws Exception {
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String maskString = null;
            String orgID = null;
            FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)queryName);
            FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
            FilterItemInfo orgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(2));
            orgID = QueryUtils.getOrgID(queryName, ctx).toString();
            FilterItemInfo isNotSystemSoluFilterItem = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
            FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
            FilterItemInfo orgNullFilterItem = new FilterItemInfo("orgID", null);
            filterInfo.getFilterItems().add(queryFilterItem);
            filterInfo.getFilterItems().add(parentUIFilterItem);
            filterInfo.getFilterItems().add(orgLevelFilterItem);
            filterInfo.getFilterItems().add(isNotSystemSoluFilterItem);
            filterInfo.getFilterItems().add(orgFilterItem);
            filterInfo.getFilterItems().add(orgNullFilterItem);
            maskString = " #0 and #1 and #2 and #3 and (#4 or #5) ";
            filterInfo.setMaskString(maskString);
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(QuerySolutionUtils.getSimpleQuerySolutionSelector());
            SorterItemCollection sortCol = new SorterItemCollection();
            sortCol.add(new SorterItemInfo("name"));
            entityViewInfo.setSorter(sortCol);
            IQuerySolution iQuerySolution = null;
            iQuerySolution = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance(ctx);
            return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    public static QuerySolutionCollection getSortedSolutionCol(final Context ctx, QuerySolutionCollection querySolutionCol) {
        int i;
        QuerySolutionCollection ret = new QuerySolutionCollection();
        ArrayList<QuerySolutionInfo> solutionList = new ArrayList<QuerySolutionInfo>();
        int size = querySolutionCol.size();
        for (i = 0; i < size; ++i) {
            solutionList.add(querySolutionCol.get(i));
        }
        Collections.sort(solutionList, new Comparator(){

            public int compare(Object o1, Object o2) {
                QuerySolutionInfo info1 = (QuerySolutionInfo)o1;
                QuerySolutionInfo info2 = (QuerySolutionInfo)o2;
                return QuerySolutionUtils.getCompareFactor(ctx, info1) - QuerySolutionUtils.getCompareFactor(ctx, info2);
            }
        });
        size = solutionList.size();
        for (i = 0; i < size; ++i) {
            ret.add((QuerySolutionInfo)solutionList.get(i));
        }
        return ret;
    }

    public static int getCompareFactor(Context ctx, QuerySolutionInfo info) {
        if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)info.getSolutionType())) {
            return 1;
        }
        if (QuerySolutionUtils.getCurrentUserId(ctx).equals(StringUtils.cnulls((Object)info.getOwner()))) {
            if (ShareTypeEnum.USER_LEVEL.equals((Object)info.getShareType())) {
                return 2;
            }
            return 3;
        }
        return 4;
    }

    public static QuerySolutionInfo getDefaultSelectSolution(Context ctx, QuerySolutionCollection col) {
        if (col == null || col.size() < 1) {
            return new QuerySolutionInfo();
        }
        QuerySolutionInfo userDefaultSolution = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (!col.get(i).isIsUserDefaultSolu() || !QuerySolutionUtils.getCurrentUserId(ctx).equals(col.get(i).getOwner().toString())) continue;
            userDefaultSolution = col.get(i);
            break;
        }
        if (userDefaultSolution != null) {
            return userDefaultSolution;
        }
        return col.get(0);
    }

    private static String getCurrentUserId(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        return ctx.getCaller().toString();
    }

    public static QuerySolutionCollection justOneDefaultSolutionVisible(QuerySolutionCollection querySolutionCollection) {
        QuerySolutionCollection ret = new QuerySolutionCollection();
        if (querySolutionCollection != null) {
            boolean addedSystem = false;
            for (int i = 0; i < querySolutionCollection.size(); ++i) {
                QuerySolutionInfo qSolutionInfo = querySolutionCollection.get(i);
                if (!qSolutionInfo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
                    ret.add(qSolutionInfo);
                    continue;
                }
                if (!qSolutionInfo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION) || addedSystem) continue;
                ret.add(qSolutionInfo);
                addedSystem = true;
            }
        }
        return ret;
    }

    public static QuerySolutionInfo createSysDefaultSolutionInfo(Context ctx, String parentUIName, String queryName) throws Exception {
        BOSUuid orgID = QueryUtils.getOrgID(queryName, ctx);
        QuerySolutionInfo querySolutionInfo = new QuerySolutionInfo();
        BOSUuid userId = null;
        userId = ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId() : BOSUuid.read((String)ctx.getCaller().toString());
        querySolutionInfo.setOwner(userId);
        querySolutionInfo.setQueryObjectName(queryName);
        querySolutionInfo.setOrgID(orgID);
        querySolutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
        querySolutionInfo.setParentUIName(parentUIName);
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelCollection.add(queryPanelInfo);
        querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l1")), new Locale("l1"));
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l2")), new Locale("l2"));
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l3")), new Locale("l3"));
        querySolutionInfo.setRowCount(1000);
        querySolutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        querySolutionInfo.getExtendedProperties().put("isVirtualSolution", true);
        return querySolutionInfo;
    }

    public static QuerySolutionInfo createVirtualSysDefaultSolutionInfo(Context ctx, String parentUIName, String queryName) throws Exception {
        QuerySolutionInfo querySolutionInfo = new QuerySolutionInfo();
        querySolutionInfo.setQueryObjectName(queryName);
        querySolutionInfo.setParentUIName(parentUIName);
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l1")), new Locale("l1"));
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l2")), new Locale("l2"));
        querySolutionInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.base.commonquery.cqResource", (String)"sysDefaultRule", (Locale)new Locale("l3")), new Locale("l3"));
        querySolutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        querySolutionInfo.getExtendedProperties().put("isVirtualSolution", true);
        return querySolutionInfo;
    }

    public static boolean isVirtualSolution(QuerySolutionInfo querySolutionInfo) {
        Object obj;
        boolean isVirtualSolution = false;
        if (querySolutionInfo != null && (obj = querySolutionInfo.getExtendedProperties().get("isVirtualSolution")) != null) {
            isVirtualSolution = Boolean.parseBoolean(obj.toString());
        }
        return isVirtualSolution;
    }

    public static QuerySolutionCollection getQuerySolutionsByUser(Context ctx, String userID) throws Exception {
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String maskString = null;
            String orgID = null;
            if (ctx == null) {
                userID = userID == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : userID;
                orgID = orgID == null ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : orgID;
            } else {
                userID = userID == null ? ctx.getCaller().toString() : userID;
                orgID = orgID == null ? ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString() : orgID;
            }
            FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
            FilterItemInfo isNotSystemSoluFilterItem = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
            FilterItemInfo orgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(2));
            FilterItemInfo publicLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(4));
            FilterItemInfo cuLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(8));
            FilterItemInfo orgCUFilterItem = new FilterItemInfo("orgID", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId());
            FilterItemInfo curOrgFilterItem = new FilterItemInfo("orgID", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId());
            filterInfo.getFilterItems().add(isNotSystemSoluFilterItem);
            filterInfo.getFilterItems().add(ownerFilterItem);
            filterInfo.getFilterItems().add(cuLevelFilterItem);
            filterInfo.getFilterItems().add(orgCUFilterItem);
            filterInfo.getFilterItems().add(publicLevelFilterItem);
            filterInfo.getFilterItems().add(orgLevelFilterItem);
            filterInfo.getFilterItems().add(curOrgFilterItem);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
            if (hasQueryManagePerm) {
                FilterItemInfo userOrgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(1));
                filterInfo.getFilterItems().add(userOrgLevelFilterItem);
                FilterItemInfo notOwnerFilterItem = new FilterItemInfo("owner", (Object)userID, CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(notOwnerFilterItem);
                FilterItemInfo notSystemFilterItemInfo = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(notSystemFilterItemInfo);
                filterInfo.getFilterItems().add(curOrgFilterItem);
            }
            maskString = " #0 and (#1 or ((#2 and #3) or #4 or (#5 and (#6 or #7))) or (#8 and #9 and #10 and #11))";
            filterInfo.setMaskString(maskString);
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(QuerySolutionUtils.getQuerySolutionFullSelector());
            SorterItemCollection sortCol = new SorterItemCollection();
            sortCol.add(new SorterItemInfo("name"));
            entityViewInfo.setSorter(sortCol);
            IQuerySolution iQuerySolution = null;
            iQuerySolution = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance(ctx);
            return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    public static QuerySolutionCollection getShareQuerySolutionsByUser(Context ctx, String userID) throws Exception {
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String maskString = null;
            userID = ctx == null ? (userID == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : userID) : (userID == null ? ctx.getCaller().toString() : userID);
            FilterItemInfo isNotSystemSoluFilterItem = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
            FilterItemInfo orgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(2));
            FilterItemInfo publicLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(4));
            FilterItemInfo cuLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(8));
            FilterItemInfo orgCUFilterItem = new FilterItemInfo("orgID", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId());
            FilterItemInfo curOrgFilterItem = new FilterItemInfo("orgID", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId());
            filterInfo.getFilterItems().add(isNotSystemSoluFilterItem);
            filterInfo.getFilterItems().add(cuLevelFilterItem);
            filterInfo.getFilterItems().add(orgCUFilterItem);
            filterInfo.getFilterItems().add(publicLevelFilterItem);
            filterInfo.getFilterItems().add(orgLevelFilterItem);
            filterInfo.getFilterItems().add(curOrgFilterItem);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            maskString = " #0 and ((#1 and #2) or #3 or (#4 and (#5 or #6)))) ";
            filterInfo.setMaskString(maskString);
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(QuerySolutionUtils.getQuerySolutionFullSelector());
            SorterItemCollection sortCol = new SorterItemCollection();
            sortCol.add(new SorterItemInfo("name"));
            entityViewInfo.setSorter(sortCol);
            IQuerySolution iQuerySolution = null;
            iQuerySolution = ctx == null ? QuerySolutionFactory.getRemoteInstance() : QuerySolutionFactory.getLocalInstance(ctx);
            return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }
}

