/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CommonQueryParamForHandler;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.app.CustomerQueryPanelHandler;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.app.CoreUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonQueryUIHandler
extends CoreUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.commonquery.app.CommonQueryUIHandler");
    private String parentUIName = "";
    private QuerySolutionInfo qSolutionInfo = null;
    private CommonQueryParamForHandler params = null;
    private ArrayList customerPanels = null;
    private RequestContext _request = null;
    private ResponseContext _response = null;
    private Context _context = null;

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.handleCommonQuerySelf(request, response, context);
        this.handleCustomer(request, response, context);
    }

    private void handleCommonQuerySelf(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._request = request;
        this.params = (CommonQueryParamForHandler)request.get("CommonQueryParamForHandler");
        IMetaDataPK queryPK = this.params.getQueryObjectPK();
        this.parentUIName = this.params.getParentUIClassName();
        this.qSolutionInfo = this.params.getQSolutionInfo();
        OrgUnitInfo orgInfo = QueryUtils.getCurrentOrgUnitInfo(this.getQueryInfo(queryPK, context), context);
        ObjectUuidPK orgPK = null;
        orgPK = orgInfo != null ? new ObjectUuidPK(orgInfo.getId()) : new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)context).getId());
        QuerySolutionCollection col = QuerySolutionUtils.getUserAndUserOrgQuerySolutions(context, this.parentUIName, queryPK.getFullName());
        col = QuerySolutionUtils.justOneDefaultSolutionVisible(col);
        QuerySolutionInfo defaultQuerySolution = QuerySolutionUtils.getDefaultSelectSolution(context, col = QuerySolutionUtils.getSortedSolutionCol(context, col));
        if (defaultQuerySolution != null && defaultQuerySolution.getId() != null) {
            defaultQuerySolution = QuerySolutionUtils.getFullQuerySolution(context, defaultQuerySolution.getId().toString());
        }
        ObjectUuidPK userPK = new ObjectUuidPK(this.getCurrentUserId(context));
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
        iPermission.getQueryFieldPermission(queryPK, (IObjectPK)userPK, (IObjectPK)orgPK);
        iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.getCurrentUserId(context)), (IObjectPK)new ObjectUuidPK(this.getCurrentCUId(context)), "querysolutionmanage");
    }

    private QueryInfo getQueryInfo(IMetaDataPK queryPK, Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getQuery(queryPK);
    }

    private BOSUuid getCurrentUserId(Context context) {
        return ContextUtil.getCurrentUserInfo((Context)context).getId();
    }

    private BOSUuid getCurrentCUId(Context context) {
        return ContextUtil.getCurrentCtrlUnit((Context)context).getId();
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("dynQuery.id"));
        coll.add(new SelectorItemInfo("dynQuery.number"));
        coll.add(new SelectorItemInfo("dynQuery.name"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.*"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.id"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return coll;
    }

    private void handleCustomer(RequestContext request, ResponseContext response, Context context) throws Exception {
        ArrayList customerList = (ArrayList)request.get("customerReq");
        if (customerList == null) {
            return;
        }
        int size = customerList.size();
        for (int i = 0; i < size; ++i) {
            RequestContext customerReq = (RequestContext)customerList.get(i);
            Map cm = customerReq.getParameter();
            Map pm = request.getParameter();
            for (Object key : pm.keySet()) {
                if (cm.containsKey(key) || pm.get(key) == null) continue;
                cm.put(key, pm.get(key));
            }
            customerReq.put("solution", (Object)this.qSolutionInfo);
            ResponseContext rc = this.handleOne(customerReq, context);
            response.putAll(rc.getResponse());
        }
    }

    private ResponseContext handleOne(RequestContext customerReq, Context ctx) throws Exception {
        ResponseContext result = new ResponseContext();
        ResponseContext response = this.handleOneCustomerInit(customerReq, ctx);
        result.putAll(response.getResponse());
        ResponseContext response1 = this.handleOneCustomerLoadSolution(customerReq, ctx);
        result.putAll(response1.getResponse());
        return result;
    }

    private ResponseContext handleOneCustomerLoadSolution(RequestContext customerReq, Context ctx) throws BOSException {
        return this.handleOneCustomerMethod(customerReq, "handleLoadSolution", ctx);
    }

    private ResponseContext handleOneCustomerMethod(RequestContext customerReq, String methodName, Context ctx) throws BOSException {
        try {
            String className = customerReq.getClassName();
            if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)methodName)) {
                return new ResponseContext();
            }
            Class<?> handlerClass = Class.forName(className);
            Object handlerInstance = handlerClass.newInstance();
            if (!CustomerQueryPanelHandler.class.isAssignableFrom(handlerInstance.getClass())) {
                return new ResponseContext();
            }
            ResponseContext response = new ResponseContext();
            Method actionMethod = handlerClass.getMethod(methodName, RequestContext.class, ResponseContext.class, Context.class);
            actionMethod.invoke(handlerInstance, customerReq, response, ctx);
            return response;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            return new ResponseContext();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private ResponseContext handleOneCustomerInit(RequestContext customerReq, Context ctx) throws Exception {
        try {
            String className = customerReq.getClassName();
            String methodName = customerReq.getMethodName();
            if (StringUtils.isEmpty((String)methodName)) {
                methodName = "handleInit";
            }
            if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)methodName)) {
                return new ResponseContext();
            }
            Class<?> handlerClass = Class.forName(className);
            Object handlerInstance = handlerClass.newInstance();
            if (!CustomerQueryPanelHandler.class.isAssignableFrom(handlerInstance.getClass())) {
                return new ResponseContext();
            }
            ResponseContext response = new ResponseContext();
            Method actionMethod = handlerClass.getMethod(methodName, RequestContext.class, ResponseContext.class, Context.class);
            actionMethod.invoke(handlerInstance, customerReq, response, ctx);
            return response;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"handleOneCustomerInit error", (Throwable)e);
            return new ResponseContext();
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof BaseException) {
                throw (BaseException)cause;
            }
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public void handleLoadSolution(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._request = request;
        this._response = response;
        this._context = context;
        this.customerPanels = (ArrayList)request.get("customerQueryPanel");
        QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)request.get("solution");
    }

    protected final void handleSetFilterInfo(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._handleSetFilterInfo(request, response, context);
    }

    protected void _handleSetFilterInfo(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected final void handleSetCustomerParams(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._handleSetCustomerParams(request, response, context);
    }

    protected void _handleSetCustomerParams(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected final void handleLoadData(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._handleLoadData(request, response, context);
    }

    protected void _handleLoadData(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleConfirm(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (this.handleVerify(request, response, context)) {
            this.handleSelfConfirm(request, response, context);
        }
    }

    private boolean handleVerify(RequestContext request, ResponseContext response, Context context) throws Exception {
        ArrayList customerList = (ArrayList)request.get("customerReq");
        if (customerList == null) {
            return true;
        }
        int size = customerList.size();
        for (int i = 0; i < size; ++i) {
            RequestContext customerReq = (RequestContext)customerList.get(i);
            Map cm = customerReq.getParameter();
            Map pm = request.getParameter();
            for (Object key : pm.keySet()) {
                if (cm.containsKey(key) || pm.get(key) == null) continue;
                cm.put(key, pm.get(key));
            }
            customerReq.put("solution", (Object)this.qSolutionInfo);
            if (this._handleOneVerify(customerReq, response, context)) continue;
            return false;
        }
        return true;
    }

    private void handleSelfConfirm(RequestContext request, ResponseContext response, Context context) throws Exception {
        QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)request.get("querySolutionInfo");
        boolean isUserDefaultSolu = false;
        Boolean tmpIsSolu = (Boolean)request.get("isUserDefaultSolu");
        if (tmpIsSolu != null && tmpIsSolu instanceof Boolean) {
            isUserDefaultSolu = tmpIsSolu;
        }
        int rowCount = 0;
        Object rowCountO = request.get("rowCount");
        if (rowCountO != null && rowCountO instanceof Integer) {
            rowCount = (Integer)rowCountO;
        }
        if (querySolutionInfo != null) {
            String objectName = (String)request.get("objectName");
            String parentUIName = (String)request.get("parentUIName");
            request.get("isUserDefaultSolu");
            try {
                IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(context);
                if (querySolutionInfo.isIsUserDefaultSolu() != isUserDefaultSolu || querySolutionInfo.getRowCount() != rowCount) {
                    iQuerySolution.saveDefaultSolution(querySolutionInfo.getId().toString(), parentUIName, objectName, rowCount, isUserDefaultSolu);
                }
            }
            catch (Exception e1) {
                logger.error((Object)"save default solution error.", (Throwable)e1);
            }
        }
    }

    protected boolean _handleOneVerify(RequestContext request, ResponseContext response, Context context) throws Exception {
        ResponseContext verifyResponse = this.handleOneCustomerMethod(request, "handleVerify", context);
        response.putAll(verifyResponse.getResponse());
        Object o = verifyResponse.get((Object)"customerquerypanelverifyresult");
        if (o != null && o instanceof Boolean) {
            Boolean result = (Boolean)o;
            return result;
        }
        return true;
    }
}

