/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.upgrade;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class StreamPumper
extends Thread {
    private BufferedReader din;
    private boolean endOfStream = false;
    private boolean isError = false;
    private StringBuffer sBuffer = new StringBuffer();
    private static final Logger logger = Logger.getLogger((String)StreamPumper.class.getName());

    public StreamPumper(InputStream is, boolean error) {
        this.isError = error;
        this.din = new BufferedReader(new InputStreamReader(is));
    }

    public void pumpStream() {
        try {
            String line = this.din.readLine();
            if (line == null) {
                this.endOfStream = true;
                return;
            }
            if (this.isError) {
                this.sBuffer.append(line + "\r\n");
            } else {
                this.sBuffer.append(line + "\r\n");
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            this.endOfStream = true;
        }
    }

    @Override
    public void run() {
        while (!this.endOfStream) {
            this.pumpStream();
        }
        try {
            this.din.close();
        }
        catch (Throwable ioe) {
            logger.error((Object)ioe.getMessage(), ioe);
        }
    }

    public boolean isPumping() {
        return !this.endOfStream;
    }

    public String getResult() {
        return this.sBuffer.toString();
    }
}

