/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.evs.app.apiservice.AbstractEvsServiceFacadeControllerBean;
import com.kingdee.eas.base.evs.app.evsservice.AssemblyEngineFacadeFactory;
import com.kingdee.eas.base.evs.app.evsservice.ConverterEngineFacadeFactory;
import com.kingdee.eas.base.evs.app.evsservice.GeneratorEngineFacadeFactory;
import com.kingdee.eas.base.evs.listener.EvsServiceGeneratorDataListener;
import com.kingdee.eas.base.evs.listener.ListenerManager;
import com.kingdee.eas.base.evs.util.BeUtils;
import com.kingdee.eas.base.evs.util.EvsUtil;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvsServiceFacadeControllerBean
extends AbstractEvsServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.app.apiservice.EvsServiceFacadeControllerBean");

    @Override
    protected Map _getVoucherXbrlJson(Context ctx, IObjectValue companyInfo, IObjectValue periodInfo, List voucherList) throws BOSException, EASBizException {
        List vouchers = voucherList;
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companyInfo;
        PeriodInfo period = (PeriodInfo)periodInfo;
        HashMap returnMap = new HashMap();
        try {
            GeneratorEngineFacadeFactory.getLocalInstance(ctx).genVoucherRelUnit(org, period.getPeriodYear(), period.getPeriodNumber(), vouchers);
            ConverterEngineFacadeFactory.getLocalInstance(ctx).dataConverterVoucherRelByVouchers(org, period.getPeriodYear(), period.getPeriodNumber(), vouchers);
            ArrayList<String> fileTypes = new ArrayList<String>();
            fileTypes.add("receiverJson");
            Map basedBill = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getVoucherDataStandardsBasedBill(org, period.getPeriodYear(), period.getPeriodNumber(), fileTypes, vouchers, EvsUtil.getVoucherStandardTypes(ctx));
            for (Map.Entry entryVoucher : basedBill.entrySet()) {
                String voucherId = (String)entryVoucher.getKey();
                HashMap returnInvoiceMap = new HashMap();
                Map standMap = (Map)entryVoucher.getValue();
                if (standMap == null) continue;
                for (Map.Entry invoiceStand : standMap.entrySet()) {
                    Map invoiceMap = (Map)invoiceStand.getValue();
                    if (invoiceMap == null) continue;
                    for (Map.Entry invoiceEntry : ((Map)invoiceStand.getValue()).entrySet()) {
                        String invoiceUnicodePK = (String)invoiceEntry.getKey();
                        List infos = (List)invoiceEntry.getValue();
                        if (infos == null || infos.size() <= 0) continue;
                        returnInvoiceMap.put(invoiceUnicodePK, infos.get(0));
                    }
                }
                returnMap.put(voucherId, returnInvoiceMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u6570\u636e\u5f02\u5e38!"), (Throwable)e);
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getVoucherReceiverXbrl(Context ctx, IObjectValue companyInfo, IObjectValue periodInfo, List voucherPks, String uniqueCode) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)uniqueCode)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("success", "false");
            map.put("errMsg", "\u53c2\u6570\uff1auniqueCode \u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        HashMap result = new HashMap(3);
        try {
            uniqueCode = uniqueCode + System.currentTimeMillis();
            ctx.put((Object)"easBizUniqueCode4Evs", (Object)uniqueCode);
            ListenerManager.getInstance().registerListener(uniqueCode, new EvsServiceGeneratorDataListener());
            List vouchers = voucherPks;
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companyInfo;
            PeriodInfo period = (PeriodInfo)periodInfo;
            Map dataMap = new HashMap();
            GeneratorEngineFacadeFactory.getLocalInstance(ctx).genVoucherRelUnit(org, period.getPeriodYear(), period.getPeriodNumber(), vouchers);
            ConverterEngineFacadeFactory.getLocalInstance(ctx).dataConverterVoucherRelByVouchers(org, period.getPeriodYear(), period.getPeriodNumber(), vouchers);
            ArrayList<String> fileTypes = new ArrayList<String>();
            fileTypes.add("receiverXbrl");
            Map basedBill = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getVoucherDataStandardsBasedBill(org, period.getPeriodYear(), period.getPeriodNumber(), fileTypes, vouchers, EvsUtil.getVoucherStandardTypes(ctx));
            dataMap = this.transResultMap(basedBill);
            result.put("data", dataMap);
        }
        catch (Exception e) {
            logger.error((Object)"_getVoucherReceiverXbrl \u5931\u8d25", (Throwable)e);
            ListenerManager.getInstance().publishError(ctx, uniqueCode, e.getMessage());
        }
        finally {
            Map listenResult = ListenerManager.getInstance().getListenerResult(ctx, uniqueCode);
            result.put("success", listenResult.get("success"));
            result.put("errMsg", listenResult.get("errMsg"));
            ListenerManager.getInstance().removeListener(uniqueCode);
        }
        return result;
    }

    @Override
    protected Map _getBkrsXbrlJson(Context ctx, IObjectValue companyInfo, int periodYear, int periodNumber) throws BOSException, EASBizException {
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companyInfo;
        HashMap returnMap = new HashMap();
        GeneratorEngineFacadeFactory.getLocalInstance(ctx).genBkrsRelUnit(org, periodYear, periodNumber);
        List<String> orgBankAccounts = EvsUtil.getOrgBankAccounts(ctx, org);
        ConverterEngineFacadeFactory.getLocalInstance(ctx).dataConverterBkrs(org, periodYear, periodNumber);
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("receiverJson");
        Map basedBill = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getBkrsDataStandardsBasedBill(org, periodYear, periodNumber, fileTypes, orgBankAccounts);
        for (Map.Entry entryVoucher : basedBill.entrySet()) {
            String voucherId = (String)entryVoucher.getKey();
            HashMap returnInvoiceMap = new HashMap();
            Map standMap = (Map)entryVoucher.getValue();
            if (standMap == null) continue;
            for (Map.Entry invoiceStand : standMap.entrySet()) {
                Map invoiceMap = (Map)invoiceStand.getValue();
                if (invoiceMap == null) continue;
                for (Map.Entry invoiceEntry : ((Map)invoiceStand.getValue()).entrySet()) {
                    String invoiceUnicodePK = (String)invoiceEntry.getKey();
                    List infos = (List)invoiceEntry.getValue();
                    if (infos == null || infos.size() <= 0) continue;
                    returnInvoiceMap.put(invoiceUnicodePK, infos.get(0));
                }
            }
            returnMap.put(voucherId, returnInvoiceMap);
        }
        return returnMap;
    }

    @Override
    protected Map _getBkrsXbrlJsonByESids(Context ctx, IObjectValue org, int periodYear, int periodNumber, List esIds) throws BOSException, EASBizException {
        HashMap returnMap = new HashMap();
        List esIdList = esIds;
        Map<String, IObjectValue> esMap = BeUtils.getElStatementBill(ctx, esIdList);
        HashMap<String, String> esMappings = new HashMap<String, String>();
        ArrayList<String> accounts = new ArrayList<String>();
        for (Map.Entry<String, IObjectValue> entry : esMap.entrySet()) {
            Object obj;
            IObjectValue value = entry.getValue();
            Object object = obj = value.get("bankaccount") == null ? null : ((IObjectValue)value.get("bankaccount")).get("bankaccountnumber");
            if (obj == null) continue;
            accounts.add(obj.toString());
            esMappings.put(obj.toString(), value.get("id").toString());
        }
        GeneratorEngineFacadeFactory.getLocalInstance(ctx).genBkrsRelUnitByESids((CompanyOrgUnitInfo)org, periodYear, periodNumber, esIdList);
        ConverterEngineFacadeFactory.getLocalInstance(ctx).dataConverterBkrsByBankAccounts((CompanyOrgUnitInfo)org, periodYear, periodNumber, accounts);
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("receiverJson");
        Map basedBill = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getBkrsDataStandardsBasedBill((CompanyOrgUnitInfo)org, periodYear, periodNumber, fileTypes, accounts);
        for (Map.Entry entryVoucher : basedBill.entrySet()) {
            String voucherId = (String)entryVoucher.getKey();
            HashMap returnInvoiceMap = new HashMap();
            Map standMap = (Map)entryVoucher.getValue();
            if (standMap == null) continue;
            for (Map.Entry invoiceStand : standMap.entrySet()) {
                Map invoiceMap = (Map)invoiceStand.getValue();
                if (invoiceMap == null) continue;
                for (Map.Entry invoiceEntry : ((Map)invoiceStand.getValue()).entrySet()) {
                    String invoiceUnicodePK = (String)invoiceEntry.getKey();
                    List infos = (List)invoiceEntry.getValue();
                    if (infos == null || infos.size() <= 0) continue;
                    returnInvoiceMap.put(esMappings.get(invoiceUnicodePK), infos.get(0));
                }
            }
            returnMap.put(voucherId, returnInvoiceMap);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getBkrsXbrlByESids(Context ctx, IObjectValue org, int periodYear, int periodNumber, List esIds, String uniqueCode) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)uniqueCode)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("success", "false");
            map.put("errMsg", "\u53c2\u6570\uff1auniqueCode \u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        HashMap result = new HashMap(3);
        try {
            uniqueCode = uniqueCode + System.currentTimeMillis();
            ctx.put((Object)"easBizUniqueCode4Evs", (Object)uniqueCode);
            ListenerManager.getInstance().registerListener(uniqueCode, new EvsServiceGeneratorDataListener());
            List esIdList = esIds;
            Map<String, IObjectValue> esMap = BeUtils.getElStatementBill(ctx, esIdList);
            HashMap<String, String> esMappings = new HashMap<String, String>();
            ArrayList<String> accounts = new ArrayList<String>();
            for (Map.Entry<String, IObjectValue> entry : esMap.entrySet()) {
                Object obj;
                IObjectValue value = entry.getValue();
                Object object = obj = value.get("bankaccount") == null ? null : ((IObjectValue)value.get("bankaccount")).get("bankaccountnumber");
                if (obj == null) continue;
                accounts.add(obj.toString());
                esMappings.put(obj.toString(), value.get("id").toString());
            }
            GeneratorEngineFacadeFactory.getLocalInstance(ctx).genBkrsRelUnitByESids((CompanyOrgUnitInfo)org, periodYear, periodNumber, esIdList);
            ConverterEngineFacadeFactory.getLocalInstance(ctx).dataConverterBkrsByBankAccounts((CompanyOrgUnitInfo)org, periodYear, periodNumber, accounts);
            ArrayList<String> fileTypes = new ArrayList<String>();
            fileTypes.add("receiverXbrl");
            Map basedBill = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getBkrsDataStandardsBasedBill((CompanyOrgUnitInfo)org, periodYear, periodNumber, fileTypes, accounts);
            result.put("data", this.transResultMap(basedBill));
        }
        catch (Exception e) {
            logger.error((Object)"_getBkrsXbrlByESids \u5931\u8d25", (Throwable)e);
            ListenerManager.getInstance().publishError(ctx, uniqueCode, e.getMessage());
        }
        finally {
            Map listenResult = ListenerManager.getInstance().getListenerResult(ctx, uniqueCode);
            result.put("success", listenResult.get("success"));
            result.put("errMsg", listenResult.get("errMsg"));
            ListenerManager.getInstance().removeListener(uniqueCode);
        }
        return result;
    }

    private Map transResultMap(Map basedBillMap) {
        HashMap dataMap = new HashMap();
        for (Map.Entry entryVoucher : basedBillMap.entrySet()) {
            String voucherId = (String)entryVoucher.getKey();
            HashMap returnInvoiceMap = new HashMap();
            Map standMap = (Map)entryVoucher.getValue();
            if (standMap == null) continue;
            for (Map.Entry invoiceStand : standMap.entrySet()) {
                Map invoiceMap = (Map)invoiceStand.getValue();
                if (invoiceMap == null) continue;
                for (Map.Entry invoiceEntry : ((Map)invoiceStand.getValue()).entrySet()) {
                    String invoiceUnicodePK = (String)invoiceEntry.getKey();
                    List infos = (List)invoiceEntry.getValue();
                    if (infos == null || infos.size() <= 0) continue;
                    EVSInfo evsInfo = (EVSInfo)infos.get(0);
                    HashMap<String, Object> fileInfo = new HashMap<String, Object>(2);
                    fileInfo.put("file", evsInfo.getFile());
                    fileInfo.put("fileName", evsInfo.getFileName());
                    returnInvoiceMap.put(invoiceUnicodePK, fileInfo);
                }
            }
            dataMap.put(voucherId, returnInvoiceMap);
        }
        return dataMap;
    }
}

