/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.BkrsConverter;
import com.kingdee.eas.base.evs.app.converter.IDataConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.BkerConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.AtrInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.EFiInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.EinvOrdInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.EinvSpclInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.GpmInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.OrdInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.RaiInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.SpclInvoiceConverter;
import com.kingdee.eas.base.evs.app.converter.voucher.invoice.TlfInvoiceConverter;
import com.kingdee.eas.base.evs.xbrlBuild.IConfigurable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Map;

public class ConverterFactory
implements IConfigurable<IDataConverter> {
    static Map<String, IDataConverter> converterMap = new HashMap<String, IDataConverter>();

    public static IDataConverter converter(Context ctx, String type) throws EASBizException {
        ConverterFactory converterFactory = new ConverterFactory();
        return converterFactory.getInterface(ctx, type);
    }

    @Override
    public IDataConverter getInterface(Context ctx, String type) throws EASBizException {
        IDataConverter processor = converterMap.get(type);
        if (processor != null) {
            return processor;
        }
        throw new EASBizException(new NumericExceptionSubItem("00-00", "\u3010" + type + "\u3011\u4e0d\u652f\u6301\u7684\u7c7b\u578b"));
    }

    static {
        converterMap.put("bker", new BkerConverter());
        converterMap.put("inv_ord", new OrdInvoiceConverter());
        converterMap.put("inv_spcl", new SpclInvoiceConverter());
        converterMap.put("inv_tlf", new TlfInvoiceConverter());
        converterMap.put("rai", new RaiInvoiceConverter());
        converterMap.put("atr", new AtrInvoiceConverter());
        converterMap.put("ntrev_gpm", new GpmInvoiceConverter());
        converterMap.put("bkrs", new BkrsConverter());
        converterMap.put("efi", new EFiInvoiceConverter());
        converterMap.put("einv_spcl", new EinvSpclInvoiceConverter());
        converterMap.put("einv_ord", new EinvOrdInvoiceConverter());
    }
}

