/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.ConverterFactory;
import com.kingdee.eas.base.evs.app.converter.thread.ConverterThread;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConverterManager {
    private static volatile ConverterManager manager = null;
    private static volatile ExecutorService executorService = null;

    private ConverterManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConverterManager getInstance() {
        if (manager != null) return manager;
        Class<ConverterManager> clazz = ConverterManager.class;
        synchronized (ConverterManager.class) {
            if (manager != null) return manager;
            manager = new ConverterManager();
            executorService = new ThreadPoolExecutor(8, 8, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(200), new ThreadPoolExecutor.CallerRunsPolicy());
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public static void voucherDataConverter(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, int periodYear, int periodNumber, List<String> standardTypes) throws BOSException {
        String oql = "select voucherPK where dataRange.company.companyCreaditCode = '" + companyOrgUnitInfo.getTaxNumber() + "' and dataRange.periodYear = " + periodYear + " and dataRange.periodNumber = " + periodNumber + " ";
        VoucherUnitCollection voucherUnitCollection = VoucherUnitFactory.getLocalInstance(ctx).getVoucherUnitCollection(oql);
        ArrayList<String> voucherIds = new ArrayList<String>(voucherUnitCollection.size());
        for (int i = 0; i < voucherUnitCollection.size(); ++i) {
            VoucherUnitInfo voucherUnitInfo = voucherUnitCollection.get(i);
            voucherIds.add(voucherUnitInfo.getVoucherPK());
        }
        ConverterManager.voucherDataConverter(ctx, companyOrgUnitInfo, periodYear, periodNumber, voucherIds, standardTypes);
    }

    public static void voucherDataConverter(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, int periodYear, int periodNumber, List<String> voucherIds, List<String> standardTypes) throws BOSException {
        if (standardTypes == null || standardTypes.isEmpty()) {
            standardTypes = new ArrayList<String>();
            Set<String> set = ConverterFactory.converterMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                if ("bkrs".equals(iterator.next())) continue;
                standardTypes.add(iterator.next());
            }
        }
        ConverterManager.getInstance().process(ctx, companyOrgUnitInfo, periodYear, periodNumber, voucherIds, standardTypes);
    }

    public void process(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) {
        this.process(ctx, companyInfo, periodYear, periodNumber, true);
    }

    public void process(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> pks, List<String> standardTypes) {
        this.process(ctx, companyInfo, periodYear, periodNumber, pks, standardTypes, true);
    }

    public void process(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, boolean isSync) {
        this.process(ctx, companyInfo, periodYear, periodNumber, null, null, isSync);
    }

    public void process(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> pks, List<String> standardTypes, boolean isSync) {
        if (isSync) {
            ConverterThread thread = new ConverterThread(ctx, companyInfo, periodYear, periodNumber, pks, standardTypes);
            thread.run();
        } else {
            ConverterThread thread = new ConverterThread(ctx, companyInfo, periodYear, periodNumber, pks, standardTypes, 3);
            executorService.submit(thread);
        }
    }
}

