/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.EFiInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.EFiInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class EFiInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FEInvoiceID,a.FPartyName,a.FPartyCode,a.FIssueDate,a.FTotalAmount,a.FUniquePK, c.FHasBeenBooked Fbooked,g.FCompanyName,g.FCompanyCreaditCode,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,isnull(a.FHasBeenChecked,c.FHasBeenChecked) FHasBeenChecked,d.FVoucherId,e.FVoucherNumber,a.FXbrlurl,a.FXbrlname,f.FPeriodNumber,f.FPeriodYear from T_EVS_EfiInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> einvoiceIds = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            einvoiceIds.add(rowSet.getString("FEInvoiceID"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FEInvoiceID, d.FVoucherId from T_EVS_EfiInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FEInvoiceID in (" + SQLUtils.getSQL(einvoiceIds) + ")  and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> invoicePKSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, EFiInvoiceInfo> uniqueMap = new HashMap<String, EFiInvoiceInfo>();
        while (rowSet.next()) {
            EFiInvoiceInfo invoiceInfo = null;
            String FEInvoiceID = rowSet.getString("FEInvoiceID");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            if (invoicePKSet.contains(FEInvoiceID)) {
                if (voucherNumberSet.contains(FEInvoiceID + fVoucherNumber)) continue;
                invoiceInfo = (EFiInvoiceInfo)uniqueMap.get(FEInvoiceID);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(FEInvoiceID + fVoucherNumber);
                continue;
            }
            invoiceInfo = new EFiInvoiceInfo();
            uniqueMap.put(FEInvoiceID, invoiceInfo);
            invoicePKSet.add(FEInvoiceID);
            voucherNumberSet.add(FEInvoiceID + fVoucherNumber);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setUniquePK(FEInvoiceID);
            invoiceInfo.setEInvoiceID(FEInvoiceID);
            invoiceInfo.setInvoicingPartyName(rowSet.getString("FPartyName"));
            invoiceInfo.setInvoicingPartyCode(rowSet.getString("FPartyCode"));
            invoiceInfo.setIssueDate(rowSet.getString("FIssueDate"));
            invoiceInfo.setTotalAmount(rowSet.getString("FTotalAmount"));
            invoiceInfo.setHasBeenBooked(rowSet.getString("Fbooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getEInvoiceID());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!invoicePKSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_EFiInvoice where FEInvoiceID in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_EFiInvoice where FEInvoiceID in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "efi").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, invoicePKSet);
            EFiInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

