/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.evsservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.evs.app.evsservice.AbstractSchemeExecuteFacadeControllerBean;
import com.kingdee.eas.base.evs.app.evsservice.SchemeExecuteFacadeFactory;
import com.kingdee.eas.base.evs.app.page.ExecuteRecordFactory;
import com.kingdee.eas.base.evs.app.page.ExecuteRecordInfo;
import com.kingdee.eas.base.evs.app.page.ExecuteState;
import com.kingdee.eas.base.evs.app.page.SchemeFactory;
import com.kingdee.eas.base.evs.app.page.SchemeInfo;
import com.kingdee.eas.base.evs.app.page.SchemeInstFactory;
import com.kingdee.eas.base.evs.app.page.SchemeInstInfo;
import com.kingdee.eas.base.evs.app.page.SchemeOrgCollection;
import com.kingdee.eas.base.evs.app.page.SchemeOrgInstCollection;
import com.kingdee.eas.base.evs.thread.ExecuteSchemeThread;
import com.kingdee.eas.base.evs.thread.ExecuteSchemeThreadPool;
import com.kingdee.eas.base.evs.util.EvsUtil;
import com.kingdee.eas.base.evs.util.H;
import com.kingdee.eas.base.evs.util.PeriodUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SchemeExecuteFacadeControllerBean
extends AbstractSchemeExecuteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.app.evsservice.SchemeExecuteFacadeControllerBean");

    @Override
    protected String _execute(Context ctx, String schemeId) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("orgEntry.*"));
        selectorItemCollection.add(new SelectorItemInfo("orgEntry.org.*"));
        SchemeInfo schemeInfo = SchemeFactory.getLocalInstance(ctx).getSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), selectorItemCollection);
        SchemeExecuteFacadeFactory.getLocalInstance(ctx).execute(schemeInfo);
        return null;
    }

    @Override
    protected void _execute(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        int i;
        EvsUtil.checkFpSysInitState(ctx);
        SchemeInfo schemeInfo = (SchemeInfo)info;
        String schemeInstId = this.saveSchemeInst(ctx, schemeInfo);
        SchemeOrgCollection orgEntry = schemeInfo.getOrgEntry();
        if (orgEntry == null || orgEntry.size() == 0) {
            logger.error((Object)("execute orgEntry is null;schemeInfo id = " + schemeInfo.getId().toString()));
            return;
        }
        CompanyOrgUnitCollection orgColl = this.getSubOrg(ctx, orgEntry);
        CoreBaseCollection executeRecordCollection = new CoreBaseCollection();
        SchemeInstInfo schemeInstInfo = SchemeInstFactory.getLocalInstance(ctx).getSchemeInstInfo(H.PK(schemeInstId));
        for (i = 0; i < orgColl.size(); ++i) {
            List<PeriodInfo> periods = PeriodUtil.getVoucherPeriods(ctx, schemeInfo, orgColl.get(i));
            for (int j = 0; j < periods.size(); ++j) {
                if (periods.get(j) == null || orgColl.get(i) == null) continue;
                executeRecordCollection.add((CoreBaseInfo)this.getExecuteRecord(ctx, schemeInstInfo, periods.get(j), orgColl.get(i)));
            }
        }
        if (executeRecordCollection.isEmpty()) {
            return;
        }
        ExecuteRecordFactory.getLocalInstance(ctx).saveBatchData(executeRecordCollection);
        try {
            for (i = 0; i < executeRecordCollection.size(); ++i) {
                ExecuteRecordInfo executeRecordInfo = (ExecuteRecordInfo)executeRecordCollection.get(i);
                Context newCtx = (Context)this.deeplyCopy((Serializable)ctx);
                ExecuteSchemeThreadPool.execute(new ExecuteSchemeThread(newCtx, executeRecordInfo));
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u6267\u884c\u5931\u8d25"), (Throwable)e);
        }
    }

    private CompanyOrgUnitCollection getSubOrg(Context ctx, SchemeOrgCollection orgEntry) throws BOSException {
        CompanyOrgUnitCollection corgs = new CompanyOrgUnitCollection();
        for (int j = 0; j < orgEntry.size(); ++j) {
            CompanyOrgUnitCollection collection;
            if (orgEntry.get(j).isContainSub() && (collection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("select *, baseCurrency.* where  longNumber like '" + orgEntry.get(j).getOrg().getLongNumber() + "!%'")) != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    CompanyOrgUnitInfo ouInfo = collection.get(i);
                    if (!StringUtils.isNotEmpty((CharSequence)ouInfo.getTaxNumber())) continue;
                    corgs.add(ouInfo);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)orgEntry.get(j).getOrg().getTaxNumber())) continue;
            corgs.add(orgEntry.get(j).getOrg());
        }
        return corgs;
    }

    private String saveSchemeInst(Context ctx, SchemeInfo schemeInfo) throws BOSException, EASBizException {
        SchemeInstInfo instInfo = new SchemeInstInfo();
        instInfo.setDuringType(schemeInfo.getDuringType());
        instInfo.setStartPeroid(schemeInfo.getStartPeroid());
        instInfo.setEndPeroid(schemeInfo.getEndPeroid());
        instInfo.setState(schemeInfo.isState());
        instInfo.setName(schemeInfo.getName());
        String number = schemeInfo.getNumber() + "_" + System.currentTimeMillis();
        instInfo.setNumber(number);
        instInfo.setCreateTime(schemeInfo.getCreateTime());
        instInfo.setLastUpdateTime(schemeInfo.getLastUpdateTime());
        instInfo.setCreator(schemeInfo.getCreator());
        instInfo.setLastUpdateUser(schemeInfo.getLastUpdateUser());
        instInfo.setOriSchemeId(schemeInfo.getId().toString());
        SchemeOrgInstCollection orgEntry = instInfo.getOrgEntry();
        instInfo.put("orgEntry", (Object)orgEntry);
        instInfo.setId(BOSUuid.create((String)"5D16E839"));
        IObjectPK pk = SchemeInstFactory.getLocalInstance(ctx).save((CoreBaseInfo)instInfo);
        return pk.toString();
    }

    private ExecuteRecordInfo getExecuteRecord(Context ctx, SchemeInstInfo schemeInstInfo, PeriodInfo periodInfo, CompanyOrgUnitInfo companyOrgUnitInfo) {
        long time = System.currentTimeMillis();
        ExecuteRecordInfo recordInfo = new ExecuteRecordInfo();
        recordInfo.setSchemeInstId(schemeInstInfo.getId().toString());
        Integer period = Integer.parseInt(periodInfo.getPeriodYear() + (periodInfo.getPeriodNumber() < 10 ? "0" + periodInfo.getPeriodNumber() : String.valueOf(periodInfo.getPeriodNumber())));
        recordInfo.setPeriod(period);
        recordInfo.setOrg(companyOrgUnitInfo);
        recordInfo.setBegin(new Timestamp(time));
        recordInfo.setState(ExecuteState.ING);
        recordInfo.setCode(companyOrgUnitInfo.getTaxNumber() + "_" + companyOrgUnitInfo.getNumber() + "_" + period + "_" + schemeInstInfo.getNumber());
        recordInfo.setId(BOSUuid.create((String)"2CD1CAB8"));
        return recordInfo;
    }

    protected Object deeplyCopy(Serializable obj) throws IOException, ClassNotFoundException {
        return this.bytes2object(this.object2bytes(obj));
    }

    private byte[] object2bytes(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object bytes2object(byte[] bytes) throws IOException, ClassNotFoundException {
        Object var3;
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            var3 = ois.readObject();
        }
        return var3;
    }
}

