/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.billData.handler;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.unitdata.billData.BizDocUint;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceInfoHandler;
import com.kingdee.eas.base.evs.unitdata.billData.handler.BizInvoiceTypeAdapter;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BizInvoiceInfoHandler
extends BizInvoiceTypeAdapter
implements InvoiceInfoHandler {
    @Override
    public Map<String, BizDocUint> getDocsByBillIds(Context ctx, List<String> billIds) throws EASBizException {
        Map<String, List<InvoiceDoc>> invoiceDocsByBillId = this.getInvoiceDocsByBillIds(ctx, billIds);
        StringBuilder builder = new StringBuilder();
        builder.append(" select bt.FID FBillID,bt.FNumber");
        builder.append(" from ");
        builder.append(this.getBizBillTableName(ctx));
        builder.append(" bt ");
        builder.append(" where bt.FID in (");
        builder.append(SQLUtils.getSQL(billIds));
        builder.append(")");
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            HashMap<String, BizDocUint> mapBizDocUint = new HashMap<String, BizDocUint>();
            while (iRowSet.next()) {
                String billId = iRowSet.getString("FBillID");
                String FNumber = iRowSet.getString("FNumber");
                BizDocUint bizDocUint = new BizDocUint();
                if (!invoiceDocsByBillId.containsKey(billId)) continue;
                List<InvoiceDoc> invoiceDocs = invoiceDocsByBillId.get(billId);
                bizDocUint.put("Invoices", invoiceDocs);
                bizDocUint.put("BillPK", billId);
                bizDocUint.put("BillNumber", FNumber);
                bizDocUint.put("WhetherInputVatHasBeenTransferredOut", "false");
                bizDocUint.put("AmountOfTransferredOutInputVat", "0.00");
                bizDocUint.put("ContractNumber", FNumber);
                bizDocUint.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", "");
                bizDocUint.put("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets", "");
                bizDocUint.put("WhetherInvoiceHasBeenFactoredSoldOrSecuritized", "true");
                bizDocUint.put("WhetherInvoiceIsRedInvoice", "false");
                bizDocUint.put("WhetherInvoiceHasBeenChecked", "true");
                bizDocUint.put("WhetherInvoiceUsageHasBeenConfirmed", "false");
                bizDocUint.put("UsageConfirmation", "");
                bizDocUint.put("PeriodOfUsageConfirmation", "");
                bizDocUint.put("WhetherInvoiceHasBeenBooked", "true");
                bizDocUint.put("WhetherInvoiceHasBeenPaid", "true");
                bizDocUint.put("NumberOfBankElectronicReceipt", "");
                mapBizDocUint.put(billId, bizDocUint);
            }
            return mapBizDocUint;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", ""), (Throwable)e);
        }
    }

    protected abstract Map<String, List<InvoiceDoc>> getInvoiceDocsByBillIds(Context var1, List<String> var2) throws EASBizException;

    protected abstract String getBizBillTableName(Context var1);

    protected abstract String getBizTicketTableName(Context var1);
}

