/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MDEvent;
import com.kingdee.bos.metadata.MDListener;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class LogServerUtil {
    public static final String MANUAL_lOG_ITEM = "manual_default_logitem";
    public static final String LOG_HIDDEN_WRITE_MODE = "LOG_HIDDEN_WRITE_MODE";
    public static final int LEVEL_HIGH = 1;
    public static final int LEVEL_MIDDLE = 2;
    public static final int LEVEL_LOW = 3;
    private static int current_level_setting = 0;
    private static final Map logLevelCache = new HashMap(100);
    private static boolean isInit = false;

    private static synchronized void initLogLevelCache(Context ctx) {
        if (!isInit) {
            LogItemCollection logItemCol = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getLog().getLogItems();
            Iterator iter = logItemCol.iterator();
            LogItemInfo logItemInfo = null;
            while (iter.hasNext()) {
                logItemInfo = (LogItemInfo)iter.next();
                logLevelCache.put(logItemInfo.getName(), logItemInfo.getLevel());
            }
            isInit = true;
        }
    }

    public static int getLogItemLevel(Context ctx, String itemName) {
        LogServerUtil.initLogLevelCache(ctx);
        Integer level = (Integer)logLevelCache.get(itemName);
        if (level == null) {
            return 0;
        }
        return level;
    }

    public static int getCurrentLevelSetting(Context ctx) throws BOSException {
        if (current_level_setting == 0) {
            current_level_setting = AppLogFactory.getLocalInstance(ctx).getLogLevel();
        }
        return current_level_setting;
    }

    public static void setCurrentLevelSetting(Context ctx, int level) throws BOSException {
        current_level_setting = level;
    }

    public static void setLogInfo(IServiceContext serviceContext, Context ctx, HashMap hashLog) {
        hashLog.put("FID", LogServerUtil.getID());
        hashLog.put("FUserID", LogServerUtil.getUserId(ctx));
        hashLog.put("FUserNumber", LogServerUtil.getUserNumber(ctx));
        LogServerUtil.setUserName(ctx, hashLog);
        LogServerUtil.setUserType(ctx, hashLog);
        hashLog.put("FOccurTime", new Timestamp(System.currentTimeMillis()));
        hashLog.put("FClientIP", LogServerUtil.getClientIp(ctx));
        hashLog.put("FClientName", LogServerUtil.getClientName(ctx));
        CtrlUnitInfo ctrlUnitInfo = LogServerUtil.getCtrlUnit(ctx);
        if (ctrlUnitInfo != null) {
            hashLog.put("FCUID", ctrlUnitInfo.getId().toString());
        }
        LogServerUtil.setCompanyName(serviceContext, ctx, hashLog);
    }

    public static void setEntityAlias(Context ctx, BOSObjectType bosType, HashMap hash) {
        SolutionInfo soInfo = LogServerUtil.getSolutionInfo(ctx);
        if (soInfo == null) {
            return;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BusinessObjectInfo boInfo = null;
        try {
            boInfo = loader.getBusinessObject(bosType);
        }
        catch (MetaDataNotFoundException e) {
            return;
        }
        if (boInfo == null) {
            return;
        }
        String strKey = "FEntityAlias_";
        LanguageCollection lC = soInfo.getLanguages();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = strKey + lInfo.getPostfix().toUpperCase();
            hash.put(key, boInfo.get("alias", lInfo.getOriginalLocale()));
        }
    }

    private static String getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private static String getUserId(Context ctx) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private static String getUserNumber(Context ctx) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String number = "";
        if (userInfo != null) {
            number = userInfo.getNumber();
        }
        return number;
    }

    private static void setUserName(Context ctx, HashMap hashLog) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            String userName = userInfo.getName();
            hashLog.put("FUserName", userName);
        }
    }

    private static void setUserType(Context ctx, HashMap hashLog) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null && userInfo.getType() != null) {
            hashLog.put("FUserType_L1", userInfo.getType().getAlias(new Locale("L1")));
            hashLog.put("FUserType_L2", userInfo.getType().getAlias(new Locale("L2")));
            hashLog.put("FUserType_L3", userInfo.getType().getAlias(new Locale("L3")));
        }
    }

    private static String getClientIp(Context ctx) {
        Object obj = ctx.getClientHostIP();
        if (obj == null) {
            obj = ctx.get((Object)"ClientIP");
        }
        return obj == null ? "" : obj.toString();
    }

    private static String getClientName(Context ctx) {
        Object obj = ctx.getClientHostName();
        if (obj == null) {
            obj = ctx.get((Object)"ClientName");
        }
        if (obj == null || obj.toString().isEmpty()) {
            obj = LogServerUtil.getClientIp(ctx);
        }
        return obj == null ? "" : obj.toString();
    }

    private static CtrlUnitInfo getCtrlUnit(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    private static SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    private static void setCompanyName(IServiceContext serviceContext, Context ctx, HashMap hash) {
        boolean isEntity;
        IMetaDataLoader loader;
        SolutionInfo soluctionInfo = LogServerUtil.getSolutionInfo(ctx);
        if (soluctionInfo == null) {
            return;
        }
        OrgUnitInfo orgInfo = null;
        if (serviceContext != null && serviceContext.getMetaType().equals((Object)MetaDataTypeList.ENTITY)) {
            loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entityInfo = loader.getEntity(serviceContext.getBoType());
            String orgTypeStr = entityInfo.getExtendedProperty("OrgType");
            OrgType orgType = OrgCommonUtils.getOrgType((String)orgTypeStr);
            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        }
        if (serviceContext == null && hash.get("FEntityID") != null && (isEntity = (loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx)).isEntity(BOSObjectType.create((String)((String)hash.get("FEntityID")))))) {
            EntityObjectInfo entityInfo = loader.getEntity(BOSObjectType.create((String)((String)hash.get("FEntityID"))));
            String orgTypeStr = entityInfo.getExtendedProperty("OrgType");
            OrgType orgType = OrgCommonUtils.getOrgType((String)orgTypeStr);
            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        }
        if (orgInfo == null) {
            orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        }
        if (orgInfo == null) {
            orgInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        }
        String strKey = "FCompanyName_";
        LanguageCollection langCol = soluctionInfo.getLanguages();
        String strDefPostfix = soluctionInfo.getDefaultLanguage().getPostfix();
        for (int i = 0; i < langCol.size(); ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String key = strKey + langInfo.getPostfix().toUpperCase();
            if (langInfo.getPostfix().equals(strDefPostfix)) {
                if (orgInfo == null) {
                    hash.put(key, "");
                    continue;
                }
                hash.put(key, orgInfo.getName());
                continue;
            }
            if (orgInfo == null) {
                hash.put(key, "");
                continue;
            }
            hash.put(key, orgInfo.get("name", langInfo.getLocale()));
        }
    }

    public static String[] getAdminCUs(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        String[] cus = null;
        FullOrgUnitCollection orgs = null;
        orgs = PermissionFactory.getLocalInstance((Context)ctx).getOrgRanges(userPK);
        cus = new String[orgs.size()];
        for (int i = 0; i < cus.length; ++i) {
            cus[i] = orgs.get(i).getId().toString();
        }
        return cus;
    }

    static {
        MDReferenceFactory.addLogListener((MDListener)new MDListener(){

            public void performed(MDEvent e) {
                if (e.getType() == 0) {
                    logLevelCache.clear();
                    isInit = false;
                }
            }
        });
    }
}

