/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.framework.cache.CacheCleanSender;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.notify.CacheCleanByTable;
import com.kingdee.bos.framework.cache.notify.RPCInvokeCacheIntercepter;
import com.kingdee.bos.invokecounter.DBConnCounter;
import com.kingdee.bos.invokecounter.HttpSqlCounter;
import com.kingdee.bos.invokecounter.InvokeKSQLCounter;
import com.kingdee.bos.invokecounter.PerfEventCounter;
import com.kingdee.bos.invokecounter.SQLPlanCounter;
import com.kingdee.bos.invokecounter.WorkflowSqlCounter;
import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.base.log.app.LogQueue;
import com.kingdee.eas.base.log.app.LogServiceThread;
import com.kingdee.eas.basedata.org.app.log.OrgLogQueue;
import com.kingdee.eas.basedata.org.app.log.OrgLogServiceThread;
import com.kingdee.eas.common.cache.CacheConfigFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class LogServiceListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger((String)LogServiceListener.class.getName());

    public void contextInitialized(ServletContextEvent arg0) {
        new LogServiceThread().start();
        new OrgLogServiceThread().start();
        InvokeKSQLCounter.init();
        SQLPlanCounter.init();
        DBConnCounter.init();
        WorkflowSqlCounter.init();
        PerfEventCounter.init();
        HttpSqlCounter.init();
        ICacheConfig config = CacheConfigFactory.getCacheConfigByServer();
        CacheConfigManager.registerConfig((ICacheConfig)config);
        CacheCleanSender.start();
        CacheCleanByTable.init();
        RPCEngineFactory.addInvokeIntercepters((InvokeIntercepter)RPCInvokeCacheIntercepter.INSTANCE);
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        boolean first = true;
        while (!LogQueue.getInstance().isEmpty()) {
            if (first) {
                first = false;
            }
            Thread.yield();
        }
        first = true;
        while (!OrgLogQueue.getInstance().isEmpty()) {
            if (first) {
                first = false;
            }
            Thread.yield();
        }
    }
}

